/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.hooks;

import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.graphql.api.api.APIoutputPort;
import info.scce.dime.graphql.api.api.ComplexAPIoutput;
import info.scce.dime.graphql.api.api.DataFlowTarget;
import info.scce.dime.graphql.api.api.EndSIB;
import info.scce.dime.process.helper.LayoutConstants;
import info.scce.dime.process.helper.NodeLayout;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class APIoutputPortHook extends DIMEPostCreateHook<ComplexAPIoutput> {
  public void layout(final DataFlowTarget node) {
    int x = LayoutConstants.ATTR_X;
    int y = (LayoutConstants.TYPE_FIRST_ATTR_Y + 35);
    if ((node instanceof EndSIB)) {
      int _size = ((EndSIB)node).getAPIoutputPorts().size();
      int attributeAmountEndSib = (_size + 2);
      ((EndSIB)node).resize(((EndSIB)node).getWidth(), NodeLayout.getTypeHeight(attributeAmountEndSib));
      EList<APIoutputPort> _aPIoutputPorts = ((EndSIB)node).getAPIoutputPorts();
      for (final APIoutputPort output : _aPIoutputPorts) {
        {
          output.moveTo(((EndSIB)node), x, y);
          int _width = ((EndSIB)node).getWidth();
          int _minus = (_width - (2 * LayoutConstants.ATTR_X));
          output.resize(_minus, output.getHeight());
          int _y = y;
          y = (_y + LayoutConstants.ATTR_SPACE);
        }
      }
    }
  }
  
  @Override
  public void postCreate(final ComplexAPIoutput inPort) {
    this.layout(inPort.getContainer());
  }
}
