/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.hooks;

import com.google.common.base.Objects;
import graphmodel.Node;
import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.data.data.Type;
import info.scce.dime.graphql.api.api.APIinputPort;
import info.scce.dime.graphql.api.api.APIoutputPort;
import info.scce.dime.graphql.api.api.ComplexAPIinput;
import info.scce.dime.graphql.api.api.ComplexAPIoutput;
import info.scce.dime.graphql.api.api.EndSIB;
import info.scce.dime.graphql.api.api.ErrorSIB;
import info.scce.dime.graphql.api.api.IO;
import info.scce.dime.graphql.api.api.PrimitiveAPIinput;
import info.scce.dime.graphql.api.api.PrimitiveAPIoutput;
import info.scce.dime.graphql.api.api.StartSIB;
import info.scce.dime.graphql.schema.graphql.APISIB;
import info.scce.dime.graphql.schema.graphql.ApiError;
import info.scce.dime.graphql.schema.graphql.ApiInput;
import info.scce.dime.graphql.schema.graphql.ApiOutput;
import info.scce.dime.graphql.schema.graphql.GraphQL;
import info.scce.dime.graphql.util.LayoutUtils;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class APISIBPostCreateHook extends DIMEPostCreateHook<APISIB> {
  @Extension
  protected LayoutUtils _layoutUtils = new LayoutUtils();
  
  @Override
  public void postCreate(final APISIB apisib) {
    this.clearContained(apisib);
    int x = 5;
    int y = 35;
    final EList<StartSIB> startSibs = apisib.getModel().getStartSIBs();
    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(startSibs);
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      final EList<APIinputPort> inputPorts = IterableExtensions.<StartSIB>head(startSibs).getAPIinputPorts();
      for (final APIinputPort port : inputPorts) {
        {
          final ApiInput apiInput = apisib.newApiInput(x, y);
          apiInput.setName(this.getPortName(port));
          apiInput.setRequired(port.isRequired());
          int _y = y;
          y = (_y + 15);
        }
      }
    }
    int _y = y;
    y = (_y + 5);
    final EList<EndSIB> endSibs = apisib.getModel().getEndSIBs();
    boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty(endSibs);
    boolean _not_1 = (!_isNullOrEmpty_1);
    if (_not_1) {
      final EList<APIoutputPort> outputPorts = IterableExtensions.<EndSIB>head(endSibs).getAPIoutputPorts();
      for (final APIoutputPort port_1 : outputPorts) {
        {
          final ApiOutput apiOutput = apisib.newApiOutput(x, y);
          apiOutput.setName(this.getPortName(port_1));
          apiOutput.setNotNull(port_1.isNotNull());
          int _y_1 = y;
          y = (_y_1 + 15);
        }
      }
    }
    int _y_1 = y;
    y = (_y_1 + 5);
    final EList<ErrorSIB> errorSibs = apisib.getModel().getErrorSIBs();
    boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty(errorSibs);
    boolean _not_2 = (!_isNullOrEmpty_2);
    if (_not_2) {
      for (final ErrorSIB errorSib : errorSibs) {
        {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("[Code ");
          String _errorCode = errorSib.getErrorCode();
          _builder.append(_errorCode);
          _builder.append("] ");
          String _errorMessage = errorSib.getErrorMessage();
          _builder.append(_errorMessage);
          final String errorMessage = _builder.toString();
          final ApiError errorOutput = apisib.newApiError(x, y);
          errorOutput.setName(errorMessage);
          int _y_2 = y;
          y = (_y_2 + 15);
        }
      }
    }
    apisib.setHeight((y + 10));
    this._layoutUtils.layout(apisib.getContainer());
    int _width = apisib.getWidth();
    final int toBeWidth = (_width - 10);
    final Consumer<Node> _function = new Consumer<Node>() {
      @Override
      public void accept(final Node it) {
        it.setWidth(toBeWidth);
      }
    };
    apisib.getAllNodes().forEach(_function);
  }
  
  public boolean clearContained(final APISIB apiSib) {
    GraphQL _rootElement = apiSib.getRootElement();
    final GraphQL container = ((GraphQL) _rootElement);
    final EList<APISIB> mutationSibs = container.getMutationss().get(0).getAPISIBs();
    final EList<APISIB> querySibs = container.getQueriess().get(0).getAPISIBs();
    for (final APISIB querySib : querySibs) {
      if ((Objects.equal(querySib.getModel().getId(), apiSib.getModel().getId()) && (!querySib.equals(apiSib)))) {
        querySib.delete();
        return true;
      }
    }
    for (final APISIB mutationSib : mutationSibs) {
      if ((Objects.equal(mutationSib.getModel().getId(), apiSib.getModel().getId()) && (!mutationSib.equals(apiSib)))) {
        mutationSib.delete();
        return true;
      }
    }
    return false;
  }
  
  public String getPortName(final IO port) {
    String _switchResult = null;
    boolean _matched = false;
    if (port instanceof PrimitiveAPIoutput) {
      _matched=true;
      _switchResult = this.getListFormat(((PrimitiveAPIoutput)port).getName(), ((PrimitiveAPIoutput)port).getDataType().getName(), ((PrimitiveAPIoutput)port).isIsList());
    }
    if (!_matched) {
      if (port instanceof PrimitiveAPIinput) {
        _matched=true;
        _switchResult = this.getListFormat(((PrimitiveAPIinput)port).getName(), ((PrimitiveAPIinput)port).getDataType().getName(), ((PrimitiveAPIinput)port).isIsList());
      }
    }
    if (!_matched) {
      if (port instanceof ComplexAPIinput) {
        _matched=true;
        Type _dataType = ((ComplexAPIinput)port).getDataType();
        _switchResult = this.getListFormat(((ComplexAPIinput)port).getName(), ((Type) _dataType).getName(), ((ComplexAPIinput)port).isIsList());
      }
    }
    if (!_matched) {
      if (port instanceof ComplexAPIoutput) {
        _matched=true;
        Type _dataType = ((ComplexAPIoutput)port).getDataType();
        _switchResult = this.getListFormat(((ComplexAPIoutput)port).getName(), ((Type) _dataType).getName(), ((ComplexAPIoutput)port).isIsList());
      }
    }
    if (!_matched) {
      _switchResult = "None";
    }
    return _switchResult;
  }
  
  public String getListFormat(final String name, final String typ, final boolean isList) {
    if (isList) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(name);
      _builder.append(": [");
      _builder.append(typ);
      _builder.append("]");
      return _builder.toString();
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append(name);
      _builder_1.append(": ");
      _builder_1.append(typ);
      return _builder_1.toString();
    }
  }
}
