/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.hooks;

import de.jabc.cinco.meta.runtime.layout.LayoutConfiguration;
import de.jabc.cinco.meta.runtime.layout.ListLayouter;
import graphmodel.Container;
import graphmodel.Node;
import info.scce.dime.graphql.schema.graphql.APISIB;
import info.scce.dime.graphql.schema.graphql.Entrypoints;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;

@SuppressWarnings("all")
public class APISIBLayouter extends ListLayouter {
  private static APISIBLayouter _instance;
  
  public static APISIBLayouter getInstance() {
    APISIBLayouter _elvis = null;
    if (APISIBLayouter._instance != null) {
      _elvis = APISIBLayouter._instance;
    } else {
      APISIBLayouter _aPISIBLayouter = new APISIBLayouter();
      APISIBLayouter __instance = (APISIBLayouter._instance = _aPISIBLayouter);
      _elvis = __instance;
    }
    return _elvis;
  }
  
  protected Map<LayoutConfiguration, ?> _getLayoutConfiguration(final Entrypoints it) {
    Pair<LayoutConfiguration, Integer> _mappedTo = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.MIN_HEIGHT, Integer.valueOf(60));
    Pair<LayoutConfiguration, Integer> _mappedTo_1 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_TOP, Integer.valueOf(30));
    Pair<LayoutConfiguration, Integer> _mappedTo_2 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_Y, Integer.valueOf(10));
    return Collections.<LayoutConfiguration, Integer>unmodifiableMap(CollectionLiterals.<LayoutConfiguration, Integer>newHashMap(_mappedTo, _mappedTo_1, _mappedTo_2));
  }
  
  protected List<? extends Class<? extends Node>> _getInnerOrder(final Entrypoints entrypoints) {
    return Collections.<Class<? extends Node>>unmodifiableList(CollectionLiterals.<Class<? extends Node>>newArrayList(APISIB.class));
  }
  
  public Map<LayoutConfiguration, ?> getLayoutConfiguration(final Container it) {
    if (it instanceof Entrypoints) {
      return _getLayoutConfiguration((Entrypoints)it);
    } else if (it != null) {
      return _getLayoutConfiguration(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public List<? extends Class<? extends Node>> getInnerOrder(final Container entrypoints) {
    if (entrypoints instanceof Entrypoints) {
      return _getInnerOrder((Entrypoints)entrypoints);
    } else if (entrypoints != null) {
      return _getInnerOrder(entrypoints);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(entrypoints).toString());
    }
  }
}
