/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.checks;

import de.jabc.cinco.meta.plugin.mcam.runtime.core.CincoCheckModule;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.PrimitiveAttribute;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.data.TypeAttribute;
import info.scce.dime.graphql.schema.graphql.GraphQL;
import info.scce.dime.graphql.schema.graphql.Resolver;
import info.scce.dime.graphql.schema.graphql.ResolverAttribute;
import info.scce.dime.graphql.schema.mcam.adapter.GraphQLAdapter;
import info.scce.dime.graphql.schema.mcam.adapter.GraphQLId;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.OutputPort;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveType;
import info.scce.dime.process.process.StartSIB;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ResolverProcessSignatureCheck extends CincoCheckModule<GraphQLId, GraphQL, GraphQLAdapter> {
  @Override
  public void check(final GraphQL model) {
    final Consumer<Resolver> _function = new Consumer<Resolver>() {
      @Override
      public void accept(final Resolver resolver) {
        final Type referencedType = resolver.getReferencedType();
        final Consumer<ResolverAttribute> _function = new Consumer<ResolverAttribute>() {
          @Override
          public void accept(final ResolverAttribute resolverAttribute) {
            final TypeAttribute referencedAttribute = resolverAttribute.getReferencedAttribute();
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(resolverAttribute.getResolverProcesss());
            boolean _not = (!_isNullOrEmpty);
            if (_not) {
              final info.scce.dime.process.process.Process referencedProcess = resolverAttribute.getResolverProcesss().get(0).getResolverProcess();
              int _length = ((Object[])Conversions.unwrapArray(referencedProcess.getEndSIBs(), Object.class)).length;
              boolean _tripleNotEquals = (_length != 1);
              if (_tripleNotEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Process in \"");
                String _name = referencedType.getName();
                _builder.append(_name);
                _builder.append("::");
                String _name_1 = referencedAttribute.getName();
                _builder.append(_name_1);
                _builder.append("\" must have exaclty one EndSIB");
                ResolverProcessSignatureCheck.this.addError(referencedProcess, _builder.toString());
              } else {
                final StartSIB startSIB = referencedProcess.getStartSIBs().get(0);
                final EndSIB endSIB = referencedProcess.getEndSIBs().get(0);
                int _length_1 = ((Object[])Conversions.unwrapArray(startSIB.getOutputPorts(), Object.class)).length;
                boolean _tripleNotEquals_1 = (_length_1 != 1);
                if (_tripleNotEquals_1) {
                  StringConcatenation _builder_1 = new StringConcatenation();
                  _builder_1.append("StartSIB in process \"");
                  String _displayName = referencedProcess.getDisplayName();
                  _builder_1.append(_displayName);
                  _builder_1.append("\" must have exaclty one output port");
                  ResolverProcessSignatureCheck.this.addError(referencedProcess, _builder_1.toString());
                } else {
                  final OutputPort output = startSIB.getOutputPorts().get(0);
                  if (((!(output instanceof ComplexOutputPort)) || (referencedType.getName() != ((ComplexOutputPort) output).getDataType().getName()))) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Input of process \"");
                    String _displayName_1 = referencedProcess.getDisplayName();
                    _builder_2.append(_displayName_1);
                    _builder_2.append("\" must by of type \"");
                    String _name_2 = referencedType.getName();
                    _builder_2.append(_name_2);
                    _builder_2.append("\"");
                    ResolverProcessSignatureCheck.this.addError(referencedProcess, _builder_2.toString());
                  }
                }
                int _length_2 = ((Object[])Conversions.unwrapArray(endSIB.getInputPorts(), Object.class)).length;
                boolean _tripleNotEquals_2 = (_length_2 != 1);
                if (_tripleNotEquals_2) {
                  StringConcatenation _builder_3 = new StringConcatenation();
                  _builder_3.append("StartSIB in process \"");
                  String _displayName_2 = referencedProcess.getDisplayName();
                  _builder_3.append(_displayName_2);
                  _builder_3.append("\" must have exaclty one input port");
                  ResolverProcessSignatureCheck.this.addError(referencedProcess, _builder_3.toString());
                } else {
                  final InputPort input = endSIB.getInputPorts().get(0);
                  if ((referencedAttribute instanceof PrimitiveAttribute)) {
                    if (((!(input instanceof PrimitiveInputPort)) || (((PrimitiveInputPort) input).getDataType().getName() != ((PrimitiveAttribute)referencedAttribute).getDataType().getName()))) {
                      StringConcatenation _builder_4 = new StringConcatenation();
                      _builder_4.append("Output in process \"");
                      String _displayName_3 = referencedProcess.getDisplayName();
                      _builder_4.append(_displayName_3);
                      _builder_4.append("\" must be a primitive attribute of type \"");
                      PrimitiveType _dataType = ((PrimitiveInputPort) input).getDataType();
                      _builder_4.append(_dataType);
                      _builder_4.append("\"");
                      ResolverProcessSignatureCheck.this.addError(referencedProcess, _builder_4.toString());
                    }
                  } else {
                    if ((referencedAttribute instanceof ComplexAttribute)) {
                      if (((!(input instanceof ComplexInputPort)) || (((ComplexInputPort) input).getDataType().getName() != ((ComplexAttribute)referencedAttribute).getDataType().getName()))) {
                        StringConcatenation _builder_5 = new StringConcatenation();
                        _builder_5.append("Output in process \"");
                        String _displayName_4 = referencedProcess.getDisplayName();
                        _builder_5.append(_displayName_4);
                        _builder_5.append("\" must be a complex attribute of type \"");
                        String _name_3 = ((ComplexInputPort) input).getDataType().getName();
                        _builder_5.append(_name_3);
                        _builder_5.append("\"");
                        ResolverProcessSignatureCheck.this.addError(referencedProcess, _builder_5.toString());
                      }
                    }
                  }
                  String _branchName = endSIB.getBranchName();
                  boolean _tripleNotEquals_3 = (_branchName != "success");
                  if (_tripleNotEquals_3) {
                    StringConcatenation _builder_6 = new StringConcatenation();
                    _builder_6.append("EndSIB in process \"");
                    String _displayName_5 = referencedProcess.getDisplayName();
                    _builder_6.append(_displayName_5);
                    _builder_6.append("\" must be labeled with \"success\"");
                    ResolverProcessSignatureCheck.this.addError(referencedProcess, _builder_6.toString());
                  }
                }
              }
            }
          }
        };
        resolver.getResolverAttributes().forEach(_function);
      }
    };
    model.getResolverss().get(0).getResolvers().forEach(_function);
  }
}
