/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.checks;

import de.jabc.cinco.meta.plugin.mcam.runtime.core.CincoCheckModule;
import info.scce.dime.graphql.schema.graphql.APISIB;
import info.scce.dime.graphql.schema.graphql.GraphQL;
import info.scce.dime.graphql.schema.mcam.adapter.GraphQLAdapter;
import info.scce.dime.graphql.schema.mcam.adapter.GraphQLId;
import java.util.HashSet;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Checks if mutation names are unique.
 */
@SuppressWarnings("all")
public class DuplicateMutationNameCheck extends CincoCheckModule<GraphQLId, GraphQL, GraphQLAdapter> {
  @Override
  public void check(final GraphQL model) {
    final HashSet<String> seenMutationNames = new HashSet<String>();
    final Consumer<APISIB> _function = new Consumer<APISIB>() {
      @Override
      public void accept(final APISIB it) {
        final String name = it.getModel().getModelName();
        boolean _contains = seenMutationNames.contains(name);
        if (_contains) {
          GraphQLId _idByString = DuplicateMutationNameCheck.this.adapter.getIdByString(it.getId());
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("Duplicate mutation name: ");
          _builder.append(name);
          DuplicateMutationNameCheck.this.addError(_idByString, _builder.toString());
        } else {
          seenMutationNames.add(name);
        }
      }
    };
    model.getMutationss().get(0).getAPISIBs().forEach(_function);
  }
}
