/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.checks;

import de.jabc.cinco.meta.plugin.mcam.runtime.core.CincoCheckModule;
import info.scce.dime.data.data.UserType;
import info.scce.dime.graphql.api.api.APIinputPort;
import info.scce.dime.graphql.api.api.ComplexAPIinput;
import info.scce.dime.graphql.schema.graphql.APISIB;
import info.scce.dime.graphql.schema.graphql.ForbiddenType;
import info.scce.dime.graphql.schema.graphql.ForbiddenUserType;
import info.scce.dime.graphql.schema.graphql.GraphQL;
import info.scce.dime.graphql.schema.graphql.Type;
import info.scce.dime.graphql.schema.mcam.adapter.GraphQLAdapter;
import info.scce.dime.graphql.schema.mcam.adapter.GraphQLId;
import java.io.File;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Check if complex properties that are used as input arguments for queries and mutations
 * are present in the Data container and are marked as input.
 */
@SuppressWarnings("all")
public class DeclaredInputsCheck extends CincoCheckModule<GraphQLId, GraphQL, GraphQLAdapter> {
  @Override
  public void check(final GraphQL model) {
    final Function1<Type, Boolean> _function = new Function1<Type, Boolean>() {
      @Override
      public Boolean apply(final Type it) {
        return Boolean.valueOf(it.isInput());
      }
    };
    final Function1<Type, info.scce.dime.data.data.Type> _function_1 = new Function1<Type, info.scce.dime.data.data.Type>() {
      @Override
      public info.scce.dime.data.data.Type apply(final Type it) {
        info.scce.dime.data.data.Type _xifexpression = null;
        if ((it instanceof ForbiddenType)) {
          _xifexpression = ((ForbiddenType)it).getReferencedType();
        } else {
          UserType _xifexpression_1 = null;
          if ((it instanceof ForbiddenUserType)) {
            _xifexpression_1 = ((ForbiddenUserType)it).getReferencedType();
          }
          _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
      }
    };
    final Iterable<info.scce.dime.data.data.Type> inputTypes = IterableExtensions.<Type, info.scce.dime.data.data.Type>map(IterableExtensions.<Type>filter(model.getForbiddenTypess().get(0).getTypes(), _function), _function_1);
    this.checkUndeclaredInputs(inputTypes, model.getQueriess().get(0).getAPISIBs(), "query");
    this.checkUndeclaredInputs(inputTypes, model.getMutationss().get(0).getAPISIBs(), "mutation");
  }
  
  public void checkUndeclaredInputs(final Iterable<info.scce.dime.data.data.Type> inputTypes, final Iterable<APISIB> sibs, final String type) {
    final Consumer<APISIB> _function = new Consumer<APISIB>() {
      @Override
      public void accept(final APISIB sib) {
        final Function1<APIinputPort, Boolean> _function = new Function1<APIinputPort, Boolean>() {
          @Override
          public Boolean apply(final APIinputPort it) {
            return Boolean.valueOf((it instanceof ComplexAPIinput));
          }
        };
        final Function1<APIinputPort, ComplexAPIinput> _function_1 = new Function1<APIinputPort, ComplexAPIinput>() {
          @Override
          public ComplexAPIinput apply(final APIinputPort it) {
            return ((ComplexAPIinput) it);
          }
        };
        final Function1<ComplexAPIinput, Boolean> _function_2 = new Function1<ComplexAPIinput, Boolean>() {
          @Override
          public Boolean apply(final ComplexAPIinput it) {
            final Function1<info.scce.dime.data.data.Type, Boolean> _function = new Function1<info.scce.dime.data.data.Type, Boolean>() {
              @Override
              public Boolean apply(final info.scce.dime.data.data.Type t) {
                return Boolean.valueOf(t.getId().equals(it.getDataType().getId()));
              }
            };
            boolean _exists = IterableExtensions.<info.scce.dime.data.data.Type>exists(inputTypes, _function);
            return Boolean.valueOf((!_exists));
          }
        };
        final Consumer<ComplexAPIinput> _function_3 = new Consumer<ComplexAPIinput>() {
          @Override
          public void accept(final ComplexAPIinput input) {
            GraphQLId _idByString = DeclaredInputsCheck.this.adapter.getIdByString(sib.getId());
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("type \"");
            String _name = input.getDataType().getName();
            _builder.append(_name);
            _builder.append("\" in ");
            _builder.append(type);
            _builder.append(" \"");
            String _queryOrMutationName = DeclaredInputsCheck.this.queryOrMutationName(sib);
            _builder.append(_queryOrMutationName);
            _builder.append("\" is not an input type");
            DeclaredInputsCheck.this.addError(_idByString, _builder.toString());
          }
        };
        IterableExtensions.<ComplexAPIinput>filter(IterableExtensions.<APIinputPort, ComplexAPIinput>map(IterableExtensions.<APIinputPort>filter(sib.getModel().getStartSIBs().get(0).getAPIinputPorts(), _function), _function_1), _function_2).forEach(_function_3);
      }
    };
    sibs.forEach(_function);
  }
  
  public String queryOrMutationName(final APISIB sib) {
    return IterableExtensions.<String>last(((Iterable<String>)Conversions.doWrapArray(this._resourceExtension.getFile(sib.getModel().eResource()).getName().split(File.separator))));
  }
}
