package info.scce.dime.graphql.api.factory;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.Type;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalModelElementContainer;
import graphmodel.internal.InternalNode;
import graphmodel.internal.InternalType;
import info.scce.dime.graphql.api.adapter.APIEContentAdapter;
import info.scce.dime.graphql.api.adapter.BranchConnectorEContentAdapter;
import info.scce.dime.graphql.api.adapter.BranchEContentAdapter;
import info.scce.dime.graphql.api.adapter.ComplexAPIinputEContentAdapter;
import info.scce.dime.graphql.api.adapter.ComplexAPIoutputEContentAdapter;
import info.scce.dime.graphql.api.adapter.ComplexDirectDataFlowEContentAdapter;
import info.scce.dime.graphql.api.adapter.ComplexInputPortEContentAdapter;
import info.scce.dime.graphql.api.adapter.ComplexOutputPortEContentAdapter;
import info.scce.dime.graphql.api.adapter.ControlFlowEContentAdapter;
import info.scce.dime.graphql.api.adapter.EndSIBEContentAdapter;
import info.scce.dime.graphql.api.adapter.ErrorSIBEContentAdapter;
import info.scce.dime.graphql.api.adapter.PrimitiveAPIinputEContentAdapter;
import info.scce.dime.graphql.api.adapter.PrimitiveAPIoutputEContentAdapter;
import info.scce.dime.graphql.api.adapter.PrimitiveDirectDataFlowEContentAdapter;
import info.scce.dime.graphql.api.adapter.PrimitiveInputPortEContentAdapter;
import info.scce.dime.graphql.api.adapter.PrimitiveOutputPortEContentAdapter;
import info.scce.dime.graphql.api.adapter.ProcessSIBEContentAdapter;
import info.scce.dime.graphql.api.adapter.StartSIBEContentAdapter;
import info.scce.dime.graphql.api.api.API;
import info.scce.dime.graphql.api.api.ApiPackage;
import info.scce.dime.graphql.api.api.Branch;
import info.scce.dime.graphql.api.api.BranchConnector;
import info.scce.dime.graphql.api.api.ComplexAPIinput;
import info.scce.dime.graphql.api.api.ComplexAPIoutput;
import info.scce.dime.graphql.api.api.ComplexDirectDataFlow;
import info.scce.dime.graphql.api.api.ComplexInputPort;
import info.scce.dime.graphql.api.api.ComplexOutputPort;
import info.scce.dime.graphql.api.api.ControlFlow;
import info.scce.dime.graphql.api.api.EndSIB;
import info.scce.dime.graphql.api.api.ErrorSIB;
import info.scce.dime.graphql.api.api.PrimitiveAPIinput;
import info.scce.dime.graphql.api.api.PrimitiveAPIoutput;
import info.scce.dime.graphql.api.api.PrimitiveDirectDataFlow;
import info.scce.dime.graphql.api.api.PrimitiveInputPort;
import info.scce.dime.graphql.api.api.PrimitiveOutputPort;
import info.scce.dime.graphql.api.api.ProcessSIB;
import info.scce.dime.graphql.api.api.StartSIB;
import info.scce.dime.graphql.api.api.impl.ApiFactoryImpl;
import info.scce.dime.graphql.api.api.internal.InternalAPI;
import info.scce.dime.graphql.api.api.internal.InternalBranch;
import info.scce.dime.graphql.api.api.internal.InternalBranchConnector;
import info.scce.dime.graphql.api.api.internal.InternalComplexAPIinput;
import info.scce.dime.graphql.api.api.internal.InternalComplexAPIoutput;
import info.scce.dime.graphql.api.api.internal.InternalComplexDirectDataFlow;
import info.scce.dime.graphql.api.api.internal.InternalComplexInputPort;
import info.scce.dime.graphql.api.api.internal.InternalComplexOutputPort;
import info.scce.dime.graphql.api.api.internal.InternalControlFlow;
import info.scce.dime.graphql.api.api.internal.InternalEndSIB;
import info.scce.dime.graphql.api.api.internal.InternalErrorSIB;
import info.scce.dime.graphql.api.api.internal.InternalFactory;
import info.scce.dime.graphql.api.api.internal.InternalPrimitiveAPIinput;
import info.scce.dime.graphql.api.api.internal.InternalPrimitiveAPIoutput;
import info.scce.dime.graphql.api.api.internal.InternalPrimitiveDirectDataFlow;
import info.scce.dime.graphql.api.api.internal.InternalPrimitiveInputPort;
import info.scce.dime.graphql.api.api.internal.InternalPrimitiveOutputPort;
import info.scce.dime.graphql.api.api.internal.InternalProcessSIB;
import info.scce.dime.graphql.api.api.internal.InternalStartSIB;
import info.scce.dime.graphql.hooks.APIInit;
import info.scce.dime.graphql.hooks.APIoutputPortHook;
import info.scce.dime.graphql.hooks.DirectDataFlowPostCreate;
import info.scce.dime.graphql.hooks.InputPortHook;
import info.scce.dime.graphql.hooks.OutputPortHook;
import info.scce.dime.graphql.hooks.PortPostCreateHook;
import info.scce.dime.graphql.hooks.ProcessSIBPostCreateHook;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class APIFactory extends ApiFactoryImpl {
  @Extension
  private final InternalFactory _internalFactory = InternalFactory.eINSTANCE;
  
  public static APIFactory eINSTANCE = APIFactory.init();
  
  @Extension
  private WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
  
  public static APIFactory init() {
    APIFactory _xblockexpression = null;
    {
      try {
        EFactory _eFactory = EPackage.Registry.INSTANCE.getEFactory(ApiPackage.eNS_URI);
        final APIFactory fct = ((APIFactory) _eFactory);
        if ((fct != null)) {
          return ((APIFactory) fct);
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception exception = (Exception)_t;
          EcorePlugin.INSTANCE.log(exception);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
      _xblockexpression = new APIFactory();
    }
    return _xblockexpression;
  }
  
  /**
   * This method creates an StartSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public StartSIB createStartSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    StartSIB _createStartSIB = super.createStartSIB();
    final Procedure1<StartSIB> _function = new Procedure1<StartSIB>() {
      @Override
      public void apply(final StartSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalStartSIB _createInternalStartSIB = APIFactory.this._internalFactory.createInternalStartSIB();
          _elvis = _createInternalStartSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            StartSIBEContentAdapter _startSIBEContentAdapter = new StartSIBEContentAdapter();
            _eAdapters.add(_startSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<StartSIB>operator_doubleArrow(_createStartSIB, _function);
  }
  
  /**
   * This method creates an StartSIB with the given id. Post create hook won't be triggered.
   */
  public StartSIB createStartSIB(final String ID) {
    return this.createStartSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an StartSIB with the given id. Post create hook will be triggered.
   */
  public StartSIB createStartSIB(final InternalModelElementContainer parent) {
    return this.createStartSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an StartSIB with the given id. Post create hook will be triggered.
   */
  public StartSIB createStartSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createStartSIB(ID, null, parent, true);
  }
  
  public StartSIB createStartSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createStartSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an StartSIB with the given id. Post create hook won't be triggered.
   */
  public StartSIB createStartSIB(final InternalModelElement ime) {
    return this.createStartSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public StartSIB createStartSIB() {
    return this.createStartSIB(EcoreUtil.generateUUID());
  }
  
  public ComplexDirectDataFlow createComplexDirectDataFlow(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    ComplexDirectDataFlow _createComplexDirectDataFlow = super.createComplexDirectDataFlow();
    final Procedure1<ComplexDirectDataFlow> _function = new Procedure1<ComplexDirectDataFlow>() {
      @Override
      public void apply(final ComplexDirectDataFlow it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexDirectDataFlow _createInternalComplexDirectDataFlow = APIFactory.this._internalFactory.createInternalComplexDirectDataFlow();
          _elvis = _createInternalComplexDirectDataFlow;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexDirectDataFlowEContentAdapter _complexDirectDataFlowEContentAdapter = new ComplexDirectDataFlowEContentAdapter();
            _eAdapters.add(_complexDirectDataFlowEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          APIFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexDirectDataFlow>operator_doubleArrow(_createComplexDirectDataFlow, _function);
  }
  
  /**
   * This method creates an ComplexDirectDataFlow with the given id. Post create hook will be triggered.
   */
  public ComplexDirectDataFlow createComplexDirectDataFlow(final String ID, final InternalNode source, final InternalNode target) {
    return this.createComplexDirectDataFlow(ID, null, source, target, true);
  }
  
  /**
   * This method creates an ComplexDirectDataFlow with generated id. Post create hook will be triggered.
   */
  public ComplexDirectDataFlow createComplexDirectDataFlow(final InternalNode source, final InternalNode target) {
    return this.createComplexDirectDataFlow(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an ComplexDirectDataFlow with the given id. Post create hook won't be triggered.
   */
  public ComplexDirectDataFlow createComplexDirectDataFlow(final String ID) {
    return this.createComplexDirectDataFlow(ID, null, null, null, false);
  }
  
  /**
   * This method creates an ComplexDirectDataFlow with a generated id. Post create hook won't be triggered.
   */
  @Override
  public ComplexDirectDataFlow createComplexDirectDataFlow() {
    return this.createComplexDirectDataFlow(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Branch with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Branch createBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Branch _createBranch = super.createBranch();
    final Procedure1<Branch> _function = new Procedure1<Branch>() {
      @Override
      public void apply(final Branch it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBranch _createInternalBranch = APIFactory.this._internalFactory.createInternalBranch();
          _elvis = _createInternalBranch;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            BranchEContentAdapter _branchEContentAdapter = new BranchEContentAdapter();
            _eAdapters.add(_branchEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<Branch>operator_doubleArrow(_createBranch, _function);
  }
  
  /**
   * This method creates an Branch with the given id. Post create hook won't be triggered.
   */
  public Branch createBranch(final String ID) {
    return this.createBranch(ID, null, null, false);
  }
  
  /**
   * This method creates an Branch with the given id. Post create hook will be triggered.
   */
  public Branch createBranch(final InternalModelElementContainer parent) {
    return this.createBranch(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Branch with the given id. Post create hook will be triggered.
   */
  public Branch createBranch(final String ID, final InternalModelElementContainer parent) {
    return this.createBranch(ID, null, parent, true);
  }
  
  public Branch createBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createBranch(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Branch with the given id. Post create hook won't be triggered.
   */
  public Branch createBranch(final InternalModelElement ime) {
    return this.createBranch(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Branch createBranch() {
    return this.createBranch(EcoreUtil.generateUUID());
  }
  
  public BranchConnector createBranchConnector(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    BranchConnector _createBranchConnector = super.createBranchConnector();
    final Procedure1<BranchConnector> _function = new Procedure1<BranchConnector>() {
      @Override
      public void apply(final BranchConnector it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBranchConnector _createInternalBranchConnector = APIFactory.this._internalFactory.createInternalBranchConnector();
          _elvis = _createInternalBranchConnector;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            BranchConnectorEContentAdapter _branchConnectorEContentAdapter = new BranchConnectorEContentAdapter();
            _eAdapters.add(_branchConnectorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<BranchConnector>operator_doubleArrow(_createBranchConnector, _function);
  }
  
  /**
   * This method creates an BranchConnector with the given id. Post create hook will be triggered.
   */
  public BranchConnector createBranchConnector(final String ID, final InternalNode source, final InternalNode target) {
    return this.createBranchConnector(ID, null, source, target, true);
  }
  
  /**
   * This method creates an BranchConnector with generated id. Post create hook will be triggered.
   */
  public BranchConnector createBranchConnector(final InternalNode source, final InternalNode target) {
    return this.createBranchConnector(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an BranchConnector with the given id. Post create hook won't be triggered.
   */
  public BranchConnector createBranchConnector(final String ID) {
    return this.createBranchConnector(ID, null, null, null, false);
  }
  
  /**
   * This method creates an BranchConnector with a generated id. Post create hook won't be triggered.
   */
  @Override
  public BranchConnector createBranchConnector() {
    return this.createBranchConnector(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an API with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public API createAPI(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    API _createAPI = super.createAPI();
    final Procedure1<API> _function = new Procedure1<API>() {
      @Override
      public void apply(final API it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalAPI _createInternalAPI = APIFactory.this._internalFactory.createInternalAPI();
          _elvis = _createInternalAPI;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            APIEContentAdapter _aPIEContentAdapter = new APIEContentAdapter();
            _eAdapters.add(_aPIEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          APIFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<API>operator_doubleArrow(_createAPI, _function);
  }
  
  /**
   * This method creates an API with the given id. Post create hook won't be triggered.
   */
  public API createAPI(final String ID) {
    return this.createAPI(ID, null, null, false);
  }
  
  /**
   * This method creates an API with the given id. Post create hook will be triggered.
   */
  public API createAPI(final InternalModelElementContainer parent) {
    return this.createAPI(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an API with the given id. Post create hook will be triggered.
   */
  public API createAPI(final String ID, final InternalModelElementContainer parent) {
    return this.createAPI(ID, null, parent, true);
  }
  
  public API createAPI(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createAPI(ID, ime, parent, true);
  }
  
  /**
   * This method creates an API with the given id. Post create hook won't be triggered.
   */
  public API createAPI(final InternalModelElement ime) {
    return this.createAPI(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public API createAPI() {
    return this.createAPI(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexInputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexInputPort createComplexInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexInputPort _createComplexInputPort = super.createComplexInputPort();
    final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
      @Override
      public void apply(final ComplexInputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexInputPort _createInternalComplexInputPort = APIFactory.this._internalFactory.createInternalComplexInputPort();
          _elvis = _createInternalComplexInputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexInputPortEContentAdapter _complexInputPortEContentAdapter = new ComplexInputPortEContentAdapter();
            _eAdapters.add(_complexInputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          APIFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_createComplexInputPort, _function);
  }
  
  /**
   * This method creates an ComplexInputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexInputPort createComplexInputPort(final String ID) {
    return this.createComplexInputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexInputPort with the given id. Post create hook will be triggered.
   */
  public ComplexInputPort createComplexInputPort(final InternalModelElementContainer parent) {
    return this.createComplexInputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexInputPort with the given id. Post create hook will be triggered.
   */
  public ComplexInputPort createComplexInputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexInputPort(ID, null, parent, true);
  }
  
  public ComplexInputPort createComplexInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexInputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexInputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexInputPort createComplexInputPort(final InternalModelElement ime) {
    return this.createComplexInputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexInputPort createComplexInputPort() {
    return this.createComplexInputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexOutputPort createComplexOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexOutputPort _createComplexOutputPort = super.createComplexOutputPort();
    final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
      @Override
      public void apply(final ComplexOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexOutputPort _createInternalComplexOutputPort = APIFactory.this._internalFactory.createInternalComplexOutputPort();
          _elvis = _createInternalComplexOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexOutputPortEContentAdapter _complexOutputPortEContentAdapter = new ComplexOutputPortEContentAdapter();
            _eAdapters.add(_complexOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          APIFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_createComplexOutputPort, _function);
  }
  
  /**
   * This method creates an ComplexOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexOutputPort createComplexOutputPort(final String ID) {
    return this.createComplexOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexOutputPort createComplexOutputPort(final InternalModelElementContainer parent) {
    return this.createComplexOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexOutputPort createComplexOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexOutputPort(ID, null, parent, true);
  }
  
  public ComplexOutputPort createComplexOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexOutputPort createComplexOutputPort(final InternalModelElement ime) {
    return this.createComplexOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexOutputPort createComplexOutputPort() {
    return this.createComplexOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexAPIinput with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexAPIinput createComplexAPIinput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexAPIinput _createComplexAPIinput = super.createComplexAPIinput();
    final Procedure1<ComplexAPIinput> _function = new Procedure1<ComplexAPIinput>() {
      @Override
      public void apply(final ComplexAPIinput it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexAPIinput _createInternalComplexAPIinput = APIFactory.this._internalFactory.createInternalComplexAPIinput();
          _elvis = _createInternalComplexAPIinput;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexAPIinputEContentAdapter _complexAPIinputEContentAdapter = new ComplexAPIinputEContentAdapter();
            _eAdapters.add(_complexAPIinputEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          APIFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexAPIinput>operator_doubleArrow(_createComplexAPIinput, _function);
  }
  
  /**
   * This method creates an ComplexAPIinput with the given id. Post create hook won't be triggered.
   */
  public ComplexAPIinput createComplexAPIinput(final String ID) {
    return this.createComplexAPIinput(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexAPIinput with the given id. Post create hook will be triggered.
   */
  public ComplexAPIinput createComplexAPIinput(final InternalModelElementContainer parent) {
    return this.createComplexAPIinput(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexAPIinput with the given id. Post create hook will be triggered.
   */
  public ComplexAPIinput createComplexAPIinput(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexAPIinput(ID, null, parent, true);
  }
  
  public ComplexAPIinput createComplexAPIinput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexAPIinput(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexAPIinput with the given id. Post create hook won't be triggered.
   */
  public ComplexAPIinput createComplexAPIinput(final InternalModelElement ime) {
    return this.createComplexAPIinput(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexAPIinput createComplexAPIinput() {
    return this.createComplexAPIinput(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ErrorSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ErrorSIB createErrorSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ErrorSIB _createErrorSIB = super.createErrorSIB();
    final Procedure1<ErrorSIB> _function = new Procedure1<ErrorSIB>() {
      @Override
      public void apply(final ErrorSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalErrorSIB _createInternalErrorSIB = APIFactory.this._internalFactory.createInternalErrorSIB();
          _elvis = _createInternalErrorSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ErrorSIBEContentAdapter _errorSIBEContentAdapter = new ErrorSIBEContentAdapter();
            _eAdapters.add(_errorSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ErrorSIB>operator_doubleArrow(_createErrorSIB, _function);
  }
  
  /**
   * This method creates an ErrorSIB with the given id. Post create hook won't be triggered.
   */
  public ErrorSIB createErrorSIB(final String ID) {
    return this.createErrorSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an ErrorSIB with the given id. Post create hook will be triggered.
   */
  public ErrorSIB createErrorSIB(final InternalModelElementContainer parent) {
    return this.createErrorSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ErrorSIB with the given id. Post create hook will be triggered.
   */
  public ErrorSIB createErrorSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createErrorSIB(ID, null, parent, true);
  }
  
  public ErrorSIB createErrorSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createErrorSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ErrorSIB with the given id. Post create hook won't be triggered.
   */
  public ErrorSIB createErrorSIB(final InternalModelElement ime) {
    return this.createErrorSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ErrorSIB createErrorSIB() {
    return this.createErrorSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an EndSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public EndSIB createEndSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    EndSIB _createEndSIB = super.createEndSIB();
    final Procedure1<EndSIB> _function = new Procedure1<EndSIB>() {
      @Override
      public void apply(final EndSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalEndSIB _createInternalEndSIB = APIFactory.this._internalFactory.createInternalEndSIB();
          _elvis = _createInternalEndSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            EndSIBEContentAdapter _endSIBEContentAdapter = new EndSIBEContentAdapter();
            _eAdapters.add(_endSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<EndSIB>operator_doubleArrow(_createEndSIB, _function);
  }
  
  /**
   * This method creates an EndSIB with the given id. Post create hook won't be triggered.
   */
  public EndSIB createEndSIB(final String ID) {
    return this.createEndSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an EndSIB with the given id. Post create hook will be triggered.
   */
  public EndSIB createEndSIB(final InternalModelElementContainer parent) {
    return this.createEndSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an EndSIB with the given id. Post create hook will be triggered.
   */
  public EndSIB createEndSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createEndSIB(ID, null, parent, true);
  }
  
  public EndSIB createEndSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createEndSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an EndSIB with the given id. Post create hook won't be triggered.
   */
  public EndSIB createEndSIB(final InternalModelElement ime) {
    return this.createEndSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public EndSIB createEndSIB() {
    return this.createEndSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveOutputPort createPrimitiveOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveOutputPort _createPrimitiveOutputPort = super.createPrimitiveOutputPort();
    final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
      @Override
      public void apply(final PrimitiveOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveOutputPort _createInternalPrimitiveOutputPort = APIFactory.this._internalFactory.createInternalPrimitiveOutputPort();
          _elvis = _createInternalPrimitiveOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveOutputPortEContentAdapter _primitiveOutputPortEContentAdapter = new PrimitiveOutputPortEContentAdapter();
            _eAdapters.add(_primitiveOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_createPrimitiveOutputPort, _function);
  }
  
  /**
   * This method creates an PrimitiveOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveOutputPort createPrimitiveOutputPort(final String ID) {
    return this.createPrimitiveOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveOutputPort createPrimitiveOutputPort(final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveOutputPort createPrimitiveOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPort(ID, null, parent, true);
  }
  
  public PrimitiveOutputPort createPrimitiveOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveOutputPort createPrimitiveOutputPort(final InternalModelElement ime) {
    return this.createPrimitiveOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveOutputPort createPrimitiveOutputPort() {
    return this.createPrimitiveOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProcessSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProcessSIB createProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProcessSIB _createProcessSIB = super.createProcessSIB();
    final Procedure1<ProcessSIB> _function = new Procedure1<ProcessSIB>() {
      @Override
      public void apply(final ProcessSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProcessSIB _createInternalProcessSIB = APIFactory.this._internalFactory.createInternalProcessSIB();
          _elvis = _createInternalProcessSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProcessSIBEContentAdapter _processSIBEContentAdapter = new ProcessSIBEContentAdapter();
            _eAdapters.add(_processSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          APIFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ProcessSIB>operator_doubleArrow(_createProcessSIB, _function);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessSIB createProcessSIB(final String ID) {
    return this.createProcessSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
   */
  public ProcessSIB createProcessSIB(final InternalModelElementContainer parent) {
    return this.createProcessSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
   */
  public ProcessSIB createProcessSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createProcessSIB(ID, null, parent, true);
  }
  
  public ProcessSIB createProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProcessSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessSIB createProcessSIB(final InternalModelElement ime) {
    return this.createProcessSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProcessSIB createProcessSIB() {
    return this.createProcessSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexAPIoutput with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexAPIoutput createComplexAPIoutput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexAPIoutput _createComplexAPIoutput = super.createComplexAPIoutput();
    final Procedure1<ComplexAPIoutput> _function = new Procedure1<ComplexAPIoutput>() {
      @Override
      public void apply(final ComplexAPIoutput it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexAPIoutput _createInternalComplexAPIoutput = APIFactory.this._internalFactory.createInternalComplexAPIoutput();
          _elvis = _createInternalComplexAPIoutput;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexAPIoutputEContentAdapter _complexAPIoutputEContentAdapter = new ComplexAPIoutputEContentAdapter();
            _eAdapters.add(_complexAPIoutputEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          APIFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexAPIoutput>operator_doubleArrow(_createComplexAPIoutput, _function);
  }
  
  /**
   * This method creates an ComplexAPIoutput with the given id. Post create hook won't be triggered.
   */
  public ComplexAPIoutput createComplexAPIoutput(final String ID) {
    return this.createComplexAPIoutput(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexAPIoutput with the given id. Post create hook will be triggered.
   */
  public ComplexAPIoutput createComplexAPIoutput(final InternalModelElementContainer parent) {
    return this.createComplexAPIoutput(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexAPIoutput with the given id. Post create hook will be triggered.
   */
  public ComplexAPIoutput createComplexAPIoutput(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexAPIoutput(ID, null, parent, true);
  }
  
  public ComplexAPIoutput createComplexAPIoutput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexAPIoutput(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexAPIoutput with the given id. Post create hook won't be triggered.
   */
  public ComplexAPIoutput createComplexAPIoutput(final InternalModelElement ime) {
    return this.createComplexAPIoutput(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexAPIoutput createComplexAPIoutput() {
    return this.createComplexAPIoutput(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveAPIoutput with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveAPIoutput createPrimitiveAPIoutput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveAPIoutput _createPrimitiveAPIoutput = super.createPrimitiveAPIoutput();
    final Procedure1<PrimitiveAPIoutput> _function = new Procedure1<PrimitiveAPIoutput>() {
      @Override
      public void apply(final PrimitiveAPIoutput it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveAPIoutput _createInternalPrimitiveAPIoutput = APIFactory.this._internalFactory.createInternalPrimitiveAPIoutput();
          _elvis = _createInternalPrimitiveAPIoutput;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveAPIoutputEContentAdapter _primitiveAPIoutputEContentAdapter = new PrimitiveAPIoutputEContentAdapter();
            _eAdapters.add(_primitiveAPIoutputEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveAPIoutput>operator_doubleArrow(_createPrimitiveAPIoutput, _function);
  }
  
  /**
   * This method creates an PrimitiveAPIoutput with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAPIoutput createPrimitiveAPIoutput(final String ID) {
    return this.createPrimitiveAPIoutput(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveAPIoutput with the given id. Post create hook will be triggered.
   */
  public PrimitiveAPIoutput createPrimitiveAPIoutput(final InternalModelElementContainer parent) {
    return this.createPrimitiveAPIoutput(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAPIoutput with the given id. Post create hook will be triggered.
   */
  public PrimitiveAPIoutput createPrimitiveAPIoutput(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveAPIoutput(ID, null, parent, true);
  }
  
  public PrimitiveAPIoutput createPrimitiveAPIoutput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveAPIoutput(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAPIoutput with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAPIoutput createPrimitiveAPIoutput(final InternalModelElement ime) {
    return this.createPrimitiveAPIoutput(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveAPIoutput createPrimitiveAPIoutput() {
    return this.createPrimitiveAPIoutput(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveAPIinput with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveAPIinput createPrimitiveAPIinput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveAPIinput _createPrimitiveAPIinput = super.createPrimitiveAPIinput();
    final Procedure1<PrimitiveAPIinput> _function = new Procedure1<PrimitiveAPIinput>() {
      @Override
      public void apply(final PrimitiveAPIinput it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveAPIinput _createInternalPrimitiveAPIinput = APIFactory.this._internalFactory.createInternalPrimitiveAPIinput();
          _elvis = _createInternalPrimitiveAPIinput;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveAPIinputEContentAdapter _primitiveAPIinputEContentAdapter = new PrimitiveAPIinputEContentAdapter();
            _eAdapters.add(_primitiveAPIinputEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveAPIinput>operator_doubleArrow(_createPrimitiveAPIinput, _function);
  }
  
  /**
   * This method creates an PrimitiveAPIinput with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAPIinput createPrimitiveAPIinput(final String ID) {
    return this.createPrimitiveAPIinput(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveAPIinput with the given id. Post create hook will be triggered.
   */
  public PrimitiveAPIinput createPrimitiveAPIinput(final InternalModelElementContainer parent) {
    return this.createPrimitiveAPIinput(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAPIinput with the given id. Post create hook will be triggered.
   */
  public PrimitiveAPIinput createPrimitiveAPIinput(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveAPIinput(ID, null, parent, true);
  }
  
  public PrimitiveAPIinput createPrimitiveAPIinput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveAPIinput(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAPIinput with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAPIinput createPrimitiveAPIinput(final InternalModelElement ime) {
    return this.createPrimitiveAPIinput(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveAPIinput createPrimitiveAPIinput() {
    return this.createPrimitiveAPIinput(EcoreUtil.generateUUID());
  }
  
  public ControlFlow createControlFlow(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    ControlFlow _createControlFlow = super.createControlFlow();
    final Procedure1<ControlFlow> _function = new Procedure1<ControlFlow>() {
      @Override
      public void apply(final ControlFlow it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalControlFlow _createInternalControlFlow = APIFactory.this._internalFactory.createInternalControlFlow();
          _elvis = _createInternalControlFlow;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ControlFlowEContentAdapter _controlFlowEContentAdapter = new ControlFlowEContentAdapter();
            _eAdapters.add(_controlFlowEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ControlFlow>operator_doubleArrow(_createControlFlow, _function);
  }
  
  /**
   * This method creates an ControlFlow with the given id. Post create hook will be triggered.
   */
  public ControlFlow createControlFlow(final String ID, final InternalNode source, final InternalNode target) {
    return this.createControlFlow(ID, null, source, target, true);
  }
  
  /**
   * This method creates an ControlFlow with generated id. Post create hook will be triggered.
   */
  public ControlFlow createControlFlow(final InternalNode source, final InternalNode target) {
    return this.createControlFlow(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an ControlFlow with the given id. Post create hook won't be triggered.
   */
  public ControlFlow createControlFlow(final String ID) {
    return this.createControlFlow(ID, null, null, null, false);
  }
  
  /**
   * This method creates an ControlFlow with a generated id. Post create hook won't be triggered.
   */
  @Override
  public ControlFlow createControlFlow() {
    return this.createControlFlow(EcoreUtil.generateUUID());
  }
  
  public PrimitiveDirectDataFlow createPrimitiveDirectDataFlow(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    PrimitiveDirectDataFlow _createPrimitiveDirectDataFlow = super.createPrimitiveDirectDataFlow();
    final Procedure1<PrimitiveDirectDataFlow> _function = new Procedure1<PrimitiveDirectDataFlow>() {
      @Override
      public void apply(final PrimitiveDirectDataFlow it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveDirectDataFlow _createInternalPrimitiveDirectDataFlow = APIFactory.this._internalFactory.createInternalPrimitiveDirectDataFlow();
          _elvis = _createInternalPrimitiveDirectDataFlow;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveDirectDataFlowEContentAdapter _primitiveDirectDataFlowEContentAdapter = new PrimitiveDirectDataFlowEContentAdapter();
            _eAdapters.add(_primitiveDirectDataFlowEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          APIFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<PrimitiveDirectDataFlow>operator_doubleArrow(_createPrimitiveDirectDataFlow, _function);
  }
  
  /**
   * This method creates an PrimitiveDirectDataFlow with the given id. Post create hook will be triggered.
   */
  public PrimitiveDirectDataFlow createPrimitiveDirectDataFlow(final String ID, final InternalNode source, final InternalNode target) {
    return this.createPrimitiveDirectDataFlow(ID, null, source, target, true);
  }
  
  /**
   * This method creates an PrimitiveDirectDataFlow with generated id. Post create hook will be triggered.
   */
  public PrimitiveDirectDataFlow createPrimitiveDirectDataFlow(final InternalNode source, final InternalNode target) {
    return this.createPrimitiveDirectDataFlow(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an PrimitiveDirectDataFlow with the given id. Post create hook won't be triggered.
   */
  public PrimitiveDirectDataFlow createPrimitiveDirectDataFlow(final String ID) {
    return this.createPrimitiveDirectDataFlow(ID, null, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveDirectDataFlow with a generated id. Post create hook won't be triggered.
   */
  @Override
  public PrimitiveDirectDataFlow createPrimitiveDirectDataFlow() {
    return this.createPrimitiveDirectDataFlow(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveInputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveInputPort createPrimitiveInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveInputPort _createPrimitiveInputPort = super.createPrimitiveInputPort();
    final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
      @Override
      public void apply(final PrimitiveInputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveInputPort _createInternalPrimitiveInputPort = APIFactory.this._internalFactory.createInternalPrimitiveInputPort();
          _elvis = _createInternalPrimitiveInputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveInputPortEContentAdapter _primitiveInputPortEContentAdapter = new PrimitiveInputPortEContentAdapter();
            _eAdapters.add(_primitiveInputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        APIFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_createPrimitiveInputPort, _function);
  }
  
  /**
   * This method creates an PrimitiveInputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveInputPort createPrimitiveInputPort(final String ID) {
    return this.createPrimitiveInputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveInputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveInputPort createPrimitiveInputPort(final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveInputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveInputPort createPrimitiveInputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPort(ID, null, parent, true);
  }
  
  public PrimitiveInputPort createPrimitiveInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveInputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveInputPort createPrimitiveInputPort(final InternalModelElement ime) {
    return this.createPrimitiveInputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveInputPort createPrimitiveInputPort() {
    return this.createPrimitiveInputPort(EcoreUtil.generateUUID());
  }
  
  private <T extends IdentifiableElement> T setInternal(final T elm, final InternalIdentifiableElement internal) {
    final Procedure1<T> _function = new Procedure1<T>() {
      @Override
      public void apply(final T it) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getId());
        if (_isNullOrEmpty) {
          EcoreUtil.setID(it, EcoreUtil.generateUUID());
        }
        boolean _matched = false;
        if (elm instanceof GraphModel) {
          _matched=true;
          ((GraphModel)elm).setInternalElement_(((InternalGraphModel) internal));
        }
        if (!_matched) {
          if (elm instanceof ModelElement) {
            _matched=true;
            ((ModelElement)elm).setInternalElement_(((InternalModelElement) internal));
          }
        }
        if (!_matched) {
          if (elm instanceof Type) {
            _matched=true;
            ((Type)elm).setInternalElement_(((InternalType) internal));
          }
        }
      }
    };
    return ObjectExtensions.<T>operator_doubleArrow(elm, _function);
  }
  
  /**
   * This method creates a new API object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can
   * simply call the API's save method to save your changes.
   */
  public API createAPI(final String path, final String fileName) {
    IPath filePath = new Path(path).append(fileName).addFileExtension("api");
    URI uri = URI.createPlatformResourceURI(filePath.toOSString(), true);
    Resource res = new ResourceSetImpl().createResource(uri);
    API graph = APIFactory.eINSTANCE.createAPI();
    EcoreUtil.setID(graph, EcoreUtil.generateUUID());
    res.getContents().add(graph.getInternalElement_());
    this.postCreates(graph);
    try {
      res.save(null);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return graph;
  }
  
  public void postCreates(final ProcessSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ProcessSIBPostCreateHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexAPIinput me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PortPostCreateHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexOutputPort me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new OutputPortHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexInputPort me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new InputPortHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexAPIoutput me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new APIoutputPortHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final PrimitiveDirectDataFlow me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new DirectDataFlowPostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexDirectDataFlow me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new DirectDataFlowPostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final API me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new APIInit().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
}
