/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.graphql.api.api.APIinputPort;
import info.scce.dime.graphql.api.api.PrimitiveAPIinput;
import info.scce.dime.graphql.api.api.StartSIB;
import info.scce.dime.process.helper.LayoutConstants;
import info.scce.dime.process.helper.NodeLayout;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class StartSIBDoubleclickAction extends DIMECustomAction<StartSIB> {
  @Override
  public String getName() {
    return "New primitive input";
  }
  
  @Override
  public void execute(final StartSIB sib) {
    final Function1<APIinputPort, String> _function = new Function1<APIinputPort, String>() {
      @Override
      public String apply(final APIinputPort it) {
        return it.getName();
      }
    };
    final List<String> existingNames = ListExtensions.<APIinputPort, String>map(sib.getAPIinputPorts(), _function);
    String newPortName = "input";
    int i = 1;
    while (existingNames.contains((newPortName + Integer.valueOf(i)))) {
      i++;
    }
    final PrimitiveAPIinput port = sib.newPrimitiveAPIinput(1, 1);
    port.setName((newPortName + Integer.valueOf(i)));
    int x = LayoutConstants.ATTR_X;
    int y = (LayoutConstants.TYPE_FIRST_ATTR_Y + 35);
    int _size = sib.getAPIinputPorts().size();
    int attributeAmount = (_size + 2);
    sib.resize(sib.getWidth(), NodeLayout.getTypeHeight(attributeAmount));
    EList<APIinputPort> _aPIinputPorts = sib.getAPIinputPorts();
    for (final APIinputPort input : _aPIinputPorts) {
      {
        input.moveTo(sib, x, y);
        int _width = sib.getWidth();
        int _minus = (_width - (2 * LayoutConstants.ATTR_X));
        input.resize(_minus, input.getHeight());
        int _y = y;
        y = (_y + LayoutConstants.ATTR_SPACE);
      }
    }
  }
}
