/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.graphql.api.api.APIoutputPort;
import info.scce.dime.graphql.api.api.EndSIB;
import info.scce.dime.graphql.api.api.PrimitiveAPIoutput;
import info.scce.dime.process.helper.LayoutConstants;
import info.scce.dime.process.helper.NodeLayout;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class EndSIBDoubleclickAction extends DIMECustomAction<EndSIB> {
  @Override
  public String getName() {
    return "New primitive Input";
  }
  
  @Override
  public void execute(final EndSIB sib) {
    final PrimitiveAPIoutput port = sib.newPrimitiveAPIoutput(1, 1);
    port.setName("output");
    int x = LayoutConstants.ATTR_X;
    int y = (LayoutConstants.TYPE_FIRST_ATTR_Y + 35);
    int _size = sib.getAPIoutputPorts().size();
    int attributeAmount = (_size + 2);
    sib.resize(sib.getWidth(), NodeLayout.getTypeHeight(attributeAmount));
    EList<APIoutputPort> _aPIoutputPorts = sib.getAPIoutputPorts();
    for (final APIoutputPort output : _aPIoutputPorts) {
      {
        output.moveTo(sib, x, y);
        int _width = sib.getWidth();
        int _minus = (_width - (2 * LayoutConstants.ATTR_X));
        output.resize(_minus, output.getHeight());
        int _y = y;
        y = (_y + LayoutConstants.ATTR_SPACE);
      }
    }
  }
}
