/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.vp;

import com.google.common.collect.Iterables;
import info.scce.dime.api.DIMEValuesProvider;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.Type;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;

@SuppressWarnings("all")
public class ComplexSuperAttrPossibleValuesProvider extends DIMEValuesProvider<ComplexAttribute, ComplexAttribute> {
  @Override
  public Map<ComplexAttribute, String> getPossibleValues(final ComplexAttribute editedAttribute) {
    Map<ComplexAttribute, String> _xblockexpression = null;
    {
      Type _container = editedAttribute.getContainer();
      final Type typeOfEditedAttribute = ((Type) _container);
      final Function1<ComplexAttribute, Boolean> _function = new Function1<ComplexAttribute, Boolean>() {
        @Override
        public Boolean apply(final ComplexAttribute it) {
          Type _dataType = it.getDataType();
          Type _dataType_1 = editedAttribute.getDataType();
          return Boolean.valueOf(ComplexSuperAttrPossibleValuesProvider.this._graphModelExtension.operator_equals(_dataType, _dataType_1));
        }
      };
      final Tuple2<Seq<ComplexAttribute>, Seq<ComplexAttribute>> it = this._collectionExtension.<ComplexAttribute>duplicate(IterableExtensions.<ComplexAttribute>filter(Iterables.<ComplexAttribute>filter(Seq.<Attribute>seq(this._dataExtension.getInheritedAttributeSeq(typeOfEditedAttribute)).removeAll(Seq.<Attribute>seq(typeOfEditedAttribute.getAttributes())), ComplexAttribute.class), _function));
      final Function<ComplexAttribute, String> _function_1 = new Function<ComplexAttribute, String>() {
        @Override
        public String apply(final ComplexAttribute it) {
          return it.getName();
        }
      };
      final Function<Tuple2<ComplexAttribute, String>, ComplexAttribute> _function_2 = new Function<Tuple2<ComplexAttribute, String>, ComplexAttribute>() {
        @Override
        public ComplexAttribute apply(final Tuple2<ComplexAttribute, String> it) {
          return it.v1;
        }
      };
      final Function<Tuple2<ComplexAttribute, String>, String> _function_3 = new Function<Tuple2<ComplexAttribute, String>, String>() {
        @Override
        public String apply(final Tuple2<ComplexAttribute, String> it) {
          return it.v2;
        }
      };
      _xblockexpression = it.v1.<String>zip(it.v2.<String>map(_function_1)).collect(Collectors.<Tuple2<ComplexAttribute, String>, ComplexAttribute, String>toMap(_function_2, _function_3));
    }
    return _xblockexpression;
  }
}
