/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.hooks;

import com.google.common.collect.Iterables;
import info.scce.dime.api.DIMEPreDeleteHook;
import info.scce.dime.data.data.Association;
import info.scce.dime.data.data.Type;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class TypePreDelete extends DIMEPreDeleteHook<Type> {
  @Override
  public void preDelete(final Type cType) {
    EList<Association> _outgoing = cType.<Association>getOutgoing(Association.class);
    EList<Association> _incoming = cType.<Association>getIncoming(Association.class);
    final Consumer<Association> _function = new Consumer<Association>() {
      @Override
      public void accept(final Association it) {
        it.delete();
      }
    };
    Iterables.<Association>concat(_outgoing, _incoming).forEach(_function);
  }
}
