/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.hooks;

import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.ReferencedEnumType;
import info.scce.dime.data.data.ReferencedType;
import info.scce.dime.data.data.ReferencedUserType;
import info.scce.dime.data.data.Type;
import info.scce.dime.util.DataID;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class TypePostCreate extends DIMEPostCreateHook<Type> {
  @Override
  public void postCreate(final Type type) {
    this.assertUniqueDataID(type);
  }
  
  public void assertUniqueDataID(final Type type) {
    final Data model = type.getRootElement();
    final Function1<Type, Boolean> _function = new Function1<Type, Boolean>() {
      @Override
      public Boolean apply(final Type it) {
        return Boolean.valueOf(TypePostCreate.this._gUIExtension.operator_notEquals(it, type));
      }
    };
    final Set<Type> types = IterableExtensions.<Type>toSet(IterableExtensions.<Type>filter(this._collectionExtension.<Type>drop(this._collectionExtension.<Type>drop(this._collectionExtension.<Type>drop(this._gUIExtension.<Type>find(model, Type.class), ReferencedType.class), ReferencedUserType.class), ReferencedEnumType.class), _function));
    DataID.assertUniqueDataID(type, types);
  }
}
