/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.hooks;

import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.data.actions.UpdateExtensionAttribute;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.ExtensionAttribute;
import info.scce.dime.data.data.ReferencedEnumType;
import info.scce.dime.data.data.ReferencedExtensionAttribute;
import info.scce.dime.data.data.ReferencedType;
import info.scce.dime.data.data.ReferencedUserType;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.helper.TypeLayoutUtils;
import info.scce.dime.util.DataID;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class AttributePostCreate extends DIMEPostCreateHook<Attribute> {
  @Override
  public void postCreate(final Attribute attribute) {
    this.assertUniqueDataID(attribute);
    ExtensionAttribute _switchResult = null;
    boolean _matched = false;
    if (attribute instanceof ReferencedExtensionAttribute) {
      _matched=true;
      _switchResult = ((ReferencedExtensionAttribute)attribute).getReferencedAttribute();
    }
    if (!_matched) {
      if (attribute instanceof ExtensionAttribute) {
        _matched=true;
        _switchResult = ((ExtensionAttribute)attribute);
      }
    }
    final ExtensionAttribute extattr = _switchResult;
    if ((extattr instanceof ExtensionAttribute)) {
      info.scce.dime.process.process.Process _process = extattr.getProcess();
      attribute.setName(((info.scce.dime.process.process.Process) _process).getModelName());
      final UpdateExtensionAttribute uea = new UpdateExtensionAttribute();
      boolean _canExecute = uea.canExecute(extattr);
      if (_canExecute) {
        uea.execute(extattr);
      }
    }
    TypeLayoutUtils.resizeAndLayout(attribute.getContainer());
    this.sortOrder(attribute);
  }
  
  public void assertUniqueDataID(final Attribute attr) {
    final Data model = attr.getRootElement();
    final Function1<Attribute, Boolean> _function = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        return Boolean.valueOf(IterableExtensions.isEmpty(AttributePostCreate.this._gUIExtension.<ReferencedType>findParents(it, ReferencedType.class)));
      }
    };
    final Function1<Attribute, Boolean> _function_1 = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        return Boolean.valueOf(IterableExtensions.isEmpty(AttributePostCreate.this._gUIExtension.<ReferencedUserType>findParents(it, ReferencedUserType.class)));
      }
    };
    final Function1<Attribute, Boolean> _function_2 = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        return Boolean.valueOf(IterableExtensions.isEmpty(AttributePostCreate.this._gUIExtension.<ReferencedEnumType>findParents(it, ReferencedEnumType.class)));
      }
    };
    final Function1<Attribute, Boolean> _function_3 = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        return Boolean.valueOf(AttributePostCreate.this._gUIExtension.operator_notEquals(it, attr));
      }
    };
    final Set<Attribute> attrs = IterableExtensions.<Attribute>toSet(IterableExtensions.<Attribute>filter(IterableExtensions.<Attribute>filter(IterableExtensions.<Attribute>filter(IterableExtensions.<Attribute>filter(this._gUIExtension.<Attribute>find(model, Attribute.class), _function), _function_1), _function_2), _function_3));
    DataID.assertUniqueDataID(attr, attrs);
  }
  
  public void sortOrder(final Attribute attribute) {
    final Data data = attribute.getRootElement();
    EList<Type> _types = data.getTypes();
    for (final Type type : _types) {
      {
        final Function1<Attribute, String> _function = new Function1<Attribute, String>() {
          @Override
          public String apply(final Attribute it) {
            return it.getName();
          }
        };
        final List<Attribute> sortedAttrs = IterableExtensions.<Attribute, String>sortBy(type.getAttributes(), _function);
        int y = 32;
        for (final Attribute attr : sortedAttrs) {
          {
            attr.moveTo(attr.getContainer(), attr.getX(), y);
            int _y = y;
            y = (_y + 18);
          }
        }
      }
    }
  }
}
