package info.scce.dime.data.factory;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.Type;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalModelElementContainer;
import graphmodel.internal.InternalNode;
import graphmodel.internal.InternalType;
import info.scce.dime.data.adapter.AbstractTypeEContentAdapter;
import info.scce.dime.data.adapter.AssociationEContentAdapter;
import info.scce.dime.data.adapter.BidirectionalAssociationEContentAdapter;
import info.scce.dime.data.adapter.BidirectionalAttributeEContentAdapter;
import info.scce.dime.data.adapter.ComplexAttributeEContentAdapter;
import info.scce.dime.data.adapter.ConcreteTypeEContentAdapter;
import info.scce.dime.data.adapter.DataEContentAdapter;
import info.scce.dime.data.adapter.EnumLiteralEContentAdapter;
import info.scce.dime.data.adapter.EnumTypeEContentAdapter;
import info.scce.dime.data.adapter.ExtensionAttributeEContentAdapter;
import info.scce.dime.data.adapter.InheritanceEContentAdapter;
import info.scce.dime.data.adapter.PrimitiveAttributeEContentAdapter;
import info.scce.dime.data.adapter.ReferencedBidirectionalAttributeEContentAdapter;
import info.scce.dime.data.adapter.ReferencedComplexAttributeEContentAdapter;
import info.scce.dime.data.adapter.ReferencedEnumTypeEContentAdapter;
import info.scce.dime.data.adapter.ReferencedExtensionAttributeEContentAdapter;
import info.scce.dime.data.adapter.ReferencedPrimitiveAttributeEContentAdapter;
import info.scce.dime.data.adapter.ReferencedTypeEContentAdapter;
import info.scce.dime.data.adapter.ReferencedUserAttributeEContentAdapter;
import info.scce.dime.data.adapter.ReferencedUserTypeEContentAdapter;
import info.scce.dime.data.adapter.UserAssociationEContentAdapter;
import info.scce.dime.data.adapter.UserAttributeEContentAdapter;
import info.scce.dime.data.adapter.UserTypeEContentAdapter;
import info.scce.dime.data.data.AbstractType;
import info.scce.dime.data.data.Association;
import info.scce.dime.data.data.BidirectionalAssociation;
import info.scce.dime.data.data.BidirectionalAttribute;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.ConcreteType;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.DataPackage;
import info.scce.dime.data.data.EnumLiteral;
import info.scce.dime.data.data.EnumType;
import info.scce.dime.data.data.ExtensionAttribute;
import info.scce.dime.data.data.Inheritance;
import info.scce.dime.data.data.PrimitiveAttribute;
import info.scce.dime.data.data.ReferencedBidirectionalAttribute;
import info.scce.dime.data.data.ReferencedComplexAttribute;
import info.scce.dime.data.data.ReferencedEnumType;
import info.scce.dime.data.data.ReferencedExtensionAttribute;
import info.scce.dime.data.data.ReferencedPrimitiveAttribute;
import info.scce.dime.data.data.ReferencedType;
import info.scce.dime.data.data.ReferencedUserAttribute;
import info.scce.dime.data.data.ReferencedUserType;
import info.scce.dime.data.data.UserAssociation;
import info.scce.dime.data.data.UserAttribute;
import info.scce.dime.data.data.UserType;
import info.scce.dime.data.data.impl.DataFactoryImpl;
import info.scce.dime.data.data.internal.InternalAbstractType;
import info.scce.dime.data.data.internal.InternalAssociation;
import info.scce.dime.data.data.internal.InternalBidirectionalAssociation;
import info.scce.dime.data.data.internal.InternalBidirectionalAttribute;
import info.scce.dime.data.data.internal.InternalComplexAttribute;
import info.scce.dime.data.data.internal.InternalConcreteType;
import info.scce.dime.data.data.internal.InternalData;
import info.scce.dime.data.data.internal.InternalEnumLiteral;
import info.scce.dime.data.data.internal.InternalEnumType;
import info.scce.dime.data.data.internal.InternalExtensionAttribute;
import info.scce.dime.data.data.internal.InternalFactory;
import info.scce.dime.data.data.internal.InternalInheritance;
import info.scce.dime.data.data.internal.InternalPrimitiveAttribute;
import info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute;
import info.scce.dime.data.data.internal.InternalReferencedComplexAttribute;
import info.scce.dime.data.data.internal.InternalReferencedEnumType;
import info.scce.dime.data.data.internal.InternalReferencedExtensionAttribute;
import info.scce.dime.data.data.internal.InternalReferencedPrimitiveAttribute;
import info.scce.dime.data.data.internal.InternalReferencedType;
import info.scce.dime.data.data.internal.InternalReferencedUserAttribute;
import info.scce.dime.data.data.internal.InternalReferencedUserType;
import info.scce.dime.data.data.internal.InternalUserAssociation;
import info.scce.dime.data.data.internal.InternalUserAttribute;
import info.scce.dime.data.data.internal.InternalUserType;
import info.scce.dime.data.hooks.AssociationInitialize;
import info.scce.dime.data.hooks.AttributePostCreate;
import info.scce.dime.data.hooks.BidirectionalAssociationInitialize;
import info.scce.dime.data.hooks.DataPostCreate;
import info.scce.dime.data.hooks.ReferencedEnumTypePostCreate;
import info.scce.dime.data.hooks.ReferencedTypePostCreate;
import info.scce.dime.data.hooks.TypePostCreate;
import info.scce.dime.data.hooks.UserAssociationInitialize;
import info.scce.dime.data.hooks.UserTypePostCreate;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class DataFactory extends DataFactoryImpl {
  @Extension
  private final InternalFactory _internalFactory = InternalFactory.eINSTANCE;
  
  public static DataFactory eINSTANCE = DataFactory.init();
  
  @Extension
  private WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
  
  public static DataFactory init() {
    DataFactory _xblockexpression = null;
    {
      try {
        EFactory _eFactory = EPackage.Registry.INSTANCE.getEFactory(DataPackage.eNS_URI);
        final DataFactory fct = ((DataFactory) _eFactory);
        if ((fct != null)) {
          return ((DataFactory) fct);
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception exception = (Exception)_t;
          EcorePlugin.INSTANCE.log(exception);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
      _xblockexpression = new DataFactory();
    }
    return _xblockexpression;
  }
  
  /**
   * This method creates an ReferencedBidirectionalAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ReferencedBidirectionalAttribute createReferencedBidirectionalAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ReferencedBidirectionalAttribute _createReferencedBidirectionalAttribute = super.createReferencedBidirectionalAttribute();
    final Procedure1<ReferencedBidirectionalAttribute> _function = new Procedure1<ReferencedBidirectionalAttribute>() {
      @Override
      public void apply(final ReferencedBidirectionalAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalReferencedBidirectionalAttribute _createInternalReferencedBidirectionalAttribute = DataFactory.this._internalFactory.createInternalReferencedBidirectionalAttribute();
          _elvis = _createInternalReferencedBidirectionalAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ReferencedBidirectionalAttributeEContentAdapter _referencedBidirectionalAttributeEContentAdapter = new ReferencedBidirectionalAttributeEContentAdapter();
            _eAdapters.add(_referencedBidirectionalAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ReferencedBidirectionalAttribute>operator_doubleArrow(_createReferencedBidirectionalAttribute, _function);
  }
  
  /**
   * This method creates an ReferencedBidirectionalAttribute with the given id. Post create hook won't be triggered.
   */
  public ReferencedBidirectionalAttribute createReferencedBidirectionalAttribute(final String ID) {
    return this.createReferencedBidirectionalAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ReferencedBidirectionalAttribute with the given id. Post create hook will be triggered.
   */
  public ReferencedBidirectionalAttribute createReferencedBidirectionalAttribute(final InternalModelElementContainer parent) {
    return this.createReferencedBidirectionalAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ReferencedBidirectionalAttribute with the given id. Post create hook will be triggered.
   */
  public ReferencedBidirectionalAttribute createReferencedBidirectionalAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createReferencedBidirectionalAttribute(ID, null, parent, true);
  }
  
  public ReferencedBidirectionalAttribute createReferencedBidirectionalAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createReferencedBidirectionalAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ReferencedBidirectionalAttribute with the given id. Post create hook won't be triggered.
   */
  public ReferencedBidirectionalAttribute createReferencedBidirectionalAttribute(final InternalModelElement ime) {
    return this.createReferencedBidirectionalAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ReferencedBidirectionalAttribute createReferencedBidirectionalAttribute() {
    return this.createReferencedBidirectionalAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ReferencedUserAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ReferencedUserAttribute createReferencedUserAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ReferencedUserAttribute _createReferencedUserAttribute = super.createReferencedUserAttribute();
    final Procedure1<ReferencedUserAttribute> _function = new Procedure1<ReferencedUserAttribute>() {
      @Override
      public void apply(final ReferencedUserAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalReferencedUserAttribute _createInternalReferencedUserAttribute = DataFactory.this._internalFactory.createInternalReferencedUserAttribute();
          _elvis = _createInternalReferencedUserAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ReferencedUserAttributeEContentAdapter _referencedUserAttributeEContentAdapter = new ReferencedUserAttributeEContentAdapter();
            _eAdapters.add(_referencedUserAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ReferencedUserAttribute>operator_doubleArrow(_createReferencedUserAttribute, _function);
  }
  
  /**
   * This method creates an ReferencedUserAttribute with the given id. Post create hook won't be triggered.
   */
  public ReferencedUserAttribute createReferencedUserAttribute(final String ID) {
    return this.createReferencedUserAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ReferencedUserAttribute with the given id. Post create hook will be triggered.
   */
  public ReferencedUserAttribute createReferencedUserAttribute(final InternalModelElementContainer parent) {
    return this.createReferencedUserAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ReferencedUserAttribute with the given id. Post create hook will be triggered.
   */
  public ReferencedUserAttribute createReferencedUserAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createReferencedUserAttribute(ID, null, parent, true);
  }
  
  public ReferencedUserAttribute createReferencedUserAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createReferencedUserAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ReferencedUserAttribute with the given id. Post create hook won't be triggered.
   */
  public ReferencedUserAttribute createReferencedUserAttribute(final InternalModelElement ime) {
    return this.createReferencedUserAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ReferencedUserAttribute createReferencedUserAttribute() {
    return this.createReferencedUserAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an UserType with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public UserType createUserType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    UserType _createUserType = super.createUserType();
    final Procedure1<UserType> _function = new Procedure1<UserType>() {
      @Override
      public void apply(final UserType it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalUserType _createInternalUserType = DataFactory.this._internalFactory.createInternalUserType();
          _elvis = _createInternalUserType;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            UserTypeEContentAdapter _userTypeEContentAdapter = new UserTypeEContentAdapter();
            _eAdapters.add(_userTypeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<UserType>operator_doubleArrow(_createUserType, _function);
  }
  
  /**
   * This method creates an UserType with the given id. Post create hook won't be triggered.
   */
  public UserType createUserType(final String ID) {
    return this.createUserType(ID, null, null, false);
  }
  
  /**
   * This method creates an UserType with the given id. Post create hook will be triggered.
   */
  public UserType createUserType(final InternalModelElementContainer parent) {
    return this.createUserType(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an UserType with the given id. Post create hook will be triggered.
   */
  public UserType createUserType(final String ID, final InternalModelElementContainer parent) {
    return this.createUserType(ID, null, parent, true);
  }
  
  public UserType createUserType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createUserType(ID, ime, parent, true);
  }
  
  /**
   * This method creates an UserType with the given id. Post create hook won't be triggered.
   */
  public UserType createUserType(final InternalModelElement ime) {
    return this.createUserType(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public UserType createUserType() {
    return this.createUserType(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ReferencedUserType with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ReferencedUserType createReferencedUserType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ReferencedUserType _createReferencedUserType = super.createReferencedUserType();
    final Procedure1<ReferencedUserType> _function = new Procedure1<ReferencedUserType>() {
      @Override
      public void apply(final ReferencedUserType it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalReferencedUserType _createInternalReferencedUserType = DataFactory.this._internalFactory.createInternalReferencedUserType();
          _elvis = _createInternalReferencedUserType;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ReferencedUserTypeEContentAdapter _referencedUserTypeEContentAdapter = new ReferencedUserTypeEContentAdapter();
            _eAdapters.add(_referencedUserTypeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ReferencedUserType>operator_doubleArrow(_createReferencedUserType, _function);
  }
  
  /**
   * This method creates an ReferencedUserType with the given id. Post create hook won't be triggered.
   */
  public ReferencedUserType createReferencedUserType(final String ID) {
    return this.createReferencedUserType(ID, null, null, false);
  }
  
  /**
   * This method creates an ReferencedUserType with the given id. Post create hook will be triggered.
   */
  public ReferencedUserType createReferencedUserType(final InternalModelElementContainer parent) {
    return this.createReferencedUserType(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ReferencedUserType with the given id. Post create hook will be triggered.
   */
  public ReferencedUserType createReferencedUserType(final String ID, final InternalModelElementContainer parent) {
    return this.createReferencedUserType(ID, null, parent, true);
  }
  
  public ReferencedUserType createReferencedUserType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createReferencedUserType(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ReferencedUserType with the given id. Post create hook won't be triggered.
   */
  public ReferencedUserType createReferencedUserType(final InternalModelElement ime) {
    return this.createReferencedUserType(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ReferencedUserType createReferencedUserType() {
    return this.createReferencedUserType(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an EnumType with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public EnumType createEnumType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    EnumType _createEnumType = super.createEnumType();
    final Procedure1<EnumType> _function = new Procedure1<EnumType>() {
      @Override
      public void apply(final EnumType it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalEnumType _createInternalEnumType = DataFactory.this._internalFactory.createInternalEnumType();
          _elvis = _createInternalEnumType;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            EnumTypeEContentAdapter _enumTypeEContentAdapter = new EnumTypeEContentAdapter();
            _eAdapters.add(_enumTypeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<EnumType>operator_doubleArrow(_createEnumType, _function);
  }
  
  /**
   * This method creates an EnumType with the given id. Post create hook won't be triggered.
   */
  public EnumType createEnumType(final String ID) {
    return this.createEnumType(ID, null, null, false);
  }
  
  /**
   * This method creates an EnumType with the given id. Post create hook will be triggered.
   */
  public EnumType createEnumType(final InternalModelElementContainer parent) {
    return this.createEnumType(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an EnumType with the given id. Post create hook will be triggered.
   */
  public EnumType createEnumType(final String ID, final InternalModelElementContainer parent) {
    return this.createEnumType(ID, null, parent, true);
  }
  
  public EnumType createEnumType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createEnumType(ID, ime, parent, true);
  }
  
  /**
   * This method creates an EnumType with the given id. Post create hook won't be triggered.
   */
  public EnumType createEnumType(final InternalModelElement ime) {
    return this.createEnumType(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public EnumType createEnumType() {
    return this.createEnumType(EcoreUtil.generateUUID());
  }
  
  public BidirectionalAssociation createBidirectionalAssociation(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    BidirectionalAssociation _createBidirectionalAssociation = super.createBidirectionalAssociation();
    final Procedure1<BidirectionalAssociation> _function = new Procedure1<BidirectionalAssociation>() {
      @Override
      public void apply(final BidirectionalAssociation it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBidirectionalAssociation _createInternalBidirectionalAssociation = DataFactory.this._internalFactory.createInternalBidirectionalAssociation();
          _elvis = _createInternalBidirectionalAssociation;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            BidirectionalAssociationEContentAdapter _bidirectionalAssociationEContentAdapter = new BidirectionalAssociationEContentAdapter();
            _eAdapters.add(_bidirectionalAssociationEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<BidirectionalAssociation>operator_doubleArrow(_createBidirectionalAssociation, _function);
  }
  
  /**
   * This method creates an BidirectionalAssociation with the given id. Post create hook will be triggered.
   */
  public BidirectionalAssociation createBidirectionalAssociation(final String ID, final InternalNode source, final InternalNode target) {
    return this.createBidirectionalAssociation(ID, null, source, target, true);
  }
  
  /**
   * This method creates an BidirectionalAssociation with generated id. Post create hook will be triggered.
   */
  public BidirectionalAssociation createBidirectionalAssociation(final InternalNode source, final InternalNode target) {
    return this.createBidirectionalAssociation(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an BidirectionalAssociation with the given id. Post create hook won't be triggered.
   */
  public BidirectionalAssociation createBidirectionalAssociation(final String ID) {
    return this.createBidirectionalAssociation(ID, null, null, null, false);
  }
  
  /**
   * This method creates an BidirectionalAssociation with a generated id. Post create hook won't be triggered.
   */
  @Override
  public BidirectionalAssociation createBidirectionalAssociation() {
    return this.createBidirectionalAssociation(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ReferencedPrimitiveAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ReferencedPrimitiveAttribute createReferencedPrimitiveAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ReferencedPrimitiveAttribute _createReferencedPrimitiveAttribute = super.createReferencedPrimitiveAttribute();
    final Procedure1<ReferencedPrimitiveAttribute> _function = new Procedure1<ReferencedPrimitiveAttribute>() {
      @Override
      public void apply(final ReferencedPrimitiveAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalReferencedPrimitiveAttribute _createInternalReferencedPrimitiveAttribute = DataFactory.this._internalFactory.createInternalReferencedPrimitiveAttribute();
          _elvis = _createInternalReferencedPrimitiveAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ReferencedPrimitiveAttributeEContentAdapter _referencedPrimitiveAttributeEContentAdapter = new ReferencedPrimitiveAttributeEContentAdapter();
            _eAdapters.add(_referencedPrimitiveAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ReferencedPrimitiveAttribute>operator_doubleArrow(_createReferencedPrimitiveAttribute, _function);
  }
  
  /**
   * This method creates an ReferencedPrimitiveAttribute with the given id. Post create hook won't be triggered.
   */
  public ReferencedPrimitiveAttribute createReferencedPrimitiveAttribute(final String ID) {
    return this.createReferencedPrimitiveAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ReferencedPrimitiveAttribute with the given id. Post create hook will be triggered.
   */
  public ReferencedPrimitiveAttribute createReferencedPrimitiveAttribute(final InternalModelElementContainer parent) {
    return this.createReferencedPrimitiveAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ReferencedPrimitiveAttribute with the given id. Post create hook will be triggered.
   */
  public ReferencedPrimitiveAttribute createReferencedPrimitiveAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createReferencedPrimitiveAttribute(ID, null, parent, true);
  }
  
  public ReferencedPrimitiveAttribute createReferencedPrimitiveAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createReferencedPrimitiveAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ReferencedPrimitiveAttribute with the given id. Post create hook won't be triggered.
   */
  public ReferencedPrimitiveAttribute createReferencedPrimitiveAttribute(final InternalModelElement ime) {
    return this.createReferencedPrimitiveAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ReferencedPrimitiveAttribute createReferencedPrimitiveAttribute() {
    return this.createReferencedPrimitiveAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveAttribute createPrimitiveAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveAttribute _createPrimitiveAttribute = super.createPrimitiveAttribute();
    final Procedure1<PrimitiveAttribute> _function = new Procedure1<PrimitiveAttribute>() {
      @Override
      public void apply(final PrimitiveAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveAttribute _createInternalPrimitiveAttribute = DataFactory.this._internalFactory.createInternalPrimitiveAttribute();
          _elvis = _createInternalPrimitiveAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveAttributeEContentAdapter _primitiveAttributeEContentAdapter = new PrimitiveAttributeEContentAdapter();
            _eAdapters.add(_primitiveAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<PrimitiveAttribute>operator_doubleArrow(_createPrimitiveAttribute, _function);
  }
  
  /**
   * This method creates an PrimitiveAttribute with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAttribute createPrimitiveAttribute(final String ID) {
    return this.createPrimitiveAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveAttribute with the given id. Post create hook will be triggered.
   */
  public PrimitiveAttribute createPrimitiveAttribute(final InternalModelElementContainer parent) {
    return this.createPrimitiveAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAttribute with the given id. Post create hook will be triggered.
   */
  public PrimitiveAttribute createPrimitiveAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveAttribute(ID, null, parent, true);
  }
  
  public PrimitiveAttribute createPrimitiveAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAttribute with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAttribute createPrimitiveAttribute(final InternalModelElement ime) {
    return this.createPrimitiveAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveAttribute createPrimitiveAttribute() {
    return this.createPrimitiveAttribute(EcoreUtil.generateUUID());
  }
  
  public UserAssociation createUserAssociation(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    UserAssociation _createUserAssociation = super.createUserAssociation();
    final Procedure1<UserAssociation> _function = new Procedure1<UserAssociation>() {
      @Override
      public void apply(final UserAssociation it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalUserAssociation _createInternalUserAssociation = DataFactory.this._internalFactory.createInternalUserAssociation();
          _elvis = _createInternalUserAssociation;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            UserAssociationEContentAdapter _userAssociationEContentAdapter = new UserAssociationEContentAdapter();
            _eAdapters.add(_userAssociationEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<UserAssociation>operator_doubleArrow(_createUserAssociation, _function);
  }
  
  /**
   * This method creates an UserAssociation with the given id. Post create hook will be triggered.
   */
  public UserAssociation createUserAssociation(final String ID, final InternalNode source, final InternalNode target) {
    return this.createUserAssociation(ID, null, source, target, true);
  }
  
  /**
   * This method creates an UserAssociation with generated id. Post create hook will be triggered.
   */
  public UserAssociation createUserAssociation(final InternalNode source, final InternalNode target) {
    return this.createUserAssociation(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an UserAssociation with the given id. Post create hook won't be triggered.
   */
  public UserAssociation createUserAssociation(final String ID) {
    return this.createUserAssociation(ID, null, null, null, false);
  }
  
  /**
   * This method creates an UserAssociation with a generated id. Post create hook won't be triggered.
   */
  @Override
  public UserAssociation createUserAssociation() {
    return this.createUserAssociation(EcoreUtil.generateUUID());
  }
  
  public Inheritance createInheritance(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    Inheritance _createInheritance = super.createInheritance();
    final Procedure1<Inheritance> _function = new Procedure1<Inheritance>() {
      @Override
      public void apply(final Inheritance it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalInheritance _createInternalInheritance = DataFactory.this._internalFactory.createInternalInheritance();
          _elvis = _createInternalInheritance;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            InheritanceEContentAdapter _inheritanceEContentAdapter = new InheritanceEContentAdapter();
            _eAdapters.add(_inheritanceEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<Inheritance>operator_doubleArrow(_createInheritance, _function);
  }
  
  /**
   * This method creates an Inheritance with the given id. Post create hook will be triggered.
   */
  public Inheritance createInheritance(final String ID, final InternalNode source, final InternalNode target) {
    return this.createInheritance(ID, null, source, target, true);
  }
  
  /**
   * This method creates an Inheritance with generated id. Post create hook will be triggered.
   */
  public Inheritance createInheritance(final InternalNode source, final InternalNode target) {
    return this.createInheritance(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an Inheritance with the given id. Post create hook won't be triggered.
   */
  public Inheritance createInheritance(final String ID) {
    return this.createInheritance(ID, null, null, null, false);
  }
  
  /**
   * This method creates an Inheritance with a generated id. Post create hook won't be triggered.
   */
  @Override
  public Inheritance createInheritance() {
    return this.createInheritance(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ExtensionAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ExtensionAttribute createExtensionAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ExtensionAttribute _createExtensionAttribute = super.createExtensionAttribute();
    final Procedure1<ExtensionAttribute> _function = new Procedure1<ExtensionAttribute>() {
      @Override
      public void apply(final ExtensionAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalExtensionAttribute _createInternalExtensionAttribute = DataFactory.this._internalFactory.createInternalExtensionAttribute();
          _elvis = _createInternalExtensionAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ExtensionAttributeEContentAdapter _extensionAttributeEContentAdapter = new ExtensionAttributeEContentAdapter();
            _eAdapters.add(_extensionAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ExtensionAttribute>operator_doubleArrow(_createExtensionAttribute, _function);
  }
  
  /**
   * This method creates an ExtensionAttribute with the given id. Post create hook won't be triggered.
   */
  public ExtensionAttribute createExtensionAttribute(final String ID) {
    return this.createExtensionAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ExtensionAttribute with the given id. Post create hook will be triggered.
   */
  public ExtensionAttribute createExtensionAttribute(final InternalModelElementContainer parent) {
    return this.createExtensionAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ExtensionAttribute with the given id. Post create hook will be triggered.
   */
  public ExtensionAttribute createExtensionAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createExtensionAttribute(ID, null, parent, true);
  }
  
  public ExtensionAttribute createExtensionAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createExtensionAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ExtensionAttribute with the given id. Post create hook won't be triggered.
   */
  public ExtensionAttribute createExtensionAttribute(final InternalModelElement ime) {
    return this.createExtensionAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ExtensionAttribute createExtensionAttribute() {
    return this.createExtensionAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an EnumLiteral with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public EnumLiteral createEnumLiteral(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    EnumLiteral _createEnumLiteral = super.createEnumLiteral();
    final Procedure1<EnumLiteral> _function = new Procedure1<EnumLiteral>() {
      @Override
      public void apply(final EnumLiteral it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalEnumLiteral _createInternalEnumLiteral = DataFactory.this._internalFactory.createInternalEnumLiteral();
          _elvis = _createInternalEnumLiteral;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            EnumLiteralEContentAdapter _enumLiteralEContentAdapter = new EnumLiteralEContentAdapter();
            _eAdapters.add(_enumLiteralEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<EnumLiteral>operator_doubleArrow(_createEnumLiteral, _function);
  }
  
  /**
   * This method creates an EnumLiteral with the given id. Post create hook won't be triggered.
   */
  public EnumLiteral createEnumLiteral(final String ID) {
    return this.createEnumLiteral(ID, null, null, false);
  }
  
  /**
   * This method creates an EnumLiteral with the given id. Post create hook will be triggered.
   */
  public EnumLiteral createEnumLiteral(final InternalModelElementContainer parent) {
    return this.createEnumLiteral(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an EnumLiteral with the given id. Post create hook will be triggered.
   */
  public EnumLiteral createEnumLiteral(final String ID, final InternalModelElementContainer parent) {
    return this.createEnumLiteral(ID, null, parent, true);
  }
  
  public EnumLiteral createEnumLiteral(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createEnumLiteral(ID, ime, parent, true);
  }
  
  /**
   * This method creates an EnumLiteral with the given id. Post create hook won't be triggered.
   */
  public EnumLiteral createEnumLiteral(final InternalModelElement ime) {
    return this.createEnumLiteral(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public EnumLiteral createEnumLiteral() {
    return this.createEnumLiteral(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an BidirectionalAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public BidirectionalAttribute createBidirectionalAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    BidirectionalAttribute _createBidirectionalAttribute = super.createBidirectionalAttribute();
    final Procedure1<BidirectionalAttribute> _function = new Procedure1<BidirectionalAttribute>() {
      @Override
      public void apply(final BidirectionalAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBidirectionalAttribute _createInternalBidirectionalAttribute = DataFactory.this._internalFactory.createInternalBidirectionalAttribute();
          _elvis = _createInternalBidirectionalAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            BidirectionalAttributeEContentAdapter _bidirectionalAttributeEContentAdapter = new BidirectionalAttributeEContentAdapter();
            _eAdapters.add(_bidirectionalAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<BidirectionalAttribute>operator_doubleArrow(_createBidirectionalAttribute, _function);
  }
  
  /**
   * This method creates an BidirectionalAttribute with the given id. Post create hook won't be triggered.
   */
  public BidirectionalAttribute createBidirectionalAttribute(final String ID) {
    return this.createBidirectionalAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an BidirectionalAttribute with the given id. Post create hook will be triggered.
   */
  public BidirectionalAttribute createBidirectionalAttribute(final InternalModelElementContainer parent) {
    return this.createBidirectionalAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an BidirectionalAttribute with the given id. Post create hook will be triggered.
   */
  public BidirectionalAttribute createBidirectionalAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createBidirectionalAttribute(ID, null, parent, true);
  }
  
  public BidirectionalAttribute createBidirectionalAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createBidirectionalAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an BidirectionalAttribute with the given id. Post create hook won't be triggered.
   */
  public BidirectionalAttribute createBidirectionalAttribute(final InternalModelElement ime) {
    return this.createBidirectionalAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public BidirectionalAttribute createBidirectionalAttribute() {
    return this.createBidirectionalAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexAttribute createComplexAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexAttribute _createComplexAttribute = super.createComplexAttribute();
    final Procedure1<ComplexAttribute> _function = new Procedure1<ComplexAttribute>() {
      @Override
      public void apply(final ComplexAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexAttribute _createInternalComplexAttribute = DataFactory.this._internalFactory.createInternalComplexAttribute();
          _elvis = _createInternalComplexAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexAttributeEContentAdapter _complexAttributeEContentAdapter = new ComplexAttributeEContentAdapter();
            _eAdapters.add(_complexAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexAttribute>operator_doubleArrow(_createComplexAttribute, _function);
  }
  
  /**
   * This method creates an ComplexAttribute with the given id. Post create hook won't be triggered.
   */
  public ComplexAttribute createComplexAttribute(final String ID) {
    return this.createComplexAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexAttribute with the given id. Post create hook will be triggered.
   */
  public ComplexAttribute createComplexAttribute(final InternalModelElementContainer parent) {
    return this.createComplexAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexAttribute with the given id. Post create hook will be triggered.
   */
  public ComplexAttribute createComplexAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexAttribute(ID, null, parent, true);
  }
  
  public ComplexAttribute createComplexAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexAttribute with the given id. Post create hook won't be triggered.
   */
  public ComplexAttribute createComplexAttribute(final InternalModelElement ime) {
    return this.createComplexAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexAttribute createComplexAttribute() {
    return this.createComplexAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ReferencedComplexAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ReferencedComplexAttribute createReferencedComplexAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ReferencedComplexAttribute _createReferencedComplexAttribute = super.createReferencedComplexAttribute();
    final Procedure1<ReferencedComplexAttribute> _function = new Procedure1<ReferencedComplexAttribute>() {
      @Override
      public void apply(final ReferencedComplexAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalReferencedComplexAttribute _createInternalReferencedComplexAttribute = DataFactory.this._internalFactory.createInternalReferencedComplexAttribute();
          _elvis = _createInternalReferencedComplexAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ReferencedComplexAttributeEContentAdapter _referencedComplexAttributeEContentAdapter = new ReferencedComplexAttributeEContentAdapter();
            _eAdapters.add(_referencedComplexAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ReferencedComplexAttribute>operator_doubleArrow(_createReferencedComplexAttribute, _function);
  }
  
  /**
   * This method creates an ReferencedComplexAttribute with the given id. Post create hook won't be triggered.
   */
  public ReferencedComplexAttribute createReferencedComplexAttribute(final String ID) {
    return this.createReferencedComplexAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ReferencedComplexAttribute with the given id. Post create hook will be triggered.
   */
  public ReferencedComplexAttribute createReferencedComplexAttribute(final InternalModelElementContainer parent) {
    return this.createReferencedComplexAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ReferencedComplexAttribute with the given id. Post create hook will be triggered.
   */
  public ReferencedComplexAttribute createReferencedComplexAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createReferencedComplexAttribute(ID, null, parent, true);
  }
  
  public ReferencedComplexAttribute createReferencedComplexAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createReferencedComplexAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ReferencedComplexAttribute with the given id. Post create hook won't be triggered.
   */
  public ReferencedComplexAttribute createReferencedComplexAttribute(final InternalModelElement ime) {
    return this.createReferencedComplexAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ReferencedComplexAttribute createReferencedComplexAttribute() {
    return this.createReferencedComplexAttribute(EcoreUtil.generateUUID());
  }
  
  public Association createAssociation(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    Association _createAssociation = super.createAssociation();
    final Procedure1<Association> _function = new Procedure1<Association>() {
      @Override
      public void apply(final Association it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalAssociation _createInternalAssociation = DataFactory.this._internalFactory.createInternalAssociation();
          _elvis = _createInternalAssociation;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            AssociationEContentAdapter _associationEContentAdapter = new AssociationEContentAdapter();
            _eAdapters.add(_associationEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<Association>operator_doubleArrow(_createAssociation, _function);
  }
  
  /**
   * This method creates an Association with the given id. Post create hook will be triggered.
   */
  public Association createAssociation(final String ID, final InternalNode source, final InternalNode target) {
    return this.createAssociation(ID, null, source, target, true);
  }
  
  /**
   * This method creates an Association with generated id. Post create hook will be triggered.
   */
  public Association createAssociation(final InternalNode source, final InternalNode target) {
    return this.createAssociation(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an Association with the given id. Post create hook won't be triggered.
   */
  public Association createAssociation(final String ID) {
    return this.createAssociation(ID, null, null, null, false);
  }
  
  /**
   * This method creates an Association with a generated id. Post create hook won't be triggered.
   */
  @Override
  public Association createAssociation() {
    return this.createAssociation(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ReferencedExtensionAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ReferencedExtensionAttribute createReferencedExtensionAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ReferencedExtensionAttribute _createReferencedExtensionAttribute = super.createReferencedExtensionAttribute();
    final Procedure1<ReferencedExtensionAttribute> _function = new Procedure1<ReferencedExtensionAttribute>() {
      @Override
      public void apply(final ReferencedExtensionAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalReferencedExtensionAttribute _createInternalReferencedExtensionAttribute = DataFactory.this._internalFactory.createInternalReferencedExtensionAttribute();
          _elvis = _createInternalReferencedExtensionAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ReferencedExtensionAttributeEContentAdapter _referencedExtensionAttributeEContentAdapter = new ReferencedExtensionAttributeEContentAdapter();
            _eAdapters.add(_referencedExtensionAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ReferencedExtensionAttribute>operator_doubleArrow(_createReferencedExtensionAttribute, _function);
  }
  
  /**
   * This method creates an ReferencedExtensionAttribute with the given id. Post create hook won't be triggered.
   */
  public ReferencedExtensionAttribute createReferencedExtensionAttribute(final String ID) {
    return this.createReferencedExtensionAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ReferencedExtensionAttribute with the given id. Post create hook will be triggered.
   */
  public ReferencedExtensionAttribute createReferencedExtensionAttribute(final InternalModelElementContainer parent) {
    return this.createReferencedExtensionAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ReferencedExtensionAttribute with the given id. Post create hook will be triggered.
   */
  public ReferencedExtensionAttribute createReferencedExtensionAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createReferencedExtensionAttribute(ID, null, parent, true);
  }
  
  public ReferencedExtensionAttribute createReferencedExtensionAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createReferencedExtensionAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ReferencedExtensionAttribute with the given id. Post create hook won't be triggered.
   */
  public ReferencedExtensionAttribute createReferencedExtensionAttribute(final InternalModelElement ime) {
    return this.createReferencedExtensionAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ReferencedExtensionAttribute createReferencedExtensionAttribute() {
    return this.createReferencedExtensionAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ConcreteType with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ConcreteType createConcreteType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ConcreteType _createConcreteType = super.createConcreteType();
    final Procedure1<ConcreteType> _function = new Procedure1<ConcreteType>() {
      @Override
      public void apply(final ConcreteType it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalConcreteType _createInternalConcreteType = DataFactory.this._internalFactory.createInternalConcreteType();
          _elvis = _createInternalConcreteType;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ConcreteTypeEContentAdapter _concreteTypeEContentAdapter = new ConcreteTypeEContentAdapter();
            _eAdapters.add(_concreteTypeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ConcreteType>operator_doubleArrow(_createConcreteType, _function);
  }
  
  /**
   * This method creates an ConcreteType with the given id. Post create hook won't be triggered.
   */
  public ConcreteType createConcreteType(final String ID) {
    return this.createConcreteType(ID, null, null, false);
  }
  
  /**
   * This method creates an ConcreteType with the given id. Post create hook will be triggered.
   */
  public ConcreteType createConcreteType(final InternalModelElementContainer parent) {
    return this.createConcreteType(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ConcreteType with the given id. Post create hook will be triggered.
   */
  public ConcreteType createConcreteType(final String ID, final InternalModelElementContainer parent) {
    return this.createConcreteType(ID, null, parent, true);
  }
  
  public ConcreteType createConcreteType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createConcreteType(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ConcreteType with the given id. Post create hook won't be triggered.
   */
  public ConcreteType createConcreteType(final InternalModelElement ime) {
    return this.createConcreteType(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ConcreteType createConcreteType() {
    return this.createConcreteType(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ReferencedEnumType with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ReferencedEnumType createReferencedEnumType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ReferencedEnumType _createReferencedEnumType = super.createReferencedEnumType();
    final Procedure1<ReferencedEnumType> _function = new Procedure1<ReferencedEnumType>() {
      @Override
      public void apply(final ReferencedEnumType it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalReferencedEnumType _createInternalReferencedEnumType = DataFactory.this._internalFactory.createInternalReferencedEnumType();
          _elvis = _createInternalReferencedEnumType;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ReferencedEnumTypeEContentAdapter _referencedEnumTypeEContentAdapter = new ReferencedEnumTypeEContentAdapter();
            _eAdapters.add(_referencedEnumTypeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ReferencedEnumType>operator_doubleArrow(_createReferencedEnumType, _function);
  }
  
  /**
   * This method creates an ReferencedEnumType with the given id. Post create hook won't be triggered.
   */
  public ReferencedEnumType createReferencedEnumType(final String ID) {
    return this.createReferencedEnumType(ID, null, null, false);
  }
  
  /**
   * This method creates an ReferencedEnumType with the given id. Post create hook will be triggered.
   */
  public ReferencedEnumType createReferencedEnumType(final InternalModelElementContainer parent) {
    return this.createReferencedEnumType(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ReferencedEnumType with the given id. Post create hook will be triggered.
   */
  public ReferencedEnumType createReferencedEnumType(final String ID, final InternalModelElementContainer parent) {
    return this.createReferencedEnumType(ID, null, parent, true);
  }
  
  public ReferencedEnumType createReferencedEnumType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createReferencedEnumType(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ReferencedEnumType with the given id. Post create hook won't be triggered.
   */
  public ReferencedEnumType createReferencedEnumType(final InternalModelElement ime) {
    return this.createReferencedEnumType(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ReferencedEnumType createReferencedEnumType() {
    return this.createReferencedEnumType(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an UserAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public UserAttribute createUserAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    UserAttribute _createUserAttribute = super.createUserAttribute();
    final Procedure1<UserAttribute> _function = new Procedure1<UserAttribute>() {
      @Override
      public void apply(final UserAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalUserAttribute _createInternalUserAttribute = DataFactory.this._internalFactory.createInternalUserAttribute();
          _elvis = _createInternalUserAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            UserAttributeEContentAdapter _userAttributeEContentAdapter = new UserAttributeEContentAdapter();
            _eAdapters.add(_userAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<UserAttribute>operator_doubleArrow(_createUserAttribute, _function);
  }
  
  /**
   * This method creates an UserAttribute with the given id. Post create hook won't be triggered.
   */
  public UserAttribute createUserAttribute(final String ID) {
    return this.createUserAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an UserAttribute with the given id. Post create hook will be triggered.
   */
  public UserAttribute createUserAttribute(final InternalModelElementContainer parent) {
    return this.createUserAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an UserAttribute with the given id. Post create hook will be triggered.
   */
  public UserAttribute createUserAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createUserAttribute(ID, null, parent, true);
  }
  
  public UserAttribute createUserAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createUserAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an UserAttribute with the given id. Post create hook won't be triggered.
   */
  public UserAttribute createUserAttribute(final InternalModelElement ime) {
    return this.createUserAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public UserAttribute createUserAttribute() {
    return this.createUserAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Data with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Data createData(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Data _createData = super.createData();
    final Procedure1<Data> _function = new Procedure1<Data>() {
      @Override
      public void apply(final Data it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalData _createInternalData = DataFactory.this._internalFactory.createInternalData();
          _elvis = _createInternalData;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            DataEContentAdapter _dataEContentAdapter = new DataEContentAdapter();
            _eAdapters.add(_dataEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<Data>operator_doubleArrow(_createData, _function);
  }
  
  /**
   * This method creates an Data with the given id. Post create hook won't be triggered.
   */
  public Data createData(final String ID) {
    return this.createData(ID, null, null, false);
  }
  
  /**
   * This method creates an Data with the given id. Post create hook will be triggered.
   */
  public Data createData(final InternalModelElementContainer parent) {
    return this.createData(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Data with the given id. Post create hook will be triggered.
   */
  public Data createData(final String ID, final InternalModelElementContainer parent) {
    return this.createData(ID, null, parent, true);
  }
  
  public Data createData(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createData(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Data with the given id. Post create hook won't be triggered.
   */
  public Data createData(final InternalModelElement ime) {
    return this.createData(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Data createData() {
    return this.createData(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ReferencedType with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ReferencedType createReferencedType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ReferencedType _createReferencedType = super.createReferencedType();
    final Procedure1<ReferencedType> _function = new Procedure1<ReferencedType>() {
      @Override
      public void apply(final ReferencedType it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalReferencedType _createInternalReferencedType = DataFactory.this._internalFactory.createInternalReferencedType();
          _elvis = _createInternalReferencedType;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ReferencedTypeEContentAdapter _referencedTypeEContentAdapter = new ReferencedTypeEContentAdapter();
            _eAdapters.add(_referencedTypeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ReferencedType>operator_doubleArrow(_createReferencedType, _function);
  }
  
  /**
   * This method creates an ReferencedType with the given id. Post create hook won't be triggered.
   */
  public ReferencedType createReferencedType(final String ID) {
    return this.createReferencedType(ID, null, null, false);
  }
  
  /**
   * This method creates an ReferencedType with the given id. Post create hook will be triggered.
   */
  public ReferencedType createReferencedType(final InternalModelElementContainer parent) {
    return this.createReferencedType(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ReferencedType with the given id. Post create hook will be triggered.
   */
  public ReferencedType createReferencedType(final String ID, final InternalModelElementContainer parent) {
    return this.createReferencedType(ID, null, parent, true);
  }
  
  public ReferencedType createReferencedType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createReferencedType(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ReferencedType with the given id. Post create hook won't be triggered.
   */
  public ReferencedType createReferencedType(final InternalModelElement ime) {
    return this.createReferencedType(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ReferencedType createReferencedType() {
    return this.createReferencedType(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an AbstractType with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public AbstractType createAbstractType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    AbstractType _createAbstractType = super.createAbstractType();
    final Procedure1<AbstractType> _function = new Procedure1<AbstractType>() {
      @Override
      public void apply(final AbstractType it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalAbstractType _createInternalAbstractType = DataFactory.this._internalFactory.createInternalAbstractType();
          _elvis = _createInternalAbstractType;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            AbstractTypeEContentAdapter _abstractTypeEContentAdapter = new AbstractTypeEContentAdapter();
            _eAdapters.add(_abstractTypeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DataFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DataFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<AbstractType>operator_doubleArrow(_createAbstractType, _function);
  }
  
  /**
   * This method creates an AbstractType with the given id. Post create hook won't be triggered.
   */
  public AbstractType createAbstractType(final String ID) {
    return this.createAbstractType(ID, null, null, false);
  }
  
  /**
   * This method creates an AbstractType with the given id. Post create hook will be triggered.
   */
  public AbstractType createAbstractType(final InternalModelElementContainer parent) {
    return this.createAbstractType(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an AbstractType with the given id. Post create hook will be triggered.
   */
  public AbstractType createAbstractType(final String ID, final InternalModelElementContainer parent) {
    return this.createAbstractType(ID, null, parent, true);
  }
  
  public AbstractType createAbstractType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createAbstractType(ID, ime, parent, true);
  }
  
  /**
   * This method creates an AbstractType with the given id. Post create hook won't be triggered.
   */
  public AbstractType createAbstractType(final InternalModelElement ime) {
    return this.createAbstractType(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public AbstractType createAbstractType() {
    return this.createAbstractType(EcoreUtil.generateUUID());
  }
  
  private <T extends IdentifiableElement> T setInternal(final T elm, final InternalIdentifiableElement internal) {
    final Procedure1<T> _function = new Procedure1<T>() {
      @Override
      public void apply(final T it) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getId());
        if (_isNullOrEmpty) {
          EcoreUtil.setID(it, EcoreUtil.generateUUID());
        }
        boolean _matched = false;
        if (elm instanceof GraphModel) {
          _matched=true;
          ((GraphModel)elm).setInternalElement_(((InternalGraphModel) internal));
        }
        if (!_matched) {
          if (elm instanceof ModelElement) {
            _matched=true;
            ((ModelElement)elm).setInternalElement_(((InternalModelElement) internal));
          }
        }
        if (!_matched) {
          if (elm instanceof Type) {
            _matched=true;
            ((Type)elm).setInternalElement_(((InternalType) internal));
          }
        }
      }
    };
    return ObjectExtensions.<T>operator_doubleArrow(elm, _function);
  }
  
  /**
   * This method creates a new Data object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can
   * simply call the Data's save method to save your changes.
   */
  public Data createData(final String path, final String fileName) {
    IPath filePath = new Path(path).append(fileName).addFileExtension("data");
    URI uri = URI.createPlatformResourceURI(filePath.toOSString(), true);
    Resource res = new ResourceSetImpl().createResource(uri);
    Data graph = DataFactory.eINSTANCE.createData();
    EcoreUtil.setID(graph, EcoreUtil.generateUUID());
    res.getContents().add(graph.getInternalElement_());
    this.postCreates(graph);
    try {
      res.save(null);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return graph;
  }
  
  public void postCreates(final AbstractType me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new TypePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ConcreteType me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new TypePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ReferencedType me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ReferencedTypePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ReferencedEnumType me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ReferencedEnumTypePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ReferencedUserType me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ReferencedTypePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final UserType me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new UserTypePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ReferencedPrimitiveAttribute me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AttributePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ReferencedComplexAttribute me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AttributePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ReferencedExtensionAttribute me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AttributePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ReferencedBidirectionalAttribute me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AttributePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ReferencedUserAttribute me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AttributePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final EnumType me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new TypePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final PrimitiveAttribute me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AttributePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexAttribute me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AttributePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ExtensionAttribute me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AttributePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final BidirectionalAttribute me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AttributePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final UserAttribute me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AttributePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final EnumLiteral me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AttributePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final BidirectionalAssociation me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new BidirectionalAssociationInitialize().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final Association me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AssociationInitialize().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final UserAssociation me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new UserAssociationInitialize().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final Data me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new DataPostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
}
