/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.checks;

import com.google.common.collect.Iterables;
import graphmodel.Node;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.Inheritance;
import info.scce.dime.data.data.InheritorType;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.mcam.modules.checks.DataCheck;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class StaticSemanticsCheck extends DataCheck {
  @Override
  public void check(final Data model) {
    this.checkInheritanceCycles(model);
  }
  
  public void checkInheritanceCycles(final Data model) {
    final HashSet<Set<Node>> cycles = CollectionLiterals.<Set<Node>>newHashSet();
    final Function1<InheritorType, Iterable<Iterable<Node>>> _function = new Function1<InheritorType, Iterable<Iterable<Node>>>() {
      @Override
      public Iterable<Iterable<Node>> apply(final InheritorType type) {
        final Function1<List<Node>, Boolean> _function = new Function1<List<Node>, Boolean>() {
          @Override
          public Boolean apply(final List<Node> it) {
            boolean _isEmpty = it.isEmpty();
            return Boolean.valueOf((!_isEmpty));
          }
        };
        final Function1<List<Node>, Boolean> _function_1 = new Function1<List<Node>, Boolean>() {
          @Override
          public Boolean apply(final List<Node> it) {
            return Boolean.valueOf(StaticSemanticsCheck.this._graphModelExtension.findSuccessorsVia(type, Inheritance.class).containsAll(it));
          }
        };
        final Function1<List<Node>, Boolean> _function_2 = new Function1<List<Node>, Boolean>() {
          @Override
          public Boolean apply(final List<Node> it) {
            return Boolean.valueOf(cycles.add(IterableExtensions.<Node>toSet(it)));
          }
        };
        final Function1<List<Node>, Iterable<Node>> _function_3 = new Function1<List<Node>, Iterable<Node>>() {
          @Override
          public Iterable<Node> apply(final List<Node> it) {
            return Iterables.<Node>concat(Collections.<InheritorType>unmodifiableList(CollectionLiterals.<InheritorType>newArrayList(type)), it);
          }
        };
        return IterableExtensions.<List<Node>, Iterable<Node>>map(IterableExtensions.<List<Node>>filter(IterableExtensions.<List<Node>>filter(IterableExtensions.<List<Node>>filter(StaticSemanticsCheck.this._graphModelExtension.findPathsTo(type, type), _function), _function_1), _function_2), _function_3);
      }
    };
    final Consumer<Iterable<Node>> _function_1 = new Consumer<Iterable<Node>>() {
      @Override
      public void accept(final Iterable<Node> path) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Inheritance cycle: ");
        final Function1<Type, String> _function = new Function1<Type, String>() {
          @Override
          public String apply(final Type it) {
            return it.getName();
          }
        };
        String _join = IterableExtensions.join(IterableExtensions.<Type, String>map(Iterables.<Type>filter(path, Type.class), _function), " < ");
        _builder.append(_join);
        StaticSemanticsCheck.this.addError(model, _builder.toString());
      }
    };
    IterableExtensions.<InheritorType, Iterable<Node>>flatMap(model.getInheritorTypes(), _function).forEach(_function_1);
  }
}
