/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.checks;

import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.ExtensionAttribute;
import info.scce.dime.data.data.ReferencedExtensionAttribute;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.helper.DataExtension;
import info.scce.dime.data.mcam.modules.checks.DataCheck;
import info.scce.dime.process.process.BooleanInputStatic;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.IntegerInputStatic;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.RealInputStatic;
import info.scce.dime.process.process.TextInputStatic;
import info.scce.dime.process.process.TimestampInputStatic;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ExtensionAttributeCheck extends DataCheck {
  @Extension
  private DataExtension _dataExtension = DataExtension.getInstance();
  
  @Override
  public void check(final Data model) {
    final Function1<Type, EList<ExtensionAttribute>> _function = new Function1<Type, EList<ExtensionAttribute>>() {
      @Override
      public EList<ExtensionAttribute> apply(final Type it) {
        return it.getExtensionAttributes();
      }
    };
    final Consumer<ExtensionAttribute> _function_1 = new Consumer<ExtensionAttribute>() {
      @Override
      public void accept(final ExtensionAttribute it) {
        ExtensionAttributeCheck.this.checkAtribute(it);
      }
    };
    IterableExtensions.<Type, ExtensionAttribute>flatMap(model.getTypes(), _function).forEach(_function_1);
  }
  
  public void checkAtribute(final ExtensionAttribute model) {
    info.scce.dime.process.process.Process _switchResult = null;
    boolean _matched = false;
    if (model instanceof ReferencedExtensionAttribute) {
      _matched=true;
      info.scce.dime.process.process.Process _process = ((ReferencedExtensionAttribute)model).getReferencedAttribute().getProcess();
      _switchResult = ((info.scce.dime.process.process.Process) _process);
    }
    if (!_matched) {
      info.scce.dime.process.process.Process _process = model.getProcess();
      _switchResult = ((info.scce.dime.process.process.Process) _process);
    }
    final info.scce.dime.process.process.Process process = _switchResult;
    if ((((process.getStartSIBs().size() != 1) || (process.getStartSIBs().get(0).getOutputs().size() != 1)) || (process.getStartSIBs().get(0).getComplexOutputPorts().size() != 1))) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("process has not exactly 1 StartSIB with 1 ComplexOutputPort");
      this.addError(model, _builder.toString());
      return;
    }
    final Type startType = this._dataExtension.getOriginalType(process.getStartSIBs().get(0).getComplexOutputPorts().get(0).getDataType());
    final Type modelType = this._dataExtension.getOriginalType(model.getContainer());
    boolean _isTypeOf = this._dataExtension.isTypeOf(modelType, startType);
    boolean _not = (!_isTypeOf);
    if (_not) {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("process ComplexOutputPort dataType incompatible with type");
      this.addError(model, _builder_1.toString());
      return;
    }
    if (((process.getEndSIBs().size() != 1) || (process.getEndSIBs().get(0).getInputs().size() != 1))) {
      StringConcatenation _builder_2 = new StringConcatenation();
      _builder_2.append("process has not exactly 1 EndSIB with 1 Input");
      this.addError(model, _builder_2.toString());
      return;
    }
    final Input port = process.getEndSIBs().get(0).getInputs().get(0);
    boolean _matched_1 = false;
    if (port instanceof ComplexInputPort) {
      _matched_1=true;
      boolean _isIsList = model.isIsList();
      boolean _isIsList_1 = ((ComplexInputPort)port).isIsList();
      boolean _notEquals = (_isIsList != _isIsList_1);
      if (_notEquals) {
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("extension attribute \"");
        String _name = model.getName();
        _builder_3.append(_name);
        _builder_3.append("\" list status should be \"");
        boolean _isIsList_2 = ((ComplexInputPort)port).isIsList();
        _builder_3.append(_isIsList_2);
        _builder_3.append("\"");
        this.addError(model, _builder_3.toString());
      }
      boolean _equals = model.getDataType().equals(((ComplexInputPort)port).getDataType().getName());
      boolean _not_1 = (!_equals);
      if (_not_1) {
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("extension attribute \"");
        String _name_1 = model.getName();
        _builder_4.append(_name_1);
        _builder_4.append("\" datatype should be \"");
        String _name_2 = ((ComplexInputPort)port).getDataType().getName();
        _builder_4.append(_name_2);
        _builder_4.append("\"");
        this.addError(model, _builder_4.toString());
      }
    }
    if (!_matched_1) {
      if (port instanceof PrimitiveInputPort) {
        _matched_1=true;
        boolean _isIsList = model.isIsList();
        boolean _isIsList_1 = ((PrimitiveInputPort)port).isIsList();
        boolean _notEquals = (_isIsList != _isIsList_1);
        if (_notEquals) {
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("extension attribute \"");
          String _name = model.getName();
          _builder_3.append(_name);
          _builder_3.append("\" list status should be \"");
          boolean _isIsList_2 = ((PrimitiveInputPort)port).isIsList();
          _builder_3.append(_isIsList_2);
          _builder_3.append("\"");
          this.addError(model, _builder_3.toString());
        }
        boolean _equals = model.getDataType().equals(((PrimitiveInputPort)port).getDataType().getLiteral());
        boolean _not_1 = (!_equals);
        if (_not_1) {
          StringConcatenation _builder_4 = new StringConcatenation();
          _builder_4.append("extension attribute \"");
          String _name_1 = model.getName();
          _builder_4.append(_name_1);
          _builder_4.append("\" datatype should be \"");
          String _literal = ((PrimitiveInputPort)port).getDataType().getLiteral();
          _builder_4.append(_literal);
          _builder_4.append("\"");
          this.addError(model, _builder_4.toString());
        }
      }
    }
    if (!_matched_1) {
      if (port instanceof InputStatic) {
        _matched_1=true;
        boolean _isIsList = model.isIsList();
        boolean _notEquals = (_isIsList != false);
        if (_notEquals) {
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("extension attribute \"");
          String _name = model.getName();
          _builder_3.append(_name);
          _builder_3.append("\" list status should be \"false\"");
          this.addError(model, _builder_3.toString());
        }
        String _switchResult_2 = null;
        boolean _matched_2 = false;
        if (port instanceof TextInputStatic) {
          _matched_2=true;
          _switchResult_2 = "Text";
        }
        if (!_matched_2) {
          if (port instanceof IntegerInputStatic) {
            _matched_2=true;
            _switchResult_2 = "Integer";
          }
        }
        if (!_matched_2) {
          if (port instanceof RealInputStatic) {
            _matched_2=true;
            _switchResult_2 = "Real";
          }
        }
        if (!_matched_2) {
          if (port instanceof TimestampInputStatic) {
            _matched_2=true;
            _switchResult_2 = "Timestamp";
          }
        }
        if (!_matched_2) {
          if (port instanceof BooleanInputStatic) {
            _matched_2=true;
            _switchResult_2 = "Boolean";
          }
        }
        final String primitiveTyeName = _switchResult_2;
        boolean _equals = model.getDataType().equals(primitiveTyeName);
        boolean _not_1 = (!_equals);
        if (_not_1) {
          StringConcatenation _builder_4 = new StringConcatenation();
          _builder_4.append("extension attribute \"");
          String _name_1 = model.getName();
          _builder_4.append(_name_1);
          _builder_4.append("\" datatype should be \"");
          _builder_4.append(primitiveTyeName);
          _builder_4.append("\"");
          this.addError(model, _builder_4.toString());
        }
      }
    }
  }
}
