/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.checks;

import graphmodel.Node;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.ReferencedEnumType;
import info.scce.dime.data.data.ReferencedType;
import info.scce.dime.data.data.ReferencedUserType;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.mcam.modules.checks.DataCheck;
import info.scce.dime.util.DataID;
import java.util.HashMap;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class DataIDsCheck extends DataCheck {
  @Override
  public void check(final Data model) {
    final Iterable<Type> types = this._collectionExtension.<Type>drop(this._collectionExtension.<Type>drop(this._collectionExtension.<Type>drop(this._graphModelExtension.<Type>find(model, Type.class), ReferencedType.class), ReferencedUserType.class), ReferencedEnumType.class);
    this.validateDataIds(types);
    final Function1<Attribute, Boolean> _function = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        return Boolean.valueOf(IterableExtensions.isEmpty(DataIDsCheck.this._graphModelExtension.<ReferencedType>findParents(it, ReferencedType.class)));
      }
    };
    final Function1<Attribute, Boolean> _function_1 = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        return Boolean.valueOf(IterableExtensions.isEmpty(DataIDsCheck.this._graphModelExtension.<ReferencedUserType>findParents(it, ReferencedUserType.class)));
      }
    };
    final Function1<Attribute, Boolean> _function_2 = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        return Boolean.valueOf(IterableExtensions.isEmpty(DataIDsCheck.this._graphModelExtension.<ReferencedEnumType>findParents(it, ReferencedEnumType.class)));
      }
    };
    final Iterable<Attribute> attrs = IterableExtensions.<Attribute>filter(IterableExtensions.<Attribute>filter(IterableExtensions.<Attribute>filter(this._graphModelExtension.<Attribute>find(model, Attribute.class), _function), _function_1), _function_2);
    this.validateDataIds(attrs);
  }
  
  public void validateDataIds(final Iterable<? extends Node> nodes) {
    final HashMap<String, Node> id16_on_node = CollectionLiterals.<String, Node>newHashMap();
    for (final Node node : nodes) {
      {
        final DataID dataId = DataID.from(node);
        final String id16 = dataId.escapedLowerCase16();
        boolean _containsKey = id16_on_node.containsKey(id16);
        boolean _not = (!_containsKey);
        if (_not) {
          id16_on_node.put(id16, node);
        } else {
          final Node other = id16_on_node.get(id16);
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("ID ");
          String _id = node.getId();
          _builder.append(_id);
          _builder.append(" conflicts with ID ");
          String _id_1 = other.getId();
          _builder.append(_id_1);
          _builder.append(" of ");
          String _displayName = this.displayName(other);
          _builder.append(_displayName);
          _builder.append(" (both map on 16 chars ");
          _builder.append(id16);
          _builder.append(")");
          this.addError(node, _builder.toString());
        }
      }
    }
  }
  
  public String displayName(final Node node) {
    String _switchResult = null;
    boolean _matched = false;
    if (node instanceof Type) {
      _matched=true;
      String _name = ((Type)node).getName();
      String _plus = ("Type \'" + _name);
      _switchResult = (_plus + "\'");
    }
    if (!_matched) {
      if (node instanceof Attribute) {
        _matched=true;
        String _name = ((Attribute)node).getName();
        String _plus = ("Attribute \'" + _name);
        String _plus_1 = (_plus + "\' of ");
        String _displayName = this.displayName(this._graphModelExtension.<Type>findFirstParent(node, Type.class));
        _switchResult = (_plus_1 + _displayName);
      }
    }
    if (!_matched) {
      _switchResult = node.getClass().getSimpleName();
    }
    return _switchResult;
  }
}
