/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.BidirectionalAttribute;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.ExtensionAttribute;
import info.scce.dime.data.data.InheritorType;
import info.scce.dime.data.data.PrimitiveAttribute;
import info.scce.dime.data.data.ReferencedBidirectionalAttribute;
import info.scce.dime.data.data.ReferencedComplexAttribute;
import info.scce.dime.data.data.ReferencedExtensionAttribute;
import info.scce.dime.data.data.ReferencedPrimitiveAttribute;
import info.scce.dime.data.data.ReferencedType;
import info.scce.dime.data.data.ReferencedUserAttribute;
import info.scce.dime.data.data.UserAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;

@SuppressWarnings("all")
public class UpdateReferencedType extends DIMECustomAction<ReferencedType> {
  private Data data;
  
  @Override
  public String getName() {
    return "Update ReferencedType";
  }
  
  @Override
  public boolean canExecute(final ReferencedType type) {
    InheritorType _referencedType = type.getReferencedType();
    return (_referencedType instanceof InheritorType);
  }
  
  @Override
  public void execute(final ReferencedType rType) {
    InheritorType iType = rType.getReferencedType();
    boolean _equals = rType.getName().equals(iType.getName());
    boolean _not = (!_equals);
    if (_not) {
      rType.setName(iType.getName());
    }
    EList<Attribute> _attributes = rType.getAttributes();
    ArrayList<Attribute> rAttributes = new ArrayList<Attribute>(_attributes);
    List<Attribute> _inheritedAttributes = this._dataExtension.getInheritedAttributes(iType);
    ArrayList<Attribute> iAttribtues = new ArrayList<Attribute>(_inheritedAttributes);
    ArrayList<Attribute> toDeleteAttr = new ArrayList<Attribute>(rAttributes);
    HashMap<Attribute, Attribute> toUpdateAttr = new HashMap<Attribute, Attribute>();
    ArrayList<Attribute> toAddAttr = new ArrayList<Attribute>();
    for (final Attribute iAttr : iAttribtues) {
      {
        Attribute foundRAttr = null;
        for (final Attribute rAttr : rAttributes) {
          if ((rAttr instanceof ReferencedPrimitiveAttribute)) {
            PrimitiveAttribute refAttr = ((ReferencedPrimitiveAttribute) rAttr).getReferencedAttribute();
            if ((this._gUIExtension.operator_notEquals(refAttr, null) && refAttr.getId().equals(iAttr.getId()))) {
              foundRAttr = rAttr;
              toDeleteAttr.remove(rAttr);
            }
          } else {
            if ((rAttr instanceof ReferencedUserAttribute)) {
              UserAttribute refAttr_1 = ((ReferencedUserAttribute) rAttr).getReferencedAttribute();
              if ((this._gUIExtension.operator_notEquals(refAttr_1, null) && refAttr_1.getId().equals(iAttr.getId()))) {
                foundRAttr = rAttr;
                toDeleteAttr.remove(rAttr);
              }
            } else {
              if ((rAttr instanceof ReferencedBidirectionalAttribute)) {
                BidirectionalAttribute refAttr_2 = ((ReferencedBidirectionalAttribute) rAttr).getReferencedAttribute();
                if ((this._gUIExtension.operator_notEquals(refAttr_2, null) && refAttr_2.getId().equals(iAttr.getId()))) {
                  foundRAttr = rAttr;
                  toDeleteAttr.remove(rAttr);
                }
              } else {
                if ((rAttr instanceof ReferencedComplexAttribute)) {
                  ComplexAttribute refAttr_3 = ((ReferencedComplexAttribute) rAttr).getReferencedAttribute();
                  if ((this._gUIExtension.operator_notEquals(refAttr_3, null) && refAttr_3.getId().equals(iAttr.getId()))) {
                    foundRAttr = rAttr;
                    toDeleteAttr.remove(rAttr);
                  }
                } else {
                  if ((rAttr instanceof ReferencedExtensionAttribute)) {
                    ExtensionAttribute refAttr_4 = ((ReferencedExtensionAttribute) rAttr).getReferencedAttribute();
                    if ((this._gUIExtension.operator_notEquals(refAttr_4, null) && refAttr_4.getId().equals(iAttr.getId()))) {
                      foundRAttr = rAttr;
                      toDeleteAttr.remove(rAttr);
                    }
                  } else {
                    throw new IllegalStateException("missing implementation for referencedAttribute");
                  }
                }
              }
            }
          }
        }
        if ((foundRAttr != null)) {
          toUpdateAttr.put(iAttr, foundRAttr);
        } else {
          toAddAttr.add(iAttr);
        }
      }
    }
    for (final Attribute attr : toDeleteAttr) {
      attr.delete();
    }
    Set<Attribute> _keySet = toUpdateAttr.keySet();
    for (final Attribute iAttr_1 : _keySet) {
      this.updateAttribute(rType, iAttr_1, toUpdateAttr.get(iAttr_1));
    }
    for (final Attribute iAttr_2 : toAddAttr) {
      this.addAttribute(rType, iAttr_2);
    }
  }
  
  private void addAttribute(final ReferencedType rType, final Attribute iAttr) {
    if ((iAttr instanceof PrimitiveAttribute)) {
      PrimitiveAttribute origAttr = ((PrimitiveAttribute) iAttr);
      ReferencedPrimitiveAttribute newAttr = rType.newReferencedPrimitiveAttribute(origAttr, 0, 0);
      newAttr.setName(origAttr.getName());
      newAttr.setDataType(origAttr.getDataType());
      newAttr.setIsList(origAttr.isIsList());
    } else {
      if ((iAttr instanceof UserAttribute)) {
        UserAttribute origAttr_1 = ((UserAttribute) iAttr);
        ReferencedUserAttribute newAttr_1 = rType.newReferencedUserAttribute(origAttr_1, 0, 0);
        newAttr_1.setName(origAttr_1.getName());
        newAttr_1.setDataType(origAttr_1.getDataType());
        newAttr_1.setIsList(origAttr_1.isIsList());
      } else {
        if ((iAttr instanceof BidirectionalAttribute)) {
          BidirectionalAttribute origAttr_2 = ((BidirectionalAttribute) iAttr);
          ReferencedBidirectionalAttribute newCAttr = rType.newReferencedBidirectionalAttribute(origAttr_2, 0, 0);
          newCAttr.setName(origAttr_2.getName());
          newCAttr.setDataType(origAttr_2.getDataType());
          newCAttr.setIsList(origAttr_2.isIsList());
        } else {
          if ((iAttr instanceof ComplexAttribute)) {
            ComplexAttribute origAttr_3 = ((ComplexAttribute) iAttr);
            ReferencedComplexAttribute newCAttr_1 = rType.newReferencedComplexAttribute(origAttr_3, 0, 0);
            newCAttr_1.setName(origAttr_3.getName());
            newCAttr_1.setDataType(origAttr_3.getDataType());
            newCAttr_1.setIsList(origAttr_3.isIsList());
          } else {
            if ((iAttr instanceof ExtensionAttribute)) {
              ExtensionAttribute origAttr_4 = ((ExtensionAttribute) iAttr);
              ReferencedExtensionAttribute newCAttr_2 = rType.newReferencedExtensionAttribute(origAttr_4, 0, 0);
              newCAttr_2.setName(origAttr_4.getName());
              newCAttr_2.setIsList(origAttr_4.isIsList());
            } else {
              Class<? extends Attribute> _class = null;
              if (iAttr!=null) {
                _class=iAttr.getClass();
              }
              String _name = null;
              if (_class!=null) {
                _name=_class.getName();
              }
              String _plus = ("missing implementation for " + _name);
              throw new IllegalStateException(_plus);
            }
          }
        }
      }
    }
  }
  
  private void updateAttribute(final ReferencedType rType, final Attribute iAttr, final Attribute rAttr) {
    Attribute cOldRAttribute = rAttr;
    Attribute cNewAttribute = null;
    String oldRAttrId = rAttr.getId();
    int oldX = cOldRAttribute.getX();
    int oldY = cOldRAttribute.getY();
    int oldHeight = cOldRAttribute.getHeight();
    int oldWidth = cOldRAttribute.getWidth();
    if ((iAttr instanceof PrimitiveAttribute)) {
      PrimitiveAttribute origAttr = ((PrimitiveAttribute) iAttr);
      ReferencedPrimitiveAttribute newCAttr = rType.newReferencedPrimitiveAttribute(origAttr, oldX, oldY, oldWidth, oldHeight);
      EcoreUtil.setID(newCAttr, oldRAttrId);
      newCAttr.setName(origAttr.getName());
      newCAttr.setDataType(origAttr.getDataType());
      newCAttr.setIsList(origAttr.isIsList());
      cNewAttribute = newCAttr;
    } else {
      if ((iAttr instanceof UserAttribute)) {
        UserAttribute origAttr_1 = ((UserAttribute) iAttr);
        ReferencedUserAttribute newCAttr_1 = rType.newReferencedUserAttribute(origAttr_1, oldX, oldY, oldWidth, oldHeight);
        EcoreUtil.setID(newCAttr_1, oldRAttrId);
        newCAttr_1.setName(origAttr_1.getName());
        newCAttr_1.setDataType(origAttr_1.getDataType());
        newCAttr_1.setIsList(origAttr_1.isIsList());
        cNewAttribute = newCAttr_1;
      } else {
        if ((iAttr instanceof BidirectionalAttribute)) {
          BidirectionalAttribute origAttr_2 = ((BidirectionalAttribute) iAttr);
          ReferencedBidirectionalAttribute newCAttr_2 = rType.newReferencedBidirectionalAttribute(origAttr_2, oldX, oldY, oldWidth, oldHeight);
          EcoreUtil.setID(newCAttr_2, oldRAttrId);
          newCAttr_2.setName(origAttr_2.getName());
          newCAttr_2.setDataType(origAttr_2.getDataType());
          newCAttr_2.setIsList(origAttr_2.isIsList());
          cNewAttribute = newCAttr_2;
        } else {
          if ((iAttr instanceof ComplexAttribute)) {
            ComplexAttribute origAttr_3 = ((ComplexAttribute) iAttr);
            ReferencedComplexAttribute newCAttr_3 = rType.newReferencedComplexAttribute(origAttr_3, oldX, oldY, oldWidth, oldHeight);
            EcoreUtil.setID(newCAttr_3, oldRAttrId);
            newCAttr_3.setName(origAttr_3.getName());
            newCAttr_3.setDataType(origAttr_3.getDataType());
            newCAttr_3.setIsList(origAttr_3.isIsList());
            cNewAttribute = newCAttr_3;
          } else {
            if ((iAttr instanceof ExtensionAttribute)) {
              ExtensionAttribute origAttr_4 = ((ExtensionAttribute) iAttr);
              ReferencedExtensionAttribute newCAttr_4 = rType.newReferencedExtensionAttribute(origAttr_4, 0, 0);
              newCAttr_4.setName(origAttr_4.getName());
              newCAttr_4.setIsList(origAttr_4.isIsList());
            } else {
              throw new IllegalStateException("missing implementation for referencedAttribute");
            }
          }
        }
      }
    }
    cOldRAttribute.delete();
  }
}
