/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.data.data.ExtensionAttribute;
import info.scce.dime.process.process.BooleanInputStatic;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.IntegerInputStatic;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.RealInputStatic;
import info.scce.dime.process.process.TextInputStatic;
import info.scce.dime.process.process.TimestampInputStatic;

@SuppressWarnings("all")
public class UpdateExtensionAttribute extends DIMECustomAction<ExtensionAttribute> {
  @Override
  public String getName() {
    return "Update Extension Attribute";
  }
  
  @Override
  public boolean canExecute(final ExtensionAttribute attr) {
    return (((attr.getProcess() != null) && 
      (!((info.scce.dime.process.process.Process) attr.getProcess()).getEndSIBs().isEmpty())) && 
      (!((info.scce.dime.process.process.Process) attr.getProcess()).getEndSIBs().get(0).getInputs().isEmpty()));
  }
  
  @Override
  public void execute(final ExtensionAttribute attr) {
    info.scce.dime.process.process.Process _process = attr.getProcess();
    final info.scce.dime.process.process.Process process = ((info.scce.dime.process.process.Process) _process);
    final Input port = process.getEndSIBs().get(0).getInputs().get(0);
    boolean _matched = false;
    if (port instanceof ComplexInputPort) {
      _matched=true;
      attr.setIsList(((ComplexInputPort)port).isIsList());
      attr.setDataType(((ComplexInputPort)port).getDataType().getName());
    }
    if (!_matched) {
      if (port instanceof PrimitiveInputPort) {
        _matched=true;
        attr.setIsList(((PrimitiveInputPort)port).isIsList());
        attr.setDataType(((PrimitiveInputPort)port).getDataType().getLiteral());
      }
    }
    if (!_matched) {
      if (port instanceof InputStatic) {
        _matched=true;
        attr.setIsList(false);
        String _switchResult_1 = null;
        boolean _matched_1 = false;
        if (port instanceof TextInputStatic) {
          _matched_1=true;
          _switchResult_1 = "Text";
        }
        if (!_matched_1) {
          if (port instanceof IntegerInputStatic) {
            _matched_1=true;
            _switchResult_1 = "Integer";
          }
        }
        if (!_matched_1) {
          if (port instanceof RealInputStatic) {
            _matched_1=true;
            _switchResult_1 = "Real";
          }
        }
        if (!_matched_1) {
          if (port instanceof TimestampInputStatic) {
            _matched_1=true;
            _switchResult_1 = "Timestamp";
          }
        }
        if (!_matched_1) {
          if (port instanceof BooleanInputStatic) {
            _matched_1=true;
            _switchResult_1 = "Boolean";
          }
        }
        attr.setDataType(_switchResult_1);
      }
    }
  }
}
