/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.data.data.Association;
import info.scce.dime.data.data.BidirectionalAssociation;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.Type;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class ShowHideAssociation<T extends ComplexAttribute> extends DIMECustomAction<T> {
  @Override
  public String getName() {
    return "Toggle Show/Hide Association";
  }
  
  @Override
  public boolean canExecute(final ComplexAttribute ca) {
    Association _correspondingAssociation = this.getCorrespondingAssociation(ca);
    return (_correspondingAssociation != null);
  }
  
  @Override
  public void execute(final ComplexAttribute ca) {
    InputOutput.<Boolean>println(Boolean.valueOf(ca.isIsList()));
    Association asso = this.getCorrespondingAssociation(ca);
    boolean _isIsHidden = asso.isIsHidden();
    boolean _not = (!_isIsHidden);
    asso.setIsHidden(_not);
  }
  
  private Association getCorrespondingAssociation(final ComplexAttribute ca) {
    Type _container = ca.getContainer();
    final Type type = ((Type) _container);
    EList<Association> _incoming = type.<Association>getIncoming(Association.class);
    final ArrayList<Association> allAssociations = new ArrayList<Association>(_incoming);
    allAssociations.addAll(type.<Association>getOutgoing(Association.class));
    for (final Association asso : allAssociations) {
      {
        boolean _equals = ((Association) asso).getSourceAttr().equals(ca);
        if (_equals) {
          return ((Association) asso);
        }
        if ((asso instanceof BidirectionalAssociation)) {
          boolean _equals_1 = ((BidirectionalAssociation) asso).getTargetAttr().equals(ca);
          if (_equals_1) {
            return ((Association) asso);
          }
        }
      }
    }
    return null;
  }
}
