/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.EnumType;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.helper.TypeLayoutUtils;
import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class NewPrimitiveAttribute extends DIMECustomAction<Type> {
  @Override
  public String getName() {
    return "New Primitive Attribute";
  }
  
  @Override
  public void execute(final Type type) {
    int currentAttrAmount = type.getAttributes().size();
    if ((type instanceof EnumType)) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("literal");
      _builder.append((currentAttrAmount + 1));
      ((EnumType)type).newEnumLiteral(1, 1).setName(_builder.toString());
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("attr");
      _builder_1.append((currentAttrAmount + 1));
      type.newPrimitiveAttribute(1, 1).setName(_builder_1.toString());
    }
    TypeLayoutUtils.resizeAndLayout(type);
    this.sortOrder(type);
  }
  
  public void sortOrder(final Type type) {
    Data data = type.getRootElement();
    EList<Type> _types = data.getTypes();
    for (final Type myType : _types) {
      {
        EList<Attribute> allAttributes = type.getAttributes();
        LinkedList<Attribute> myAttr = new LinkedList<Attribute>();
        myAttr.addAll(allAttributes);
        myAttr.sort(new Comparator<Attribute>() {
          @Override
          public int compare(final Attribute o1, final Attribute o2) {
            return o1.getName().compareTo(o2.getName());
          }
        });
        int offset = 32;
        for (final Attribute attr : myAttr) {
          {
            attr.moveTo(attr.getContainer(), attr.getX(), offset);
            int _offset = offset;
            offset = (_offset + 18);
          }
        }
      }
    }
  }
}
