/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.data.actions;

import com.google.common.collect.Iterables;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.data.data.AbstractType;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.ConcreteType;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.EnumLiteral;
import info.scce.dime.data.data.EnumType;
import info.scce.dime.data.data.PrimitiveAttribute;
import info.scce.dime.data.data.ReferencedType;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.data.UserType;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class GenerateMarkdownDocumentation<T extends Data> extends DIMECustomAction<T> {
  @Override
  public String getName() {
    return "Create Documentation";
  }
  
  @Override
  public boolean canExecute(final Data d) {
    return true;
  }
  
  @Override
  public boolean hasDoneChanges() {
    return false;
  }
  
  @Override
  public void execute(final Data d) {
    try {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("../documentation/data/");
      String _modelName = d.getModelName();
      _builder.append(_modelName);
      _builder.append(".md");
      final String filePath = this._workspaceExtension.getFile(d).getProject().getLocation().append(_builder.toString()).toString();
      this.createFile(this.createDoc(d).toString(), filePath);
      final Consumer<Type> _function = new Consumer<Type>() {
        @Override
        public void accept(final Type t) {
          try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("../documentation/data/");
            String _modelName = d.getModelName();
            _builder.append(_modelName);
            _builder.append("/");
            String _name = t.getName();
            _builder.append(_name);
            _builder.append(".md");
            final String typeFilePath = GenerateMarkdownDocumentation.this._workspaceExtension.getFile(d).getProject().getLocation().append(_builder.toString()).toString();
            GenerateMarkdownDocumentation.this.createFile(GenerateMarkdownDocumentation.this.getTypeDoc(t).toString(), typeFilePath);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      };
      d.getTypes().forEach(_function);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * Helper method to create a file with the given content on the given path.
   * @param content
   * @param path
   * @throws IOException
   */
  public void createFile(final String content, final String path) throws IOException {
    final File f = new File(path);
    f.getParentFile().mkdirs();
    f.createNewFile();
    FileUtils.writeStringToFile(f, content);
  }
  
  public CharSequence createDoc(final Data d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("# ");
    String _modelName = d.getModelName();
    _builder.append(_modelName);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    String _doc = this.doc(d.getDocumentation());
    _builder.append(_doc);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("### User Types");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    final Function1<UserType, String> _function = new Function1<UserType, String>() {
      @Override
      public String apply(final UserType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("* [");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("](./");
        String _modelName = d.getRootElement().getModelName();
        _builder.append(_modelName);
        _builder.append("/");
        String _name_1 = it.getName();
        _builder.append(_name_1);
        _builder.append(".md)");
        return _builder.toString();
      }
    };
    String _join = IterableExtensions.join(ListExtensions.<UserType, String>map(d.getUserTypes(), _function), "\n");
    _builder.append(_join);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("### Abstract Types");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    final Function1<AbstractType, String> _function_1 = new Function1<AbstractType, String>() {
      @Override
      public String apply(final AbstractType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("* [");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("](./");
        String _modelName = d.getRootElement().getModelName();
        _builder.append(_modelName);
        _builder.append("/");
        String _name_1 = it.getName();
        _builder.append(_name_1);
        _builder.append(".md)");
        return _builder.toString();
      }
    };
    String _join_1 = IterableExtensions.join(ListExtensions.<AbstractType, String>map(d.getAbstractTypes(), _function_1), "\n");
    _builder.append(_join_1);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("### Concrete Types");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    final Function1<ConcreteType, String> _function_2 = new Function1<ConcreteType, String>() {
      @Override
      public String apply(final ConcreteType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("* [");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("](./");
        String _modelName = d.getRootElement().getModelName();
        _builder.append(_modelName);
        _builder.append("/");
        String _name_1 = it.getName();
        _builder.append(_name_1);
        _builder.append(".md)");
        return _builder.toString();
      }
    };
    String _join_2 = IterableExtensions.join(ListExtensions.<ConcreteType, String>map(d.getConcreteTypes(), _function_2), "\n");
    _builder.append(_join_2);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("### Enumerations");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    final Function1<EnumType, String> _function_3 = new Function1<EnumType, String>() {
      @Override
      public String apply(final EnumType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("* [");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("](./");
        String _modelName = d.getRootElement().getModelName();
        _builder.append(_modelName);
        _builder.append("/");
        String _name_1 = it.getName();
        _builder.append(_name_1);
        _builder.append(".md)");
        return _builder.toString();
      }
    };
    String _join_3 = IterableExtensions.join(ListExtensions.<EnumType, String>map(d.getEnumTypes(), _function_3), "\n");
    _builder.append(_join_3);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("### Referenced Types");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    final Function1<ReferencedType, String> _function_4 = new Function1<ReferencedType, String>() {
      @Override
      public String apply(final ReferencedType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("* [");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("](./");
        String _modelName = d.getRootElement().getModelName();
        _builder.append(_modelName);
        _builder.append("/");
        String _name_1 = it.getName();
        _builder.append(_name_1);
        _builder.append(".md)");
        return _builder.toString();
      }
    };
    String _join_4 = IterableExtensions.join(ListExtensions.<ReferencedType, String>map(d.getReferencedTypes(), _function_4), "\n");
    _builder.append(_join_4);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getTypeDoc(final Type t) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("# ");
    String _typeName = this.typeName(t);
    _builder.append(_typeName);
    _builder.append(" ");
    {
      boolean _isEmpty = this._dataExtension.getSuperTypes(t).isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append("extends ");
        final Function<Type, String> _function = new Function<Type, String>() {
          @Override
          public String apply(final Type it) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("[");
            String _name = it.getName();
            _builder.append(_name);
            _builder.append("](");
            String _name_1 = it.getName();
            _builder.append(_name_1);
            _builder.append(".md)");
            return _builder.toString();
          }
        };
        String _join = IterableExtensions.join(this._dataExtension.getSuperTypes(t).<String>map(_function).toList(), ", ");
        _builder.append(_join);
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    String _doc = this.doc(t.getDocumentation());
    _builder.append(_doc);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    {
      boolean _isEmpty_1 = this._dataExtension.getSuperTypes(t).isEmpty();
      boolean _not_1 = (!_isEmpty_1);
      if (_not_1) {
        final Function<Type, EList<Attribute>> _function_1 = new Function<Type, EList<Attribute>>() {
          @Override
          public EList<Attribute> apply(final Type it) {
            return it.getAttributes();
          }
        };
        final Function1<Attribute, CharSequence> _function_2 = new Function1<Attribute, CharSequence>() {
          @Override
          public CharSequence apply(final Attribute it) {
            return GenerateMarkdownDocumentation.this.attributeDoc(it);
          }
        };
        String _join_1 = IterableExtensions.join(IterableExtensions.<Attribute, CharSequence>map(Iterables.<Attribute>concat(this._dataExtension.getSuperTypes(t).<EList<Attribute>>map(_function_1)), _function_2), "\n");
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      boolean _isEmpty_2 = t.getAttributes().isEmpty();
      boolean _not_2 = (!_isEmpty_2);
      if (_not_2) {
        final Function1<Attribute, CharSequence> _function_3 = new Function1<Attribute, CharSequence>() {
          @Override
          public CharSequence apply(final Attribute it) {
            return GenerateMarkdownDocumentation.this.attributeDoc(it);
          }
        };
        String _join_2 = IterableExtensions.join(ListExtensions.<Attribute, CharSequence>map(t.getAttributes(), _function_3), "\n");
        _builder.append(_join_2);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence attributeDoc(final Attribute attr) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("* *");
    String _name = attr.getName();
    _builder.append(_name);
    _builder.append("* ");
    {
      if ((!(attr instanceof EnumLiteral))) {
        _builder.append(": ");
        String _typeName = this.typeName(attr);
        _builder.append(_typeName);
      }
    }
    {
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(attr.getDocumentation());
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        _builder.append(" ");
        String _documentation = attr.getDocumentation();
        _builder.append(_documentation);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public String typeName(final Type t) {
    String s = "";
    boolean _matched = false;
    if (t instanceof AbstractType) {
      _matched=true;
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("_(abstract)_ ");
      s = _builder.toString();
    }
    if (!_matched) {
      if (t instanceof EnumType) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("_(enumeration)_ ");
        s = _builder.toString();
      }
    }
    if (!_matched) {
      if (t instanceof ReferencedType) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("_(referenced)_ ");
        s = _builder.toString();
      }
    }
    String _name = t.getName();
    return (s + _name);
  }
  
  public String typeName(final Attribute t) {
    StringConcatenation _builder = new StringConcatenation();
    String s = _builder.toString();
    boolean _matched = false;
    if (t instanceof PrimitiveAttribute) {
      _matched=true;
      StringConcatenation _builder_1 = new StringConcatenation();
      String _literal = ((PrimitiveAttribute)t).getDataType().getLiteral();
      _builder_1.append(_literal);
      s = _builder_1.toString();
    }
    if (!_matched) {
      if (t instanceof ComplexAttribute) {
        _matched=true;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("[");
        String _name = ((ComplexAttribute)t).getDataType().getName();
        _builder_1.append(_name);
        _builder_1.append("](./");
        _builder_1.append(s);
        _builder_1.append(".md)");
        {
          ComplexAttribute _superAttr = ((ComplexAttribute)t).getSuperAttr();
          boolean _notEquals = this._gUIExtension.operator_notEquals(_superAttr, null);
          if (_notEquals) {
            _builder_1.append(" -> ");
            String _name_1 = ((ComplexAttribute)t).getSuperAttr().getName();
            _builder_1.append(_name_1);
            _builder_1.append(" of [");
            String _name_2 = this._dataExtension.getType(((ComplexAttribute)t).getSuperAttr()).getName();
            _builder_1.append(_name_2);
            _builder_1.append("](./");
            String _name_3 = this._dataExtension.getType(((ComplexAttribute)t).getSuperAttr()).getName();
            _builder_1.append(_name_3);
            _builder_1.append(".md)");
          }
        }
        s = _builder_1.toString();
      }
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      boolean _isIsList = t.isIsList();
      if (_isIsList) {
        _builder_1.append("List<");
      }
    }
    _builder_1.append(s);
    {
      boolean _isIsList_1 = t.isIsList();
      if (_isIsList_1) {
        _builder_1.append(">");
      }
    }
    return _builder_1.toString();
  }
  
  public String doc(final String s) {
    String _xblockexpression = null;
    {
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(s);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(">>>");
        _builder.newLine();
        _builder.append(s);
        _builder.newLineIfNotEmpty();
        _builder.append("<<<");
        _builder.newLine();
        return _builder.toString();
      }
      _xblockexpression = "";
    }
    return _xblockexpression;
  }
}
