/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.layout;

import de.jabc.cinco.meta.runtime.layout.LayoutConfiguration;
import de.jabc.cinco.meta.runtime.layout.ListLayouter;
import graphmodel.Container;
import graphmodel.Node;
import info.scce.dime.dad.dad.ProfileContainer;
import info.scce.dime.dad.dad.ProfileIconButton;
import info.scce.dime.dad.dad.ProfileSIB;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;

@SuppressWarnings("all")
public class Layouter extends ListLayouter {
  private static Layouter _instance;
  
  public static Layouter getInstance() {
    Layouter _elvis = null;
    if (Layouter._instance != null) {
      _elvis = Layouter._instance;
    } else {
      Layouter _layouter = new Layouter();
      Layouter __instance = (Layouter._instance = _layouter);
      _elvis = __instance;
    }
    return _elvis;
  }
  
  protected Map<LayoutConfiguration, ?> _getLayoutConfiguration(final ProfileContainer container) {
    Pair<LayoutConfiguration, Integer> _mappedTo = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_TOP, Integer.valueOf(30));
    Pair<LayoutConfiguration, Integer> _mappedTo_1 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_BOTTOM, Integer.valueOf(10));
    Pair<LayoutConfiguration, Integer> _mappedTo_2 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_Y, Integer.valueOf(5));
    Pair<LayoutConfiguration, Integer> _mappedTo_3 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.MIN_HEIGHT, Integer.valueOf(100));
    Pair<LayoutConfiguration, Integer> _mappedTo_4 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.MIN_WIDTH, Integer.valueOf(150));
    return Collections.<LayoutConfiguration, Integer>unmodifiableMap(CollectionLiterals.<LayoutConfiguration, Integer>newHashMap(_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3, _mappedTo_4));
  }
  
  protected Map<LayoutConfiguration, ?> _getLayoutConfiguration(final ProfileSIB sib) {
    Pair<LayoutConfiguration, Integer> _mappedTo = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_TOP, Integer.valueOf(0));
    return Collections.<LayoutConfiguration, Integer>unmodifiableMap(CollectionLiterals.<LayoutConfiguration, Integer>newHashMap(_mappedTo));
  }
  
  protected List<? extends Class<? extends Node>> _getIgnoredChildren(final ProfileSIB container) {
    return Collections.<Class<? extends Node>>unmodifiableList(CollectionLiterals.<Class<? extends Node>>newArrayList(ProfileIconButton.class));
  }
  
  public Map<LayoutConfiguration, ?> getLayoutConfiguration(final Container container) {
    if (container instanceof ProfileContainer) {
      return _getLayoutConfiguration((ProfileContainer)container);
    } else if (container instanceof ProfileSIB) {
      return _getLayoutConfiguration((ProfileSIB)container);
    } else if (container != null) {
      return _getLayoutConfiguration(container);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(container).toString());
    }
  }
  
  public List<? extends Class<? extends Node>> getIgnoredChildren(final Container container) {
    if (container instanceof ProfileSIB) {
      return _getIgnoredChildren((ProfileSIB)container);
    } else if (container != null) {
      return _getIgnoredChildren(container);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(container).toString());
    }
  }
}
