/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.hooks;

import graphmodel.ModelElementContainer;
import info.scce.dime.api.DIMEPostMoveHook;
import info.scce.dime.dad.dad.Server;
import info.scce.dime.dad.layout.ServersLayouter;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class PostMoveServer extends DIMEPostMoveHook<Server> {
  @Extension
  private ServersLayouter _serversLayouter = ServersLayouter.getInstance();
  
  @Override
  public void postMove(final Server server, final ModelElementContainer source, final ModelElementContainer target, final int x, final int y, final int deltaX, final int deltaY) {
    this._serversLayouter.layout(server.getContainer());
  }
}
