/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.hooks;

import de.jabc.cinco.meta.runtime.hook.CincoPostDeleteHook;
import info.scce.dime.dad.dad.ProfileContainer;
import info.scce.dime.dad.dad.ProfileSIB;
import info.scce.dime.dad.layout.Layouter;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class PostDeleteProfileSIB extends CincoPostDeleteHook<ProfileSIB> {
  @Extension
  private Layouter _layouter = Layouter.getInstance();
  
  @Override
  public Runnable getPostDeleteFunction(final ProfileSIB sib) {
    final ProfileContainer container = sib.getContainer();
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        PostDeleteProfileSIB.this._layouter.layout(container);
      }
    };
    return _function;
  }
}
