/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.hooks;

import com.google.common.base.Objects;
import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.dad.dad.ProfileSIB;
import info.scce.dime.dad.layout.Layouter;
import info.scce.dime.profile.profile.Profile;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class PostCreateProfileSIB extends DIMEPostCreateHook<ProfileSIB> {
  @Extension
  private Layouter _layouter = Layouter.getInstance();
  
  @Override
  public void postCreate(final ProfileSIB sib) {
    final Procedure1<ProfileSIB> _function = new Procedure1<ProfileSIB>() {
      @Override
      public void apply(final ProfileSIB it) {
        PostCreateProfileSIB.this.cacheNames(it);
        it.newProfileIconButton(0, 0);
        PostCreateProfileSIB.this._layouter.layout(it.getContainer());
      }
    };
    ObjectExtensions.<ProfileSIB>operator_doubleArrow(sib, _function);
  }
  
  public boolean cacheNames(final ProfileSIB sib) {
    Profile _referencedProfile = sib.getReferencedProfile();
    final Profile obj = ((Profile) _referencedProfile);
    String _name = null;
    if (obj!=null) {
      _name=obj.getName();
    }
    this.cacheName(sib, _name);
    return (obj != null);
  }
  
  public void cacheName(final ProfileSIB sib, final String name) {
    if (((!StringExtensions.isNullOrEmpty(name)) && (!Objects.equal(sib.getCachedReferencedProfileName(), name)))) {
      sib.setCachedReferencedProfileName(name);
    }
  }
}
