/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.hooks;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.Highlight;
import de.jabc.cinco.meta.runtime.hook.CincoPostSelectHook;
import info.scce.dime.dad.dad.ProfileIconButton;
import info.scce.dime.dad.dad.ProfileSIB;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ActivateButtonOnClick extends CincoPostSelectHook<ProfileIconButton> {
  @Override
  public void postSelect(final ProfileIconButton button) {
    final Procedure1<ProfileIconButton> _function = new Procedure1<ProfileIconButton>() {
      @Override
      public void apply(final ProfileIconButton it) {
        ActivateButtonOnClick.this.animateClick(it);
        ActivateButtonOnClick.this._workbenchExtension.clearSelection(ActivateButtonOnClick.this._workbenchExtension.getDiagram(it));
        ActivateButtonOnClick.this.onClick(it);
      }
    };
    ObjectExtensions.<ProfileIconButton>operator_doubleArrow(button, _function);
  }
  
  public void onClick(final ProfileIconButton button) {
    ProfileSIB _container = null;
    if (button!=null) {
      _container=button.getContainer();
    }
    final ProfileSIB it = _container;
    boolean _matched = false;
    if (it instanceof ProfileSIB) {
      _matched=true;
      boolean _isActive = it.isActive();
      boolean _not = (!_isActive);
      it.setActive(_not);
    }
  }
  
  public Highlight animateClick(final ProfileIconButton button) {
    Highlight _xblockexpression = null;
    {
      IColorConstant fgColor = IColorConstant.GRAY;
      IColorConstant bgColor = IColorConstant.WHITE;
      ProfileSIB _container = button.getContainer();
      if ((_container instanceof ProfileSIB)) {
        ProfileSIB _container_1 = button.getContainer();
        final ProfileSIB profileSIB = ((ProfileSIB) _container_1);
        IColorConstant _xifexpression = null;
        boolean _isActive = profileSIB.isActive();
        if (_isActive) {
          _xifexpression = IColorConstant.RED;
        } else {
          _xifexpression = IColorConstant.GREEN;
        }
        fgColor = _xifexpression;
        IColorConstant _xifexpression_1 = null;
        boolean _isActive_1 = profileSIB.isActive();
        if (_isActive_1) {
          _xifexpression_1 = IColorConstant.RED;
        } else {
          _xifexpression_1 = IColorConstant.GREEN;
        }
        bgColor = _xifexpression_1;
      }
      _xblockexpression = new Highlight(fgColor, bgColor).add(button).flash(0.5);
    }
    return _xblockexpression;
  }
}
