package info.scce.dime.dad.factory;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.Type;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalModelElementContainer;
import graphmodel.internal.InternalNode;
import graphmodel.internal.InternalType;
import info.scce.dime.dad.adapter.AdvancedSettingsEContentAdapter;
import info.scce.dime.dad.adapter.BlueprintingConfigEContentAdapter;
import info.scce.dime.dad.adapter.DADEContentAdapter;
import info.scce.dime.dad.adapter.DataComponentEContentAdapter;
import info.scce.dime.dad.adapter.ExternalResourceEContentAdapter;
import info.scce.dime.dad.adapter.FindLoginUserComponentEContentAdapter;
import info.scce.dime.dad.adapter.GraphQLComponentEContentAdapter;
import info.scce.dime.dad.adapter.GraphQLDataPointerEContentAdapter;
import info.scce.dime.dad.adapter.LoginComponentEContentAdapter;
import info.scce.dime.dad.adapter.NonProductionServerEContentAdapter;
import info.scce.dime.dad.adapter.ProcessComponentEContentAdapter;
import info.scce.dime.dad.adapter.ProcessEntryPointComponentEContentAdapter;
import info.scce.dime.dad.adapter.ProductionServerEContentAdapter;
import info.scce.dime.dad.adapter.ProfileContainerEContentAdapter;
import info.scce.dime.dad.adapter.ProfileIconButtonEContentAdapter;
import info.scce.dime.dad.adapter.ProfileSIBEContentAdapter;
import info.scce.dime.dad.adapter.PropertyEContentAdapter;
import info.scce.dime.dad.adapter.RootInteractionPointerEContentAdapter;
import info.scce.dime.dad.adapter.ServersEContentAdapter;
import info.scce.dime.dad.adapter.StartEContentAdapter;
import info.scce.dime.dad.adapter.StartupProcessPointerEContentAdapter;
import info.scce.dime.dad.adapter.SystemUserEContentAdapter;
import info.scce.dime.dad.dad.AdvancedSettings;
import info.scce.dime.dad.dad.BlueprintingConfig;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.dad.dad.DadPackage;
import info.scce.dime.dad.dad.DataComponent;
import info.scce.dime.dad.dad.ExternalResource;
import info.scce.dime.dad.dad.FindLoginUserComponent;
import info.scce.dime.dad.dad.GraphQLComponent;
import info.scce.dime.dad.dad.GraphQLDataPointer;
import info.scce.dime.dad.dad.LoginComponent;
import info.scce.dime.dad.dad.NonProductionServer;
import info.scce.dime.dad.dad.ProcessComponent;
import info.scce.dime.dad.dad.ProcessEntryPointComponent;
import info.scce.dime.dad.dad.ProductionServer;
import info.scce.dime.dad.dad.ProfileContainer;
import info.scce.dime.dad.dad.ProfileIconButton;
import info.scce.dime.dad.dad.ProfileSIB;
import info.scce.dime.dad.dad.Property;
import info.scce.dime.dad.dad.RootInteractionPointer;
import info.scce.dime.dad.dad.Servers;
import info.scce.dime.dad.dad.Start;
import info.scce.dime.dad.dad.StartupProcessPointer;
import info.scce.dime.dad.dad.SystemUser;
import info.scce.dime.dad.dad.impl.DadFactoryImpl;
import info.scce.dime.dad.dad.internal.InternalAdvancedSettings;
import info.scce.dime.dad.dad.internal.InternalBlueprintingConfig;
import info.scce.dime.dad.dad.internal.InternalDAD;
import info.scce.dime.dad.dad.internal.InternalDataComponent;
import info.scce.dime.dad.dad.internal.InternalExternalResource;
import info.scce.dime.dad.dad.internal.InternalFactory;
import info.scce.dime.dad.dad.internal.InternalFindLoginUserComponent;
import info.scce.dime.dad.dad.internal.InternalGraphQLComponent;
import info.scce.dime.dad.dad.internal.InternalGraphQLDataPointer;
import info.scce.dime.dad.dad.internal.InternalLoginComponent;
import info.scce.dime.dad.dad.internal.InternalNonProductionServer;
import info.scce.dime.dad.dad.internal.InternalProcessComponent;
import info.scce.dime.dad.dad.internal.InternalProcessEntryPointComponent;
import info.scce.dime.dad.dad.internal.InternalProductionServer;
import info.scce.dime.dad.dad.internal.InternalProfileContainer;
import info.scce.dime.dad.dad.internal.InternalProfileIconButton;
import info.scce.dime.dad.dad.internal.InternalProfileSIB;
import info.scce.dime.dad.dad.internal.InternalProperty;
import info.scce.dime.dad.dad.internal.InternalRootInteractionPointer;
import info.scce.dime.dad.dad.internal.InternalServers;
import info.scce.dime.dad.dad.internal.InternalStart;
import info.scce.dime.dad.dad.internal.InternalStartupProcessPointer;
import info.scce.dime.dad.dad.internal.InternalSystemUser;
import info.scce.dime.dad.hooks.PostCreateProfileSIB;
import info.scce.dime.dad.hooks.PostCreateServer;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class DADFactory extends DadFactoryImpl {
  @Extension
  private final InternalFactory _internalFactory = InternalFactory.eINSTANCE;
  
  public static DADFactory eINSTANCE = DADFactory.init();
  
  @Extension
  private WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
  
  public static DADFactory init() {
    DADFactory _xblockexpression = null;
    {
      try {
        EFactory _eFactory = EPackage.Registry.INSTANCE.getEFactory(DadPackage.eNS_URI);
        final DADFactory fct = ((DADFactory) _eFactory);
        if ((fct != null)) {
          return ((DADFactory) fct);
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception exception = (Exception)_t;
          EcorePlugin.INSTANCE.log(exception);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
      _xblockexpression = new DADFactory();
    }
    return _xblockexpression;
  }
  
  /**
   * This method creates an Property with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Property createProperty(final String ID, final InternalModelElement ime, final boolean hook) {
    Property _createProperty = super.createProperty();
    final Procedure1<Property> _function = new Procedure1<Property>() {
      @Override
      public void apply(final Property it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProperty _createInternalProperty = DADFactory.this._internalFactory.createInternalProperty();
          _elvis = _createInternalProperty;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            PropertyEContentAdapter _propertyEContentAdapter = new PropertyEContentAdapter();
            _eAdapters.add(_propertyEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<Property>operator_doubleArrow(_createProperty, _function);
  }
  
  /**
   * This method creates an Property with the given id. Post create hook won't be triggered.
   */
  public Property createProperty(final String ID) {
    return this.createProperty(ID, null, false);
  }
  
  /**
   * This method creates an Property with the given id. Post create hook won't be triggered.
   */
  public Property createProperty(final InternalModelElement ime) {
    return this.createProperty(EcoreUtil.generateUUID(), ime, false);
  }
  
  @Override
  public Property createProperty() {
    return this.createProperty(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Servers with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Servers createServers(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Servers _createServers = super.createServers();
    final Procedure1<Servers> _function = new Procedure1<Servers>() {
      @Override
      public void apply(final Servers it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalServers _createInternalServers = DADFactory.this._internalFactory.createInternalServers();
          _elvis = _createInternalServers;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ServersEContentAdapter _serversEContentAdapter = new ServersEContentAdapter();
            _eAdapters.add(_serversEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<Servers>operator_doubleArrow(_createServers, _function);
  }
  
  /**
   * This method creates an Servers with the given id. Post create hook won't be triggered.
   */
  public Servers createServers(final String ID) {
    return this.createServers(ID, null, null, false);
  }
  
  /**
   * This method creates an Servers with the given id. Post create hook will be triggered.
   */
  public Servers createServers(final InternalModelElementContainer parent) {
    return this.createServers(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Servers with the given id. Post create hook will be triggered.
   */
  public Servers createServers(final String ID, final InternalModelElementContainer parent) {
    return this.createServers(ID, null, parent, true);
  }
  
  public Servers createServers(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createServers(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Servers with the given id. Post create hook won't be triggered.
   */
  public Servers createServers(final InternalModelElement ime) {
    return this.createServers(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Servers createServers() {
    return this.createServers(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GraphQLComponent with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GraphQLComponent createGraphQLComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GraphQLComponent _createGraphQLComponent = super.createGraphQLComponent();
    final Procedure1<GraphQLComponent> _function = new Procedure1<GraphQLComponent>() {
      @Override
      public void apply(final GraphQLComponent it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGraphQLComponent _createInternalGraphQLComponent = DADFactory.this._internalFactory.createInternalGraphQLComponent();
          _elvis = _createInternalGraphQLComponent;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GraphQLComponentEContentAdapter _graphQLComponentEContentAdapter = new GraphQLComponentEContentAdapter();
            _eAdapters.add(_graphQLComponentEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<GraphQLComponent>operator_doubleArrow(_createGraphQLComponent, _function);
  }
  
  /**
   * This method creates an GraphQLComponent with the given id. Post create hook won't be triggered.
   */
  public GraphQLComponent createGraphQLComponent(final String ID) {
    return this.createGraphQLComponent(ID, null, null, false);
  }
  
  /**
   * This method creates an GraphQLComponent with the given id. Post create hook will be triggered.
   */
  public GraphQLComponent createGraphQLComponent(final InternalModelElementContainer parent) {
    return this.createGraphQLComponent(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GraphQLComponent with the given id. Post create hook will be triggered.
   */
  public GraphQLComponent createGraphQLComponent(final String ID, final InternalModelElementContainer parent) {
    return this.createGraphQLComponent(ID, null, parent, true);
  }
  
  public GraphQLComponent createGraphQLComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGraphQLComponent(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GraphQLComponent with the given id. Post create hook won't be triggered.
   */
  public GraphQLComponent createGraphQLComponent(final InternalModelElement ime) {
    return this.createGraphQLComponent(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GraphQLComponent createGraphQLComponent() {
    return this.createGraphQLComponent(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an LoginComponent with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public LoginComponent createLoginComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    LoginComponent _createLoginComponent = super.createLoginComponent();
    final Procedure1<LoginComponent> _function = new Procedure1<LoginComponent>() {
      @Override
      public void apply(final LoginComponent it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalLoginComponent _createInternalLoginComponent = DADFactory.this._internalFactory.createInternalLoginComponent();
          _elvis = _createInternalLoginComponent;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            LoginComponentEContentAdapter _loginComponentEContentAdapter = new LoginComponentEContentAdapter();
            _eAdapters.add(_loginComponentEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<LoginComponent>operator_doubleArrow(_createLoginComponent, _function);
  }
  
  /**
   * This method creates an LoginComponent with the given id. Post create hook won't be triggered.
   */
  public LoginComponent createLoginComponent(final String ID) {
    return this.createLoginComponent(ID, null, null, false);
  }
  
  /**
   * This method creates an LoginComponent with the given id. Post create hook will be triggered.
   */
  public LoginComponent createLoginComponent(final InternalModelElementContainer parent) {
    return this.createLoginComponent(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an LoginComponent with the given id. Post create hook will be triggered.
   */
  public LoginComponent createLoginComponent(final String ID, final InternalModelElementContainer parent) {
    return this.createLoginComponent(ID, null, parent, true);
  }
  
  public LoginComponent createLoginComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createLoginComponent(ID, ime, parent, true);
  }
  
  /**
   * This method creates an LoginComponent with the given id. Post create hook won't be triggered.
   */
  public LoginComponent createLoginComponent(final InternalModelElement ime) {
    return this.createLoginComponent(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public LoginComponent createLoginComponent() {
    return this.createLoginComponent(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProfileSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProfileSIB createProfileSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProfileSIB _createProfileSIB = super.createProfileSIB();
    final Procedure1<ProfileSIB> _function = new Procedure1<ProfileSIB>() {
      @Override
      public void apply(final ProfileSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProfileSIB _createInternalProfileSIB = DADFactory.this._internalFactory.createInternalProfileSIB();
          _elvis = _createInternalProfileSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProfileSIBEContentAdapter _profileSIBEContentAdapter = new ProfileSIBEContentAdapter();
            _eAdapters.add(_profileSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DADFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ProfileSIB>operator_doubleArrow(_createProfileSIB, _function);
  }
  
  /**
   * This method creates an ProfileSIB with the given id. Post create hook won't be triggered.
   */
  public ProfileSIB createProfileSIB(final String ID) {
    return this.createProfileSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an ProfileSIB with the given id. Post create hook will be triggered.
   */
  public ProfileSIB createProfileSIB(final InternalModelElementContainer parent) {
    return this.createProfileSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProfileSIB with the given id. Post create hook will be triggered.
   */
  public ProfileSIB createProfileSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createProfileSIB(ID, null, parent, true);
  }
  
  public ProfileSIB createProfileSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProfileSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProfileSIB with the given id. Post create hook won't be triggered.
   */
  public ProfileSIB createProfileSIB(final InternalModelElement ime) {
    return this.createProfileSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProfileSIB createProfileSIB() {
    return this.createProfileSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ExternalResource with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ExternalResource createExternalResource(final String ID, final InternalModelElement ime, final boolean hook) {
    ExternalResource _createExternalResource = super.createExternalResource();
    final Procedure1<ExternalResource> _function = new Procedure1<ExternalResource>() {
      @Override
      public void apply(final ExternalResource it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalExternalResource _createInternalExternalResource = DADFactory.this._internalFactory.createInternalExternalResource();
          _elvis = _createInternalExternalResource;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ExternalResourceEContentAdapter _externalResourceEContentAdapter = new ExternalResourceEContentAdapter();
            _eAdapters.add(_externalResourceEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ExternalResource>operator_doubleArrow(_createExternalResource, _function);
  }
  
  /**
   * This method creates an ExternalResource with the given id. Post create hook won't be triggered.
   */
  public ExternalResource createExternalResource(final String ID) {
    return this.createExternalResource(ID, null, false);
  }
  
  /**
   * This method creates an ExternalResource with the given id. Post create hook won't be triggered.
   */
  public ExternalResource createExternalResource(final InternalModelElement ime) {
    return this.createExternalResource(EcoreUtil.generateUUID(), ime, false);
  }
  
  @Override
  public ExternalResource createExternalResource() {
    return this.createExternalResource(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an DataComponent with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public DataComponent createDataComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    DataComponent _createDataComponent = super.createDataComponent();
    final Procedure1<DataComponent> _function = new Procedure1<DataComponent>() {
      @Override
      public void apply(final DataComponent it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalDataComponent _createInternalDataComponent = DADFactory.this._internalFactory.createInternalDataComponent();
          _elvis = _createInternalDataComponent;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            DataComponentEContentAdapter _dataComponentEContentAdapter = new DataComponentEContentAdapter();
            _eAdapters.add(_dataComponentEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<DataComponent>operator_doubleArrow(_createDataComponent, _function);
  }
  
  /**
   * This method creates an DataComponent with the given id. Post create hook won't be triggered.
   */
  public DataComponent createDataComponent(final String ID) {
    return this.createDataComponent(ID, null, null, false);
  }
  
  /**
   * This method creates an DataComponent with the given id. Post create hook will be triggered.
   */
  public DataComponent createDataComponent(final InternalModelElementContainer parent) {
    return this.createDataComponent(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an DataComponent with the given id. Post create hook will be triggered.
   */
  public DataComponent createDataComponent(final String ID, final InternalModelElementContainer parent) {
    return this.createDataComponent(ID, null, parent, true);
  }
  
  public DataComponent createDataComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createDataComponent(ID, ime, parent, true);
  }
  
  /**
   * This method creates an DataComponent with the given id. Post create hook won't be triggered.
   */
  public DataComponent createDataComponent(final InternalModelElement ime) {
    return this.createDataComponent(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public DataComponent createDataComponent() {
    return this.createDataComponent(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an AdvancedSettings with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public AdvancedSettings createAdvancedSettings(final String ID, final InternalModelElement ime, final boolean hook) {
    AdvancedSettings _createAdvancedSettings = super.createAdvancedSettings();
    final Procedure1<AdvancedSettings> _function = new Procedure1<AdvancedSettings>() {
      @Override
      public void apply(final AdvancedSettings it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalAdvancedSettings _createInternalAdvancedSettings = DADFactory.this._internalFactory.createInternalAdvancedSettings();
          _elvis = _createInternalAdvancedSettings;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            AdvancedSettingsEContentAdapter _advancedSettingsEContentAdapter = new AdvancedSettingsEContentAdapter();
            _eAdapters.add(_advancedSettingsEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<AdvancedSettings>operator_doubleArrow(_createAdvancedSettings, _function);
  }
  
  /**
   * This method creates an AdvancedSettings with the given id. Post create hook won't be triggered.
   */
  public AdvancedSettings createAdvancedSettings(final String ID) {
    return this.createAdvancedSettings(ID, null, false);
  }
  
  /**
   * This method creates an AdvancedSettings with the given id. Post create hook won't be triggered.
   */
  public AdvancedSettings createAdvancedSettings(final InternalModelElement ime) {
    return this.createAdvancedSettings(EcoreUtil.generateUUID(), ime, false);
  }
  
  @Override
  public AdvancedSettings createAdvancedSettings() {
    return this.createAdvancedSettings(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Start with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Start createStart(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Start _createStart = super.createStart();
    final Procedure1<Start> _function = new Procedure1<Start>() {
      @Override
      public void apply(final Start it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalStart _createInternalStart = DADFactory.this._internalFactory.createInternalStart();
          _elvis = _createInternalStart;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            StartEContentAdapter _startEContentAdapter = new StartEContentAdapter();
            _eAdapters.add(_startEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<Start>operator_doubleArrow(_createStart, _function);
  }
  
  /**
   * This method creates an Start with the given id. Post create hook won't be triggered.
   */
  public Start createStart(final String ID) {
    return this.createStart(ID, null, null, false);
  }
  
  /**
   * This method creates an Start with the given id. Post create hook will be triggered.
   */
  public Start createStart(final InternalModelElementContainer parent) {
    return this.createStart(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Start with the given id. Post create hook will be triggered.
   */
  public Start createStart(final String ID, final InternalModelElementContainer parent) {
    return this.createStart(ID, null, parent, true);
  }
  
  public Start createStart(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createStart(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Start with the given id. Post create hook won't be triggered.
   */
  public Start createStart(final InternalModelElement ime) {
    return this.createStart(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Start createStart() {
    return this.createStart(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an SystemUser with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public SystemUser createSystemUser(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    SystemUser _createSystemUser = super.createSystemUser();
    final Procedure1<SystemUser> _function = new Procedure1<SystemUser>() {
      @Override
      public void apply(final SystemUser it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalSystemUser _createInternalSystemUser = DADFactory.this._internalFactory.createInternalSystemUser();
          _elvis = _createInternalSystemUser;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            SystemUserEContentAdapter _systemUserEContentAdapter = new SystemUserEContentAdapter();
            _eAdapters.add(_systemUserEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<SystemUser>operator_doubleArrow(_createSystemUser, _function);
  }
  
  /**
   * This method creates an SystemUser with the given id. Post create hook won't be triggered.
   */
  public SystemUser createSystemUser(final String ID) {
    return this.createSystemUser(ID, null, null, false);
  }
  
  /**
   * This method creates an SystemUser with the given id. Post create hook will be triggered.
   */
  public SystemUser createSystemUser(final InternalModelElementContainer parent) {
    return this.createSystemUser(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an SystemUser with the given id. Post create hook will be triggered.
   */
  public SystemUser createSystemUser(final String ID, final InternalModelElementContainer parent) {
    return this.createSystemUser(ID, null, parent, true);
  }
  
  public SystemUser createSystemUser(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createSystemUser(ID, ime, parent, true);
  }
  
  /**
   * This method creates an SystemUser with the given id. Post create hook won't be triggered.
   */
  public SystemUser createSystemUser(final InternalModelElement ime) {
    return this.createSystemUser(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public SystemUser createSystemUser() {
    return this.createSystemUser(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProfileIconButton with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProfileIconButton createProfileIconButton(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProfileIconButton _createProfileIconButton = super.createProfileIconButton();
    final Procedure1<ProfileIconButton> _function = new Procedure1<ProfileIconButton>() {
      @Override
      public void apply(final ProfileIconButton it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProfileIconButton _createInternalProfileIconButton = DADFactory.this._internalFactory.createInternalProfileIconButton();
          _elvis = _createInternalProfileIconButton;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProfileIconButtonEContentAdapter _profileIconButtonEContentAdapter = new ProfileIconButtonEContentAdapter();
            _eAdapters.add(_profileIconButtonEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ProfileIconButton>operator_doubleArrow(_createProfileIconButton, _function);
  }
  
  /**
   * This method creates an ProfileIconButton with the given id. Post create hook won't be triggered.
   */
  public ProfileIconButton createProfileIconButton(final String ID) {
    return this.createProfileIconButton(ID, null, null, false);
  }
  
  /**
   * This method creates an ProfileIconButton with the given id. Post create hook will be triggered.
   */
  public ProfileIconButton createProfileIconButton(final InternalModelElementContainer parent) {
    return this.createProfileIconButton(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProfileIconButton with the given id. Post create hook will be triggered.
   */
  public ProfileIconButton createProfileIconButton(final String ID, final InternalModelElementContainer parent) {
    return this.createProfileIconButton(ID, null, parent, true);
  }
  
  public ProfileIconButton createProfileIconButton(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProfileIconButton(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProfileIconButton with the given id. Post create hook won't be triggered.
   */
  public ProfileIconButton createProfileIconButton(final InternalModelElement ime) {
    return this.createProfileIconButton(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProfileIconButton createProfileIconButton() {
    return this.createProfileIconButton(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProfileContainer with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProfileContainer createProfileContainer(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProfileContainer _createProfileContainer = super.createProfileContainer();
    final Procedure1<ProfileContainer> _function = new Procedure1<ProfileContainer>() {
      @Override
      public void apply(final ProfileContainer it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProfileContainer _createInternalProfileContainer = DADFactory.this._internalFactory.createInternalProfileContainer();
          _elvis = _createInternalProfileContainer;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProfileContainerEContentAdapter _profileContainerEContentAdapter = new ProfileContainerEContentAdapter();
            _eAdapters.add(_profileContainerEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ProfileContainer>operator_doubleArrow(_createProfileContainer, _function);
  }
  
  /**
   * This method creates an ProfileContainer with the given id. Post create hook won't be triggered.
   */
  public ProfileContainer createProfileContainer(final String ID) {
    return this.createProfileContainer(ID, null, null, false);
  }
  
  /**
   * This method creates an ProfileContainer with the given id. Post create hook will be triggered.
   */
  public ProfileContainer createProfileContainer(final InternalModelElementContainer parent) {
    return this.createProfileContainer(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProfileContainer with the given id. Post create hook will be triggered.
   */
  public ProfileContainer createProfileContainer(final String ID, final InternalModelElementContainer parent) {
    return this.createProfileContainer(ID, null, parent, true);
  }
  
  public ProfileContainer createProfileContainer(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProfileContainer(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProfileContainer with the given id. Post create hook won't be triggered.
   */
  public ProfileContainer createProfileContainer(final InternalModelElement ime) {
    return this.createProfileContainer(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProfileContainer createProfileContainer() {
    return this.createProfileContainer(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProductionServer with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProductionServer createProductionServer(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProductionServer _createProductionServer = super.createProductionServer();
    final Procedure1<ProductionServer> _function = new Procedure1<ProductionServer>() {
      @Override
      public void apply(final ProductionServer it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProductionServer _createInternalProductionServer = DADFactory.this._internalFactory.createInternalProductionServer();
          _elvis = _createInternalProductionServer;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProductionServerEContentAdapter _productionServerEContentAdapter = new ProductionServerEContentAdapter();
            _eAdapters.add(_productionServerEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DADFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ProductionServer>operator_doubleArrow(_createProductionServer, _function);
  }
  
  /**
   * This method creates an ProductionServer with the given id. Post create hook won't be triggered.
   */
  public ProductionServer createProductionServer(final String ID) {
    return this.createProductionServer(ID, null, null, false);
  }
  
  /**
   * This method creates an ProductionServer with the given id. Post create hook will be triggered.
   */
  public ProductionServer createProductionServer(final InternalModelElementContainer parent) {
    return this.createProductionServer(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProductionServer with the given id. Post create hook will be triggered.
   */
  public ProductionServer createProductionServer(final String ID, final InternalModelElementContainer parent) {
    return this.createProductionServer(ID, null, parent, true);
  }
  
  public ProductionServer createProductionServer(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProductionServer(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProductionServer with the given id. Post create hook won't be triggered.
   */
  public ProductionServer createProductionServer(final InternalModelElement ime) {
    return this.createProductionServer(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProductionServer createProductionServer() {
    return this.createProductionServer(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProcessEntryPointComponent with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProcessEntryPointComponent createProcessEntryPointComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProcessEntryPointComponent _createProcessEntryPointComponent = super.createProcessEntryPointComponent();
    final Procedure1<ProcessEntryPointComponent> _function = new Procedure1<ProcessEntryPointComponent>() {
      @Override
      public void apply(final ProcessEntryPointComponent it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProcessEntryPointComponent _createInternalProcessEntryPointComponent = DADFactory.this._internalFactory.createInternalProcessEntryPointComponent();
          _elvis = _createInternalProcessEntryPointComponent;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProcessEntryPointComponentEContentAdapter _processEntryPointComponentEContentAdapter = new ProcessEntryPointComponentEContentAdapter();
            _eAdapters.add(_processEntryPointComponentEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ProcessEntryPointComponent>operator_doubleArrow(_createProcessEntryPointComponent, _function);
  }
  
  /**
   * This method creates an ProcessEntryPointComponent with the given id. Post create hook won't be triggered.
   */
  public ProcessEntryPointComponent createProcessEntryPointComponent(final String ID) {
    return this.createProcessEntryPointComponent(ID, null, null, false);
  }
  
  /**
   * This method creates an ProcessEntryPointComponent with the given id. Post create hook will be triggered.
   */
  public ProcessEntryPointComponent createProcessEntryPointComponent(final InternalModelElementContainer parent) {
    return this.createProcessEntryPointComponent(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProcessEntryPointComponent with the given id. Post create hook will be triggered.
   */
  public ProcessEntryPointComponent createProcessEntryPointComponent(final String ID, final InternalModelElementContainer parent) {
    return this.createProcessEntryPointComponent(ID, null, parent, true);
  }
  
  public ProcessEntryPointComponent createProcessEntryPointComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProcessEntryPointComponent(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProcessEntryPointComponent with the given id. Post create hook won't be triggered.
   */
  public ProcessEntryPointComponent createProcessEntryPointComponent(final InternalModelElement ime) {
    return this.createProcessEntryPointComponent(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProcessEntryPointComponent createProcessEntryPointComponent() {
    return this.createProcessEntryPointComponent(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an FindLoginUserComponent with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public FindLoginUserComponent createFindLoginUserComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    FindLoginUserComponent _createFindLoginUserComponent = super.createFindLoginUserComponent();
    final Procedure1<FindLoginUserComponent> _function = new Procedure1<FindLoginUserComponent>() {
      @Override
      public void apply(final FindLoginUserComponent it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalFindLoginUserComponent _createInternalFindLoginUserComponent = DADFactory.this._internalFactory.createInternalFindLoginUserComponent();
          _elvis = _createInternalFindLoginUserComponent;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            FindLoginUserComponentEContentAdapter _findLoginUserComponentEContentAdapter = new FindLoginUserComponentEContentAdapter();
            _eAdapters.add(_findLoginUserComponentEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<FindLoginUserComponent>operator_doubleArrow(_createFindLoginUserComponent, _function);
  }
  
  /**
   * This method creates an FindLoginUserComponent with the given id. Post create hook won't be triggered.
   */
  public FindLoginUserComponent createFindLoginUserComponent(final String ID) {
    return this.createFindLoginUserComponent(ID, null, null, false);
  }
  
  /**
   * This method creates an FindLoginUserComponent with the given id. Post create hook will be triggered.
   */
  public FindLoginUserComponent createFindLoginUserComponent(final InternalModelElementContainer parent) {
    return this.createFindLoginUserComponent(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an FindLoginUserComponent with the given id. Post create hook will be triggered.
   */
  public FindLoginUserComponent createFindLoginUserComponent(final String ID, final InternalModelElementContainer parent) {
    return this.createFindLoginUserComponent(ID, null, parent, true);
  }
  
  public FindLoginUserComponent createFindLoginUserComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createFindLoginUserComponent(ID, ime, parent, true);
  }
  
  /**
   * This method creates an FindLoginUserComponent with the given id. Post create hook won't be triggered.
   */
  public FindLoginUserComponent createFindLoginUserComponent(final InternalModelElement ime) {
    return this.createFindLoginUserComponent(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public FindLoginUserComponent createFindLoginUserComponent() {
    return this.createFindLoginUserComponent(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an NonProductionServer with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public NonProductionServer createNonProductionServer(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    NonProductionServer _createNonProductionServer = super.createNonProductionServer();
    final Procedure1<NonProductionServer> _function = new Procedure1<NonProductionServer>() {
      @Override
      public void apply(final NonProductionServer it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalNonProductionServer _createInternalNonProductionServer = DADFactory.this._internalFactory.createInternalNonProductionServer();
          _elvis = _createInternalNonProductionServer;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            NonProductionServerEContentAdapter _nonProductionServerEContentAdapter = new NonProductionServerEContentAdapter();
            _eAdapters.add(_nonProductionServerEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          DADFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<NonProductionServer>operator_doubleArrow(_createNonProductionServer, _function);
  }
  
  /**
   * This method creates an NonProductionServer with the given id. Post create hook won't be triggered.
   */
  public NonProductionServer createNonProductionServer(final String ID) {
    return this.createNonProductionServer(ID, null, null, false);
  }
  
  /**
   * This method creates an NonProductionServer with the given id. Post create hook will be triggered.
   */
  public NonProductionServer createNonProductionServer(final InternalModelElementContainer parent) {
    return this.createNonProductionServer(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an NonProductionServer with the given id. Post create hook will be triggered.
   */
  public NonProductionServer createNonProductionServer(final String ID, final InternalModelElementContainer parent) {
    return this.createNonProductionServer(ID, null, parent, true);
  }
  
  public NonProductionServer createNonProductionServer(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createNonProductionServer(ID, ime, parent, true);
  }
  
  /**
   * This method creates an NonProductionServer with the given id. Post create hook won't be triggered.
   */
  public NonProductionServer createNonProductionServer(final InternalModelElement ime) {
    return this.createNonProductionServer(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public NonProductionServer createNonProductionServer() {
    return this.createNonProductionServer(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an BlueprintingConfig with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public BlueprintingConfig createBlueprintingConfig(final String ID, final InternalModelElement ime, final boolean hook) {
    BlueprintingConfig _createBlueprintingConfig = super.createBlueprintingConfig();
    final Procedure1<BlueprintingConfig> _function = new Procedure1<BlueprintingConfig>() {
      @Override
      public void apply(final BlueprintingConfig it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBlueprintingConfig _createInternalBlueprintingConfig = DADFactory.this._internalFactory.createInternalBlueprintingConfig();
          _elvis = _createInternalBlueprintingConfig;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            BlueprintingConfigEContentAdapter _blueprintingConfigEContentAdapter = new BlueprintingConfigEContentAdapter();
            _eAdapters.add(_blueprintingConfigEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<BlueprintingConfig>operator_doubleArrow(_createBlueprintingConfig, _function);
  }
  
  /**
   * This method creates an BlueprintingConfig with the given id. Post create hook won't be triggered.
   */
  public BlueprintingConfig createBlueprintingConfig(final String ID) {
    return this.createBlueprintingConfig(ID, null, false);
  }
  
  /**
   * This method creates an BlueprintingConfig with the given id. Post create hook won't be triggered.
   */
  public BlueprintingConfig createBlueprintingConfig(final InternalModelElement ime) {
    return this.createBlueprintingConfig(EcoreUtil.generateUUID(), ime, false);
  }
  
  @Override
  public BlueprintingConfig createBlueprintingConfig() {
    return this.createBlueprintingConfig(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an DAD with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public DAD createDAD(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    DAD _createDAD = super.createDAD();
    final Procedure1<DAD> _function = new Procedure1<DAD>() {
      @Override
      public void apply(final DAD it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalDAD _createInternalDAD = DADFactory.this._internalFactory.createInternalDAD();
          _elvis = _createInternalDAD;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            DADEContentAdapter _dADEContentAdapter = new DADEContentAdapter();
            _eAdapters.add(_dADEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<DAD>operator_doubleArrow(_createDAD, _function);
  }
  
  /**
   * This method creates an DAD with the given id. Post create hook won't be triggered.
   */
  public DAD createDAD(final String ID) {
    return this.createDAD(ID, null, null, false);
  }
  
  /**
   * This method creates an DAD with the given id. Post create hook will be triggered.
   */
  public DAD createDAD(final InternalModelElementContainer parent) {
    return this.createDAD(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an DAD with the given id. Post create hook will be triggered.
   */
  public DAD createDAD(final String ID, final InternalModelElementContainer parent) {
    return this.createDAD(ID, null, parent, true);
  }
  
  public DAD createDAD(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createDAD(ID, ime, parent, true);
  }
  
  /**
   * This method creates an DAD with the given id. Post create hook won't be triggered.
   */
  public DAD createDAD(final InternalModelElement ime) {
    return this.createDAD(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public DAD createDAD() {
    return this.createDAD(EcoreUtil.generateUUID());
  }
  
  public RootInteractionPointer createRootInteractionPointer(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    RootInteractionPointer _createRootInteractionPointer = super.createRootInteractionPointer();
    final Procedure1<RootInteractionPointer> _function = new Procedure1<RootInteractionPointer>() {
      @Override
      public void apply(final RootInteractionPointer it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalRootInteractionPointer _createInternalRootInteractionPointer = DADFactory.this._internalFactory.createInternalRootInteractionPointer();
          _elvis = _createInternalRootInteractionPointer;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            RootInteractionPointerEContentAdapter _rootInteractionPointerEContentAdapter = new RootInteractionPointerEContentAdapter();
            _eAdapters.add(_rootInteractionPointerEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<RootInteractionPointer>operator_doubleArrow(_createRootInteractionPointer, _function);
  }
  
  /**
   * This method creates an RootInteractionPointer with the given id. Post create hook will be triggered.
   */
  public RootInteractionPointer createRootInteractionPointer(final String ID, final InternalNode source, final InternalNode target) {
    return this.createRootInteractionPointer(ID, null, source, target, true);
  }
  
  /**
   * This method creates an RootInteractionPointer with generated id. Post create hook will be triggered.
   */
  public RootInteractionPointer createRootInteractionPointer(final InternalNode source, final InternalNode target) {
    return this.createRootInteractionPointer(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an RootInteractionPointer with the given id. Post create hook won't be triggered.
   */
  public RootInteractionPointer createRootInteractionPointer(final String ID) {
    return this.createRootInteractionPointer(ID, null, null, null, false);
  }
  
  /**
   * This method creates an RootInteractionPointer with a generated id. Post create hook won't be triggered.
   */
  @Override
  public RootInteractionPointer createRootInteractionPointer() {
    return this.createRootInteractionPointer(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProcessComponent with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProcessComponent createProcessComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProcessComponent _createProcessComponent = super.createProcessComponent();
    final Procedure1<ProcessComponent> _function = new Procedure1<ProcessComponent>() {
      @Override
      public void apply(final ProcessComponent it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProcessComponent _createInternalProcessComponent = DADFactory.this._internalFactory.createInternalProcessComponent();
          _elvis = _createInternalProcessComponent;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProcessComponentEContentAdapter _processComponentEContentAdapter = new ProcessComponentEContentAdapter();
            _eAdapters.add(_processComponentEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ProcessComponent>operator_doubleArrow(_createProcessComponent, _function);
  }
  
  /**
   * This method creates an ProcessComponent with the given id. Post create hook won't be triggered.
   */
  public ProcessComponent createProcessComponent(final String ID) {
    return this.createProcessComponent(ID, null, null, false);
  }
  
  /**
   * This method creates an ProcessComponent with the given id. Post create hook will be triggered.
   */
  public ProcessComponent createProcessComponent(final InternalModelElementContainer parent) {
    return this.createProcessComponent(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProcessComponent with the given id. Post create hook will be triggered.
   */
  public ProcessComponent createProcessComponent(final String ID, final InternalModelElementContainer parent) {
    return this.createProcessComponent(ID, null, parent, true);
  }
  
  public ProcessComponent createProcessComponent(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProcessComponent(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProcessComponent with the given id. Post create hook won't be triggered.
   */
  public ProcessComponent createProcessComponent(final InternalModelElement ime) {
    return this.createProcessComponent(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProcessComponent createProcessComponent() {
    return this.createProcessComponent(EcoreUtil.generateUUID());
  }
  
  public GraphQLDataPointer createGraphQLDataPointer(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    GraphQLDataPointer _createGraphQLDataPointer = super.createGraphQLDataPointer();
    final Procedure1<GraphQLDataPointer> _function = new Procedure1<GraphQLDataPointer>() {
      @Override
      public void apply(final GraphQLDataPointer it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGraphQLDataPointer _createInternalGraphQLDataPointer = DADFactory.this._internalFactory.createInternalGraphQLDataPointer();
          _elvis = _createInternalGraphQLDataPointer;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            GraphQLDataPointerEContentAdapter _graphQLDataPointerEContentAdapter = new GraphQLDataPointerEContentAdapter();
            _eAdapters.add(_graphQLDataPointerEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<GraphQLDataPointer>operator_doubleArrow(_createGraphQLDataPointer, _function);
  }
  
  /**
   * This method creates an GraphQLDataPointer with the given id. Post create hook will be triggered.
   */
  public GraphQLDataPointer createGraphQLDataPointer(final String ID, final InternalNode source, final InternalNode target) {
    return this.createGraphQLDataPointer(ID, null, source, target, true);
  }
  
  /**
   * This method creates an GraphQLDataPointer with generated id. Post create hook will be triggered.
   */
  public GraphQLDataPointer createGraphQLDataPointer(final InternalNode source, final InternalNode target) {
    return this.createGraphQLDataPointer(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an GraphQLDataPointer with the given id. Post create hook won't be triggered.
   */
  public GraphQLDataPointer createGraphQLDataPointer(final String ID) {
    return this.createGraphQLDataPointer(ID, null, null, null, false);
  }
  
  /**
   * This method creates an GraphQLDataPointer with a generated id. Post create hook won't be triggered.
   */
  @Override
  public GraphQLDataPointer createGraphQLDataPointer() {
    return this.createGraphQLDataPointer(EcoreUtil.generateUUID());
  }
  
  public StartupProcessPointer createStartupProcessPointer(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    StartupProcessPointer _createStartupProcessPointer = super.createStartupProcessPointer();
    final Procedure1<StartupProcessPointer> _function = new Procedure1<StartupProcessPointer>() {
      @Override
      public void apply(final StartupProcessPointer it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalStartupProcessPointer _createInternalStartupProcessPointer = DADFactory.this._internalFactory.createInternalStartupProcessPointer();
          _elvis = _createInternalStartupProcessPointer;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            StartupProcessPointerEContentAdapter _startupProcessPointerEContentAdapter = new StartupProcessPointerEContentAdapter();
            _eAdapters.add(_startupProcessPointerEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        DADFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<StartupProcessPointer>operator_doubleArrow(_createStartupProcessPointer, _function);
  }
  
  /**
   * This method creates an StartupProcessPointer with the given id. Post create hook will be triggered.
   */
  public StartupProcessPointer createStartupProcessPointer(final String ID, final InternalNode source, final InternalNode target) {
    return this.createStartupProcessPointer(ID, null, source, target, true);
  }
  
  /**
   * This method creates an StartupProcessPointer with generated id. Post create hook will be triggered.
   */
  public StartupProcessPointer createStartupProcessPointer(final InternalNode source, final InternalNode target) {
    return this.createStartupProcessPointer(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an StartupProcessPointer with the given id. Post create hook won't be triggered.
   */
  public StartupProcessPointer createStartupProcessPointer(final String ID) {
    return this.createStartupProcessPointer(ID, null, null, null, false);
  }
  
  /**
   * This method creates an StartupProcessPointer with a generated id. Post create hook won't be triggered.
   */
  @Override
  public StartupProcessPointer createStartupProcessPointer() {
    return this.createStartupProcessPointer(EcoreUtil.generateUUID());
  }
  
  private <T extends IdentifiableElement> T setInternal(final T elm, final InternalIdentifiableElement internal) {
    final Procedure1<T> _function = new Procedure1<T>() {
      @Override
      public void apply(final T it) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getId());
        if (_isNullOrEmpty) {
          EcoreUtil.setID(it, EcoreUtil.generateUUID());
        }
        boolean _matched = false;
        if (elm instanceof GraphModel) {
          _matched=true;
          ((GraphModel)elm).setInternalElement_(((InternalGraphModel) internal));
        }
        if (!_matched) {
          if (elm instanceof ModelElement) {
            _matched=true;
            ((ModelElement)elm).setInternalElement_(((InternalModelElement) internal));
          }
        }
        if (!_matched) {
          if (elm instanceof Type) {
            _matched=true;
            ((Type)elm).setInternalElement_(((InternalType) internal));
          }
        }
      }
    };
    return ObjectExtensions.<T>operator_doubleArrow(elm, _function);
  }
  
  /**
   * This method creates a new DAD object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can
   * simply call the DAD's save method to save your changes.
   */
  public DAD createDAD(final String path, final String fileName) {
    IPath filePath = new Path(path).append(fileName).addFileExtension("dad");
    URI uri = URI.createPlatformResourceURI(filePath.toOSString(), true);
    Resource res = new ResourceSetImpl().createResource(uri);
    DAD graph = DADFactory.eINSTANCE.createDAD();
    EcoreUtil.setID(graph, EcoreUtil.generateUUID());
    res.getContents().add(graph.getInternalElement_());
    try {
      res.save(null);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return graph;
  }
  
  public void postCreates(final ProfileSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PostCreateProfileSIB().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ProductionServer me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PostCreateServer().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final NonProductionServer me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PostCreateServer().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
}
