/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.checks;

import com.google.common.collect.Iterables;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.api.DIMEGraphModelExtension;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.dad.dad.ProfileSIB;
import info.scce.dime.dad.mcam.modules.checks.DADCheck;
import info.scce.dime.profile.api.ProfileExtension;
import info.scce.dime.profile.profile.BlueprintSIB;
import info.scce.dime.profile.profile.Profile;
import info.scce.dime.profile.profile.ReplacementSIB;
import info.scce.dime.profile.util.ReplacementStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class ProfileSIBCheck extends DADCheck {
  @Extension
  private DIMEGraphModelExtension _dIMEGraphModelExtension = new DIMEGraphModelExtension();
  
  @Extension
  private ProfileExtension _profileExtension = new ProfileExtension();
  
  @Extension
  private ReplacementStrategy _replacementStrategy = new ReplacementStrategy();
  
  private final Function1<IdentifiableElement, ModelElementContainer> followPrimeRefs = new Function1<IdentifiableElement, ModelElementContainer>() {
    @Override
    public ModelElementContainer apply(final IdentifiableElement elm) {
      return ProfileSIBCheck.this._dIMEGraphModelExtension.getPrimeReferencedContainer(elm);
    }
  };
  
  @Override
  public void check(final DAD it) {
    final Consumer<ProfileSIB> _function = new Consumer<ProfileSIB>() {
      @Override
      public void accept(final ProfileSIB it) {
        ProfileSIBCheck.this.checkIntegrity(it);
      }
    };
    this._dIMEGraphModelExtension.<ProfileSIB>find(it, ProfileSIB.class).forEach(_function);
    this.checkProfileUniqueness(it);
    this.checkProfileReachability(it);
    this.checkProfileConflicts(it);
  }
  
  public void checkIntegrity(final ProfileSIB it) {
    Profile _referencedProfile = it.getReferencedProfile();
    boolean _tripleEquals = (_referencedProfile == null);
    if (_tripleEquals) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Referenced profile \'");
      String _cachedReferencedProfileName = it.getCachedReferencedProfileName();
      _builder.append(_cachedReferencedProfileName);
      _builder.append("\' does not exist");
      this.addError(it, _builder.toString());
      return;
    }
  }
  
  public void checkProfileUniqueness(final DAD it) {
    final Function1<ProfileSIB, Boolean> _function = new Function1<ProfileSIB, Boolean>() {
      @Override
      public Boolean apply(final ProfileSIB it) {
        Profile _referencedProfile = it.getReferencedProfile();
        return Boolean.valueOf((_referencedProfile != null));
      }
    };
    final Function1<ProfileSIB, Profile> _function_1 = new Function1<ProfileSIB, Profile>() {
      @Override
      public Profile apply(final ProfileSIB it) {
        return it.getReferencedProfile();
      }
    };
    final Function1<List<ProfileSIB>, Boolean> _function_2 = new Function1<List<ProfileSIB>, Boolean>() {
      @Override
      public Boolean apply(final List<ProfileSIB> it) {
        int _size = it.size();
        return Boolean.valueOf((_size <= 1));
      }
    };
    final Consumer<List<ProfileSIB>> _function_3 = new Consumer<List<ProfileSIB>>() {
      @Override
      public void accept(final List<ProfileSIB> duplicates) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("These Profile SIBs reference the same Profile: ");
        final Function1<ProfileSIB, String> _function = new Function1<ProfileSIB, String>() {
          @Override
          public String apply(final ProfileSIB it) {
            return it.getCachedReferencedProfileName();
          }
        };
        String _join = IterableExtensions.join(ListExtensions.<ProfileSIB, String>map(duplicates, _function), ", ");
        _builder.append(_join);
        ProfileSIBCheck.this.addError(it, _builder.toString());
      }
    };
    this._collectionExtension.<List<ProfileSIB>>drop(IterableExtensions.<Profile, ProfileSIB>groupBy(IterableExtensions.<ProfileSIB>filter(this._dIMEGraphModelExtension.<ProfileSIB>find(it, ProfileSIB.class), _function), _function_1).values(), _function_2).forEach(_function_3);
  }
  
  public void checkProfileReachability(final DAD dad) {
    final Set<GraphModel> usedModels = IterableExtensions.<GraphModel>toSet(this._dIMEGraphModelExtension.<GraphModel>findDeeply(dad, GraphModel.class, this.followPrimeRefs));
    final Function1<ProfileSIB, Boolean> _function = new Function1<ProfileSIB, Boolean>() {
      @Override
      public Boolean apply(final ProfileSIB it) {
        return Boolean.valueOf(it.isActive());
      }
    };
    final Function1<ProfileSIB, Boolean> _function_1 = new Function1<ProfileSIB, Boolean>() {
      @Override
      public Boolean apply(final ProfileSIB it) {
        Profile _referencedProfile = it.getReferencedProfile();
        return Boolean.valueOf((_referencedProfile != null));
      }
    };
    final Function1<ProfileSIB, Profile> _function_2 = new Function1<ProfileSIB, Profile>() {
      @Override
      public Profile apply(final ProfileSIB it) {
        return it.getReferencedProfile();
      }
    };
    final Function1<Profile, Iterable<ReplacementSIB>> _function_3 = new Function1<Profile, Iterable<ReplacementSIB>>() {
      @Override
      public Iterable<ReplacementSIB> apply(final Profile it) {
        return ProfileSIBCheck.this._dIMEGraphModelExtension.<ReplacementSIB>find(it, ReplacementSIB.class);
      }
    };
    final Function1<ReplacementSIB, Boolean> _function_4 = new Function1<ReplacementSIB, Boolean>() {
      @Override
      public Boolean apply(final ReplacementSIB it) {
        return Boolean.valueOf(ProfileSIBCheck.this._replacementStrategy.isInferredReplacement(it));
      }
    };
    final Function1<ReplacementSIB, ModelElementContainer> _function_5 = new Function1<ReplacementSIB, ModelElementContainer>() {
      @Override
      public ModelElementContainer apply(final ReplacementSIB it) {
        return ProfileSIBCheck.this._profileExtension.getReferencedObject(it);
      }
    };
    final Function1<ModelElementContainer, Iterable<GraphModel>> _function_6 = new Function1<ModelElementContainer, Iterable<GraphModel>>() {
      @Override
      public Iterable<GraphModel> apply(final ModelElementContainer it) {
        return ProfileSIBCheck.this._dIMEGraphModelExtension.<GraphModel>findDeeply(it, GraphModel.class, ProfileSIBCheck.this.followPrimeRefs);
      }
    };
    final Iterable<GraphModel> replModels = IterableExtensions.<ModelElementContainer, GraphModel>flatMap(IterableExtensions.<ReplacementSIB, ModelElementContainer>map(IterableExtensions.<ReplacementSIB>filter(IterableExtensions.<Profile, ReplacementSIB>flatMap(IterableExtensions.<ProfileSIB, Profile>map(IterableExtensions.<ProfileSIB>filter(IterableExtensions.<ProfileSIB>filter(this._dIMEGraphModelExtension.<ProfileSIB>find(dad, ProfileSIB.class), _function), _function_1), _function_2), _function_3), _function_4), _function_5), _function_6);
    Iterables.<GraphModel>addAll(usedModels, replModels);
    final Function1<ProfileSIB, Boolean> _function_7 = new Function1<ProfileSIB, Boolean>() {
      @Override
      public Boolean apply(final ProfileSIB it) {
        return Boolean.valueOf(it.isActive());
      }
    };
    final Function1<ProfileSIB, Boolean> _function_8 = new Function1<ProfileSIB, Boolean>() {
      @Override
      public Boolean apply(final ProfileSIB it) {
        Profile _referencedProfile = it.getReferencedProfile();
        return Boolean.valueOf((_referencedProfile != null));
      }
    };
    final Consumer<ProfileSIB> _function_9 = new Consumer<ProfileSIB>() {
      @Override
      public void accept(final ProfileSIB profileSIB) {
        final Profile profile = profileSIB.getReferencedProfile();
        final Function1<BlueprintSIB, ModelElementContainer> _function = new Function1<BlueprintSIB, ModelElementContainer>() {
          @Override
          public ModelElementContainer apply(final BlueprintSIB it) {
            return ProfileSIBCheck.this._profileExtension.getReferencedObject(it);
          }
        };
        final Function1<Node, GraphModel> _function_1 = new Function1<Node, GraphModel>() {
          @Override
          public GraphModel apply(final Node it) {
            return it.getRootElement();
          }
        };
        final Function1<info.scce.dime.process.process.Process, Boolean> _function_2 = new Function1<info.scce.dime.process.process.Process, Boolean>() {
          @Override
          public Boolean apply(final info.scce.dime.process.process.Process it) {
            boolean _contains = usedModels.contains(it);
            return Boolean.valueOf((!_contains));
          }
        };
        final Iterable<info.scce.dime.process.process.Process> notUsed = IterableExtensions.<info.scce.dime.process.process.Process>filter(Iterables.<info.scce.dime.process.process.Process>filter(IterableExtensions.<Node, GraphModel>map(Iterables.<Node>filter(ListExtensions.<BlueprintSIB, ModelElementContainer>map(profile.getBlueprintSIBs(), _function), Node.class), _function_1), info.scce.dime.process.process.Process.class), _function_2);
        boolean _isEmpty = IterableExtensions.isEmpty(notUsed);
        boolean _not = (!_isEmpty);
        if (_not) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("The referenced profile contains replacements for models that are not used: ");
          final Function1<info.scce.dime.process.process.Process, String> _function_3 = new Function1<info.scce.dime.process.process.Process, String>() {
            @Override
            public String apply(final info.scce.dime.process.process.Process it) {
              return it.getModelName();
            }
          };
          String _join = IterableExtensions.join(IterableExtensions.<info.scce.dime.process.process.Process, String>map(notUsed, _function_3), ", ");
          _builder.append(_join);
          ProfileSIBCheck.this.addError(profileSIB, _builder.toString());
        }
      }
    };
    IterableExtensions.<ProfileSIB>filter(IterableExtensions.<ProfileSIB>filter(this._dIMEGraphModelExtension.<ProfileSIB>find(dad, ProfileSIB.class), _function_7), _function_8).forEach(_function_9);
  }
  
  public void checkProfileConflicts(final DAD it) {
    final Function1<ProfileSIB, Boolean> _function = new Function1<ProfileSIB, Boolean>() {
      @Override
      public Boolean apply(final ProfileSIB it) {
        Profile _referencedProfile = it.getReferencedProfile();
        return Boolean.valueOf((_referencedProfile != null));
      }
    };
    final Function1<ProfileSIB, Boolean> _function_1 = new Function1<ProfileSIB, Boolean>() {
      @Override
      public Boolean apply(final ProfileSIB it) {
        return Boolean.valueOf(it.isActive());
      }
    };
    final Set<ProfileSIB> activeProfileSIBs = IterableExtensions.<ProfileSIB>toSet(IterableExtensions.<ProfileSIB>filter(IterableExtensions.<ProfileSIB>filter(this._dIMEGraphModelExtension.<ProfileSIB>find(it, ProfileSIB.class), _function), _function_1));
    final Function1<ProfileSIB, Set<ProfileSIB>> _function_2 = new Function1<ProfileSIB, Set<ProfileSIB>>() {
      @Override
      public Set<ProfileSIB> apply(final ProfileSIB sib) {
        final Function1<ProfileSIB, Boolean> _function = new Function1<ProfileSIB, Boolean>() {
          @Override
          public Boolean apply(final ProfileSIB it) {
            return Boolean.valueOf(ProfileSIBCheck.this._dIMEGraphModelExtension.operator_notEquals(it, sib));
          }
        };
        Iterable<ProfileSIB> _conlictedProfileSIBs = ProfileSIBCheck.this.getConlictedProfileSIBs(sib, IterableExtensions.<ProfileSIB>filter(activeProfileSIBs, _function));
        return IterableExtensions.<ProfileSIB>toSet(Iterables.<ProfileSIB>concat(Collections.<ProfileSIB>unmodifiableList(CollectionLiterals.<ProfileSIB>newArrayList(sib)), _conlictedProfileSIBs));
      }
    };
    final Function1<Set<ProfileSIB>, Boolean> _function_3 = new Function1<Set<ProfileSIB>, Boolean>() {
      @Override
      public Boolean apply(final Set<ProfileSIB> it) {
        int _size = it.size();
        return Boolean.valueOf((_size <= 1));
      }
    };
    final Consumer<Set<ProfileSIB>> _function_4 = new Consumer<Set<ProfileSIB>>() {
      @Override
      public void accept(final Set<ProfileSIB> conflicted) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("These Profiles contain replacement rules for the same Blueprint SIBs: ");
        final Function1<ProfileSIB, String> _function = new Function1<ProfileSIB, String>() {
          @Override
          public String apply(final ProfileSIB it) {
            return it.getCachedReferencedProfileName();
          }
        };
        String _join = IterableExtensions.join(IterableExtensions.<ProfileSIB, String>map(conflicted, _function), ", ");
        _builder.append(_join);
        ProfileSIBCheck.this.addError(it, _builder.toString());
      }
    };
    IterableExtensions.<Set<ProfileSIB>>toSet(this._collectionExtension.<Set<ProfileSIB>>drop(IterableExtensions.<ProfileSIB, Set<ProfileSIB>>map(activeProfileSIBs, _function_2), _function_3)).forEach(_function_4);
  }
  
  public Iterable<ProfileSIB> getConlictedProfileSIBs(final ProfileSIB sib, final Iterable<ProfileSIB> otherSIBs) {
    final Function1<ProfileSIB, Boolean> _function = new Function1<ProfileSIB, Boolean>() {
      @Override
      public Boolean apply(final ProfileSIB it) {
        return Boolean.valueOf(ProfileSIBCheck.this.isConflictedWith(it.getReferencedProfile(), sib.getReferencedProfile()));
      }
    };
    return IterableExtensions.<ProfileSIB>filter(otherSIBs, _function);
  }
  
  public Iterable<Profile> getConlictedProfiles(final Profile profile, final Iterable<Profile> profiles) {
    final Function1<Profile, Boolean> _function = new Function1<Profile, Boolean>() {
      @Override
      public Boolean apply(final Profile it) {
        return Boolean.valueOf(ProfileSIBCheck.this.isConflictedWith(it, profile));
      }
    };
    return IterableExtensions.<Profile>filter(profiles, _function);
  }
  
  public boolean isConflictedWith(final Profile profile, final Profile other) {
    boolean _disjoint = Collections.disjoint(this.getReferencedBlueprintSIBs(profile), this.getReferencedBlueprintSIBs(other));
    return (!_disjoint);
  }
  
  public Set<ModelElementContainer> getReferencedBlueprintSIBs(final Profile profile) {
    final Function1<BlueprintSIB, ModelElementContainer> _function = new Function1<BlueprintSIB, ModelElementContainer>() {
      @Override
      public ModelElementContainer apply(final BlueprintSIB it) {
        return ProfileSIBCheck.this._profileExtension.getReferencedObject(it);
      }
    };
    return IterableExtensions.<ModelElementContainer>toSet(IterableExtensions.<ModelElementContainer>filterNull(ListExtensions.<BlueprintSIB, ModelElementContainer>map(profile.getBlueprintSIBs(), _function)));
  }
}
