/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.checks;

import com.google.common.collect.Iterables;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.dad.dad.GraphQLDataPointer;
import info.scce.dime.dad.mcam.modules.checks.DADCheck;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.Type;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * If GraphQL is enabled, verify that property names of data types are not reserved
 * keywords for auto generated properties of the GraphQL API.
 */
@SuppressWarnings("all")
public class ForbiddenDataAttributeNamesCheck extends DADCheck {
  private static final ArrayList<String> forbiddenAttributeNames = CollectionLiterals.<String>newArrayList("dywaId", "dywaType", "__typename");
  
  @Override
  public void check(final DAD model) {
    boolean _isEmpty = model.getGraphQLComponents().isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      final Function1<GraphQLDataPointer, EList<Type>> _function = new Function1<GraphQLDataPointer, EList<Type>>() {
        @Override
        public EList<Type> apply(final GraphQLDataPointer it) {
          return it.getTargetElement().getInternalDataComponent().getModel().getTypes();
        }
      };
      final Consumer<Type> _function_1 = new Consumer<Type>() {
        @Override
        public void accept(final Type type) {
          final Function1<Attribute, Boolean> _function = new Function1<Attribute, Boolean>() {
            @Override
            public Boolean apply(final Attribute it) {
              return Boolean.valueOf(ForbiddenDataAttributeNamesCheck.forbiddenAttributeNames.contains(it));
            }
          };
          final Consumer<Attribute> _function_1 = new Consumer<Attribute>() {
            @Override
            public void accept(final Attribute attr) {
              StringConcatenation _builder = new StringConcatenation();
              String _name = type.getName();
              _builder.append(_name);
              _builder.append(" cannot have attribute with name \"");
              String _name_1 = attr.getName();
              _builder.append(_name_1);
              _builder.append("\"");
              ForbiddenDataAttributeNamesCheck.this.addError(type, _builder.toString());
            }
          };
          IterableExtensions.<Attribute>filter(type.getAttributes(), _function).forEach(_function_1);
        }
      };
      Iterables.<Type>concat(ListExtensions.<GraphQLDataPointer, EList<Type>>map(model.getGraphQLComponents().get(0).getOutgoingGraphQLDataPointers(), _function)).forEach(_function_1);
    }
  }
}
