/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.checks;

import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.Node;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.dad.dad.DataComponent;
import info.scce.dime.dad.mcam.modules.checks.DADCheck;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.ReferencedEnumType;
import info.scce.dime.data.data.ReferencedType;
import info.scce.dime.data.data.ReferencedUserType;
import info.scce.dime.data.data.Type;
import info.scce.dime.util.DataID;
import java.util.HashMap;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class DataIDsCheck extends DADCheck {
  private DAD dad;
  
  @Override
  public void check(final DAD model) {
    this.dad = model;
    final Function1<DataComponent, Data> _function = new Function1<DataComponent, Data>() {
      @Override
      public Data apply(final DataComponent it) {
        return it.getModel();
      }
    };
    final Iterable<Data> dataModels = IterableExtensions.<DataComponent, Data>map(this._graphModelExtension.<DataComponent>find(model, DataComponent.class), _function);
    final Function1<Data, Iterable<Type>> _function_1 = new Function1<Data, Iterable<Type>>() {
      @Override
      public Iterable<Type> apply(final Data it) {
        return DataIDsCheck.this._collectionExtension.<Type>drop(DataIDsCheck.this._collectionExtension.<Type>drop(DataIDsCheck.this._collectionExtension.<Type>drop(DataIDsCheck.this._graphModelExtension.<Type>find(it, Type.class), ReferencedType.class), ReferencedUserType.class), ReferencedEnumType.class);
      }
    };
    final Iterable<Type> types = IterableExtensions.<Data, Type>flatMap(dataModels, _function_1);
    this.validateDataIds(types);
    final Function1<Data, Iterable<Attribute>> _function_2 = new Function1<Data, Iterable<Attribute>>() {
      @Override
      public Iterable<Attribute> apply(final Data it) {
        final Function1<Attribute, Boolean> _function = new Function1<Attribute, Boolean>() {
          @Override
          public Boolean apply(final Attribute it) {
            return Boolean.valueOf(IterableExtensions.isEmpty(DataIDsCheck.this._graphModelExtension.<ReferencedType>findParents(it, ReferencedType.class)));
          }
        };
        final Function1<Attribute, Boolean> _function_1 = new Function1<Attribute, Boolean>() {
          @Override
          public Boolean apply(final Attribute it) {
            return Boolean.valueOf(IterableExtensions.isEmpty(DataIDsCheck.this._graphModelExtension.<ReferencedUserType>findParents(it, ReferencedUserType.class)));
          }
        };
        final Function1<Attribute, Boolean> _function_2 = new Function1<Attribute, Boolean>() {
          @Override
          public Boolean apply(final Attribute it) {
            return Boolean.valueOf(IterableExtensions.isEmpty(DataIDsCheck.this._graphModelExtension.<ReferencedEnumType>findParents(it, ReferencedEnumType.class)));
          }
        };
        return IterableExtensions.<Attribute>filter(IterableExtensions.<Attribute>filter(IterableExtensions.<Attribute>filter(DataIDsCheck.this._graphModelExtension.<Attribute>find(it, Attribute.class), _function), _function_1), _function_2);
      }
    };
    final Iterable<Attribute> attrs = IterableExtensions.<Data, Attribute>flatMap(dataModels, _function_2);
    this.validateDataIds(attrs);
  }
  
  public void validateDataIds(final Iterable<? extends Node> nodes) {
    final HashMap<String, Node> id16_on_node = CollectionLiterals.<String, Node>newHashMap();
    for (final Node node : nodes) {
      {
        final DataID dataId = DataID.from(node);
        final String id16 = dataId.escapedLowerCase16();
        boolean _containsKey = id16_on_node.containsKey(id16);
        boolean _not = (!_containsKey);
        if (_not) {
          id16_on_node.put(id16, node);
        } else {
          final Node other = id16_on_node.get(id16);
          final Function1<DataComponent, Boolean> _function = new Function1<DataComponent, Boolean>() {
            @Override
            public Boolean apply(final DataComponent it) {
              Data _model = it.getModel();
              GraphModel _rootElement = node.getRootElement();
              return Boolean.valueOf(DataIDsCheck.this._graphModelExtension.operator_equals(_model, _rootElement));
            }
          };
          DataComponent _findFirst = IterableExtensions.<DataComponent>findFirst(this._graphModelExtension.<DataComponent>find(this.dad, DataComponent.class), _function);
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("ID ");
          String _id = node.getId();
          _builder.append(_id);
          _builder.append(" of ");
          String _displayName = this.displayName(node);
          _builder.append(_displayName);
          _builder.append(" conflicts with ID ");
          String _id_1 = other.getId();
          _builder.append(_id_1);
          _builder.append(" of ");
          String _displayName_1 = this.displayName(other);
          _builder.append(_displayName_1);
          _builder.append(" (both map on 16 chars ");
          _builder.append(id16);
          _builder.append(")");
          this.addError(_findFirst, _builder.toString());
        }
      }
    }
  }
  
  public String displayName(final IdentifiableElement elm) {
    String _switchResult = null;
    boolean _matched = false;
    if (elm instanceof Data) {
      _matched=true;
      String _modelName = ((Data)elm).getModelName();
      String _plus = ("Model \'" + _modelName);
      _switchResult = (_plus + "\'");
    }
    if (!_matched) {
      if (elm instanceof Type) {
        _matched=true;
        String _name = ((Type)elm).getName();
        String _plus = ("Type \'" + _name);
        String _plus_1 = (_plus + "\' in ");
        String _displayName = this.displayName(((Type)elm).getRootElement());
        _switchResult = (_plus_1 + _displayName);
      }
    }
    if (!_matched) {
      if (elm instanceof Attribute) {
        _matched=true;
        String _name = ((Attribute)elm).getName();
        String _plus = ("Attribute \'" + _name);
        String _plus_1 = (_plus + "\' of ");
        String _displayName = this.displayName(this._graphModelExtension.<Type>findFirstParent(((ModelElement)elm), Type.class));
        _switchResult = (_plus_1 + _displayName);
      }
    }
    if (!_matched) {
      _switchResult = elm.getClass().getSimpleName();
    }
    return _switchResult;
  }
}
