/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.appearance;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.appearance.StyleAppearanceProvider;
import info.scce.dime.dad.dad.ProfileSIB;
import info.scce.dime.profile.profile.Profile;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import style.Appearance;
import style.Color;
import style.LineStyle;
import style.StyleFactory;

@SuppressWarnings("all")
public class ProfileAppearance implements StyleAppearanceProvider<ProfileSIB> {
  private static final StyleFactory factory = StyleFactory.eINSTANCE;
  
  private static final Appearance black = ObjectExtensions.<Appearance>operator_doubleArrow(ProfileAppearance.factory.createAppearance(), new Procedure1<Appearance>() {
    @Override
    public void apply(final Appearance it) {
      Color _createColor = ProfileAppearance.factory.createColor();
      final Procedure1<Color> _function = new Procedure1<Color>() {
        @Override
        public void apply(final Color it) {
          it.setR(0);
          it.setG(0);
          it.setB(0);
        }
      };
      Color _doubleArrow = ObjectExtensions.<Color>operator_doubleArrow(_createColor, _function);
      it.setForeground(_doubleArrow);
    }
  });
  
  private static final Appearance darkGray = ObjectExtensions.<Appearance>operator_doubleArrow(ProfileAppearance.factory.createAppearance(), new Procedure1<Appearance>() {
    @Override
    public void apply(final Appearance it) {
      Color _createColor = ProfileAppearance.factory.createColor();
      final Procedure1<Color> _function = new Procedure1<Color>() {
        @Override
        public void apply(final Color it) {
          it.setR(80);
          it.setG(80);
          it.setB(80);
        }
      };
      Color _doubleArrow = ObjectExtensions.<Color>operator_doubleArrow(_createColor, _function);
      it.setForeground(_doubleArrow);
    }
  });
  
  private static final Appearance lightGray = ObjectExtensions.<Appearance>operator_doubleArrow(ProfileAppearance.factory.createAppearance(), new Procedure1<Appearance>() {
    @Override
    public void apply(final Appearance it) {
      Color _createColor = ProfileAppearance.factory.createColor();
      final Procedure1<Color> _function = new Procedure1<Color>() {
        @Override
        public void apply(final Color it) {
          it.setR(180);
          it.setG(180);
          it.setB(180);
        }
      };
      Color _doubleArrow = ObjectExtensions.<Color>operator_doubleArrow(_createColor, _function);
      it.setForeground(_doubleArrow);
    }
  });
  
  private static final Appearance invalid = ObjectExtensions.<Appearance>operator_doubleArrow(ProfileAppearance.factory.createAppearance(), new Procedure1<Appearance>() {
    @Override
    public void apply(final Appearance it) {
      Color _createColor = ProfileAppearance.factory.createColor();
      final Procedure1<Color> _function = new Procedure1<Color>() {
        @Override
        public void apply(final Color it) {
          it.setR(255);
        }
      };
      Color _doubleArrow = ObjectExtensions.<Color>operator_doubleArrow(_createColor, _function);
      it.setForeground(_doubleArrow);
      it.setLineStyle(LineStyle.DASH);
    }
  });
  
  @Override
  public Appearance getAppearance(final ProfileSIB sib, final String shapeId) {
    boolean _equals = Objects.equal(shapeId, "rootShape");
    if (_equals) {
      Profile _referencedProfile = sib.getReferencedProfile();
      boolean _tripleEquals = (_referencedProfile == null);
      if (_tripleEquals) {
        return ProfileAppearance.invalid;
      }
      Appearance _xifexpression = null;
      boolean _isActive = sib.isActive();
      if (_isActive) {
        _xifexpression = ProfileAppearance.black;
      } else {
        _xifexpression = ProfileAppearance.darkGray;
      }
      return _xifexpression;
    } else {
      boolean _equals_1 = Objects.equal(shapeId, "label");
      if (_equals_1) {
        Appearance _xifexpression_1 = null;
        boolean _isActive_1 = sib.isActive();
        if (_isActive_1) {
          _xifexpression_1 = ProfileAppearance.black;
        } else {
          _xifexpression_1 = ProfileAppearance.lightGray;
        }
        return _xifexpression_1;
      }
    }
    return null;
  }
}
