/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.appearance;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.appearance.StyleAppearanceProvider;
import info.scce.dime.dad.dad.ProfileIconButton;
import info.scce.dime.dad.dad.ProfileSIB;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import style.Appearance;
import style.StyleFactory;

@SuppressWarnings("all")
public class ActivateButtonAppearance implements StyleAppearanceProvider<ProfileIconButton> {
  private static final StyleFactory factory = StyleFactory.eINSTANCE;
  
  private static final Appearance transparent = ObjectExtensions.<Appearance>operator_doubleArrow(ActivateButtonAppearance.factory.createAppearance(), new Procedure1<Appearance>() {
    @Override
    public void apply(final Appearance it) {
      it.setTransparency(1.0);
    }
  });
  
  private static final Appearance visible = ObjectExtensions.<Appearance>operator_doubleArrow(ActivateButtonAppearance.factory.createAppearance(), new Procedure1<Appearance>() {
    @Override
    public void apply(final Appearance it) {
      it.setTransparency(0.0);
    }
  });
  
  @Override
  public Appearance getAppearance(final ProfileIconButton button, final String shapeId) {
    ProfileSIB _container = button.getContainer();
    if ((_container instanceof ProfileSIB)) {
      ProfileSIB _container_1 = button.getContainer();
      final ProfileSIB profileSIB = ((ProfileSIB) _container_1);
      boolean _equals = Objects.equal(shapeId, "imageActive");
      if (_equals) {
        Appearance _xifexpression = null;
        boolean _isActive = profileSIB.isActive();
        if (_isActive) {
          _xifexpression = ActivateButtonAppearance.visible;
        } else {
          _xifexpression = ActivateButtonAppearance.transparent;
        }
        return _xifexpression;
      }
      boolean _equals_1 = Objects.equal(shapeId, "imageInactive");
      if (_equals_1) {
        Appearance _xifexpression_1 = null;
        boolean _isActive_1 = profileSIB.isActive();
        if (_isActive_1) {
          _xifexpression_1 = ActivateButtonAppearance.transparent;
        } else {
          _xifexpression_1 = ActivateButtonAppearance.visible;
        }
        return _xifexpression_1;
      }
    }
    return null;
  }
}
