/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.actions;

import graphmodel.Node;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.dad.dad.ProfileSIB;
import info.scce.dime.profile.profile.Profile;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class OpenModel extends DIMECustomAction<Node> {
  @Override
  public void execute(final Node it) {
    String _name = it.eClass().getName();
    String _plus = ("Opening submodel for " + _name);
    InputOutput.<String>println(_plus);
    Profile _switchResult = null;
    boolean _matched = false;
    if (it instanceof ProfileSIB) {
      _matched=true;
      _switchResult = ((ProfileSIB)it).getReferencedProfile();
    }
    if (_switchResult!=null) {
      Profile _switchResult_1 = null;
      boolean _matched_1 = false;
      if (it instanceof ProfileSIB) {
        _matched_1=true;
        _switchResult_1 = ((ProfileSIB)it).getReferencedProfile();
      }
      this._workbenchExtension.openEditor(_switchResult);
    }
  }
  
  @Override
  public boolean hasDoneChanges() {
    return false;
  }
}
