/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.dad.actions;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import graphmodel.IdentifiableElement;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.dad.dad.DataComponent;
import info.scce.dime.dad.dad.ProcessComponent;
import info.scce.dime.dad.dad.RootInteractionPointer;
import info.scce.dime.dad.dad.Start;
import info.scce.dime.dad.dad.StartupProcessPointer;
import info.scce.dime.dad.dad.SystemUser;
import info.scce.dime.data.data.Data;
import info.scce.dime.gui.gui.GUI;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class GenerateMarkdownDocumentation<T extends DAD> extends DIMECustomAction<T> {
  @Override
  public String getName() {
    return "Create Documentation";
  }
  
  @Override
  public boolean canExecute(final DAD d) {
    return true;
  }
  
  @Override
  public boolean hasDoneChanges() {
    return false;
  }
  
  @Override
  public void execute(final DAD d) {
    try {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("../documentation/");
      String _appName = d.getAppName();
      _builder.append(_appName);
      _builder.append(".md");
      final String filePath = this._workspaceExtension.getFile(d).getProject().getLocation().append(_builder.toString()).toString();
      this.createFile(this.createDoc(d).toString(), filePath);
      final Function1<DataComponent, Data> _function = new Function1<DataComponent, Data>() {
        @Override
        public Data apply(final DataComponent it) {
          return it.getModel();
        }
      };
      final Consumer<Data> _function_1 = new Consumer<Data>() {
        @Override
        public void accept(final Data it) {
          new info.scce.dime.data.actions.GenerateMarkdownDocumentation<Data>().execute(it);
        }
      };
      ListExtensions.<DataComponent, Data>map(d.getDataComponents(), _function).forEach(_function_1);
      final Consumer<GUI> _function_2 = new Consumer<GUI>() {
        @Override
        public void accept(final GUI it) {
          new info.scce.dime.gui.actions.GenerateMarkdownDocumentation<GUI>().execute(it);
        }
      };
      this.<GUI>lookup(GUI.class).forEach(_function_2);
      final Consumer<info.scce.dime.process.process.Process> _function_3 = new Consumer<info.scce.dime.process.process.Process>() {
        @Override
        public void accept(final info.scce.dime.process.process.Process it) {
          new info.scce.dime.process.actions.GenerateMarkdownDocumentation<info.scce.dime.process.process.Process>().execute(it);
        }
      };
      this.<info.scce.dime.process.process.Process>lookup(info.scce.dime.process.process.Process.class).forEach(_function_3);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * Helper method to create a file with the given content on the given path.
   * @param content
   * @param path
   * @throws IOException
   */
  public void createFile(final String content, final String path) throws IOException {
    final File f = new File(path);
    f.getParentFile().mkdirs();
    f.createNewFile();
    FileUtils.writeStringToFile(f, content);
  }
  
  public CharSequence createDoc(final DAD d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("# ");
    String _appName = d.getAppName();
    _builder.append(_appName);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("## Data model");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    final Function1<DataComponent, String> _function = new Function1<DataComponent, String>() {
      @Override
      public String apply(final DataComponent it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("* [");
        String _modelName = it.getModel().getModelName();
        _builder.append(_modelName);
        _builder.append("](./data/");
        String _modelName_1 = it.getModel().getModelName();
        _builder.append(_modelName_1);
        _builder.append(".md)");
        return _builder.toString();
      }
    };
    String _join = IterableExtensions.join(ListExtensions.<DataComponent, String>map(d.getDataComponents(), _function), "\n");
    _builder.append(_join);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("## Root Interaction Process");
    _builder.newLine();
    _builder.append("\t ");
    _builder.newLine();
    final Function1<Start, EList<RootInteractionPointer>> _function_1 = new Function1<Start, EList<RootInteractionPointer>>() {
      @Override
      public EList<RootInteractionPointer> apply(final Start it) {
        return it.<RootInteractionPointer>getOutgoing(RootInteractionPointer.class);
      }
    };
    final Function1<RootInteractionPointer, ProcessComponent> _function_2 = new Function1<RootInteractionPointer, ProcessComponent>() {
      @Override
      public ProcessComponent apply(final RootInteractionPointer it) {
        return it.getTargetElement();
      }
    };
    final Function1<ProcessComponent, String> _function_3 = new Function1<ProcessComponent, String>() {
      @Override
      public String apply(final ProcessComponent it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("* [");
        String _modelName = it.getModel().getModelName();
        _builder.append(_modelName);
        _builder.append("](./process/");
        String _modelName_1 = it.getModel().getModelName();
        _builder.append(_modelName_1);
        _builder.append(".md)");
        return _builder.toString();
      }
    };
    String _join_1 = IterableExtensions.join(IterableExtensions.<ProcessComponent, String>map(IterableExtensions.<RootInteractionPointer, ProcessComponent>map(Iterables.<RootInteractionPointer>concat(ListExtensions.<Start, EList<RootInteractionPointer>>map(d.getStarts(), _function_1)), _function_2), _function_3), "\n");
    _builder.append(_join_1);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("## Startup process");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    final Function1<Start, EList<StartupProcessPointer>> _function_4 = new Function1<Start, EList<StartupProcessPointer>>() {
      @Override
      public EList<StartupProcessPointer> apply(final Start it) {
        return it.<StartupProcessPointer>getOutgoing(StartupProcessPointer.class);
      }
    };
    final Function1<StartupProcessPointer, ProcessComponent> _function_5 = new Function1<StartupProcessPointer, ProcessComponent>() {
      @Override
      public ProcessComponent apply(final StartupProcessPointer it) {
        return it.getTargetElement();
      }
    };
    final Function1<ProcessComponent, String> _function_6 = new Function1<ProcessComponent, String>() {
      @Override
      public String apply(final ProcessComponent it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("* [");
        String _modelName = it.getModel().getModelName();
        _builder.append(_modelName);
        _builder.append("](./process/");
        String _modelName_1 = it.getModel().getModelName();
        _builder.append(_modelName_1);
        _builder.append(".md)");
        return _builder.toString();
      }
    };
    String _join_2 = IterableExtensions.join(IterableExtensions.<ProcessComponent, String>map(IterableExtensions.<StartupProcessPointer, ProcessComponent>map(Iterables.<StartupProcessPointer>concat(ListExtensions.<Start, EList<StartupProcessPointer>>map(d.getStarts(), _function_4)), _function_5), _function_6), "\n");
    _builder.append(_join_2);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("## System User Type");
    _builder.newLine();
    _builder.append("\t ");
    _builder.newLine();
    final Function1<SystemUser, String> _function_7 = new Function1<SystemUser, String>() {
      @Override
      public String apply(final SystemUser it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("* [");
        String _name = it.getSystemUser().getName();
        _builder.append(_name);
        _builder.append("](./data/");
        String _modelName = it.getSystemUser().getRootElement().getModelName();
        _builder.append(_modelName);
        _builder.append("/");
        String _name_1 = it.getSystemUser().getName();
        _builder.append(_name_1);
        _builder.append(".md)");
        return _builder.toString();
      }
    };
    String _join_3 = IterableExtensions.join(ListExtensions.<SystemUser, String>map(d.getSystemUsers(), _function_7), "\n");
    _builder.append(_join_3);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }
  
  public <T extends IdentifiableElement> Set<T> lookup(final Class<T> clazz) {
    return ReferenceRegistry.getInstance().<T>lookup(clazz);
  }
}
