/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.api.modelgen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.EdgeLayout;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.EdgeLayoutUtils;
import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import de.jabc.cinco.meta.runtime.CincoRuntimeBaseClass;
import graphmodel.Container;
import graphmodel.Edge;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.BidirectionalAttribute;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.helper.DataExtension;
import info.scce.dime.gui.actions.PrimitivePortToStatic;
import info.scce.dime.gui.factory.GUIFactory;
import info.scce.dime.gui.gui.Branch;
import info.scce.dime.gui.gui.ComplexAttribute;
import info.scce.dime.gui.gui.ComplexAttributeConnector;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.DataContext;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.InputPort;
import info.scce.dime.gui.gui.OutputPort;
import info.scce.dime.gui.gui.PrimitiveAttribute;
import info.scce.dime.gui.gui.PrimitiveType;
import info.scce.dime.gui.gui.PrimitiveVariable;
import info.scce.dime.gui.gui.Read;
import info.scce.dime.gui.gui.SIB;
import info.scce.dime.gui.gui.TextInputStatic;
import info.scce.dime.gui.gui.Variable;
import info.scce.dime.gui.helper.GUIExtension;
import info.scce.dime.process.helper.PortUtils;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.PrimitiveInputPort;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class GUIModelGenerationLanguage extends CincoRuntimeBaseClass {
  @Extension
  protected DataExtension _dataExtension = DataExtension.getInstance();
  
  @Extension
  protected GUIExtension _gUIExtension = new GUIExtension();
  
  @Extension
  private EdgeLayoutUtils _edgeLayoutUtils = new EdgeLayoutUtils();
  
  private static final int VARIABLE_DEFAULT_HEIGHT = 25;
  
  private static final int DATACONTEXT_PADDING_TOP = 23;
  
  private static final int VARIABLE_MARGIN_X = 10;
  
  private static final int VARIABLE_MARGIN_Y = 20;
  
  private static final int VARIABLE_PADDING_TOP = 23;
  
  private static final int VARIABLE_UNFOLDED_ATTRIBUTE_MARGIN_TOP = 20;
  
  private static final int ATTRIBUTE_DEFAULT_HEIGHT = 25;
  
  private static final int ATTRIBUTE_MARGIN_X = 10;
  
  private static final int ATTRIBUTE_MARGIN_Y = 5;
  
  private static final int NODE_PADDING_Y = 20;
  
  private final GUIFactory guiFactory = GUIFactory.eINSTANCE;
  
  public GUI createGUI(final Path outlet, final String name) {
    return this.guiFactory.createGUI(outlet.toString(), name);
  }
  
  public Attribute getAttribute(final Type propType, final String name) {
    final Function1<Attribute, Boolean> _function = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, name));
      }
    };
    return IterableExtensions.<Attribute>head(IterableExtensions.<Attribute>filter(this._dataExtension.getInheritedAttributes(propType), _function));
  }
  
  public info.scce.dime.gui.gui.Attribute getAttribute(final ComplexVariable compVar, final String name) {
    final Function1<info.scce.dime.gui.gui.Attribute, Boolean> _function = new Function1<info.scce.dime.gui.gui.Attribute, Boolean>() {
      @Override
      public Boolean apply(final info.scce.dime.gui.gui.Attribute it) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (it instanceof ComplexAttribute) {
          _matched=true;
          String _name = ((ComplexAttribute)it).getAttribute().getName();
          _switchResult = Objects.equal(_name, name);
        }
        if (!_matched) {
          if (it instanceof PrimitiveAttribute) {
            _matched=true;
            String _name = ((PrimitiveAttribute)it).getAttribute().getName();
            _switchResult = Objects.equal(_name, name);
          }
        }
        if (!_matched) {
          _switchResult = false;
        }
        return Boolean.valueOf(_switchResult);
      }
    };
    return this._gUIExtension.<info.scce.dime.gui.gui.Attribute>findThe(compVar, info.scce.dime.gui.gui.Attribute.class, _function);
  }
  
  public info.scce.dime.data.data.ComplexAttribute getComplexAttribute(final Type propType, final String name) {
    final Function1<Attribute, Boolean> _function = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, name));
      }
    };
    return IterableExtensions.<info.scce.dime.data.data.ComplexAttribute>head(Iterables.<info.scce.dime.data.data.ComplexAttribute>filter(IterableExtensions.<Attribute>filter(this._dataExtension.getInheritedAttributes(propType), _function), info.scce.dime.data.data.ComplexAttribute.class));
  }
  
  public info.scce.dime.data.data.PrimitiveAttribute getPrimitiveAttribute(final Type propType, final String name) {
    final Function1<Attribute, Boolean> _function = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, name));
      }
    };
    return IterableExtensions.<info.scce.dime.data.data.PrimitiveAttribute>head(Iterables.<info.scce.dime.data.data.PrimitiveAttribute>filter(IterableExtensions.<Attribute>filter(this._dataExtension.getInheritedAttributes(propType), _function), info.scce.dime.data.data.PrimitiveAttribute.class));
  }
  
  public BidirectionalAttribute getBidirectionalAttribute(final Type propType, final String name) {
    final Function1<Attribute, Boolean> _function = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, name));
      }
    };
    return IterableExtensions.<BidirectionalAttribute>head(Iterables.<BidirectionalAttribute>filter(IterableExtensions.<Attribute>filter(this._dataExtension.getInheritedAttributes(propType), _function), BidirectionalAttribute.class));
  }
  
  protected info.scce.dime.gui.gui.Attribute _addAttribute(final ComplexVariable compVar, final String attrName) {
    info.scce.dime.gui.gui.Attribute _xblockexpression = null;
    {
      final Type parentType = compVar.getDataType();
      final Attribute attr = this.getAttribute(parentType, attrName);
      _xblockexpression = this.addAttribute(compVar, attr);
    }
    return _xblockexpression;
  }
  
  protected info.scce.dime.gui.gui.Attribute _addAttribute(final ComplexVariable it, final info.scce.dime.data.data.PrimitiveAttribute attr) {
    final PrimitiveAttribute newAttr = it.newPrimitiveAttribute(attr, GUIModelGenerationLanguage.ATTRIBUTE_MARGIN_X, this.beneathBottomAttribute(it), this.maxAttributeWidth(it), GUIModelGenerationLanguage.ATTRIBUTE_DEFAULT_HEIGHT);
    this.increaseIfNecessary(it);
    return newAttr;
  }
  
  protected info.scce.dime.gui.gui.Attribute _addAttribute(final ComplexVariable it, final info.scce.dime.data.data.ComplexAttribute attr) {
    final ComplexAttribute newAttr = it.newComplexAttribute(attr, GUIModelGenerationLanguage.ATTRIBUTE_MARGIN_X, this.beneathBottomAttribute(it), this.maxAttributeWidth(it), GUIModelGenerationLanguage.ATTRIBUTE_DEFAULT_HEIGHT);
    this.increaseIfNecessary(it);
    return newAttr;
  }
  
  public ComplexVariable unfoldAttribute(final ComplexVariable compVar, final String attrName) {
    ComplexVariable _xblockexpression = null;
    {
      final Type parentType = compVar.getDataType();
      final info.scce.dime.data.data.ComplexAttribute attr = this.getComplexAttribute(parentType, attrName);
      final Type type = attr.getDataType();
      final DataContext dataContext = compVar.getContainer();
      int _x = compVar.getX();
      int _bottom = this.getBottom(compVar);
      int _plus = (_bottom + GUIModelGenerationLanguage.VARIABLE_UNFOLDED_ATTRIBUTE_MARGIN_TOP);
      ComplexVariable _newComplexVariable = dataContext.newComplexVariable(type, _x, _plus, compVar.getWidth(), GUIModelGenerationLanguage.VARIABLE_DEFAULT_HEIGHT);
      final Procedure1<ComplexVariable> _function = new Procedure1<ComplexVariable>() {
        @Override
        public void apply(final ComplexVariable it) {
          it.setName(attr.getName());
          ComplexAttributeConnector _newComplexAttributeConnector = compVar.newComplexAttributeConnector(it);
          final Procedure1<ComplexAttributeConnector> _function = new Procedure1<ComplexAttributeConnector>() {
            @Override
            public void apply(final ComplexAttributeConnector it) {
              it.setAssociationName(attrName);
            }
          };
          ObjectExtensions.<ComplexAttributeConnector>operator_doubleArrow(_newComplexAttributeConnector, _function);
        }
      };
      _xblockexpression = ObjectExtensions.<ComplexVariable>operator_doubleArrow(_newComplexVariable, _function);
    }
    return _xblockexpression;
  }
  
  public ComplexVariable addVariable(final DataContext it, final Type varType, final boolean varIsList, final String varName) {
    ComplexVariable _newComplexVariable = it.newComplexVariable(varType, 
      GUIModelGenerationLanguage.VARIABLE_MARGIN_X, this.beneathBottomVariable(it), this.maxVariableWidth(it), GUIModelGenerationLanguage.VARIABLE_DEFAULT_HEIGHT);
    final Procedure1<ComplexVariable> _function = new Procedure1<ComplexVariable>() {
      @Override
      public void apply(final ComplexVariable it) {
        it.setIsList(varIsList);
        it.setName(varName);
      }
    };
    return ObjectExtensions.<ComplexVariable>operator_doubleArrow(_newComplexVariable, _function);
  }
  
  public PrimitiveVariable addVariable(final DataContext it, final PrimitiveType varType, final boolean varIsList, final String varName) {
    PrimitiveVariable _newPrimitiveVariable = it.newPrimitiveVariable(
      GUIModelGenerationLanguage.VARIABLE_MARGIN_X, this.beneathBottomVariable(it), this.maxVariableWidth(it), GUIModelGenerationLanguage.VARIABLE_DEFAULT_HEIGHT);
    final Procedure1<PrimitiveVariable> _function = new Procedure1<PrimitiveVariable>() {
      @Override
      public void apply(final PrimitiveVariable it) {
        it.setDataType(varType);
        it.setIsList(varIsList);
        it.setName(varName);
      }
    };
    return ObjectExtensions.<PrimitiveVariable>operator_doubleArrow(_newPrimitiveVariable, _function);
  }
  
  protected Variable _addVariable(final DataContext dataContext, final ComplexInputPort port) {
    ComplexVariable _addVariable = this.addVariable(dataContext, port.getDataType(), port.isIsList(), port.getName());
    return ((Variable) _addVariable);
  }
  
  protected Variable _addVariable(final DataContext dataContext, final PrimitiveInputPort port) {
    PrimitiveVariable _addVariable = this.addVariable(dataContext, this._gUIExtension.toGUI(this._dataExtension.toData(port.getDataType())), port.isIsList(), port.getName());
    return ((Variable) _addVariable);
  }
  
  protected Variable _addVariable(final DataContext dataContext, final InputStatic port) {
    PrimitiveVariable _addVariable = this.addVariable(dataContext, this._gUIExtension.toGUI(this._dataExtension.toData(PortUtils.toPrimitiveType(port))), false, port.getName());
    return ((Variable) _addVariable);
  }
  
  protected Read _dataFlowTo(final ComplexAttribute attr, final info.scce.dime.gui.gui.ComplexInputPort port) {
    return attr.newComplexRead(port);
  }
  
  protected Read _dataFlowTo(final PrimitiveAttribute attr, final info.scce.dime.gui.gui.PrimitiveInputPort port) {
    return attr.newPrimitiveRead(port);
  }
  
  protected Read _dataFlowTo(final ComplexVariable compVar, final info.scce.dime.gui.gui.ComplexInputPort port) {
    return compVar.newComplexRead(port);
  }
  
  protected Read _dataFlowTo(final PrimitiveVariable primVar, final info.scce.dime.gui.gui.PrimitiveInputPort port) {
    return primVar.newPrimitiveRead(port);
  }
  
  protected Read _dataFlowFrom(final info.scce.dime.gui.gui.PrimitiveInputPort inPort, final PrimitiveVariable primVar) {
    return primVar.newPrimitiveRead(inPort);
  }
  
  protected Read _dataFlowFrom(final info.scce.dime.gui.gui.ComplexInputPort inPort, final ComplexVariable compVar) {
    return compVar.newComplexRead(inPort);
  }
  
  protected Read _dataFlowFrom(final info.scce.dime.gui.gui.PrimitiveInputPort inPort, final PrimitiveAttribute primAttr) {
    return primAttr.newPrimitiveRead(inPort);
  }
  
  protected Read _dataFlowFrom(final info.scce.dime.gui.gui.ComplexInputPort inPort, final ComplexAttribute compAttr) {
    return compAttr.newComplexRead(inPort);
  }
  
  public InputPort getInputPort(final SIB sib, final String name) {
    final Function1<InputPort, Boolean> _function = new Function1<InputPort, Boolean>() {
      @Override
      public Boolean apply(final InputPort it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, name));
      }
    };
    return this._gUIExtension.<InputPort>findThe(sib, InputPort.class, _function);
  }
  
  public OutputPort getOutputPort(final Branch branch, final String name) {
    final Function1<OutputPort, Boolean> _function = new Function1<OutputPort, Boolean>() {
      @Override
      public Boolean apply(final OutputPort it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, name));
      }
    };
    return this._gUIExtension.<OutputPort>findThe(branch, OutputPort.class, _function);
  }
  
  public Branch getBranch(final SIB sib, final String name) {
    final Function1<Branch, Boolean> _function = new Function1<Branch, Boolean>() {
      @Override
      public Boolean apply(final Branch it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, name));
      }
    };
    return IterableExtensions.<Branch>head(IterableExtensions.<Branch>filter(this._gUIExtension.<Branch>find(sib, Branch.class), _function));
  }
  
  public void keepBranches(final SIB sib, final String... names) {
    final Function1<Branch, Boolean> _function = new Function1<Branch, Boolean>() {
      @Override
      public Boolean apply(final Branch it) {
        boolean _contains = ArrayExtensions.contains(names, it.getName());
        return Boolean.valueOf((!_contains));
      }
    };
    final Consumer<Branch> _function_1 = new Consumer<Branch>() {
      @Override
      public void accept(final Branch it) {
        it.delete();
      }
    };
    IterableExtensions.<Branch>filter(this._gUIExtension.<Branch>find(sib, Branch.class), _function).forEach(_function_1);
  }
  
  public void layoutMiddleToCenter(final Edge it) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        it.addBendpoint(
          GUIModelGenerationLanguage.this._edgeLayoutUtils.getTopCenter(it.getTargetElement()).x, 
          GUIModelGenerationLanguage.this._edgeLayoutUtils.getMiddleLeft(it.getSourceElement()).y);
      }
    };
    this._workbenchExtension.transact(it, _function);
  }
  
  public void increaseIfNecessary(final Container it) {
    this.increaseIfNecessaryRight(it);
    this.increaseIfNecessaryBottom(it);
  }
  
  protected void _increaseIfNecessaryBottom(final DataContext container) {
    this.increaseIfNecessaryBottom(container, GUIModelGenerationLanguage.VARIABLE_MARGIN_Y);
  }
  
  protected void _increaseIfNecessaryBottom(final Variable container) {
    this.increaseIfNecessaryBottom(container, GUIModelGenerationLanguage.ATTRIBUTE_MARGIN_Y);
  }
  
  public void increaseIfNecessaryBottom(final Container container, final int padding) {
    final Node botNode = this.getBottomChild(container);
    boolean _notEquals = this._gUIExtension.operator_notEquals(botNode, null);
    if (_notEquals) {
      int _width = container.getWidth();
      int _bottom = this.getBottom(botNode);
      int _plus = (_bottom + padding);
      container.resize(_width, _plus);
      ModelElementContainer _container = container.getContainer();
      final ModelElementContainer it = _container;
      boolean _matched = false;
      if (it instanceof Container) {
        _matched=true;
        this.increaseIfNecessaryBottom(((Container)it));
      }
    }
  }
  
  protected void _increaseIfNecessaryRight(final DataContext container) {
    this.increaseIfNecessaryRight(container, GUIModelGenerationLanguage.VARIABLE_MARGIN_X);
  }
  
  protected void _increaseIfNecessaryRight(final Variable container) {
    this.increaseIfNecessaryRight(container, GUIModelGenerationLanguage.ATTRIBUTE_MARGIN_X);
  }
  
  public void increaseIfNecessaryRight(final Container container, final int padding) {
    final Node rightNode = this.getRightChild(container);
    boolean _notEquals = this._gUIExtension.operator_notEquals(rightNode, null);
    if (_notEquals) {
      int _width = container.getWidth();
      int _right = this.getRight(rightNode);
      int _plus = (_right + padding);
      container.resize(_width, _plus);
      ModelElementContainer _container = container.getContainer();
      final ModelElementContainer it = _container;
      boolean _matched = false;
      if (it instanceof Container) {
        _matched=true;
        this.increaseIfNecessaryRight(((Container)it));
      }
    }
  }
  
  public void moveConnected(final Node node, final int deltaX, final int deltaY) {
    this.moveConnected_rec(node, deltaX, deltaY, CollectionLiterals.<Node>newHashSet(node));
  }
  
  public void moveConnected_rec(final Node node, final int deltaX, final int deltaY, final Set<Node> seen) {
    EList<Node> _successors = node.<Node>getSuccessors();
    EList<Node> _predecessors = node.<Node>getPredecessors();
    Iterable<Node> _plus = Iterables.<Node>concat(_successors, _predecessors);
    for (final Node n : _plus) {
      boolean _add = seen.add(n);
      if (_add) {
        int _x = n.getX();
        int _plus_1 = (_x + deltaX);
        int _y = n.getY();
        int _plus_2 = (_y + deltaY);
        n.move(_plus_1, _plus_2);
        this.moveConnected_rec(n, deltaX, deltaY, seen);
      }
    }
  }
  
  public void moveSuccessors(final Node node, final int deltaX, final int deltaY) {
    this.moveSuccessors_rec(node, deltaX, deltaY, CollectionLiterals.<Node>newHashSet(node));
  }
  
  public void moveSuccessors_rec(final Node node, final int deltaX, final int deltaY, final Set<Node> seen) {
    EList<Node> _successors = node.<Node>getSuccessors();
    for (final Node n : _successors) {
      boolean _add = seen.add(n);
      if (_add) {
        int _x = n.getX();
        int _plus = (_x + deltaX);
        int _y = n.getY();
        int _plus_1 = (_y + deltaY);
        n.move(_plus, _plus_1);
        this.moveSuccessors_rec(n, deltaX, deltaY, seen);
      }
    }
  }
  
  public void alignWithTopOf(final Node node, final Node otherNode) {
    node.move(node.getX(), otherNode.getY());
  }
  
  public void alignWithBottomOf(final Node node, final Node otherNode) {
    int _x = node.getX();
    int _y = otherNode.getY();
    int _height = otherNode.getHeight();
    int _plus = (_y + _height);
    int _height_1 = node.getHeight();
    int _minus = (_plus - _height_1);
    node.move(_x, _minus);
  }
  
  public void moveToBottomOf(final Node node, final Node otherNode, final int margin) {
    int _center = this.getCenter(otherNode);
    int _width = node.getWidth();
    int _divide = (_width / 2);
    int _minus = (_center - _divide);
    int _bottom = this.getBottom(otherNode);
    int _plus = (_bottom + margin);
    node.move(_minus, _plus);
  }
  
  public void moveToBottom(final Node it) {
    final int oldX = it.getX();
    final int oldY = it.getY();
    int _x = it.getX();
    int _bottom = this.getBottom(this.getBottomChild(it.getContainer()));
    int _plus = (_bottom + GUIModelGenerationLanguage.NODE_PADDING_Y);
    it.move(_x, _plus);
    int _x_1 = it.getX();
    final int deltaX = (_x_1 - oldX);
    int _y = it.getY();
    final int deltaY = (_y - oldY);
    if (((deltaX != 0) || (deltaY != 0))) {
      this.moveSuccessors(it, deltaX, deltaY);
    }
  }
  
  public void moveToRight(final Node it) {
    final int oldX = it.getX();
    final int oldY = it.getY();
    int _right = this.getRight(this.getBottomChild(it.getContainer()));
    int _plus = (_right + GUIModelGenerationLanguage.NODE_PADDING_Y);
    it.move(_plus, it.getY());
    int _x = it.getX();
    final int deltaX = (_x - oldX);
    int _y = it.getY();
    final int deltaY = (_y - oldY);
    if (((deltaX != 0) || (deltaY != 0))) {
      this.moveSuccessors(it, deltaX, deltaY);
    }
  }
  
  public void moveToBottomRight(final Node it) {
    final int oldX = it.getX();
    final int oldY = it.getY();
    int _right = this.getRight(this.getBottomChild(it.getContainer()));
    int _plus = (_right + GUIModelGenerationLanguage.NODE_PADDING_Y);
    int _bottom = this.getBottom(this.getBottomChild(it.getContainer()));
    int _plus_1 = (_bottom + GUIModelGenerationLanguage.NODE_PADDING_Y);
    it.move(_plus, _plus_1);
    int _x = it.getX();
    final int deltaX = (_x - oldX);
    int _y = it.getY();
    final int deltaY = (_y - oldY);
    if (((deltaX != 0) || (deltaY != 0))) {
      this.moveSuccessors(it, deltaX, deltaY);
    }
  }
  
  public void alignBeneathOf(final Node node, final Node otherNode) {
    this.moveToBottomOf(node, otherNode, GUIModelGenerationLanguage.NODE_PADDING_Y);
  }
  
  public void alignRightOf(final Node node, final Node otherNode) {
    this.moveToRightOf(node, otherNode, GUIModelGenerationLanguage.NODE_PADDING_Y);
  }
  
  public void moveToRightOf(final Node node, final Node otherNode, final int margin) {
    int _right = this.getRight(otherNode);
    int _plus = (_right + margin);
    int _middle = this.getMiddle(otherNode);
    int _height = node.getHeight();
    int _divide = (_height / 2);
    int _minus = (_middle - _divide);
    node.move(_plus, _minus);
  }
  
  public int getCenter(final Node it) {
    int _x = it.getX();
    int _width = it.getWidth();
    int _divide = (_width / 2);
    return (_x + _divide);
  }
  
  public int getBottom(final Node it) {
    int _y = it.getY();
    int _height = it.getHeight();
    return (_y + _height);
  }
  
  public int getRight(final Node it) {
    int _x = it.getX();
    int _width = it.getWidth();
    return (_x + _width);
  }
  
  public int getMiddle(final Node it) {
    int _y = it.getY();
    int _height = it.getHeight();
    int _divide = (_height / 2);
    return (_y + _divide);
  }
  
  public Node getBottomChild(final ModelElementContainer it) {
    final Function1<Node, Integer> _function = new Function1<Node, Integer>() {
      @Override
      public Integer apply(final Node it) {
        return Integer.valueOf(GUIModelGenerationLanguage.this.getBottom(it));
      }
    };
    return IterableExtensions.<Node>head(ListExtensions.<Node>reverse(IterableExtensions.<Node, Integer>sortBy(it.getAllNodes(), _function)));
  }
  
  public Node getRightChild(final Container it) {
    final Function1<Node, Integer> _function = new Function1<Node, Integer>() {
      @Override
      public Integer apply(final Node it) {
        return Integer.valueOf(GUIModelGenerationLanguage.this.getRight(it));
      }
    };
    return IterableExtensions.<Node>head(ListExtensions.<Node>reverse(IterableExtensions.<Node, Integer>sortBy(it.getAllNodes(), _function)));
  }
  
  public int beneathBottomAttribute(final Container con) {
    return this.beneathBottomChild(con, GUIModelGenerationLanguage.ATTRIBUTE_MARGIN_Y, GUIModelGenerationLanguage.VARIABLE_PADDING_TOP);
  }
  
  public int beneathBottomVariable(final Container con) {
    return this.beneathBottomChild(con, GUIModelGenerationLanguage.VARIABLE_MARGIN_Y, GUIModelGenerationLanguage.DATACONTEXT_PADDING_TOP);
  }
  
  public int beneathBottomChild(final Container con, final int margin, final int min) {
    int _xblockexpression = (int) 0;
    {
      final Node botChild = this.getBottomChild(con);
      int _xifexpression = (int) 0;
      if ((botChild != null)) {
        int _bottom = this.getBottom(botChild);
        _xifexpression = (_bottom + margin);
      } else {
        _xifexpression = min;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public int maxAttributeWidth(final Container con) {
    return this.maxChildWidth(con, GUIModelGenerationLanguage.ATTRIBUTE_MARGIN_X);
  }
  
  public int maxVariableWidth(final Container con) {
    return this.maxChildWidth(con, GUIModelGenerationLanguage.VARIABLE_MARGIN_X);
  }
  
  public int maxChildWidth(final Container con, final int padding) {
    int _width = con.getWidth();
    return (_width - (padding * 2));
  }
  
  public void applyLayout(final Edge edge, final EdgeLayout layout) {
    layout.apply(edge);
  }
  
  public EObject getByID(final String id) {
    return ReferenceRegistry.getInstance().getEObject(id);
  }
  
  public info.scce.dime.gui.gui.InputStatic setStaticInput(final InputPort inPort, final String value) {
    final String name = inPort.getName();
    final ModelElementContainer sib = inPort.getContainer();
    new PrimitivePortToStatic().execute(((info.scce.dime.gui.gui.PrimitiveInputPort) inPort));
    final Function1<info.scce.dime.gui.gui.InputStatic, Boolean> _function = new Function1<info.scce.dime.gui.gui.InputStatic, Boolean>() {
      @Override
      public Boolean apply(final info.scce.dime.gui.gui.InputStatic it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, name));
      }
    };
    final info.scce.dime.gui.gui.InputStatic staticInPort = this._gUIExtension.<info.scce.dime.gui.gui.InputStatic>findThe(sib, info.scce.dime.gui.gui.InputStatic.class, _function);
    final info.scce.dime.gui.gui.InputStatic it = staticInPort;
    boolean _matched = false;
    if (it instanceof TextInputStatic) {
      _matched=true;
      ((TextInputStatic)it).setValue(value);
    }
    return staticInPort;
  }
  
  public info.scce.dime.gui.gui.Attribute addAttribute(final ComplexVariable it, final Object attr) {
    if (attr instanceof info.scce.dime.data.data.ComplexAttribute) {
      return _addAttribute(it, (info.scce.dime.data.data.ComplexAttribute)attr);
    } else if (attr instanceof info.scce.dime.data.data.PrimitiveAttribute) {
      return _addAttribute(it, (info.scce.dime.data.data.PrimitiveAttribute)attr);
    } else if (attr instanceof String) {
      return _addAttribute(it, (String)attr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, attr).toString());
    }
  }
  
  public Variable addVariable(final DataContext dataContext, final Input port) {
    if (port instanceof ComplexInputPort) {
      return _addVariable(dataContext, (ComplexInputPort)port);
    } else if (port instanceof PrimitiveInputPort) {
      return _addVariable(dataContext, (PrimitiveInputPort)port);
    } else if (port instanceof InputStatic) {
      return _addVariable(dataContext, (InputStatic)port);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(dataContext, port).toString());
    }
  }
  
  public Read dataFlowTo(final Node compVar, final InputPort port) {
    if (compVar instanceof ComplexVariable
         && port instanceof info.scce.dime.gui.gui.ComplexInputPort) {
      return _dataFlowTo((ComplexVariable)compVar, (info.scce.dime.gui.gui.ComplexInputPort)port);
    } else if (compVar instanceof PrimitiveVariable
         && port instanceof info.scce.dime.gui.gui.PrimitiveInputPort) {
      return _dataFlowTo((PrimitiveVariable)compVar, (info.scce.dime.gui.gui.PrimitiveInputPort)port);
    } else if (compVar instanceof ComplexAttribute
         && port instanceof info.scce.dime.gui.gui.ComplexInputPort) {
      return _dataFlowTo((ComplexAttribute)compVar, (info.scce.dime.gui.gui.ComplexInputPort)port);
    } else if (compVar instanceof PrimitiveAttribute
         && port instanceof info.scce.dime.gui.gui.PrimitiveInputPort) {
      return _dataFlowTo((PrimitiveAttribute)compVar, (info.scce.dime.gui.gui.PrimitiveInputPort)port);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(compVar, port).toString());
    }
  }
  
  public Read dataFlowFrom(final InputPort inPort, final Node compVar) {
    if (inPort instanceof info.scce.dime.gui.gui.ComplexInputPort
         && compVar instanceof ComplexVariable) {
      return _dataFlowFrom((info.scce.dime.gui.gui.ComplexInputPort)inPort, (ComplexVariable)compVar);
    } else if (inPort instanceof info.scce.dime.gui.gui.PrimitiveInputPort
         && compVar instanceof PrimitiveVariable) {
      return _dataFlowFrom((info.scce.dime.gui.gui.PrimitiveInputPort)inPort, (PrimitiveVariable)compVar);
    } else if (inPort instanceof info.scce.dime.gui.gui.ComplexInputPort
         && compVar instanceof ComplexAttribute) {
      return _dataFlowFrom((info.scce.dime.gui.gui.ComplexInputPort)inPort, (ComplexAttribute)compVar);
    } else if (inPort instanceof info.scce.dime.gui.gui.PrimitiveInputPort
         && compVar instanceof PrimitiveAttribute) {
      return _dataFlowFrom((info.scce.dime.gui.gui.PrimitiveInputPort)inPort, (PrimitiveAttribute)compVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(inPort, compVar).toString());
    }
  }
  
  public void increaseIfNecessaryBottom(final Container container) {
    if (container instanceof DataContext) {
      _increaseIfNecessaryBottom((DataContext)container);
      return;
    } else if (container instanceof Variable) {
      _increaseIfNecessaryBottom((Variable)container);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(container).toString());
    }
  }
  
  public void increaseIfNecessaryRight(final Container container) {
    if (container instanceof DataContext) {
      _increaseIfNecessaryRight((DataContext)container);
      return;
    } else if (container instanceof Variable) {
      _increaseIfNecessaryRight((Variable)container);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(container).toString());
    }
  }
}
