/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.api;

import de.jabc.cinco.meta.runtime.xapi.GraphModelExtension;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.ModelElementContainer;
import info.scce.dime.dad.dad.DataComponent;
import info.scce.dime.dad.dad.FindLoginUserComponent;
import info.scce.dime.dad.dad.LoginComponent;
import info.scce.dime.dad.dad.ProcessComponent;
import info.scce.dime.data.data.ExtensionAttribute;
import info.scce.dime.data.data.ReferencedExtensionAttribute;
import info.scce.dime.gui.gui.GUISIB;
import info.scce.dime.gui.gui.GuardSIB;
import info.scce.dime.gui.gui.ProcessSIB;
import info.scce.dime.gui.gui.SecuritySIB;
import info.scce.dime.process.process.GuardProcessSIB;
import info.scce.dime.process.process.GuardedProcessSIB;
import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class DIMEGraphModelExtension extends GraphModelExtension {
  @Extension
  protected ResourceExtension _resourceExtension = new ResourceExtension();
  
  /**
   * Retrieve the local package string (project relative) in standard Java syntax.
   * 
   * @param it - The model element in some model, for which the package should be built.
   */
  protected String _getLocalPkg(final ModelElement it) {
    return this.getLocalPkg(it.getRootElement());
  }
  
  /**
   * Retrieve the local package string (project relative) in standard Java syntax.
   * 
   * @param it - The model, for which the package should be built.
   */
  protected String _getLocalPkg(final GraphModel it) {
    return this.buildLocalPkg(it, false);
  }
  
  /**
   * Retrieve the local package string (project relative) in standard Java syntax.
   * 
   * @param it - The model element in some model, for which the package should be built.
   */
  protected String _getLocalPkgWithFilename(final ModelElement it) {
    return this.getLocalPkgWithFilename(it.getRootElement());
  }
  
  /**
   * Retrieve the local package string (project relative) in standard Java syntax.
   * 
   * @param it - The model, for which the package should be built.
   */
  protected String _getLocalPkgWithFilename(final GraphModel it) {
    return this.buildLocalPkg(it, true);
  }
  
  /**
   * Retrieve the local package string (project relative) in standard Java syntax.
   * 
   * @param model - The model element in some model, for which the package should be built.
   * @param includeFileName - Include the name of the file (without extension) as the last element of the package.
   */
  private String buildLocalPkg(final GraphModel model, final boolean includeFileName) {
    String _xblockexpression = null;
    {
      final IProject project = this._resourceExtension.getProject(model.eResource());
      final String absoluteProjectPath = project.getFullPath().toFile().getAbsolutePath();
      File _switchResult = null;
      File _file = this._resourceExtension.getIResource(model.eResource()).getFullPath().toFile();
      final File it = _file;
      boolean _matched = false;
      if ((!includeFileName)) {
        _matched=true;
        _switchResult = it.getParentFile();
      }
      if (!_matched) {
        if (includeFileName) {
          _matched=true;
          _switchResult = it;
        }
      }
      final String absoluteModelPath = _switchResult.getAbsolutePath();
      boolean _startsWith = absoluteModelPath.startsWith(absoluteProjectPath);
      boolean _not = (!_startsWith);
      if (_not) {
        StringConcatenation _builder = new StringConcatenation();
        String _id = model.getId();
        _builder.append(_id);
        _builder.append(": model path does not start with project path");
        throw new IllegalStateException(_builder.toString());
      }
      final int suffixPos = absoluteModelPath.lastIndexOf(".");
      String _xifexpression = null;
      if ((includeFileName && (suffixPos > 0))) {
        _xifexpression = absoluteModelPath.substring(absoluteProjectPath.length(), suffixPos);
      } else {
        _xifexpression = absoluteModelPath.substring(absoluteProjectPath.length());
      }
      final String relativeModelPath = _xifexpression;
      _xblockexpression = relativeModelPath.replaceFirst("^(\\.|\\\\|\\/)*", "").replaceAll("(\\\\|\\/)", ".").toLowerCase();
    }
    return _xblockexpression;
  }
  
  public ModelElementContainer getPrimeReferencedContainer(final IdentifiableElement it) {
    GraphModel _switchResult = null;
    boolean _matched = false;
    if (it instanceof ProcessComponent) {
      _matched=true;
      _switchResult = ((ProcessComponent)it).getModel();
    }
    if (!_matched) {
      if (it instanceof LoginComponent) {
        _matched=true;
        _switchResult = ((LoginComponent)it).getModel();
      }
    }
    if (!_matched) {
      if (it instanceof FindLoginUserComponent) {
        _matched=true;
        _switchResult = ((FindLoginUserComponent)it).getModel();
      }
    }
    if (!_matched) {
      if (it instanceof DataComponent) {
        _matched=true;
        _switchResult = ((DataComponent)it).getModel();
      }
    }
    if (!_matched) {
      if (it instanceof GUISIB) {
        _matched=true;
        _switchResult = ((GUISIB)it).getGui();
      }
    }
    if (!_matched) {
      if (it instanceof ProcessSIB) {
        _matched=true;
        info.scce.dime.process.process.Process _proMod = ((ProcessSIB)it).getProMod();
        _switchResult = ((info.scce.dime.process.process.Process) _proMod);
      }
    }
    if (!_matched) {
      if (it instanceof SecuritySIB) {
        _matched=true;
        info.scce.dime.process.process.Process _proMod = ((SecuritySIB)it).getProMod();
        _switchResult = ((info.scce.dime.process.process.Process) _proMod);
      }
    }
    if (!_matched) {
      if (it instanceof GuardSIB) {
        _matched=true;
        info.scce.dime.process.process.Process _process = ((GuardSIB)it).getProcess();
        _switchResult = ((info.scce.dime.process.process.Process) _process);
      }
    }
    if (!_matched) {
      if (it instanceof info.scce.dime.process.process.GUISIB) {
        _matched=true;
        _switchResult = ((info.scce.dime.process.process.GUISIB)it).getGui();
      }
    }
    if (!_matched) {
      if (it instanceof info.scce.dime.process.process.ProcessSIB) {
        _matched=true;
        _switchResult = ((info.scce.dime.process.process.ProcessSIB)it).getProMod();
      }
    }
    if (!_matched) {
      if (it instanceof GuardedProcessSIB) {
        _matched=true;
        _switchResult = ((GuardedProcessSIB)it).getProMod();
      }
    }
    if (!_matched) {
      if (it instanceof GuardProcessSIB) {
        _matched=true;
        _switchResult = ((GuardProcessSIB)it).getSecurityProcess();
      }
    }
    if (!_matched) {
      if (it instanceof ReferencedExtensionAttribute) {
        _matched=true;
        info.scce.dime.process.process.Process _process = ((ReferencedExtensionAttribute)it).getReferencedAttribute().getProcess();
        _switchResult = ((info.scce.dime.process.process.Process) _process);
      }
    }
    if (!_matched) {
      if (it instanceof ExtensionAttribute) {
        _matched=true;
        info.scce.dime.process.process.Process _process = ((ExtensionAttribute)it).getProcess();
        _switchResult = ((info.scce.dime.process.process.Process) _process);
      }
    }
    return _switchResult;
  }
  
  public String getLocalPkg(final IdentifiableElement it) {
    if (it instanceof GraphModel) {
      return _getLocalPkg((GraphModel)it);
    } else if (it instanceof ModelElement) {
      return _getLocalPkg((ModelElement)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public String getLocalPkgWithFilename(final IdentifiableElement it) {
    if (it instanceof GraphModel) {
      return _getLocalPkgWithFilename((GraphModel)it);
    } else if (it instanceof ModelElement) {
      return _getLocalPkgWithFilename((ModelElement)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
