package info.scce.dime.search.factory

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

import info.scce.dime.search.search.SearchPackage
import info.scce.dime.search.search.impl.SearchFactoryImpl
import info.scce.dime.search.search.internal.InternalFactory
import info.scce.dime.search.search.internal.InternalPackage

import info.scce.dime.search.search.adapter.*

import graphmodel.internal.InternalModelElement
import graphmodel.internal.InternalModelElementContainer
import graphmodel.internal.InternalGraphModel
import graphmodel.internal.InternalContainer
import graphmodel.internal.InternalNode
import graphmodel.internal.InternalEdge
import graphmodel.internal.InternalType
import graphmodel.internal.InternalIdentifiableElement
import graphmodel.ModelElement
import graphmodel.IdentifiableElement
import graphmodel.GraphModel
import graphmodel.Type

import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EPackage
import org.eclipse.emf.ecore.plugin.EcorePlugin

class SearchFactory extends SearchFactoryImpl {
	
	final extension InternalFactory = InternalFactory.eINSTANCE
	public static SearchFactory eINSTANCE = SearchFactory.init
	
	extension de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension = new de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension
	
	static def SearchFactory init() {
		try {
			val fct = EPackage::Registry.INSTANCE.getEFactory(SearchPackage.eNS_URI) as SearchFactory
			if (fct !== null)
				return fct as SearchFactory
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		new SearchFactory
	}
	
	/**
	 * This method creates an Search with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createSearch(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createSearch => [ 
			setID(ID)
			internal = ime ?: createInternalSearch => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.search.adapter.SearchEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Search with the given id. Post create hook won't be triggered.
	 */
	def createSearch(String ID){
		createSearch(ID,null,null,false)
	}
	
	/**
	 * This method creates an Search with the given id. Post create hook will be triggered.
	 */
	def createSearch(InternalModelElementContainer parent){
		createSearch(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Search with the given id. Post create hook will be triggered.
	 */
	def createSearch(String ID, InternalModelElementContainer parent){
		createSearch(ID,null,parent,true)
	}
	
	def createSearch(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createSearch(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Search with the given id. Post create hook won't be triggered.
	 */
	def createSearch(InternalModelElement ime) {
		createSearch(generateUUID,ime,null,false)
	}
	
	override createSearch() {
		createSearch(generateUUID)
	}
	/**
	 * This method creates an OrOperator with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createOrOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createOrOperator => [
			setID(ID)
			internal = ime ?: createInternalOrOperator => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.OrOperatorEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an OrOperator with the given id. Post create hook won't be triggered.
	 */
	def createOrOperator(String ID){
		createOrOperator(ID,null,null,false)
	}
	
	/**
	 * This method creates an OrOperator with the given id. Post create hook will be triggered.
	 */
	def createOrOperator(InternalModelElementContainer parent){
		createOrOperator(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an OrOperator with the given id. Post create hook will be triggered.
	 */
	def createOrOperator(String ID, InternalModelElementContainer parent){
		createOrOperator(ID,null,parent,true)
	}
	
	def createOrOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createOrOperator(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an OrOperator with the given id. Post create hook won't be triggered.
	 */
	def createOrOperator(InternalModelElement ime) {
		createOrOperator(generateUUID,ime,null,false)
	}
	
	override createOrOperator() {
		createOrOperator(generateUUID)
	}
	def createConditionEdge(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createConditionEdge => [
			setID(ID)
			internal = ime ?: createInternalConditionEdge => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.search.adapter.ConditionEdgeEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ConditionEdge with the given id. Post create hook will be triggered.
	 */
	def createConditionEdge(String ID, InternalNode source, InternalNode target){
		createConditionEdge(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ConditionEdge with generated id. Post create hook will be triggered.
	 */
	def createConditionEdge(InternalNode source, InternalNode target){
		createConditionEdge(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ConditionEdge with the given id. Post create hook won't be triggered.
	 */
	def createConditionEdge(String ID){
		createConditionEdge(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ConditionEdge with a generated id. Post create hook won't be triggered.
	 */
	override createConditionEdge() {
		createConditionEdge(generateUUID)
	}
	/**
	 * This method creates an BooleanCompareOperator with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBooleanCompareOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBooleanCompareOperator => [
			setID(ID)
			internal = ime ?: createInternalBooleanCompareOperator => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.BooleanCompareOperatorEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an BooleanCompareOperator with the given id. Post create hook won't be triggered.
	 */
	def createBooleanCompareOperator(String ID){
		createBooleanCompareOperator(ID,null,null,false)
	}
	
	/**
	 * This method creates an BooleanCompareOperator with the given id. Post create hook will be triggered.
	 */
	def createBooleanCompareOperator(InternalModelElementContainer parent){
		createBooleanCompareOperator(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an BooleanCompareOperator with the given id. Post create hook will be triggered.
	 */
	def createBooleanCompareOperator(String ID, InternalModelElementContainer parent){
		createBooleanCompareOperator(ID,null,parent,true)
	}
	
	def createBooleanCompareOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBooleanCompareOperator(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an BooleanCompareOperator with the given id. Post create hook won't be triggered.
	 */
	def createBooleanCompareOperator(InternalModelElement ime) {
		createBooleanCompareOperator(generateUUID,ime,null,false)
	}
	
	override createBooleanCompareOperator() {
		createBooleanCompareOperator(generateUUID)
	}
	/**
	 * This method creates an AndOperator with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createAndOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createAndOperator => [
			setID(ID)
			internal = ime ?: createInternalAndOperator => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.AndOperatorEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an AndOperator with the given id. Post create hook won't be triggered.
	 */
	def createAndOperator(String ID){
		createAndOperator(ID,null,null,false)
	}
	
	/**
	 * This method creates an AndOperator with the given id. Post create hook will be triggered.
	 */
	def createAndOperator(InternalModelElementContainer parent){
		createAndOperator(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an AndOperator with the given id. Post create hook will be triggered.
	 */
	def createAndOperator(String ID, InternalModelElementContainer parent){
		createAndOperator(ID,null,parent,true)
	}
	
	def createAndOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createAndOperator(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an AndOperator with the given id. Post create hook won't be triggered.
	 */
	def createAndOperator(InternalModelElement ime) {
		createAndOperator(generateUUID,ime,null,false)
	}
	
	override createAndOperator() {
		createAndOperator(generateUUID)
	}
	/**
	 * This method creates an PrimitiveVariable with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveVariable => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveVariable => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.PrimitiveVariableEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveVariable(String ID){
		createPrimitiveVariable(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveVariable(InternalModelElementContainer parent){
		createPrimitiveVariable(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveVariable(String ID, InternalModelElementContainer parent){
		createPrimitiveVariable(ID,null,parent,true)
	}
	
	def createPrimitiveVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveVariable(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveVariable(InternalModelElement ime) {
		createPrimitiveVariable(generateUUID,ime,null,false)
	}
	
	override createPrimitiveVariable() {
		createPrimitiveVariable(generateUUID)
	}
	/**
	 * This method creates an SearchConditional with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createSearchConditional(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createSearchConditional => [
			setID(ID)
			internal = ime ?: createInternalSearchConditional => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.SearchConditionalEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an SearchConditional with the given id. Post create hook won't be triggered.
	 */
	def createSearchConditional(String ID){
		createSearchConditional(ID,null,null,false)
	}
	
	/**
	 * This method creates an SearchConditional with the given id. Post create hook will be triggered.
	 */
	def createSearchConditional(InternalModelElementContainer parent){
		createSearchConditional(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an SearchConditional with the given id. Post create hook will be triggered.
	 */
	def createSearchConditional(String ID, InternalModelElementContainer parent){
		createSearchConditional(ID,null,parent,true)
	}
	
	def createSearchConditional(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createSearchConditional(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an SearchConditional with the given id. Post create hook won't be triggered.
	 */
	def createSearchConditional(InternalModelElement ime) {
		createSearchConditional(generateUUID,ime,null,false)
	}
	
	override createSearchConditional() {
		createSearchConditional(generateUUID)
	}
	def createDataEdge(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createDataEdge => [
			setID(ID)
			internal = ime ?: createInternalDataEdge => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.search.adapter.DataEdgeEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an DataEdge with the given id. Post create hook will be triggered.
	 */
	def createDataEdge(String ID, InternalNode source, InternalNode target){
		createDataEdge(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an DataEdge with generated id. Post create hook will be triggered.
	 */
	def createDataEdge(InternalNode source, InternalNode target){
		createDataEdge(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an DataEdge with the given id. Post create hook won't be triggered.
	 */
	def createDataEdge(String ID){
		createDataEdge(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an DataEdge with a generated id. Post create hook won't be triggered.
	 */
	override createDataEdge() {
		createDataEdge(generateUUID)
	}
	/**
	 * This method creates an DataContext with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDataContext(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDataContext => [
			setID(ID)
			internal = ime ?: createInternalDataContext => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.DataContextEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook won't be triggered.
	 */
	def createDataContext(String ID){
		createDataContext(ID,null,null,false)
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook will be triggered.
	 */
	def createDataContext(InternalModelElementContainer parent){
		createDataContext(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook will be triggered.
	 */
	def createDataContext(String ID, InternalModelElementContainer parent){
		createDataContext(ID,null,parent,true)
	}
	
	def createDataContext(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDataContext(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook won't be triggered.
	 */
	def createDataContext(InternalModelElement ime) {
		createDataContext(generateUUID,ime,null,false)
	}
	
	override createDataContext() {
		createDataContext(generateUUID)
	}
	/**
	 * This method creates an RealCompareOperator with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createRealCompareOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createRealCompareOperator => [
			setID(ID)
			internal = ime ?: createInternalRealCompareOperator => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.RealCompareOperatorEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an RealCompareOperator with the given id. Post create hook won't be triggered.
	 */
	def createRealCompareOperator(String ID){
		createRealCompareOperator(ID,null,null,false)
	}
	
	/**
	 * This method creates an RealCompareOperator with the given id. Post create hook will be triggered.
	 */
	def createRealCompareOperator(InternalModelElementContainer parent){
		createRealCompareOperator(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an RealCompareOperator with the given id. Post create hook will be triggered.
	 */
	def createRealCompareOperator(String ID, InternalModelElementContainer parent){
		createRealCompareOperator(ID,null,parent,true)
	}
	
	def createRealCompareOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createRealCompareOperator(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an RealCompareOperator with the given id. Post create hook won't be triggered.
	 */
	def createRealCompareOperator(InternalModelElement ime) {
		createRealCompareOperator(generateUUID,ime,null,false)
	}
	
	override createRealCompareOperator() {
		createRealCompareOperator(generateUUID)
	}
	/**
	 * This method creates an IntegerCompareOperator with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createIntegerCompareOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createIntegerCompareOperator => [
			setID(ID)
			internal = ime ?: createInternalIntegerCompareOperator => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.IntegerCompareOperatorEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an IntegerCompareOperator with the given id. Post create hook won't be triggered.
	 */
	def createIntegerCompareOperator(String ID){
		createIntegerCompareOperator(ID,null,null,false)
	}
	
	/**
	 * This method creates an IntegerCompareOperator with the given id. Post create hook will be triggered.
	 */
	def createIntegerCompareOperator(InternalModelElementContainer parent){
		createIntegerCompareOperator(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an IntegerCompareOperator with the given id. Post create hook will be triggered.
	 */
	def createIntegerCompareOperator(String ID, InternalModelElementContainer parent){
		createIntegerCompareOperator(ID,null,parent,true)
	}
	
	def createIntegerCompareOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createIntegerCompareOperator(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an IntegerCompareOperator with the given id. Post create hook won't be triggered.
	 */
	def createIntegerCompareOperator(InternalModelElement ime) {
		createIntegerCompareOperator(generateUUID,ime,null,false)
	}
	
	override createIntegerCompareOperator() {
		createIntegerCompareOperator(generateUUID)
	}
	/**
	 * This method creates an SearchInterface with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createSearchInterface(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createSearchInterface => [
			setID(ID)
			internal = ime ?: createInternalSearchInterface => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.SearchInterfaceEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an SearchInterface with the given id. Post create hook won't be triggered.
	 */
	def createSearchInterface(String ID){
		createSearchInterface(ID,null,null,false)
	}
	
	/**
	 * This method creates an SearchInterface with the given id. Post create hook will be triggered.
	 */
	def createSearchInterface(InternalModelElementContainer parent){
		createSearchInterface(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an SearchInterface with the given id. Post create hook will be triggered.
	 */
	def createSearchInterface(String ID, InternalModelElementContainer parent){
		createSearchInterface(ID,null,parent,true)
	}
	
	def createSearchInterface(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createSearchInterface(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an SearchInterface with the given id. Post create hook won't be triggered.
	 */
	def createSearchInterface(InternalModelElement ime) {
		createSearchInterface(generateUUID,ime,null,false)
	}
	
	override createSearchInterface() {
		createSearchInterface(generateUUID)
	}
	/**
	 * This method creates an PrimitiveInputParameter with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveInputParameter(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveInputParameter => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveInputParameter => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.PrimitiveInputParameterEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PrimitiveInputParameter with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputParameter(String ID){
		createPrimitiveInputParameter(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveInputParameter with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputParameter(InternalModelElementContainer parent){
		createPrimitiveInputParameter(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputParameter with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputParameter(String ID, InternalModelElementContainer parent){
		createPrimitiveInputParameter(ID,null,parent,true)
	}
	
	def createPrimitiveInputParameter(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveInputParameter(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputParameter with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputParameter(InternalModelElement ime) {
		createPrimitiveInputParameter(generateUUID,ime,null,false)
	}
	
	override createPrimitiveInputParameter() {
		createPrimitiveInputParameter(generateUUID)
	}
	/**
	 * This method creates an TimestampCompareOperator with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTimestampCompareOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTimestampCompareOperator => [
			setID(ID)
			internal = ime ?: createInternalTimestampCompareOperator => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.TimestampCompareOperatorEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an TimestampCompareOperator with the given id. Post create hook won't be triggered.
	 */
	def createTimestampCompareOperator(String ID){
		createTimestampCompareOperator(ID,null,null,false)
	}
	
	/**
	 * This method creates an TimestampCompareOperator with the given id. Post create hook will be triggered.
	 */
	def createTimestampCompareOperator(InternalModelElementContainer parent){
		createTimestampCompareOperator(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an TimestampCompareOperator with the given id. Post create hook will be triggered.
	 */
	def createTimestampCompareOperator(String ID, InternalModelElementContainer parent){
		createTimestampCompareOperator(ID,null,parent,true)
	}
	
	def createTimestampCompareOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTimestampCompareOperator(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an TimestampCompareOperator with the given id. Post create hook won't be triggered.
	 */
	def createTimestampCompareOperator(InternalModelElement ime) {
		createTimestampCompareOperator(generateUUID,ime,null,false)
	}
	
	override createTimestampCompareOperator() {
		createTimestampCompareOperator(generateUUID)
	}
	/**
	 * This method creates an TextCompareOperator with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTextCompareOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTextCompareOperator => [
			setID(ID)
			internal = ime ?: createInternalTextCompareOperator => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.TextCompareOperatorEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an TextCompareOperator with the given id. Post create hook won't be triggered.
	 */
	def createTextCompareOperator(String ID){
		createTextCompareOperator(ID,null,null,false)
	}
	
	/**
	 * This method creates an TextCompareOperator with the given id. Post create hook will be triggered.
	 */
	def createTextCompareOperator(InternalModelElementContainer parent){
		createTextCompareOperator(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an TextCompareOperator with the given id. Post create hook will be triggered.
	 */
	def createTextCompareOperator(String ID, InternalModelElementContainer parent){
		createTextCompareOperator(ID,null,parent,true)
	}
	
	def createTextCompareOperator(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTextCompareOperator(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an TextCompareOperator with the given id. Post create hook won't be triggered.
	 */
	def createTextCompareOperator(InternalModelElement ime) {
		createTextCompareOperator(generateUUID,ime,null,false)
	}
	
	override createTextCompareOperator() {
		createTextCompareOperator(generateUUID)
	}
	/**
	 * This method creates an ComplexOutputParameter with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexOutputParameter(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexOutputParameter => [
			setID(ID)
			internal = ime ?: createInternalComplexOutputParameter => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.search.adapter.ComplexOutputParameterEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexOutputParameter with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputParameter(String ID){
		createComplexOutputParameter(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexOutputParameter with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputParameter(InternalModelElementContainer parent){
		createComplexOutputParameter(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputParameter with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputParameter(String ID, InternalModelElementContainer parent){
		createComplexOutputParameter(ID,null,parent,true)
	}
	
	def createComplexOutputParameter(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexOutputParameter(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputParameter with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputParameter(InternalModelElement ime) {
		createComplexOutputParameter(generateUUID,ime,null,false)
	}
	
	override createComplexOutputParameter() {
		createComplexOutputParameter(generateUUID)
	}
	
	private def <T extends IdentifiableElement> setInternal(T elm, InternalIdentifiableElement internal) {
		elm => [
			if (id.isNullOrEmpty)
				ID = generateUUID
			switch elm {
				GraphModel: elm.setInternalElement_(internal as InternalGraphModel)
				ModelElement: elm.setInternalElement_(internal as InternalModelElement)
				Type: elm.setInternalElement_(internal as InternalType)
			}
		]
	}
	
	/**
	* This method creates a new Search object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can 
	* simply call the Search's save method to save your changes.
	*/
	def info.scce.dime.search.search.Search createSearch(java.lang.String path, java.lang.String fileName) {
		var filePath = new org.eclipse.core.runtime.Path(path).append(fileName).addFileExtension("search");
		var uri = org.eclipse.emf.common.util.URI.createPlatformResourceURI(filePath.toOSString(), true);
		var res = new org.eclipse.emf.ecore.resource.impl.ResourceSetImpl().createResource(uri);
		var graph = info.scce.dime.search.factory.SearchFactory.eINSTANCE.createSearch();
		
		org.eclipse.emf.ecore.util.EcoreUtil.setID(graph, org.eclipse.emf.ecore.util.EcoreUtil.generateUUID());

		res.getContents().add(graph.getInternalElement_());
		
		postCreates(graph);
		try {
			res.save(null);
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}

		return graph;
	}
	
	def postCreates(info.scce.dime.search.search.SearchConditional me) {
		me.transact [ // Post create hook
			new info.scce.dime.search.hooks.SearchConditionalPostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.search.search.ComplexOutputParameter me) {
		me.transact [ // Post create hook
			new info.scce.dime.search.hooks.ParameterPostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.search.search.PrimitiveInputParameter me) {
		me.transact [ // Post create hook
			new info.scce.dime.search.hooks.ParameterPostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.search.search.Search me) {
		me.transact [ // Post create hook
			new info.scce.dime.search.hooks.SearchInit().postCreate(me)
		]
	}
	
}
