package info.scce.dime.profile.factory

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

import info.scce.dime.profile.profile.ProfilePackage
import info.scce.dime.profile.profile.impl.ProfileFactoryImpl
import info.scce.dime.profile.profile.internal.InternalFactory
import info.scce.dime.profile.profile.internal.InternalPackage

import info.scce.dime.profile.profile.adapter.*

import graphmodel.internal.InternalModelElement
import graphmodel.internal.InternalModelElementContainer
import graphmodel.internal.InternalGraphModel
import graphmodel.internal.InternalContainer
import graphmodel.internal.InternalNode
import graphmodel.internal.InternalEdge
import graphmodel.internal.InternalType
import graphmodel.internal.InternalIdentifiableElement
import graphmodel.ModelElement
import graphmodel.IdentifiableElement
import graphmodel.GraphModel
import graphmodel.Type

import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EPackage
import org.eclipse.emf.ecore.plugin.EcorePlugin

class ProfileFactory extends ProfileFactoryImpl {
	
	final extension InternalFactory = InternalFactory.eINSTANCE
	public static ProfileFactory eINSTANCE = ProfileFactory.init
	
	extension de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension = new de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension
	
	static def ProfileFactory init() {
		try {
			val fct = EPackage::Registry.INSTANCE.getEFactory(ProfilePackage.eNS_URI) as ProfileFactory
			if (fct !== null)
				return fct as ProfileFactory
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		new ProfileFactory
	}
	
	/**
	 * This method creates an OutputGenericReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createOutputGenericReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createOutputGenericReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalOutputGenericReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.OutputGenericReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an OutputGenericReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createOutputGenericReferencingOutputPort(String ID){
		createOutputGenericReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an OutputGenericReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createOutputGenericReferencingOutputPort(InternalModelElementContainer parent){
		createOutputGenericReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an OutputGenericReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createOutputGenericReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createOutputGenericReferencingOutputPort(ID,null,parent,true)
	}
	
	def createOutputGenericReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createOutputGenericReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an OutputGenericReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createOutputGenericReferencingOutputPort(InternalModelElement ime) {
		createOutputGenericReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createOutputGenericReferencingOutputPort() {
		createOutputGenericReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an ComplexOutputPortReferencingInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexOutputPortReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexOutputPortReferencingInputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexOutputPortReferencingInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.ComplexOutputPortReferencingInputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexOutputPortReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputPortReferencingInputPort(String ID){
		createComplexOutputPortReferencingInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexOutputPortReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputPortReferencingInputPort(InternalModelElementContainer parent){
		createComplexOutputPortReferencingInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputPortReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputPortReferencingInputPort(String ID, InternalModelElementContainer parent){
		createComplexOutputPortReferencingInputPort(ID,null,parent,true)
	}
	
	def createComplexOutputPortReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexOutputPortReferencingInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputPortReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputPortReferencingInputPort(InternalModelElement ime) {
		createComplexOutputPortReferencingInputPort(generateUUID,ime,null,false)
	}
	
	override createComplexOutputPortReferencingInputPort() {
		createComplexOutputPortReferencingInputPort(generateUUID)
	}
	/**
	 * This method creates an GUIComplexOutputPortReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUIComplexOutputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGUIComplexOutputPortReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalGUIComplexOutputPortReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.GUIComplexOutputPortReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an GUIComplexOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createGUIComplexOutputPortReferencingOutputPort(String ID){
		createGUIComplexOutputPortReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an GUIComplexOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createGUIComplexOutputPortReferencingOutputPort(InternalModelElementContainer parent){
		createGUIComplexOutputPortReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GUIComplexOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createGUIComplexOutputPortReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createGUIComplexOutputPortReferencingOutputPort(ID,null,parent,true)
	}
	
	def createGUIComplexOutputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGUIComplexOutputPortReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GUIComplexOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createGUIComplexOutputPortReferencingOutputPort(InternalModelElement ime) {
		createGUIComplexOutputPortReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createGUIComplexOutputPortReferencingOutputPort() {
		createGUIComplexOutputPortReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an PrimitiveInputPortReferencingInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveInputPortReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveInputPortReferencingInputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveInputPortReferencingInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.PrimitiveInputPortReferencingInputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveInputPortReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputPortReferencingInputPort(String ID){
		createPrimitiveInputPortReferencingInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveInputPortReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputPortReferencingInputPort(InternalModelElementContainer parent){
		createPrimitiveInputPortReferencingInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputPortReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputPortReferencingInputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveInputPortReferencingInputPort(ID,null,parent,true)
	}
	
	def createPrimitiveInputPortReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveInputPortReferencingInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputPortReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputPortReferencingInputPort(InternalModelElement ime) {
		createPrimitiveInputPortReferencingInputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveInputPortReferencingInputPort() {
		createPrimitiveInputPortReferencingInputPort(generateUUID)
	}
	def createOutputPortMapping(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createOutputPortMapping => [
			setID(ID)
			internal = ime ?: createInternalOutputPortMapping => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.profile.adapter.OutputPortMappingEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an OutputPortMapping with the given id. Post create hook will be triggered.
	 */
	def createOutputPortMapping(String ID, InternalNode source, InternalNode target){
		createOutputPortMapping(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an OutputPortMapping with generated id. Post create hook will be triggered.
	 */
	def createOutputPortMapping(InternalNode source, InternalNode target){
		createOutputPortMapping(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an OutputPortMapping with the given id. Post create hook won't be triggered.
	 */
	def createOutputPortMapping(String ID){
		createOutputPortMapping(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an OutputPortMapping with a generated id. Post create hook won't be triggered.
	 */
	override createOutputPortMapping() {
		createOutputPortMapping(generateUUID)
	}
	/**
	 * This method creates an ComplexVariableReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexVariableReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexVariableReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexVariableReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.ComplexVariableReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexVariableReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexVariableReferencingOutputPort(String ID){
		createComplexVariableReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexVariableReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexVariableReferencingOutputPort(InternalModelElementContainer parent){
		createComplexVariableReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexVariableReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexVariableReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createComplexVariableReferencingOutputPort(ID,null,parent,true)
	}
	
	def createComplexVariableReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexVariableReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexVariableReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexVariableReferencingOutputPort(InternalModelElement ime) {
		createComplexVariableReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createComplexVariableReferencingOutputPort() {
		createComplexVariableReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an ProcessSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProcessSIB => [
			setID(ID)
			internal = ime ?: createInternalProcessSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.ProcessSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessSIB(String ID){
		createProcessSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessSIB(InternalModelElementContainer parent){
		createProcessSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessSIB(String ID, InternalModelElementContainer parent){
		createProcessSIB(ID,null,parent,true)
	}
	
	def createProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProcessSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessSIB(InternalModelElement ime) {
		createProcessSIB(generateUUID,ime,null,false)
	}
	
	override createProcessSIB() {
		createProcessSIB(generateUUID)
	}
	/**
	 * This method creates an AddToSubmissionReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createAddToSubmissionReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createAddToSubmissionReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalAddToSubmissionReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.AddToSubmissionReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an AddToSubmissionReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createAddToSubmissionReferencingOutputPort(String ID){
		createAddToSubmissionReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an AddToSubmissionReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createAddToSubmissionReferencingOutputPort(InternalModelElementContainer parent){
		createAddToSubmissionReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an AddToSubmissionReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createAddToSubmissionReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createAddToSubmissionReferencingOutputPort(ID,null,parent,true)
	}
	
	def createAddToSubmissionReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createAddToSubmissionReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an AddToSubmissionReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createAddToSubmissionReferencingOutputPort(InternalModelElement ime) {
		createAddToSubmissionReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createAddToSubmissionReferencingOutputPort() {
		createAddToSubmissionReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an ComplexInputPortReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexInputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexInputPortReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexInputPortReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.ComplexInputPortReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexInputPortReferencingOutputPort(String ID){
		createComplexInputPortReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexInputPortReferencingOutputPort(InternalModelElementContainer parent){
		createComplexInputPortReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexInputPortReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createComplexInputPortReferencingOutputPort(ID,null,parent,true)
	}
	
	def createComplexInputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexInputPortReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexInputPortReferencingOutputPort(InternalModelElement ime) {
		createComplexInputPortReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createComplexInputPortReferencingOutputPort() {
		createComplexInputPortReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an OutputReferencingBranch with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createOutputReferencingBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createOutputReferencingBranch => [
			setID(ID)
			internal = ime ?: createInternalOutputReferencingBranch => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.OutputReferencingBranchEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an OutputReferencingBranch with the given id. Post create hook won't be triggered.
	 */
	def createOutputReferencingBranch(String ID){
		createOutputReferencingBranch(ID,null,null,false)
	}
	
	/**
	 * This method creates an OutputReferencingBranch with the given id. Post create hook will be triggered.
	 */
	def createOutputReferencingBranch(InternalModelElementContainer parent){
		createOutputReferencingBranch(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an OutputReferencingBranch with the given id. Post create hook will be triggered.
	 */
	def createOutputReferencingBranch(String ID, InternalModelElementContainer parent){
		createOutputReferencingBranch(ID,null,parent,true)
	}
	
	def createOutputReferencingBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createOutputReferencingBranch(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an OutputReferencingBranch with the given id. Post create hook won't be triggered.
	 */
	def createOutputReferencingBranch(InternalModelElement ime) {
		createOutputReferencingBranch(generateUUID,ime,null,false)
	}
	
	override createOutputReferencingBranch() {
		createOutputReferencingBranch(generateUUID)
	}
	/**
	 * This method creates an GUIPrimitiveOutputPortReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUIPrimitiveOutputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGUIPrimitiveOutputPortReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalGUIPrimitiveOutputPortReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.GUIPrimitiveOutputPortReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an GUIPrimitiveOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createGUIPrimitiveOutputPortReferencingOutputPort(String ID){
		createGUIPrimitiveOutputPortReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an GUIPrimitiveOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createGUIPrimitiveOutputPortReferencingOutputPort(InternalModelElementContainer parent){
		createGUIPrimitiveOutputPortReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GUIPrimitiveOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createGUIPrimitiveOutputPortReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createGUIPrimitiveOutputPortReferencingOutputPort(ID,null,parent,true)
	}
	
	def createGUIPrimitiveOutputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGUIPrimitiveOutputPortReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GUIPrimitiveOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createGUIPrimitiveOutputPortReferencingOutputPort(InternalModelElement ime) {
		createGUIPrimitiveOutputPortReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createGUIPrimitiveOutputPortReferencingOutputPort() {
		createGUIPrimitiveOutputPortReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an Profile with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProfile(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProfile => [ 
			setID(ID)
			internal = ime ?: createInternalProfile => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.profile.adapter.ProfileEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Profile with the given id. Post create hook won't be triggered.
	 */
	def createProfile(String ID){
		createProfile(ID,null,null,false)
	}
	
	/**
	 * This method creates an Profile with the given id. Post create hook will be triggered.
	 */
	def createProfile(InternalModelElementContainer parent){
		createProfile(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Profile with the given id. Post create hook will be triggered.
	 */
	def createProfile(String ID, InternalModelElementContainer parent){
		createProfile(ID,null,parent,true)
	}
	
	def createProfile(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProfile(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Profile with the given id. Post create hook won't be triggered.
	 */
	def createProfile(InternalModelElement ime) {
		createProfile(generateUUID,ime,null,false)
	}
	
	override createProfile() {
		createProfile(generateUUID)
	}
	/**
	 * This method creates an AbstractParameterReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createAbstractParameterReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createAbstractParameterReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalAbstractParameterReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.AbstractParameterReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an AbstractParameterReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createAbstractParameterReferencingOutputPort(String ID){
		createAbstractParameterReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an AbstractParameterReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createAbstractParameterReferencingOutputPort(InternalModelElementContainer parent){
		createAbstractParameterReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an AbstractParameterReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createAbstractParameterReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createAbstractParameterReferencingOutputPort(ID,null,parent,true)
	}
	
	def createAbstractParameterReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createAbstractParameterReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an AbstractParameterReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createAbstractParameterReferencingOutputPort(InternalModelElement ime) {
		createAbstractParameterReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createAbstractParameterReferencingOutputPort() {
		createAbstractParameterReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an ButtonReferencingBranch with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createButtonReferencingBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createButtonReferencingBranch => [
			setID(ID)
			internal = ime ?: createInternalButtonReferencingBranch => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.ButtonReferencingBranchEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ButtonReferencingBranch with the given id. Post create hook won't be triggered.
	 */
	def createButtonReferencingBranch(String ID){
		createButtonReferencingBranch(ID,null,null,false)
	}
	
	/**
	 * This method creates an ButtonReferencingBranch with the given id. Post create hook will be triggered.
	 */
	def createButtonReferencingBranch(InternalModelElementContainer parent){
		createButtonReferencingBranch(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ButtonReferencingBranch with the given id. Post create hook will be triggered.
	 */
	def createButtonReferencingBranch(String ID, InternalModelElementContainer parent){
		createButtonReferencingBranch(ID,null,parent,true)
	}
	
	def createButtonReferencingBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createButtonReferencingBranch(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ButtonReferencingBranch with the given id. Post create hook won't be triggered.
	 */
	def createButtonReferencingBranch(InternalModelElement ime) {
		createButtonReferencingBranch(generateUUID,ime,null,false)
	}
	
	override createButtonReferencingBranch() {
		createButtonReferencingBranch(generateUUID)
	}
	/**
	 * This method creates an PrimitiveVariableReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveVariableReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveVariableReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveVariableReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.PrimitiveVariableReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveVariableReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveVariableReferencingOutputPort(String ID){
		createPrimitiveVariableReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveVariableReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveVariableReferencingOutputPort(InternalModelElementContainer parent){
		createPrimitiveVariableReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveVariableReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveVariableReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveVariableReferencingOutputPort(ID,null,parent,true)
	}
	
	def createPrimitiveVariableReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveVariableReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveVariableReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveVariableReferencingOutputPort(InternalModelElement ime) {
		createPrimitiveVariableReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveVariableReferencingOutputPort() {
		createPrimitiveVariableReferencingOutputPort(generateUUID)
	}
	def createReplacementCondition(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createReplacementCondition => [
			setID(ID)
			internal = ime ?: createInternalReplacementCondition => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.profile.adapter.ReplacementConditionEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ReplacementCondition with the given id. Post create hook will be triggered.
	 */
	def createReplacementCondition(String ID, InternalNode source, InternalNode target){
		createReplacementCondition(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ReplacementCondition with generated id. Post create hook will be triggered.
	 */
	def createReplacementCondition(InternalNode source, InternalNode target){
		createReplacementCondition(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ReplacementCondition with the given id. Post create hook won't be triggered.
	 */
	def createReplacementCondition(String ID){
		createReplacementCondition(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ReplacementCondition with a generated id. Post create hook won't be triggered.
	 */
	override createReplacementCondition() {
		createReplacementCondition(generateUUID)
	}
	def createInputPortMapping(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createInputPortMapping => [
			setID(ID)
			internal = ime ?: createInternalInputPortMapping => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.profile.adapter.InputPortMappingEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an InputPortMapping with the given id. Post create hook will be triggered.
	 */
	def createInputPortMapping(String ID, InternalNode source, InternalNode target){
		createInputPortMapping(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an InputPortMapping with generated id. Post create hook will be triggered.
	 */
	def createInputPortMapping(InternalNode source, InternalNode target){
		createInputPortMapping(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an InputPortMapping with the given id. Post create hook won't be triggered.
	 */
	def createInputPortMapping(String ID){
		createInputPortMapping(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an InputPortMapping with a generated id. Post create hook won't be triggered.
	 */
	override createInputPortMapping() {
		createInputPortMapping(generateUUID)
	}
	/**
	 * This method creates an PrimitiveInputPortReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveInputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveInputPortReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveInputPortReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.PrimitiveInputPortReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputPortReferencingOutputPort(String ID){
		createPrimitiveInputPortReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputPortReferencingOutputPort(InternalModelElementContainer parent){
		createPrimitiveInputPortReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputPortReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveInputPortReferencingOutputPort(ID,null,parent,true)
	}
	
	def createPrimitiveInputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveInputPortReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputPortReferencingOutputPort(InternalModelElement ime) {
		createPrimitiveInputPortReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveInputPortReferencingOutputPort() {
		createPrimitiveInputPortReferencingOutputPort(generateUUID)
	}
	def createSIBReplacement(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createSIBReplacement => [
			setID(ID)
			internal = ime ?: createInternalSIBReplacement => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.profile.adapter.SIBReplacementEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an SIBReplacement with the given id. Post create hook will be triggered.
	 */
	def createSIBReplacement(String ID, InternalNode source, InternalNode target){
		createSIBReplacement(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an SIBReplacement with generated id. Post create hook will be triggered.
	 */
	def createSIBReplacement(InternalNode source, InternalNode target){
		createSIBReplacement(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an SIBReplacement with the given id. Post create hook won't be triggered.
	 */
	def createSIBReplacement(String ID){
		createSIBReplacement(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an SIBReplacement with a generated id. Post create hook won't be triggered.
	 */
	override createSIBReplacement() {
		createSIBReplacement(generateUUID)
	}
	def createBranchReplacement(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createBranchReplacement => [
			setID(ID)
			internal = ime ?: createInternalBranchReplacement => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.profile.adapter.BranchReplacementEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an BranchReplacement with the given id. Post create hook will be triggered.
	 */
	def createBranchReplacement(String ID, InternalNode source, InternalNode target){
		createBranchReplacement(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an BranchReplacement with generated id. Post create hook will be triggered.
	 */
	def createBranchReplacement(InternalNode source, InternalNode target){
		createBranchReplacement(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an BranchReplacement with the given id. Post create hook won't be triggered.
	 */
	def createBranchReplacement(String ID){
		createBranchReplacement(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an BranchReplacement with a generated id. Post create hook won't be triggered.
	 */
	override createBranchReplacement() {
		createBranchReplacement(generateUUID)
	}
	/**
	 * This method creates an BranchReferencingBranch with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBranchReferencingBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBranchReferencingBranch => [
			setID(ID)
			internal = ime ?: createInternalBranchReferencingBranch => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.BranchReferencingBranchEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an BranchReferencingBranch with the given id. Post create hook won't be triggered.
	 */
	def createBranchReferencingBranch(String ID){
		createBranchReferencingBranch(ID,null,null,false)
	}
	
	/**
	 * This method creates an BranchReferencingBranch with the given id. Post create hook will be triggered.
	 */
	def createBranchReferencingBranch(InternalModelElementContainer parent){
		createBranchReferencingBranch(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an BranchReferencingBranch with the given id. Post create hook will be triggered.
	 */
	def createBranchReferencingBranch(String ID, InternalModelElementContainer parent){
		createBranchReferencingBranch(ID,null,parent,true)
	}
	
	def createBranchReferencingBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBranchReferencingBranch(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an BranchReferencingBranch with the given id. Post create hook won't be triggered.
	 */
	def createBranchReferencingBranch(InternalModelElement ime) {
		createBranchReferencingBranch(generateUUID,ime,null,false)
	}
	
	override createBranchReferencingBranch() {
		createBranchReferencingBranch(generateUUID)
	}
	/**
	 * This method creates an ComplexInputPortReferencingInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexInputPortReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexInputPortReferencingInputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexInputPortReferencingInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.ComplexInputPortReferencingInputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexInputPortReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexInputPortReferencingInputPort(String ID){
		createComplexInputPortReferencingInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexInputPortReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexInputPortReferencingInputPort(InternalModelElementContainer parent){
		createComplexInputPortReferencingInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexInputPortReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexInputPortReferencingInputPort(String ID, InternalModelElementContainer parent){
		createComplexInputPortReferencingInputPort(ID,null,parent,true)
	}
	
	def createComplexInputPortReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexInputPortReferencingInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexInputPortReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexInputPortReferencingInputPort(InternalModelElement ime) {
		createComplexInputPortReferencingInputPort(generateUUID,ime,null,false)
	}
	
	override createComplexInputPortReferencingInputPort() {
		createComplexInputPortReferencingInputPort(generateUUID)
	}
	/**
	 * This method creates an ComplexVariableReferencingInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexVariableReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexVariableReferencingInputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexVariableReferencingInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.ComplexVariableReferencingInputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexVariableReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexVariableReferencingInputPort(String ID){
		createComplexVariableReferencingInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexVariableReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexVariableReferencingInputPort(InternalModelElementContainer parent){
		createComplexVariableReferencingInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexVariableReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexVariableReferencingInputPort(String ID, InternalModelElementContainer parent){
		createComplexVariableReferencingInputPort(ID,null,parent,true)
	}
	
	def createComplexVariableReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexVariableReferencingInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexVariableReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexVariableReferencingInputPort(InternalModelElement ime) {
		createComplexVariableReferencingInputPort(generateUUID,ime,null,false)
	}
	
	override createComplexVariableReferencingInputPort() {
		createComplexVariableReferencingInputPort(generateUUID)
	}
	/**
	 * This method creates an ProcessBlueprintSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProcessBlueprintSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProcessBlueprintSIB => [
			setID(ID)
			internal = ime ?: createInternalProcessBlueprintSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.ProcessBlueprintSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ProcessBlueprintSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessBlueprintSIB(String ID){
		createProcessBlueprintSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProcessBlueprintSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessBlueprintSIB(InternalModelElementContainer parent){
		createProcessBlueprintSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProcessBlueprintSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessBlueprintSIB(String ID, InternalModelElementContainer parent){
		createProcessBlueprintSIB(ID,null,parent,true)
	}
	
	def createProcessBlueprintSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProcessBlueprintSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProcessBlueprintSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessBlueprintSIB(InternalModelElement ime) {
		createProcessBlueprintSIB(generateUUID,ime,null,false)
	}
	
	override createProcessBlueprintSIB() {
		createProcessBlueprintSIB(generateUUID)
	}
	/**
	 * This method creates an PrimitiveOutputPortReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveOutputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveOutputPortReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveOutputPortReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.PrimitiveOutputPortReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveOutputPortReferencingOutputPort(String ID){
		createPrimitiveOutputPortReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveOutputPortReferencingOutputPort(InternalModelElementContainer parent){
		createPrimitiveOutputPortReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveOutputPortReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveOutputPortReferencingOutputPort(ID,null,parent,true)
	}
	
	def createPrimitiveOutputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveOutputPortReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveOutputPortReferencingOutputPort(InternalModelElement ime) {
		createPrimitiveOutputPortReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveOutputPortReferencingOutputPort() {
		createPrimitiveOutputPortReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an GUISIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUISIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGUISIB => [
			setID(ID)
			internal = ime ?: createInternalGUISIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.GUISIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook won't be triggered.
	 */
	def createGUISIB(String ID){
		createGUISIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook will be triggered.
	 */
	def createGUISIB(InternalModelElementContainer parent){
		createGUISIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook will be triggered.
	 */
	def createGUISIB(String ID, InternalModelElementContainer parent){
		createGUISIB(ID,null,parent,true)
	}
	
	def createGUISIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGUISIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook won't be triggered.
	 */
	def createGUISIB(InternalModelElement ime) {
		createGUISIB(generateUUID,ime,null,false)
	}
	
	override createGUISIB() {
		createGUISIB(generateUUID)
	}
	/**
	 * This method creates an ComplexOutputPortReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexOutputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexOutputPortReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexOutputPortReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.ComplexOutputPortReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputPortReferencingOutputPort(String ID){
		createComplexOutputPortReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputPortReferencingOutputPort(InternalModelElementContainer parent){
		createComplexOutputPortReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputPortReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createComplexOutputPortReferencingOutputPort(ID,null,parent,true)
	}
	
	def createComplexOutputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexOutputPortReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputPortReferencingOutputPort(InternalModelElement ime) {
		createComplexOutputPortReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createComplexOutputPortReferencingOutputPort() {
		createComplexOutputPortReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an PrimitiveVariableReferencingInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveVariableReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveVariableReferencingInputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveVariableReferencingInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.PrimitiveVariableReferencingInputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveVariableReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveVariableReferencingInputPort(String ID){
		createPrimitiveVariableReferencingInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveVariableReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveVariableReferencingInputPort(InternalModelElementContainer parent){
		createPrimitiveVariableReferencingInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveVariableReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveVariableReferencingInputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveVariableReferencingInputPort(ID,null,parent,true)
	}
	
	def createPrimitiveVariableReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveVariableReferencingInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveVariableReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveVariableReferencingInputPort(InternalModelElement ime) {
		createPrimitiveVariableReferencingInputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveVariableReferencingInputPort() {
		createPrimitiveVariableReferencingInputPort(generateUUID)
	}
	/**
	 * This method creates an BlueprintBranch with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBlueprintBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBlueprintBranch => [
			setID(ID)
			internal = ime ?: createInternalBlueprintBranch => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.BlueprintBranchEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an BlueprintBranch with the given id. Post create hook won't be triggered.
	 */
	def createBlueprintBranch(String ID){
		createBlueprintBranch(ID,null,null,false)
	}
	
	/**
	 * This method creates an BlueprintBranch with the given id. Post create hook will be triggered.
	 */
	def createBlueprintBranch(InternalModelElementContainer parent){
		createBlueprintBranch(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an BlueprintBranch with the given id. Post create hook will be triggered.
	 */
	def createBlueprintBranch(String ID, InternalModelElementContainer parent){
		createBlueprintBranch(ID,null,parent,true)
	}
	
	def createBlueprintBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBlueprintBranch(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an BlueprintBranch with the given id. Post create hook won't be triggered.
	 */
	def createBlueprintBranch(InternalModelElement ime) {
		createBlueprintBranch(generateUUID,ime,null,false)
	}
	
	override createBlueprintBranch() {
		createBlueprintBranch(generateUUID)
	}
	/**
	 * This method creates an GUIBlueprintSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUIBlueprintSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGUIBlueprintSIB => [
			setID(ID)
			internal = ime ?: createInternalGUIBlueprintSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.GUIBlueprintSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GUIBlueprintSIB with the given id. Post create hook won't be triggered.
	 */
	def createGUIBlueprintSIB(String ID){
		createGUIBlueprintSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an GUIBlueprintSIB with the given id. Post create hook will be triggered.
	 */
	def createGUIBlueprintSIB(InternalModelElementContainer parent){
		createGUIBlueprintSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GUIBlueprintSIB with the given id. Post create hook will be triggered.
	 */
	def createGUIBlueprintSIB(String ID, InternalModelElementContainer parent){
		createGUIBlueprintSIB(ID,null,parent,true)
	}
	
	def createGUIBlueprintSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGUIBlueprintSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GUIBlueprintSIB with the given id. Post create hook won't be triggered.
	 */
	def createGUIBlueprintSIB(InternalModelElement ime) {
		createGUIBlueprintSIB(generateUUID,ime,null,false)
	}
	
	override createGUIBlueprintSIB() {
		createGUIBlueprintSIB(generateUUID)
	}
	/**
	 * This method creates an PrimitiveOutputPortReferencingInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveOutputPortReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveOutputPortReferencingInputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveOutputPortReferencingInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.PrimitiveOutputPortReferencingInputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveOutputPortReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveOutputPortReferencingInputPort(String ID){
		createPrimitiveOutputPortReferencingInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveOutputPortReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveOutputPortReferencingInputPort(InternalModelElementContainer parent){
		createPrimitiveOutputPortReferencingInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveOutputPortReferencingInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveOutputPortReferencingInputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveOutputPortReferencingInputPort(ID,null,parent,true)
	}
	
	def createPrimitiveOutputPortReferencingInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveOutputPortReferencingInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveOutputPortReferencingInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveOutputPortReferencingInputPort(InternalModelElement ime) {
		createPrimitiveOutputPortReferencingInputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveOutputPortReferencingInputPort() {
		createPrimitiveOutputPortReferencingInputPort(generateUUID)
	}
	/**
	 * This method creates an ComplexAttributeReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexAttributeReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexAttributeReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexAttributeReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.ComplexAttributeReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexAttributeReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttributeReferencingOutputPort(String ID){
		createComplexAttributeReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexAttributeReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexAttributeReferencingOutputPort(InternalModelElementContainer parent){
		createComplexAttributeReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexAttributeReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexAttributeReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createComplexAttributeReferencingOutputPort(ID,null,parent,true)
	}
	
	def createComplexAttributeReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexAttributeReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexAttributeReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttributeReferencingOutputPort(InternalModelElement ime) {
		createComplexAttributeReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createComplexAttributeReferencingOutputPort() {
		createComplexAttributeReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an DoNotReplace with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDoNotReplace(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDoNotReplace => [
			setID(ID)
			internal = ime ?: createInternalDoNotReplace => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.DoNotReplaceEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an DoNotReplace with the given id. Post create hook won't be triggered.
	 */
	def createDoNotReplace(String ID){
		createDoNotReplace(ID,null,null,false)
	}
	
	/**
	 * This method creates an DoNotReplace with the given id. Post create hook will be triggered.
	 */
	def createDoNotReplace(InternalModelElementContainer parent){
		createDoNotReplace(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an DoNotReplace with the given id. Post create hook will be triggered.
	 */
	def createDoNotReplace(String ID, InternalModelElementContainer parent){
		createDoNotReplace(ID,null,parent,true)
	}
	
	def createDoNotReplace(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDoNotReplace(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an DoNotReplace with the given id. Post create hook won't be triggered.
	 */
	def createDoNotReplace(InternalModelElement ime) {
		createDoNotReplace(generateUUID,ime,null,false)
	}
	
	override createDoNotReplace() {
		createDoNotReplace(generateUUID)
	}
	/**
	 * This method creates an GUIPrimitiveInputPortReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUIPrimitiveInputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGUIPrimitiveInputPortReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalGUIPrimitiveInputPortReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.GUIPrimitiveInputPortReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an GUIPrimitiveInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createGUIPrimitiveInputPortReferencingOutputPort(String ID){
		createGUIPrimitiveInputPortReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an GUIPrimitiveInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createGUIPrimitiveInputPortReferencingOutputPort(InternalModelElementContainer parent){
		createGUIPrimitiveInputPortReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GUIPrimitiveInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createGUIPrimitiveInputPortReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createGUIPrimitiveInputPortReferencingOutputPort(ID,null,parent,true)
	}
	
	def createGUIPrimitiveInputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGUIPrimitiveInputPortReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GUIPrimitiveInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createGUIPrimitiveInputPortReferencingOutputPort(InternalModelElement ime) {
		createGUIPrimitiveInputPortReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createGUIPrimitiveInputPortReferencingOutputPort() {
		createGUIPrimitiveInputPortReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an GUIComplexInputPortReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUIComplexInputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGUIComplexInputPortReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalGUIComplexInputPortReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.GUIComplexInputPortReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an GUIComplexInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createGUIComplexInputPortReferencingOutputPort(String ID){
		createGUIComplexInputPortReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an GUIComplexInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createGUIComplexInputPortReferencingOutputPort(InternalModelElementContainer parent){
		createGUIComplexInputPortReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GUIComplexInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createGUIComplexInputPortReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createGUIComplexInputPortReferencingOutputPort(ID,null,parent,true)
	}
	
	def createGUIComplexInputPortReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGUIComplexInputPortReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GUIComplexInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createGUIComplexInputPortReferencingOutputPort(InternalModelElement ime) {
		createGUIComplexInputPortReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createGUIComplexInputPortReferencingOutputPort() {
		createGUIComplexInputPortReferencingOutputPort(generateUUID)
	}
	/**
	 * This method creates an EndSIBReferencingBranch with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createEndSIBReferencingBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createEndSIBReferencingBranch => [
			setID(ID)
			internal = ime ?: createInternalEndSIBReferencingBranch => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.EndSIBReferencingBranchEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an EndSIBReferencingBranch with the given id. Post create hook won't be triggered.
	 */
	def createEndSIBReferencingBranch(String ID){
		createEndSIBReferencingBranch(ID,null,null,false)
	}
	
	/**
	 * This method creates an EndSIBReferencingBranch with the given id. Post create hook will be triggered.
	 */
	def createEndSIBReferencingBranch(InternalModelElementContainer parent){
		createEndSIBReferencingBranch(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an EndSIBReferencingBranch with the given id. Post create hook will be triggered.
	 */
	def createEndSIBReferencingBranch(String ID, InternalModelElementContainer parent){
		createEndSIBReferencingBranch(ID,null,parent,true)
	}
	
	def createEndSIBReferencingBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createEndSIBReferencingBranch(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an EndSIBReferencingBranch with the given id. Post create hook won't be triggered.
	 */
	def createEndSIBReferencingBranch(InternalModelElement ime) {
		createEndSIBReferencingBranch(generateUUID,ime,null,false)
	}
	
	override createEndSIBReferencingBranch() {
		createEndSIBReferencingBranch(generateUUID)
	}
	/**
	 * This method creates an PrimitiveAttributeReferencingOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveAttributeReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveAttributeReferencingOutputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveAttributeReferencingOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.profile.adapter.PrimitiveAttributeReferencingOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveAttributeReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAttributeReferencingOutputPort(String ID){
		createPrimitiveAttributeReferencingOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveAttributeReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAttributeReferencingOutputPort(InternalModelElementContainer parent){
		createPrimitiveAttributeReferencingOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAttributeReferencingOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAttributeReferencingOutputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveAttributeReferencingOutputPort(ID,null,parent,true)
	}
	
	def createPrimitiveAttributeReferencingOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveAttributeReferencingOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAttributeReferencingOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAttributeReferencingOutputPort(InternalModelElement ime) {
		createPrimitiveAttributeReferencingOutputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveAttributeReferencingOutputPort() {
		createPrimitiveAttributeReferencingOutputPort(generateUUID)
	}
	
	private def <T extends IdentifiableElement> setInternal(T elm, InternalIdentifiableElement internal) {
		elm => [
			if (id.isNullOrEmpty)
				ID = generateUUID
			switch elm {
				GraphModel: elm.setInternalElement_(internal as InternalGraphModel)
				ModelElement: elm.setInternalElement_(internal as InternalModelElement)
				Type: elm.setInternalElement_(internal as InternalType)
			}
		]
	}
	
	/**
	* This method creates a new Profile object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can 
	* simply call the Profile's save method to save your changes.
	*/
	def info.scce.dime.profile.profile.Profile createProfile(java.lang.String path, java.lang.String fileName) {
		var filePath = new org.eclipse.core.runtime.Path(path).append(fileName).addFileExtension("profile");
		var uri = org.eclipse.emf.common.util.URI.createPlatformResourceURI(filePath.toOSString(), true);
		var res = new org.eclipse.emf.ecore.resource.impl.ResourceSetImpl().createResource(uri);
		var graph = info.scce.dime.profile.factory.ProfileFactory.eINSTANCE.createProfile();
		
		org.eclipse.emf.ecore.util.EcoreUtil.setID(graph, org.eclipse.emf.ecore.util.EcoreUtil.generateUUID());

		res.getContents().add(graph.getInternalElement_());
		
		postCreates(graph);
		try {
			res.save(null);
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}

		return graph;
	}
	
	def postCreates(info.scce.dime.profile.profile.GUISIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.profile.hooks.PostCreateSIB().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.profile.profile.ProcessSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.profile.hooks.PostCreateSIB().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.profile.profile.ProcessBlueprintSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.profile.hooks.PostCreateSIB().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.profile.profile.GUIBlueprintSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.profile.hooks.PostCreateSIB().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.profile.profile.Profile me) {
		me.transact [ // Post create hook
			new info.scce.dime.profile.hooks.PostCreateProfile().postCreate(me)
		]
	}
	
}
