package info.scce.dime.process.factory

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

import info.scce.dime.process.process.ProcessPackage
import info.scce.dime.process.process.impl.ProcessFactoryImpl
import info.scce.dime.process.process.internal.InternalFactory
import info.scce.dime.process.process.internal.InternalPackage

import info.scce.dime.process.process.adapter.*

import graphmodel.internal.InternalModelElement
import graphmodel.internal.InternalModelElementContainer
import graphmodel.internal.InternalGraphModel
import graphmodel.internal.InternalContainer
import graphmodel.internal.InternalNode
import graphmodel.internal.InternalEdge
import graphmodel.internal.InternalType
import graphmodel.internal.InternalIdentifiableElement
import graphmodel.ModelElement
import graphmodel.IdentifiableElement
import graphmodel.GraphModel
import graphmodel.Type

import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EPackage
import org.eclipse.emf.ecore.plugin.EcorePlugin

class ProcessFactory extends ProcessFactoryImpl {
	
	final extension InternalFactory = InternalFactory.eINSTANCE
	public static ProcessFactory eINSTANCE = ProcessFactory.init
	
	extension de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension = new de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension
	
	static def ProcessFactory init() {
		try {
			val fct = EPackage::Registry.INSTANCE.getEFactory(ProcessPackage.eNS_URI) as ProcessFactory
			if (fct !== null)
				return fct as ProcessFactory
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		new ProcessFactory
	}
	
	/**
	 * This method creates an GuardedProcessSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGuardedProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGuardedProcessSIB => [
			setID(ID)
			internal = ime ?: createInternalGuardedProcessSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.GuardedProcessSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GuardedProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createGuardedProcessSIB(String ID){
		createGuardedProcessSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an GuardedProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createGuardedProcessSIB(InternalModelElementContainer parent){
		createGuardedProcessSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GuardedProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createGuardedProcessSIB(String ID, InternalModelElementContainer parent){
		createGuardedProcessSIB(ID,null,parent,true)
	}
	
	def createGuardedProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGuardedProcessSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GuardedProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createGuardedProcessSIB(InternalModelElement ime) {
		createGuardedProcessSIB(generateUUID,ime,null,false)
	}
	
	override createGuardedProcessSIB() {
		createGuardedProcessSIB(generateUUID)
	}
	/**
	 * This method creates an RetrieveCurrentUserSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createRetrieveCurrentUserSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createRetrieveCurrentUserSIB => [
			setID(ID)
			internal = ime ?: createInternalRetrieveCurrentUserSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.RetrieveCurrentUserSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an RetrieveCurrentUserSIB with the given id. Post create hook won't be triggered.
	 */
	def createRetrieveCurrentUserSIB(String ID){
		createRetrieveCurrentUserSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an RetrieveCurrentUserSIB with the given id. Post create hook will be triggered.
	 */
	def createRetrieveCurrentUserSIB(InternalModelElementContainer parent){
		createRetrieveCurrentUserSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an RetrieveCurrentUserSIB with the given id. Post create hook will be triggered.
	 */
	def createRetrieveCurrentUserSIB(String ID, InternalModelElementContainer parent){
		createRetrieveCurrentUserSIB(ID,null,parent,true)
	}
	
	def createRetrieveCurrentUserSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createRetrieveCurrentUserSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an RetrieveCurrentUserSIB with the given id. Post create hook won't be triggered.
	 */
	def createRetrieveCurrentUserSIB(InternalModelElement ime) {
		createRetrieveCurrentUserSIB(generateUUID,ime,null,false)
	}
	
	override createRetrieveCurrentUserSIB() {
		createRetrieveCurrentUserSIB(generateUUID)
	}
	/**
	 * This method creates an RetrieveEnumLiteralSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createRetrieveEnumLiteralSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createRetrieveEnumLiteralSIB => [
			setID(ID)
			internal = ime ?: createInternalRetrieveEnumLiteralSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.RetrieveEnumLiteralSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an RetrieveEnumLiteralSIB with the given id. Post create hook won't be triggered.
	 */
	def createRetrieveEnumLiteralSIB(String ID){
		createRetrieveEnumLiteralSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an RetrieveEnumLiteralSIB with the given id. Post create hook will be triggered.
	 */
	def createRetrieveEnumLiteralSIB(InternalModelElementContainer parent){
		createRetrieveEnumLiteralSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an RetrieveEnumLiteralSIB with the given id. Post create hook will be triggered.
	 */
	def createRetrieveEnumLiteralSIB(String ID, InternalModelElementContainer parent){
		createRetrieveEnumLiteralSIB(ID,null,parent,true)
	}
	
	def createRetrieveEnumLiteralSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createRetrieveEnumLiteralSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an RetrieveEnumLiteralSIB with the given id. Post create hook won't be triggered.
	 */
	def createRetrieveEnumLiteralSIB(InternalModelElement ime) {
		createRetrieveEnumLiteralSIB(generateUUID,ime,null,false)
	}
	
	override createRetrieveEnumLiteralSIB() {
		createRetrieveEnumLiteralSIB(generateUUID)
	}
	/**
	 * This method creates an DeleteSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDeleteSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDeleteSIB => [
			setID(ID)
			internal = ime ?: createInternalDeleteSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.DeleteSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an DeleteSIB with the given id. Post create hook won't be triggered.
	 */
	def createDeleteSIB(String ID){
		createDeleteSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an DeleteSIB with the given id. Post create hook will be triggered.
	 */
	def createDeleteSIB(InternalModelElementContainer parent){
		createDeleteSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an DeleteSIB with the given id. Post create hook will be triggered.
	 */
	def createDeleteSIB(String ID, InternalModelElementContainer parent){
		createDeleteSIB(ID,null,parent,true)
	}
	
	def createDeleteSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDeleteSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an DeleteSIB with the given id. Post create hook won't be triggered.
	 */
	def createDeleteSIB(InternalModelElement ime) {
		createDeleteSIB(generateUUID,ime,null,false)
	}
	
	override createDeleteSIB() {
		createDeleteSIB(generateUUID)
	}
	/**
	 * This method creates an ContainsSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createContainsSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createContainsSIB => [
			setID(ID)
			internal = ime ?: createInternalContainsSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ContainsSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ContainsSIB with the given id. Post create hook won't be triggered.
	 */
	def createContainsSIB(String ID){
		createContainsSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ContainsSIB with the given id. Post create hook will be triggered.
	 */
	def createContainsSIB(InternalModelElementContainer parent){
		createContainsSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ContainsSIB with the given id. Post create hook will be triggered.
	 */
	def createContainsSIB(String ID, InternalModelElementContainer parent){
		createContainsSIB(ID,null,parent,true)
	}
	
	def createContainsSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createContainsSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ContainsSIB with the given id. Post create hook won't be triggered.
	 */
	def createContainsSIB(InternalModelElement ime) {
		createContainsSIB(generateUUID,ime,null,false)
	}
	
	override createContainsSIB() {
		createContainsSIB(generateUUID)
	}
	def createComplexListAttributeConnector(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexListAttributeConnector => [
			setID(ID)
			internal = ime ?: createInternalComplexListAttributeConnector => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.ComplexListAttributeConnectorEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ComplexListAttributeConnector with the given id. Post create hook will be triggered.
	 */
	def createComplexListAttributeConnector(String ID, InternalNode source, InternalNode target){
		createComplexListAttributeConnector(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexListAttributeConnector with generated id. Post create hook will be triggered.
	 */
	def createComplexListAttributeConnector(InternalNode source, InternalNode target){
		createComplexListAttributeConnector(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexListAttributeConnector with the given id. Post create hook won't be triggered.
	 */
	def createComplexListAttributeConnector(String ID){
		createComplexListAttributeConnector(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexListAttributeConnector with a generated id. Post create hook won't be triggered.
	 */
	override createComplexListAttributeConnector() {
		createComplexListAttributeConnector(generateUUID)
	}
	/**
	 * This method creates an BranchBlueprint with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBranchBlueprint(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBranchBlueprint => [
			setID(ID)
			internal = ime ?: createInternalBranchBlueprint => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.BranchBlueprintEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an BranchBlueprint with the given id. Post create hook won't be triggered.
	 */
	def createBranchBlueprint(String ID){
		createBranchBlueprint(ID,null,null,false)
	}
	
	/**
	 * This method creates an BranchBlueprint with the given id. Post create hook will be triggered.
	 */
	def createBranchBlueprint(InternalModelElementContainer parent){
		createBranchBlueprint(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an BranchBlueprint with the given id. Post create hook will be triggered.
	 */
	def createBranchBlueprint(String ID, InternalModelElementContainer parent){
		createBranchBlueprint(ID,null,parent,true)
	}
	
	def createBranchBlueprint(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBranchBlueprint(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an BranchBlueprint with the given id. Post create hook won't be triggered.
	 */
	def createBranchBlueprint(InternalModelElement ime) {
		createBranchBlueprint(generateUUID,ime,null,false)
	}
	
	override createBranchBlueprint() {
		createBranchBlueprint(generateUUID)
	}
	/**
	 * This method creates an IntegerInputStatic with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createIntegerInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createIntegerInputStatic => [
			setID(ID)
			internal = ime ?: createInternalIntegerInputStatic => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.IntegerInputStaticEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an IntegerInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createIntegerInputStatic(String ID){
		createIntegerInputStatic(ID,null,null,false)
	}
	
	/**
	 * This method creates an IntegerInputStatic with the given id. Post create hook will be triggered.
	 */
	def createIntegerInputStatic(InternalModelElementContainer parent){
		createIntegerInputStatic(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an IntegerInputStatic with the given id. Post create hook will be triggered.
	 */
	def createIntegerInputStatic(String ID, InternalModelElementContainer parent){
		createIntegerInputStatic(ID,null,parent,true)
	}
	
	def createIntegerInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createIntegerInputStatic(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an IntegerInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createIntegerInputStatic(InternalModelElement ime) {
		createIntegerInputStatic(generateUUID,ime,null,false)
	}
	
	override createIntegerInputStatic() {
		createIntegerInputStatic(generateUUID)
	}
	/**
	 * This method creates an StartSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createStartSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createStartSIB => [
			setID(ID)
			internal = ime ?: createInternalStartSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.StartSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an StartSIB with the given id. Post create hook won't be triggered.
	 */
	def createStartSIB(String ID){
		createStartSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an StartSIB with the given id. Post create hook will be triggered.
	 */
	def createStartSIB(InternalModelElementContainer parent){
		createStartSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an StartSIB with the given id. Post create hook will be triggered.
	 */
	def createStartSIB(String ID, InternalModelElementContainer parent){
		createStartSIB(ID,null,parent,true)
	}
	
	def createStartSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createStartSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an StartSIB with the given id. Post create hook won't be triggered.
	 */
	def createStartSIB(InternalModelElement ime) {
		createStartSIB(generateUUID,ime,null,false)
	}
	
	override createStartSIB() {
		createStartSIB(generateUUID)
	}
	/**
	 * This method creates an TimestampInputStatic with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTimestampInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTimestampInputStatic => [
			setID(ID)
			internal = ime ?: createInternalTimestampInputStatic => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.TimestampInputStaticEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an TimestampInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createTimestampInputStatic(String ID){
		createTimestampInputStatic(ID,null,null,false)
	}
	
	/**
	 * This method creates an TimestampInputStatic with the given id. Post create hook will be triggered.
	 */
	def createTimestampInputStatic(InternalModelElementContainer parent){
		createTimestampInputStatic(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an TimestampInputStatic with the given id. Post create hook will be triggered.
	 */
	def createTimestampInputStatic(String ID, InternalModelElementContainer parent){
		createTimestampInputStatic(ID,null,parent,true)
	}
	
	def createTimestampInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTimestampInputStatic(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an TimestampInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createTimestampInputStatic(InternalModelElement ime) {
		createTimestampInputStatic(generateUUID,ime,null,false)
	}
	
	override createTimestampInputStatic() {
		createTimestampInputStatic(generateUUID)
	}
	/**
	 * This method creates an EndSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createEndSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createEndSIB => [
			setID(ID)
			internal = ime ?: createInternalEndSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.EndSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an EndSIB with the given id. Post create hook won't be triggered.
	 */
	def createEndSIB(String ID){
		createEndSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an EndSIB with the given id. Post create hook will be triggered.
	 */
	def createEndSIB(InternalModelElementContainer parent){
		createEndSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an EndSIB with the given id. Post create hook will be triggered.
	 */
	def createEndSIB(String ID, InternalModelElementContainer parent){
		createEndSIB(ID,null,parent,true)
	}
	
	def createEndSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createEndSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an EndSIB with the given id. Post create hook won't be triggered.
	 */
	def createEndSIB(InternalModelElement ime) {
		createEndSIB(generateUUID,ime,null,false)
	}
	
	override createEndSIB() {
		createEndSIB(generateUUID)
	}
	/**
	 * This method creates an LinkProcessSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createLinkProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createLinkProcessSIB => [
			setID(ID)
			internal = ime ?: createInternalLinkProcessSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.LinkProcessSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an LinkProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createLinkProcessSIB(String ID){
		createLinkProcessSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an LinkProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createLinkProcessSIB(InternalModelElementContainer parent){
		createLinkProcessSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an LinkProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createLinkProcessSIB(String ID, InternalModelElementContainer parent){
		createLinkProcessSIB(ID,null,parent,true)
	}
	
	def createLinkProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createLinkProcessSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an LinkProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createLinkProcessSIB(InternalModelElement ime) {
		createLinkProcessSIB(generateUUID,ime,null,false)
	}
	
	override createLinkProcessSIB() {
		createLinkProcessSIB(generateUUID)
	}
	/**
	 * This method creates an ComplexExtensionAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexExtensionAttribute => [
			setID(ID)
			internal = ime ?: createInternalComplexExtensionAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ComplexExtensionAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexExtensionAttribute(String ID){
		createComplexExtensionAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexExtensionAttribute(InternalModelElementContainer parent){
		createComplexExtensionAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexExtensionAttribute(String ID, InternalModelElementContainer parent){
		createComplexExtensionAttribute(ID,null,parent,true)
	}
	
	def createComplexExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexExtensionAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexExtensionAttribute(InternalModelElement ime) {
		createComplexExtensionAttribute(generateUUID,ime,null,false)
	}
	
	override createComplexExtensionAttribute() {
		createComplexExtensionAttribute(generateUUID)
	}
	/**
	 * This method creates an ComplexVariable with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexVariable => [
			setID(ID)
			internal = ime ?: createInternalComplexVariable => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ComplexVariableEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexVariable with the given id. Post create hook won't be triggered.
	 */
	def createComplexVariable(String ID){
		createComplexVariable(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexVariable with the given id. Post create hook will be triggered.
	 */
	def createComplexVariable(InternalModelElementContainer parent){
		createComplexVariable(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexVariable with the given id. Post create hook will be triggered.
	 */
	def createComplexVariable(String ID, InternalModelElementContainer parent){
		createComplexVariable(ID,null,parent,true)
	}
	
	def createComplexVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexVariable(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexVariable with the given id. Post create hook won't be triggered.
	 */
	def createComplexVariable(InternalModelElement ime) {
		createComplexVariable(generateUUID,ime,null,false)
	}
	
	override createComplexVariable() {
		createComplexVariable(generateUUID)
	}
	def createComplexDirectDataFlow(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexDirectDataFlow => [
			setID(ID)
			internal = ime ?: createInternalComplexDirectDataFlow => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.ComplexDirectDataFlowEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an ComplexDirectDataFlow with the given id. Post create hook will be triggered.
	 */
	def createComplexDirectDataFlow(String ID, InternalNode source, InternalNode target){
		createComplexDirectDataFlow(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexDirectDataFlow with generated id. Post create hook will be triggered.
	 */
	def createComplexDirectDataFlow(InternalNode source, InternalNode target){
		createComplexDirectDataFlow(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexDirectDataFlow with the given id. Post create hook won't be triggered.
	 */
	def createComplexDirectDataFlow(String ID){
		createComplexDirectDataFlow(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexDirectDataFlow with a generated id. Post create hook won't be triggered.
	 */
	override createComplexDirectDataFlow() {
		createComplexDirectDataFlow(generateUUID)
	}
	/**
	 * This method creates an ComplexListAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexListAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexListAttribute => [
			setID(ID)
			internal = ime ?: createInternalComplexListAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ComplexListAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexListAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexListAttribute(String ID){
		createComplexListAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexListAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexListAttribute(InternalModelElementContainer parent){
		createComplexListAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexListAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexListAttribute(String ID, InternalModelElementContainer parent){
		createComplexListAttribute(ID,null,parent,true)
	}
	
	def createComplexListAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexListAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexListAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexListAttribute(InternalModelElement ime) {
		createComplexListAttribute(generateUUID,ime,null,false)
	}
	
	override createComplexListAttribute() {
		createComplexListAttribute(generateUUID)
	}
	/**
	 * This method creates an ComplexAttributePort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexAttributePort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexAttributePort => [
			setID(ID)
			internal = ime ?: createInternalComplexAttributePort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ComplexAttributePortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexAttributePort with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttributePort(String ID){
		createComplexAttributePort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexAttributePort with the given id. Post create hook will be triggered.
	 */
	def createComplexAttributePort(InternalModelElementContainer parent){
		createComplexAttributePort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexAttributePort with the given id. Post create hook will be triggered.
	 */
	def createComplexAttributePort(String ID, InternalModelElementContainer parent){
		createComplexAttributePort(ID,null,parent,true)
	}
	
	def createComplexAttributePort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexAttributePort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexAttributePort with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttributePort(InternalModelElement ime) {
		createComplexAttributePort(generateUUID,ime,null,false)
	}
	
	override createComplexAttributePort() {
		createComplexAttributePort(generateUUID)
	}
	/**
	 * This method creates an GetOriginalUserSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGetOriginalUserSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGetOriginalUserSIB => [
			setID(ID)
			internal = ime ?: createInternalGetOriginalUserSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.GetOriginalUserSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GetOriginalUserSIB with the given id. Post create hook won't be triggered.
	 */
	def createGetOriginalUserSIB(String ID){
		createGetOriginalUserSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an GetOriginalUserSIB with the given id. Post create hook will be triggered.
	 */
	def createGetOriginalUserSIB(InternalModelElementContainer parent){
		createGetOriginalUserSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GetOriginalUserSIB with the given id. Post create hook will be triggered.
	 */
	def createGetOriginalUserSIB(String ID, InternalModelElementContainer parent){
		createGetOriginalUserSIB(ID,null,parent,true)
	}
	
	def createGetOriginalUserSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGetOriginalUserSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GetOriginalUserSIB with the given id. Post create hook won't be triggered.
	 */
	def createGetOriginalUserSIB(InternalModelElement ime) {
		createGetOriginalUserSIB(generateUUID,ime,null,false)
	}
	
	override createGetOriginalUserSIB() {
		createGetOriginalUserSIB(generateUUID)
	}
	/**
	 * This method creates an IgnoreBranch with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createIgnoreBranch(String ID, InternalModelElement ime, boolean hook){
		super.createIgnoreBranch => [ 
			setID(ID)
			internal = ime ?: createInternalIgnoreBranch => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.IgnoreBranchEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an IgnoreBranch with the given id. Post create hook won't be triggered.
	 */
	def createIgnoreBranch(String ID){
		createIgnoreBranch(ID,null,false)
	}
	
	/**
	 * This method creates an IgnoreBranch with the given id. Post create hook won't be triggered.
	 */
	def createIgnoreBranch(InternalModelElement ime) {
		createIgnoreBranch(generateUUID,ime,false)
	}
	
	override createIgnoreBranch() {
		createIgnoreBranch(generateUUID)
	}
	/**
	 * This method creates an NativeFrontendBranch with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createNativeFrontendBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createNativeFrontendBranch => [
			setID(ID)
			internal = ime ?: createInternalNativeFrontendBranch => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.NativeFrontendBranchEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an NativeFrontendBranch with the given id. Post create hook won't be triggered.
	 */
	def createNativeFrontendBranch(String ID){
		createNativeFrontendBranch(ID,null,null,false)
	}
	
	/**
	 * This method creates an NativeFrontendBranch with the given id. Post create hook will be triggered.
	 */
	def createNativeFrontendBranch(InternalModelElementContainer parent){
		createNativeFrontendBranch(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an NativeFrontendBranch with the given id. Post create hook will be triggered.
	 */
	def createNativeFrontendBranch(String ID, InternalModelElementContainer parent){
		createNativeFrontendBranch(ID,null,parent,true)
	}
	
	def createNativeFrontendBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createNativeFrontendBranch(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an NativeFrontendBranch with the given id. Post create hook won't be triggered.
	 */
	def createNativeFrontendBranch(InternalModelElement ime) {
		createNativeFrontendBranch(generateUUID,ime,null,false)
	}
	
	override createNativeFrontendBranch() {
		createNativeFrontendBranch(generateUUID)
	}
	/**
	 * This method creates an IterateSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createIterateSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createIterateSIB => [
			setID(ID)
			internal = ime ?: createInternalIterateSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.IterateSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an IterateSIB with the given id. Post create hook won't be triggered.
	 */
	def createIterateSIB(String ID){
		createIterateSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an IterateSIB with the given id. Post create hook will be triggered.
	 */
	def createIterateSIB(InternalModelElementContainer parent){
		createIterateSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an IterateSIB with the given id. Post create hook will be triggered.
	 */
	def createIterateSIB(String ID, InternalModelElementContainer parent){
		createIterateSIB(ID,null,parent,true)
	}
	
	def createIterateSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createIterateSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an IterateSIB with the given id. Post create hook won't be triggered.
	 */
	def createIterateSIB(InternalModelElement ime) {
		createIterateSIB(generateUUID,ime,null,false)
	}
	
	override createIterateSIB() {
		createIterateSIB(generateUUID)
	}
	def createJavaNativeRead(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createJavaNativeRead => [
			setID(ID)
			internal = ime ?: createInternalJavaNativeRead => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.JavaNativeReadEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an JavaNativeRead with the given id. Post create hook will be triggered.
	 */
	def createJavaNativeRead(String ID, InternalNode source, InternalNode target){
		createJavaNativeRead(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an JavaNativeRead with generated id. Post create hook will be triggered.
	 */
	def createJavaNativeRead(InternalNode source, InternalNode target){
		createJavaNativeRead(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an JavaNativeRead with the given id. Post create hook won't be triggered.
	 */
	def createJavaNativeRead(String ID){
		createJavaNativeRead(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an JavaNativeRead with a generated id. Post create hook won't be triggered.
	 */
	override createJavaNativeRead() {
		createJavaNativeRead(generateUUID)
	}
	def createComplexUpdate(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexUpdate => [
			setID(ID)
			internal = ime ?: createInternalComplexUpdate => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.ComplexUpdateEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ComplexUpdate with the given id. Post create hook will be triggered.
	 */
	def createComplexUpdate(String ID, InternalNode source, InternalNode target){
		createComplexUpdate(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexUpdate with generated id. Post create hook will be triggered.
	 */
	def createComplexUpdate(InternalNode source, InternalNode target){
		createComplexUpdate(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexUpdate with the given id. Post create hook won't be triggered.
	 */
	def createComplexUpdate(String ID){
		createComplexUpdate(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexUpdate with a generated id. Post create hook won't be triggered.
	 */
	override createComplexUpdate() {
		createComplexUpdate(generateUUID)
	}
	/**
	 * This method creates an ComplexAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexAttribute => [
			setID(ID)
			internal = ime ?: createInternalComplexAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ComplexAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttribute(String ID){
		createComplexAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexAttribute(InternalModelElementContainer parent){
		createComplexAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexAttribute(String ID, InternalModelElementContainer parent){
		createComplexAttribute(ID,null,parent,true)
	}
	
	def createComplexAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttribute(InternalModelElement ime) {
		createComplexAttribute(generateUUID,ime,null,false)
	}
	
	override createComplexAttribute() {
		createComplexAttribute(generateUUID)
	}
	def createComplexAttributeConnector(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexAttributeConnector => [
			setID(ID)
			internal = ime ?: createInternalComplexAttributeConnector => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.ComplexAttributeConnectorEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ComplexAttributeConnector with the given id. Post create hook will be triggered.
	 */
	def createComplexAttributeConnector(String ID, InternalNode source, InternalNode target){
		createComplexAttributeConnector(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexAttributeConnector with generated id. Post create hook will be triggered.
	 */
	def createComplexAttributeConnector(InternalNode source, InternalNode target){
		createComplexAttributeConnector(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexAttributeConnector with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttributeConnector(String ID){
		createComplexAttributeConnector(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexAttributeConnector with a generated id. Post create hook won't be triggered.
	 */
	override createComplexAttributeConnector() {
		createComplexAttributeConnector(generateUUID)
	}
	/**
	 * This method creates an GUISIBOptions with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUISIBOptions(String ID, InternalModelElement ime, boolean hook){
		super.createGUISIBOptions => [ 
			setID(ID)
			internal = ime ?: createInternalGUISIBOptions => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.GUISIBOptionsEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an GUISIBOptions with the given id. Post create hook won't be triggered.
	 */
	def createGUISIBOptions(String ID){
		createGUISIBOptions(ID,null,false)
	}
	
	/**
	 * This method creates an GUISIBOptions with the given id. Post create hook won't be triggered.
	 */
	def createGUISIBOptions(InternalModelElement ime) {
		createGUISIBOptions(generateUUID,ime,false)
	}
	
	override createGUISIBOptions() {
		createGUISIBOptions(generateUUID)
	}
	/**
	 * This method creates an RemoveFromListSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createRemoveFromListSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createRemoveFromListSIB => [
			setID(ID)
			internal = ime ?: createInternalRemoveFromListSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.RemoveFromListSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an RemoveFromListSIB with the given id. Post create hook won't be triggered.
	 */
	def createRemoveFromListSIB(String ID){
		createRemoveFromListSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an RemoveFromListSIB with the given id. Post create hook will be triggered.
	 */
	def createRemoveFromListSIB(InternalModelElementContainer parent){
		createRemoveFromListSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an RemoveFromListSIB with the given id. Post create hook will be triggered.
	 */
	def createRemoveFromListSIB(String ID, InternalModelElementContainer parent){
		createRemoveFromListSIB(ID,null,parent,true)
	}
	
	def createRemoveFromListSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createRemoveFromListSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an RemoveFromListSIB with the given id. Post create hook won't be triggered.
	 */
	def createRemoveFromListSIB(InternalModelElement ime) {
		createRemoveFromListSIB(generateUUID,ime,null,false)
	}
	
	override createRemoveFromListSIB() {
		createRemoveFromListSIB(generateUUID)
	}
	/**
	 * This method creates an NativeFrontendSIBReference with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createNativeFrontendSIBReference(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createNativeFrontendSIBReference => [
			setID(ID)
			internal = ime ?: createInternalNativeFrontendSIBReference => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.NativeFrontendSIBReferenceEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an NativeFrontendSIBReference with the given id. Post create hook won't be triggered.
	 */
	def createNativeFrontendSIBReference(String ID){
		createNativeFrontendSIBReference(ID,null,null,false)
	}
	
	/**
	 * This method creates an NativeFrontendSIBReference with the given id. Post create hook will be triggered.
	 */
	def createNativeFrontendSIBReference(InternalModelElementContainer parent){
		createNativeFrontendSIBReference(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an NativeFrontendSIBReference with the given id. Post create hook will be triggered.
	 */
	def createNativeFrontendSIBReference(String ID, InternalModelElementContainer parent){
		createNativeFrontendSIBReference(ID,null,parent,true)
	}
	
	def createNativeFrontendSIBReference(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createNativeFrontendSIBReference(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an NativeFrontendSIBReference with the given id. Post create hook won't be triggered.
	 */
	def createNativeFrontendSIBReference(InternalModelElement ime) {
		createNativeFrontendSIBReference(generateUUID,ime,null,false)
	}
	
	override createNativeFrontendSIBReference() {
		createNativeFrontendSIBReference(generateUUID)
	}
	/**
	 * This method creates an NativeFrontendSIBLibrary with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createNativeFrontendSIBLibrary(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createNativeFrontendSIBLibrary => [
			setID(ID)
			internal = ime ?: createInternalNativeFrontendSIBLibrary => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.NativeFrontendSIBLibraryEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an NativeFrontendSIBLibrary with the given id. Post create hook won't be triggered.
	 */
	def createNativeFrontendSIBLibrary(String ID){
		createNativeFrontendSIBLibrary(ID,null,null,false)
	}
	
	/**
	 * This method creates an NativeFrontendSIBLibrary with the given id. Post create hook will be triggered.
	 */
	def createNativeFrontendSIBLibrary(InternalModelElementContainer parent){
		createNativeFrontendSIBLibrary(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an NativeFrontendSIBLibrary with the given id. Post create hook will be triggered.
	 */
	def createNativeFrontendSIBLibrary(String ID, InternalModelElementContainer parent){
		createNativeFrontendSIBLibrary(ID,null,parent,true)
	}
	
	def createNativeFrontendSIBLibrary(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createNativeFrontendSIBLibrary(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an NativeFrontendSIBLibrary with the given id. Post create hook won't be triggered.
	 */
	def createNativeFrontendSIBLibrary(InternalModelElement ime) {
		createNativeFrontendSIBLibrary(generateUUID,ime,null,false)
	}
	
	override createNativeFrontendSIBLibrary() {
		createNativeFrontendSIBLibrary(generateUUID)
	}
	/**
	 * This method creates an ComplexInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexInputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ComplexInputPortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexInputPort(String ID){
		createComplexInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexInputPort(InternalModelElementContainer parent){
		createComplexInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexInputPort(String ID, InternalModelElementContainer parent){
		createComplexInputPort(ID,null,parent,true)
	}
	
	def createComplexInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexInputPort(InternalModelElement ime) {
		createComplexInputPort(generateUUID,ime,null,false)
	}
	
	override createComplexInputPort() {
		createComplexInputPort(generateUUID)
	}
	/**
	 * This method creates an RealInputStatic with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createRealInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createRealInputStatic => [
			setID(ID)
			internal = ime ?: createInternalRealInputStatic => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.RealInputStaticEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an RealInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createRealInputStatic(String ID){
		createRealInputStatic(ID,null,null,false)
	}
	
	/**
	 * This method creates an RealInputStatic with the given id. Post create hook will be triggered.
	 */
	def createRealInputStatic(InternalModelElementContainer parent){
		createRealInputStatic(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an RealInputStatic with the given id. Post create hook will be triggered.
	 */
	def createRealInputStatic(String ID, InternalModelElementContainer parent){
		createRealInputStatic(ID,null,parent,true)
	}
	
	def createRealInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createRealInputStatic(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an RealInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createRealInputStatic(InternalModelElement ime) {
		createRealInputStatic(generateUUID,ime,null,false)
	}
	
	override createRealInputStatic() {
		createRealInputStatic(generateUUID)
	}
	def createRegistration(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createRegistration => [
			setID(ID)
			internal = ime ?: createInternalRegistration => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.RegistrationEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an Registration with the given id. Post create hook will be triggered.
	 */
	def createRegistration(String ID, InternalNode source, InternalNode target){
		createRegistration(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an Registration with generated id. Post create hook will be triggered.
	 */
	def createRegistration(InternalNode source, InternalNode target){
		createRegistration(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an Registration with the given id. Post create hook won't be triggered.
	 */
	def createRegistration(String ID){
		createRegistration(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an Registration with a generated id. Post create hook won't be triggered.
	 */
	override createRegistration() {
		createRegistration(generateUUID)
	}
	/**
	 * This method creates an JavaNativeInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createJavaNativeInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createJavaNativeInputPort => [
			setID(ID)
			internal = ime ?: createInternalJavaNativeInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.JavaNativeInputPortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an JavaNativeInputPort with the given id. Post create hook won't be triggered.
	 */
	def createJavaNativeInputPort(String ID){
		createJavaNativeInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an JavaNativeInputPort with the given id. Post create hook will be triggered.
	 */
	def createJavaNativeInputPort(InternalModelElementContainer parent){
		createJavaNativeInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an JavaNativeInputPort with the given id. Post create hook will be triggered.
	 */
	def createJavaNativeInputPort(String ID, InternalModelElementContainer parent){
		createJavaNativeInputPort(ID,null,parent,true)
	}
	
	def createJavaNativeInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createJavaNativeInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an JavaNativeInputPort with the given id. Post create hook won't be triggered.
	 */
	def createJavaNativeInputPort(InternalModelElement ime) {
		createJavaNativeInputPort(generateUUID,ime,null,false)
	}
	
	override createJavaNativeInputPort() {
		createJavaNativeInputPort(generateUUID)
	}
	/**
	 * This method creates an Branch with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBranch => [
			setID(ID)
			internal = ime ?: createInternalBranch => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.BranchEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook won't be triggered.
	 */
	def createBranch(String ID){
		createBranch(ID,null,null,false)
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook will be triggered.
	 */
	def createBranch(InternalModelElementContainer parent){
		createBranch(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook will be triggered.
	 */
	def createBranch(String ID, InternalModelElementContainer parent){
		createBranch(ID,null,parent,true)
	}
	
	def createBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBranch(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook won't be triggered.
	 */
	def createBranch(InternalModelElement ime) {
		createBranch(generateUUID,ime,null,false)
	}
	
	override createBranch() {
		createBranch(generateUUID)
	}
	/**
	 * This method creates an ProcessPlaceholderSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProcessPlaceholderSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProcessPlaceholderSIB => [
			setID(ID)
			internal = ime ?: createInternalProcessPlaceholderSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ProcessPlaceholderSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ProcessPlaceholderSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessPlaceholderSIB(String ID){
		createProcessPlaceholderSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProcessPlaceholderSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessPlaceholderSIB(InternalModelElementContainer parent){
		createProcessPlaceholderSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProcessPlaceholderSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessPlaceholderSIB(String ID, InternalModelElementContainer parent){
		createProcessPlaceholderSIB(ID,null,parent,true)
	}
	
	def createProcessPlaceholderSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProcessPlaceholderSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProcessPlaceholderSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessPlaceholderSIB(InternalModelElement ime) {
		createProcessPlaceholderSIB(generateUUID,ime,null,false)
	}
	
	override createProcessPlaceholderSIB() {
		createProcessPlaceholderSIB(generateUUID)
	}
	/**
	 * This method creates an GUIBlueprintSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUIBlueprintSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGUIBlueprintSIB => [
			setID(ID)
			internal = ime ?: createInternalGUIBlueprintSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.GUIBlueprintSIBEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an GUIBlueprintSIB with the given id. Post create hook won't be triggered.
	 */
	def createGUIBlueprintSIB(String ID){
		createGUIBlueprintSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an GUIBlueprintSIB with the given id. Post create hook will be triggered.
	 */
	def createGUIBlueprintSIB(InternalModelElementContainer parent){
		createGUIBlueprintSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GUIBlueprintSIB with the given id. Post create hook will be triggered.
	 */
	def createGUIBlueprintSIB(String ID, InternalModelElementContainer parent){
		createGUIBlueprintSIB(ID,null,parent,true)
	}
	
	def createGUIBlueprintSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGUIBlueprintSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GUIBlueprintSIB with the given id. Post create hook won't be triggered.
	 */
	def createGUIBlueprintSIB(InternalModelElement ime) {
		createGUIBlueprintSIB(generateUUID,ime,null,false)
	}
	
	override createGUIBlueprintSIB() {
		createGUIBlueprintSIB(generateUUID)
	}
	/**
	 * This method creates an ProcessSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProcessSIB => [
			setID(ID)
			internal = ime ?: createInternalProcessSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ProcessSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessSIB(String ID){
		createProcessSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessSIB(InternalModelElementContainer parent){
		createProcessSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessSIB(String ID, InternalModelElementContainer parent){
		createProcessSIB(ID,null,parent,true)
	}
	
	def createProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProcessSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessSIB(InternalModelElement ime) {
		createProcessSIB(generateUUID,ime,null,false)
	}
	
	override createProcessSIB() {
		createProcessSIB(generateUUID)
	}
	/**
	 * This method creates an PrimitiveInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveInputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.PrimitiveInputPortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputPort(String ID){
		createPrimitiveInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputPort(InternalModelElementContainer parent){
		createPrimitiveInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveInputPort(ID,null,parent,true)
	}
	
	def createPrimitiveInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputPort(InternalModelElement ime) {
		createPrimitiveInputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveInputPort() {
		createPrimitiveInputPort(generateUUID)
	}
	/**
	 * This method creates an ComplexOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexOutputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ComplexOutputPortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputPort(String ID){
		createComplexOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputPort(InternalModelElementContainer parent){
		createComplexOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputPort(String ID, InternalModelElementContainer parent){
		createComplexOutputPort(ID,null,parent,true)
	}
	
	def createComplexOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputPort(InternalModelElement ime) {
		createComplexOutputPort(generateUUID,ime,null,false)
	}
	
	override createComplexOutputPort() {
		createComplexOutputPort(generateUUID)
	}
	/**
	 * This method creates an ProcessBlueprintSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProcessBlueprintSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProcessBlueprintSIB => [
			setID(ID)
			internal = ime ?: createInternalProcessBlueprintSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ProcessBlueprintSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ProcessBlueprintSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessBlueprintSIB(String ID){
		createProcessBlueprintSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProcessBlueprintSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessBlueprintSIB(InternalModelElementContainer parent){
		createProcessBlueprintSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProcessBlueprintSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessBlueprintSIB(String ID, InternalModelElementContainer parent){
		createProcessBlueprintSIB(ID,null,parent,true)
	}
	
	def createProcessBlueprintSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProcessBlueprintSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProcessBlueprintSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessBlueprintSIB(InternalModelElement ime) {
		createProcessBlueprintSIB(generateUUID,ime,null,false)
	}
	
	override createProcessBlueprintSIB() {
		createProcessBlueprintSIB(generateUUID)
	}
	/**
	 * This method creates an PutComplexToContextSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPutComplexToContextSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPutComplexToContextSIB => [
			setID(ID)
			internal = ime ?: createInternalPutComplexToContextSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.PutComplexToContextSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PutComplexToContextSIB with the given id. Post create hook won't be triggered.
	 */
	def createPutComplexToContextSIB(String ID){
		createPutComplexToContextSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an PutComplexToContextSIB with the given id. Post create hook will be triggered.
	 */
	def createPutComplexToContextSIB(InternalModelElementContainer parent){
		createPutComplexToContextSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PutComplexToContextSIB with the given id. Post create hook will be triggered.
	 */
	def createPutComplexToContextSIB(String ID, InternalModelElementContainer parent){
		createPutComplexToContextSIB(ID,null,parent,true)
	}
	
	def createPutComplexToContextSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPutComplexToContextSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PutComplexToContextSIB with the given id. Post create hook won't be triggered.
	 */
	def createPutComplexToContextSIB(InternalModelElement ime) {
		createPutComplexToContextSIB(generateUUID,ime,null,false)
	}
	
	override createPutComplexToContextSIB() {
		createPutComplexToContextSIB(generateUUID)
	}
	/**
	 * This method creates an GenericSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGenericSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGenericSIB => [
			setID(ID)
			internal = ime ?: createInternalGenericSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.GenericSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GenericSIB with the given id. Post create hook won't be triggered.
	 */
	def createGenericSIB(String ID){
		createGenericSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an GenericSIB with the given id. Post create hook will be triggered.
	 */
	def createGenericSIB(InternalModelElementContainer parent){
		createGenericSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GenericSIB with the given id. Post create hook will be triggered.
	 */
	def createGenericSIB(String ID, InternalModelElementContainer parent){
		createGenericSIB(ID,null,parent,true)
	}
	
	def createGenericSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGenericSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GenericSIB with the given id. Post create hook won't be triggered.
	 */
	def createGenericSIB(InternalModelElement ime) {
		createGenericSIB(generateUUID,ime,null,false)
	}
	
	override createGenericSIB() {
		createGenericSIB(generateUUID)
	}
	/**
	 * This method creates an DataContext with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDataContext(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDataContext => [
			setID(ID)
			internal = ime ?: createInternalDataContext => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.DataContextEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook won't be triggered.
	 */
	def createDataContext(String ID){
		createDataContext(ID,null,null,false)
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook will be triggered.
	 */
	def createDataContext(InternalModelElementContainer parent){
		createDataContext(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook will be triggered.
	 */
	def createDataContext(String ID, InternalModelElementContainer parent){
		createDataContext(ID,null,parent,true)
	}
	
	def createDataContext(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDataContext(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook won't be triggered.
	 */
	def createDataContext(InternalModelElement ime) {
		createDataContext(generateUUID,ime,null,false)
	}
	
	override createDataContext() {
		createDataContext(generateUUID)
	}
	/**
	 * This method creates an Process with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProcess(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProcess => [ 
			setID(ID)
			internal = ime ?: createInternalProcess => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.ProcessEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Process with the given id. Post create hook won't be triggered.
	 */
	def createProcess(String ID){
		createProcess(ID,null,null,false)
	}
	
	/**
	 * This method creates an Process with the given id. Post create hook will be triggered.
	 */
	def createProcess(InternalModelElementContainer parent){
		createProcess(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Process with the given id. Post create hook will be triggered.
	 */
	def createProcess(String ID, InternalModelElementContainer parent){
		createProcess(ID,null,parent,true)
	}
	
	def createProcess(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProcess(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Process with the given id. Post create hook won't be triggered.
	 */
	def createProcess(InternalModelElement ime) {
		createProcess(generateUUID,ime,null,false)
	}
	
	override createProcess() {
		createProcess(generateUUID)
	}
	/**
	 * This method creates an SwitchToUserSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createSwitchToUserSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createSwitchToUserSIB => [
			setID(ID)
			internal = ime ?: createInternalSwitchToUserSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.SwitchToUserSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an SwitchToUserSIB with the given id. Post create hook won't be triggered.
	 */
	def createSwitchToUserSIB(String ID){
		createSwitchToUserSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an SwitchToUserSIB with the given id. Post create hook will be triggered.
	 */
	def createSwitchToUserSIB(InternalModelElementContainer parent){
		createSwitchToUserSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an SwitchToUserSIB with the given id. Post create hook will be triggered.
	 */
	def createSwitchToUserSIB(String ID, InternalModelElementContainer parent){
		createSwitchToUserSIB(ID,null,parent,true)
	}
	
	def createSwitchToUserSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createSwitchToUserSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an SwitchToUserSIB with the given id. Post create hook won't be triggered.
	 */
	def createSwitchToUserSIB(InternalModelElement ime) {
		createSwitchToUserSIB(generateUUID,ime,null,false)
	}
	
	override createSwitchToUserSIB() {
		createSwitchToUserSIB(generateUUID)
	}
	/**
	 * This method creates an Documentation with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDocumentation(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDocumentation => [
			setID(ID)
			internal = ime ?: createInternalDocumentation => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.DocumentationEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Documentation with the given id. Post create hook won't be triggered.
	 */
	def createDocumentation(String ID){
		createDocumentation(ID,null,null,false)
	}
	
	/**
	 * This method creates an Documentation with the given id. Post create hook will be triggered.
	 */
	def createDocumentation(InternalModelElementContainer parent){
		createDocumentation(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Documentation with the given id. Post create hook will be triggered.
	 */
	def createDocumentation(String ID, InternalModelElementContainer parent){
		createDocumentation(ID,null,parent,true)
	}
	
	def createDocumentation(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDocumentation(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Documentation with the given id. Post create hook won't be triggered.
	 */
	def createDocumentation(InternalModelElement ime) {
		createDocumentation(generateUUID,ime,null,false)
	}
	
	override createDocumentation() {
		createDocumentation(generateUUID)
	}
	/**
	 * This method creates an SwitchToOriginalUserSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createSwitchToOriginalUserSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createSwitchToOriginalUserSIB => [
			setID(ID)
			internal = ime ?: createInternalSwitchToOriginalUserSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.SwitchToOriginalUserSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an SwitchToOriginalUserSIB with the given id. Post create hook won't be triggered.
	 */
	def createSwitchToOriginalUserSIB(String ID){
		createSwitchToOriginalUserSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an SwitchToOriginalUserSIB with the given id. Post create hook will be triggered.
	 */
	def createSwitchToOriginalUserSIB(InternalModelElementContainer parent){
		createSwitchToOriginalUserSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an SwitchToOriginalUserSIB with the given id. Post create hook will be triggered.
	 */
	def createSwitchToOriginalUserSIB(String ID, InternalModelElementContainer parent){
		createSwitchToOriginalUserSIB(ID,null,parent,true)
	}
	
	def createSwitchToOriginalUserSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createSwitchToOriginalUserSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an SwitchToOriginalUserSIB with the given id. Post create hook won't be triggered.
	 */
	def createSwitchToOriginalUserSIB(InternalModelElement ime) {
		createSwitchToOriginalUserSIB(generateUUID,ime,null,false)
	}
	
	override createSwitchToOriginalUserSIB() {
		createSwitchToOriginalUserSIB(generateUUID)
	}
	/**
	 * This method creates an PrimitiveOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveOutputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.PrimitiveOutputPortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveOutputPort(String ID){
		createPrimitiveOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveOutputPort(InternalModelElementContainer parent){
		createPrimitiveOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveOutputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveOutputPort(ID,null,parent,true)
	}
	
	def createPrimitiveOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveOutputPort(InternalModelElement ime) {
		createPrimitiveOutputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveOutputPort() {
		createPrimitiveOutputPort(generateUUID)
	}
	def createBranchConnector(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createBranchConnector => [
			setID(ID)
			internal = ime ?: createInternalBranchConnector => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.BranchConnectorEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an BranchConnector with the given id. Post create hook will be triggered.
	 */
	def createBranchConnector(String ID, InternalNode source, InternalNode target){
		createBranchConnector(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an BranchConnector with generated id. Post create hook will be triggered.
	 */
	def createBranchConnector(InternalNode source, InternalNode target){
		createBranchConnector(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an BranchConnector with the given id. Post create hook won't be triggered.
	 */
	def createBranchConnector(String ID){
		createBranchConnector(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an BranchConnector with a generated id. Post create hook won't be triggered.
	 */
	override createBranchConnector() {
		createBranchConnector(generateUUID)
	}
	/**
	 * This method creates an PrimitiveAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveAttribute => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.PrimitiveAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAttribute(String ID){
		createPrimitiveAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAttribute(InternalModelElementContainer parent){
		createPrimitiveAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAttribute(String ID, InternalModelElementContainer parent){
		createPrimitiveAttribute(ID,null,parent,true)
	}
	
	def createPrimitiveAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAttribute(InternalModelElement ime) {
		createPrimitiveAttribute(generateUUID,ime,null,false)
	}
	
	override createPrimitiveAttribute() {
		createPrimitiveAttribute(generateUUID)
	}
	/**
	 * This method creates an IteratePrimitiveSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createIteratePrimitiveSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createIteratePrimitiveSIB => [
			setID(ID)
			internal = ime ?: createInternalIteratePrimitiveSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.IteratePrimitiveSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an IteratePrimitiveSIB with the given id. Post create hook won't be triggered.
	 */
	def createIteratePrimitiveSIB(String ID){
		createIteratePrimitiveSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an IteratePrimitiveSIB with the given id. Post create hook will be triggered.
	 */
	def createIteratePrimitiveSIB(InternalModelElementContainer parent){
		createIteratePrimitiveSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an IteratePrimitiveSIB with the given id. Post create hook will be triggered.
	 */
	def createIteratePrimitiveSIB(String ID, InternalModelElementContainer parent){
		createIteratePrimitiveSIB(ID,null,parent,true)
	}
	
	def createIteratePrimitiveSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createIteratePrimitiveSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an IteratePrimitiveSIB with the given id. Post create hook won't be triggered.
	 */
	def createIteratePrimitiveSIB(InternalModelElement ime) {
		createIteratePrimitiveSIB(generateUUID,ime,null,false)
	}
	
	override createIteratePrimitiveSIB() {
		createIteratePrimitiveSIB(generateUUID)
	}
	/**
	 * This method creates an SearchSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createSearchSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createSearchSIB => [
			setID(ID)
			internal = ime ?: createInternalSearchSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.SearchSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an SearchSIB with the given id. Post create hook won't be triggered.
	 */
	def createSearchSIB(String ID){
		createSearchSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an SearchSIB with the given id. Post create hook will be triggered.
	 */
	def createSearchSIB(InternalModelElementContainer parent){
		createSearchSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an SearchSIB with the given id. Post create hook will be triggered.
	 */
	def createSearchSIB(String ID, InternalModelElementContainer parent){
		createSearchSIB(ID,null,parent,true)
	}
	
	def createSearchSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createSearchSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an SearchSIB with the given id. Post create hook won't be triggered.
	 */
	def createSearchSIB(InternalModelElement ime) {
		createSearchSIB(generateUUID,ime,null,false)
	}
	
	override createSearchSIB() {
		createSearchSIB(generateUUID)
	}
	/**
	 * This method creates an LongRunningProcess with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createLongRunningProcess(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createLongRunningProcess => [
			setID(ID)
			internal = ime ?: createInternalLongRunningProcess => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.LongRunningProcessEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an LongRunningProcess with the given id. Post create hook won't be triggered.
	 */
	def createLongRunningProcess(String ID){
		createLongRunningProcess(ID,null,null,false)
	}
	
	/**
	 * This method creates an LongRunningProcess with the given id. Post create hook will be triggered.
	 */
	def createLongRunningProcess(InternalModelElementContainer parent){
		createLongRunningProcess(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an LongRunningProcess with the given id. Post create hook will be triggered.
	 */
	def createLongRunningProcess(String ID, InternalModelElementContainer parent){
		createLongRunningProcess(ID,null,parent,true)
	}
	
	def createLongRunningProcess(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createLongRunningProcess(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an LongRunningProcess with the given id. Post create hook won't be triggered.
	 */
	def createLongRunningProcess(InternalModelElement ime) {
		createLongRunningProcess(generateUUID,ime,null,false)
	}
	
	override createLongRunningProcess() {
		createLongRunningProcess(generateUUID)
	}
	def createPrimitiveDirectDataFlow(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createPrimitiveDirectDataFlow => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveDirectDataFlow => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.PrimitiveDirectDataFlowEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an PrimitiveDirectDataFlow with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveDirectDataFlow(String ID, InternalNode source, InternalNode target){
		createPrimitiveDirectDataFlow(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveDirectDataFlow with generated id. Post create hook will be triggered.
	 */
	def createPrimitiveDirectDataFlow(InternalNode source, InternalNode target){
		createPrimitiveDirectDataFlow(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveDirectDataFlow with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveDirectDataFlow(String ID){
		createPrimitiveDirectDataFlow(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveDirectDataFlow with a generated id. Post create hook won't be triggered.
	 */
	override createPrimitiveDirectDataFlow() {
		createPrimitiveDirectDataFlow(generateUUID)
	}
	/**
	 * This method creates an CreateSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createCreateSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createCreateSIB => [
			setID(ID)
			internal = ime ?: createInternalCreateSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.CreateSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an CreateSIB with the given id. Post create hook won't be triggered.
	 */
	def createCreateSIB(String ID){
		createCreateSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an CreateSIB with the given id. Post create hook will be triggered.
	 */
	def createCreateSIB(InternalModelElementContainer parent){
		createCreateSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an CreateSIB with the given id. Post create hook will be triggered.
	 */
	def createCreateSIB(String ID, InternalModelElementContainer parent){
		createCreateSIB(ID,null,parent,true)
	}
	
	def createCreateSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createCreateSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an CreateSIB with the given id. Post create hook won't be triggered.
	 */
	def createCreateSIB(InternalModelElement ime) {
		createCreateSIB(generateUUID,ime,null,false)
	}
	
	override createCreateSIB() {
		createCreateSIB(generateUUID)
	}
	/**
	 * This method creates an PutPrimitiveToContextSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPutPrimitiveToContextSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPutPrimitiveToContextSIB => [
			setID(ID)
			internal = ime ?: createInternalPutPrimitiveToContextSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.PutPrimitiveToContextSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PutPrimitiveToContextSIB with the given id. Post create hook won't be triggered.
	 */
	def createPutPrimitiveToContextSIB(String ID){
		createPutPrimitiveToContextSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an PutPrimitiveToContextSIB with the given id. Post create hook will be triggered.
	 */
	def createPutPrimitiveToContextSIB(InternalModelElementContainer parent){
		createPutPrimitiveToContextSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PutPrimitiveToContextSIB with the given id. Post create hook will be triggered.
	 */
	def createPutPrimitiveToContextSIB(String ID, InternalModelElementContainer parent){
		createPutPrimitiveToContextSIB(ID,null,parent,true)
	}
	
	def createPutPrimitiveToContextSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPutPrimitiveToContextSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PutPrimitiveToContextSIB with the given id. Post create hook won't be triggered.
	 */
	def createPutPrimitiveToContextSIB(InternalModelElement ime) {
		createPutPrimitiveToContextSIB(generateUUID,ime,null,false)
	}
	
	override createPutPrimitiveToContextSIB() {
		createPutPrimitiveToContextSIB(generateUUID)
	}
	/**
	 * This method creates an EventListener with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createEventListener(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createEventListener => [
			setID(ID)
			internal = ime ?: createInternalEventListener => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.EventListenerEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an EventListener with the given id. Post create hook won't be triggered.
	 */
	def createEventListener(String ID){
		createEventListener(ID,null,null,false)
	}
	
	/**
	 * This method creates an EventListener with the given id. Post create hook will be triggered.
	 */
	def createEventListener(InternalModelElementContainer parent){
		createEventListener(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an EventListener with the given id. Post create hook will be triggered.
	 */
	def createEventListener(String ID, InternalModelElementContainer parent){
		createEventListener(ID,null,parent,true)
	}
	
	def createEventListener(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createEventListener(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an EventListener with the given id. Post create hook won't be triggered.
	 */
	def createEventListener(InternalModelElement ime) {
		createEventListener(generateUUID,ime,null,false)
	}
	
	override createEventListener() {
		createEventListener(generateUUID)
	}
	/**
	 * This method creates an GUISIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUISIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGUISIB => [
			setID(ID)
			internal = ime ?: createInternalGUISIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.GUISIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook won't be triggered.
	 */
	def createGUISIB(String ID){
		createGUISIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook will be triggered.
	 */
	def createGUISIB(InternalModelElementContainer parent){
		createGUISIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook will be triggered.
	 */
	def createGUISIB(String ID, InternalModelElementContainer parent){
		createGUISIB(ID,null,parent,true)
	}
	
	def createGUISIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGUISIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook won't be triggered.
	 */
	def createGUISIB(InternalModelElement ime) {
		createGUISIB(generateUUID,ime,null,false)
	}
	
	override createGUISIB() {
		createGUISIB(generateUUID)
	}
	/**
	 * This method creates an PrimitiveVariable with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveVariable => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveVariable => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.PrimitiveVariableEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveVariable(String ID){
		createPrimitiveVariable(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveVariable(InternalModelElementContainer parent){
		createPrimitiveVariable(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveVariable(String ID, InternalModelElementContainer parent){
		createPrimitiveVariable(ID,null,parent,true)
	}
	
	def createPrimitiveVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveVariable(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveVariable(InternalModelElement ime) {
		createPrimitiveVariable(generateUUID,ime,null,false)
	}
	
	override createPrimitiveVariable() {
		createPrimitiveVariable(generateUUID)
	}
	/**
	 * This method creates an IsOfTypeSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createIsOfTypeSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createIsOfTypeSIB => [
			setID(ID)
			internal = ime ?: createInternalIsOfTypeSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.IsOfTypeSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an IsOfTypeSIB with the given id. Post create hook won't be triggered.
	 */
	def createIsOfTypeSIB(String ID){
		createIsOfTypeSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an IsOfTypeSIB with the given id. Post create hook will be triggered.
	 */
	def createIsOfTypeSIB(InternalModelElementContainer parent){
		createIsOfTypeSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an IsOfTypeSIB with the given id. Post create hook will be triggered.
	 */
	def createIsOfTypeSIB(String ID, InternalModelElementContainer parent){
		createIsOfTypeSIB(ID,null,parent,true)
	}
	
	def createIsOfTypeSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createIsOfTypeSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an IsOfTypeSIB with the given id. Post create hook won't be triggered.
	 */
	def createIsOfTypeSIB(InternalModelElement ime) {
		createIsOfTypeSIB(generateUUID,ime,null,false)
	}
	
	override createIsOfTypeSIB() {
		createIsOfTypeSIB(generateUUID)
	}
	/**
	 * This method creates an PrimitiveListAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveListAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveListAttribute => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveListAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.PrimitiveListAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveListAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveListAttribute(String ID){
		createPrimitiveListAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveListAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveListAttribute(InternalModelElementContainer parent){
		createPrimitiveListAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveListAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveListAttribute(String ID, InternalModelElementContainer parent){
		createPrimitiveListAttribute(ID,null,parent,true)
	}
	
	def createPrimitiveListAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveListAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveListAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveListAttribute(InternalModelElement ime) {
		createPrimitiveListAttribute(generateUUID,ime,null,false)
	}
	
	override createPrimitiveListAttribute() {
		createPrimitiveListAttribute(generateUUID)
	}
	def createJavaNativeDirectDataFlow(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createJavaNativeDirectDataFlow => [
			setID(ID)
			internal = ime ?: createInternalJavaNativeDirectDataFlow => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.JavaNativeDirectDataFlowEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an JavaNativeDirectDataFlow with the given id. Post create hook will be triggered.
	 */
	def createJavaNativeDirectDataFlow(String ID, InternalNode source, InternalNode target){
		createJavaNativeDirectDataFlow(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an JavaNativeDirectDataFlow with generated id. Post create hook will be triggered.
	 */
	def createJavaNativeDirectDataFlow(InternalNode source, InternalNode target){
		createJavaNativeDirectDataFlow(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an JavaNativeDirectDataFlow with the given id. Post create hook won't be triggered.
	 */
	def createJavaNativeDirectDataFlow(String ID){
		createJavaNativeDirectDataFlow(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an JavaNativeDirectDataFlow with a generated id. Post create hook won't be triggered.
	 */
	override createJavaNativeDirectDataFlow() {
		createJavaNativeDirectDataFlow(generateUUID)
	}
	/**
	 * This method creates an PrimitiveExtensionAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveExtensionAttribute => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveExtensionAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.PrimitiveExtensionAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveExtensionAttribute(String ID){
		createPrimitiveExtensionAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveExtensionAttribute(InternalModelElementContainer parent){
		createPrimitiveExtensionAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveExtensionAttribute(String ID, InternalModelElementContainer parent){
		createPrimitiveExtensionAttribute(ID,null,parent,true)
	}
	
	def createPrimitiveExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveExtensionAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveExtensionAttribute(InternalModelElement ime) {
		createPrimitiveExtensionAttribute(generateUUID,ime,null,false)
	}
	
	override createPrimitiveExtensionAttribute() {
		createPrimitiveExtensionAttribute(generateUUID)
	}
	/**
	 * This method creates an ContainsPrimitiveSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createContainsPrimitiveSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createContainsPrimitiveSIB => [
			setID(ID)
			internal = ime ?: createInternalContainsPrimitiveSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ContainsPrimitiveSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ContainsPrimitiveSIB with the given id. Post create hook won't be triggered.
	 */
	def createContainsPrimitiveSIB(String ID){
		createContainsPrimitiveSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ContainsPrimitiveSIB with the given id. Post create hook will be triggered.
	 */
	def createContainsPrimitiveSIB(InternalModelElementContainer parent){
		createContainsPrimitiveSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ContainsPrimitiveSIB with the given id. Post create hook will be triggered.
	 */
	def createContainsPrimitiveSIB(String ID, InternalModelElementContainer parent){
		createContainsPrimitiveSIB(ID,null,parent,true)
	}
	
	def createContainsPrimitiveSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createContainsPrimitiveSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ContainsPrimitiveSIB with the given id. Post create hook won't be triggered.
	 */
	def createContainsPrimitiveSIB(InternalModelElement ime) {
		createContainsPrimitiveSIB(generateUUID,ime,null,false)
	}
	
	override createContainsPrimitiveSIB() {
		createContainsPrimitiveSIB(generateUUID)
	}
	/**
	 * This method creates an TriggerEventSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTriggerEventSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTriggerEventSIB => [
			setID(ID)
			internal = ime ?: createInternalTriggerEventSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.TriggerEventSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an TriggerEventSIB with the given id. Post create hook won't be triggered.
	 */
	def createTriggerEventSIB(String ID){
		createTriggerEventSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an TriggerEventSIB with the given id. Post create hook will be triggered.
	 */
	def createTriggerEventSIB(InternalModelElementContainer parent){
		createTriggerEventSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an TriggerEventSIB with the given id. Post create hook will be triggered.
	 */
	def createTriggerEventSIB(String ID, InternalModelElementContainer parent){
		createTriggerEventSIB(ID,null,parent,true)
	}
	
	def createTriggerEventSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTriggerEventSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an TriggerEventSIB with the given id. Post create hook won't be triggered.
	 */
	def createTriggerEventSIB(InternalModelElement ime) {
		createTriggerEventSIB(generateUUID,ime,null,false)
	}
	
	override createTriggerEventSIB() {
		createTriggerEventSIB(generateUUID)
	}
	/**
	 * This method creates an JavaNativeOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createJavaNativeOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createJavaNativeOutputPort => [
			setID(ID)
			internal = ime ?: createInternalJavaNativeOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.JavaNativeOutputPortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an JavaNativeOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createJavaNativeOutputPort(String ID){
		createJavaNativeOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an JavaNativeOutputPort with the given id. Post create hook will be triggered.
	 */
	def createJavaNativeOutputPort(InternalModelElementContainer parent){
		createJavaNativeOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an JavaNativeOutputPort with the given id. Post create hook will be triggered.
	 */
	def createJavaNativeOutputPort(String ID, InternalModelElementContainer parent){
		createJavaNativeOutputPort(ID,null,parent,true)
	}
	
	def createJavaNativeOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createJavaNativeOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an JavaNativeOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createJavaNativeOutputPort(InternalModelElement ime) {
		createJavaNativeOutputPort(generateUUID,ime,null,false)
	}
	
	override createJavaNativeOutputPort() {
		createJavaNativeOutputPort(generateUUID)
	}
	/**
	 * This method creates an JavaNativeVariable with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createJavaNativeVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createJavaNativeVariable => [
			setID(ID)
			internal = ime ?: createInternalJavaNativeVariable => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.JavaNativeVariableEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an JavaNativeVariable with the given id. Post create hook won't be triggered.
	 */
	def createJavaNativeVariable(String ID){
		createJavaNativeVariable(ID,null,null,false)
	}
	
	/**
	 * This method creates an JavaNativeVariable with the given id. Post create hook will be triggered.
	 */
	def createJavaNativeVariable(InternalModelElementContainer parent){
		createJavaNativeVariable(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an JavaNativeVariable with the given id. Post create hook will be triggered.
	 */
	def createJavaNativeVariable(String ID, InternalModelElementContainer parent){
		createJavaNativeVariable(ID,null,parent,true)
	}
	
	def createJavaNativeVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createJavaNativeVariable(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an JavaNativeVariable with the given id. Post create hook won't be triggered.
	 */
	def createJavaNativeVariable(InternalModelElement ime) {
		createJavaNativeVariable(generateUUID,ime,null,false)
	}
	
	override createJavaNativeVariable() {
		createJavaNativeVariable(generateUUID)
	}
	/**
	 * This method creates an PrimitiveAttributePort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveAttributePort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveAttributePort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveAttributePort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.PrimitiveAttributePortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PrimitiveAttributePort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAttributePort(String ID){
		createPrimitiveAttributePort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveAttributePort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAttributePort(InternalModelElementContainer parent){
		createPrimitiveAttributePort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAttributePort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAttributePort(String ID, InternalModelElementContainer parent){
		createPrimitiveAttributePort(ID,null,parent,true)
	}
	
	def createPrimitiveAttributePort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveAttributePort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAttributePort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAttributePort(InternalModelElement ime) {
		createPrimitiveAttributePort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveAttributePort() {
		createPrimitiveAttributePort(generateUUID)
	}
	/**
	 * This method creates an TransientCreateSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTransientCreateSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTransientCreateSIB => [
			setID(ID)
			internal = ime ?: createInternalTransientCreateSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.TransientCreateSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an TransientCreateSIB with the given id. Post create hook won't be triggered.
	 */
	def createTransientCreateSIB(String ID){
		createTransientCreateSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an TransientCreateSIB with the given id. Post create hook will be triggered.
	 */
	def createTransientCreateSIB(InternalModelElementContainer parent){
		createTransientCreateSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an TransientCreateSIB with the given id. Post create hook will be triggered.
	 */
	def createTransientCreateSIB(String ID, InternalModelElementContainer parent){
		createTransientCreateSIB(ID,null,parent,true)
	}
	
	def createTransientCreateSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTransientCreateSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an TransientCreateSIB with the given id. Post create hook won't be triggered.
	 */
	def createTransientCreateSIB(InternalModelElement ime) {
		createTransientCreateSIB(generateUUID,ime,null,false)
	}
	
	override createTransientCreateSIB() {
		createTransientCreateSIB(generateUUID)
	}
	/**
	 * This method creates an UnsetAttributeValueSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createUnsetAttributeValueSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createUnsetAttributeValueSIB => [
			setID(ID)
			internal = ime ?: createInternalUnsetAttributeValueSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.UnsetAttributeValueSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an UnsetAttributeValueSIB with the given id. Post create hook won't be triggered.
	 */
	def createUnsetAttributeValueSIB(String ID){
		createUnsetAttributeValueSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an UnsetAttributeValueSIB with the given id. Post create hook will be triggered.
	 */
	def createUnsetAttributeValueSIB(InternalModelElementContainer parent){
		createUnsetAttributeValueSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an UnsetAttributeValueSIB with the given id. Post create hook will be triggered.
	 */
	def createUnsetAttributeValueSIB(String ID, InternalModelElementContainer parent){
		createUnsetAttributeValueSIB(ID,null,parent,true)
	}
	
	def createUnsetAttributeValueSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createUnsetAttributeValueSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an UnsetAttributeValueSIB with the given id. Post create hook won't be triggered.
	 */
	def createUnsetAttributeValueSIB(InternalModelElement ime) {
		createUnsetAttributeValueSIB(generateUUID,ime,null,false)
	}
	
	override createUnsetAttributeValueSIB() {
		createUnsetAttributeValueSIB(generateUUID)
	}
	/**
	 * This method creates an TextInputStatic with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTextInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTextInputStatic => [
			setID(ID)
			internal = ime ?: createInternalTextInputStatic => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.TextInputStaticEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an TextInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createTextInputStatic(String ID){
		createTextInputStatic(ID,null,null,false)
	}
	
	/**
	 * This method creates an TextInputStatic with the given id. Post create hook will be triggered.
	 */
	def createTextInputStatic(InternalModelElementContainer parent){
		createTextInputStatic(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an TextInputStatic with the given id. Post create hook will be triggered.
	 */
	def createTextInputStatic(String ID, InternalModelElementContainer parent){
		createTextInputStatic(ID,null,parent,true)
	}
	
	def createTextInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTextInputStatic(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an TextInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createTextInputStatic(InternalModelElement ime) {
		createTextInputStatic(generateUUID,ime,null,false)
	}
	
	override createTextInputStatic() {
		createTextInputStatic(generateUUID)
	}
	def createPrimitiveRead(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createPrimitiveRead => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveRead => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.PrimitiveReadEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an PrimitiveRead with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveRead(String ID, InternalNode source, InternalNode target){
		createPrimitiveRead(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveRead with generated id. Post create hook will be triggered.
	 */
	def createPrimitiveRead(InternalNode source, InternalNode target){
		createPrimitiveRead(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveRead with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveRead(String ID){
		createPrimitiveRead(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveRead with a generated id. Post create hook won't be triggered.
	 */
	override createPrimitiveRead() {
		createPrimitiveRead(generateUUID)
	}
	/**
	 * This method creates an GuardProcessSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGuardProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGuardProcessSIB => [
			setID(ID)
			internal = ime ?: createInternalGuardProcessSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.GuardProcessSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GuardProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createGuardProcessSIB(String ID){
		createGuardProcessSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an GuardProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createGuardProcessSIB(InternalModelElementContainer parent){
		createGuardProcessSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GuardProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createGuardProcessSIB(String ID, InternalModelElementContainer parent){
		createGuardProcessSIB(ID,null,parent,true)
	}
	
	def createGuardProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGuardProcessSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GuardProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createGuardProcessSIB(InternalModelElement ime) {
		createGuardProcessSIB(generateUUID,ime,null,false)
	}
	
	override createGuardProcessSIB() {
		createGuardProcessSIB(generateUUID)
	}
	def createControlFlow(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createControlFlow => [
			setID(ID)
			internal = ime ?: createInternalControlFlow => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.ControlFlowEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ControlFlow with the given id. Post create hook will be triggered.
	 */
	def createControlFlow(String ID, InternalNode source, InternalNode target){
		createControlFlow(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ControlFlow with generated id. Post create hook will be triggered.
	 */
	def createControlFlow(InternalNode source, InternalNode target){
		createControlFlow(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ControlFlow with the given id. Post create hook won't be triggered.
	 */
	def createControlFlow(String ID){
		createControlFlow(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ControlFlow with a generated id. Post create hook won't be triggered.
	 */
	override createControlFlow() {
		createControlFlow(generateUUID)
	}
	def createComplexRead(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexRead => [
			setID(ID)
			internal = ime ?: createInternalComplexRead => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.ComplexReadEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ComplexRead with the given id. Post create hook will be triggered.
	 */
	def createComplexRead(String ID, InternalNode source, InternalNode target){
		createComplexRead(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexRead with generated id. Post create hook will be triggered.
	 */
	def createComplexRead(InternalNode source, InternalNode target){
		createComplexRead(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexRead with the given id. Post create hook won't be triggered.
	 */
	def createComplexRead(String ID){
		createComplexRead(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexRead with a generated id. Post create hook won't be triggered.
	 */
	override createComplexRead() {
		createComplexRead(generateUUID)
	}
	/**
	 * This method creates an PutToContextSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPutToContextSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPutToContextSIB => [
			setID(ID)
			internal = ime ?: createInternalPutToContextSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.PutToContextSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PutToContextSIB with the given id. Post create hook won't be triggered.
	 */
	def createPutToContextSIB(String ID){
		createPutToContextSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an PutToContextSIB with the given id. Post create hook will be triggered.
	 */
	def createPutToContextSIB(InternalModelElementContainer parent){
		createPutToContextSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PutToContextSIB with the given id. Post create hook will be triggered.
	 */
	def createPutToContextSIB(String ID, InternalModelElementContainer parent){
		createPutToContextSIB(ID,null,parent,true)
	}
	
	def createPutToContextSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPutToContextSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PutToContextSIB with the given id. Post create hook won't be triggered.
	 */
	def createPutToContextSIB(InternalModelElement ime) {
		createPutToContextSIB(generateUUID,ime,null,false)
	}
	
	override createPutToContextSIB() {
		createPutToContextSIB(generateUUID)
	}
	/**
	 * This method creates an ProcessInputStatic with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProcessInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProcessInputStatic => [
			setID(ID)
			internal = ime ?: createInternalProcessInputStatic => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ProcessInputStaticEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ProcessInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createProcessInputStatic(String ID){
		createProcessInputStatic(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProcessInputStatic with the given id. Post create hook will be triggered.
	 */
	def createProcessInputStatic(InternalModelElementContainer parent){
		createProcessInputStatic(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProcessInputStatic with the given id. Post create hook will be triggered.
	 */
	def createProcessInputStatic(String ID, InternalModelElementContainer parent){
		createProcessInputStatic(ID,null,parent,true)
	}
	
	def createProcessInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProcessInputStatic(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProcessInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createProcessInputStatic(InternalModelElement ime) {
		createProcessInputStatic(generateUUID,ime,null,false)
	}
	
	override createProcessInputStatic() {
		createProcessInputStatic(generateUUID)
	}
	/**
	 * This method creates an IterateJavaNativeSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createIterateJavaNativeSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createIterateJavaNativeSIB => [
			setID(ID)
			internal = ime ?: createInternalIterateJavaNativeSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.IterateJavaNativeSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an IterateJavaNativeSIB with the given id. Post create hook won't be triggered.
	 */
	def createIterateJavaNativeSIB(String ID){
		createIterateJavaNativeSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an IterateJavaNativeSIB with the given id. Post create hook will be triggered.
	 */
	def createIterateJavaNativeSIB(InternalModelElementContainer parent){
		createIterateJavaNativeSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an IterateJavaNativeSIB with the given id. Post create hook will be triggered.
	 */
	def createIterateJavaNativeSIB(String ID, InternalModelElementContainer parent){
		createIterateJavaNativeSIB(ID,null,parent,true)
	}
	
	def createIterateJavaNativeSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createIterateJavaNativeSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an IterateJavaNativeSIB with the given id. Post create hook won't be triggered.
	 */
	def createIterateJavaNativeSIB(InternalModelElement ime) {
		createIterateJavaNativeSIB(generateUUID,ime,null,false)
	}
	
	override createIterateJavaNativeSIB() {
		createIterateJavaNativeSIB(generateUUID)
	}
	/**
	 * This method creates an SetAttributeValueSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createSetAttributeValueSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createSetAttributeValueSIB => [
			setID(ID)
			internal = ime ?: createInternalSetAttributeValueSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.SetAttributeValueSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an SetAttributeValueSIB with the given id. Post create hook won't be triggered.
	 */
	def createSetAttributeValueSIB(String ID){
		createSetAttributeValueSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an SetAttributeValueSIB with the given id. Post create hook will be triggered.
	 */
	def createSetAttributeValueSIB(InternalModelElementContainer parent){
		createSetAttributeValueSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an SetAttributeValueSIB with the given id. Post create hook will be triggered.
	 */
	def createSetAttributeValueSIB(String ID, InternalModelElementContainer parent){
		createSetAttributeValueSIB(ID,null,parent,true)
	}
	
	def createSetAttributeValueSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createSetAttributeValueSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an SetAttributeValueSIB with the given id. Post create hook won't be triggered.
	 */
	def createSetAttributeValueSIB(InternalModelElement ime) {
		createSetAttributeValueSIB(generateUUID,ime,null,false)
	}
	
	override createSetAttributeValueSIB() {
		createSetAttributeValueSIB(generateUUID)
	}
	def createPrimitiveUpdate(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createPrimitiveUpdate => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveUpdate => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.PrimitiveUpdateEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an PrimitiveUpdate with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveUpdate(String ID, InternalNode source, InternalNode target){
		createPrimitiveUpdate(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveUpdate with generated id. Post create hook will be triggered.
	 */
	def createPrimitiveUpdate(InternalNode source, InternalNode target){
		createPrimitiveUpdate(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveUpdate with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveUpdate(String ID){
		createPrimitiveUpdate(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveUpdate with a generated id. Post create hook won't be triggered.
	 */
	override createPrimitiveUpdate() {
		createPrimitiveUpdate(generateUUID)
	}
	/**
	 * This method creates an ContainsJavaNativeSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createContainsJavaNativeSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createContainsJavaNativeSIB => [
			setID(ID)
			internal = ime ?: createInternalContainsJavaNativeSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ContainsJavaNativeSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ContainsJavaNativeSIB with the given id. Post create hook won't be triggered.
	 */
	def createContainsJavaNativeSIB(String ID){
		createContainsJavaNativeSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ContainsJavaNativeSIB with the given id. Post create hook will be triggered.
	 */
	def createContainsJavaNativeSIB(InternalModelElementContainer parent){
		createContainsJavaNativeSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ContainsJavaNativeSIB with the given id. Post create hook will be triggered.
	 */
	def createContainsJavaNativeSIB(String ID, InternalModelElementContainer parent){
		createContainsJavaNativeSIB(ID,null,parent,true)
	}
	
	def createContainsJavaNativeSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createContainsJavaNativeSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ContainsJavaNativeSIB with the given id. Post create hook won't be triggered.
	 */
	def createContainsJavaNativeSIB(InternalModelElement ime) {
		createContainsJavaNativeSIB(generateUUID,ime,null,false)
	}
	
	override createContainsJavaNativeSIB() {
		createContainsJavaNativeSIB(generateUUID)
	}
	/**
	 * This method creates an EnumSwitchSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createEnumSwitchSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createEnumSwitchSIB => [
			setID(ID)
			internal = ime ?: createInternalEnumSwitchSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.EnumSwitchSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an EnumSwitchSIB with the given id. Post create hook won't be triggered.
	 */
	def createEnumSwitchSIB(String ID){
		createEnumSwitchSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an EnumSwitchSIB with the given id. Post create hook will be triggered.
	 */
	def createEnumSwitchSIB(InternalModelElementContainer parent){
		createEnumSwitchSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an EnumSwitchSIB with the given id. Post create hook will be triggered.
	 */
	def createEnumSwitchSIB(String ID, InternalModelElementContainer parent){
		createEnumSwitchSIB(ID,null,parent,true)
	}
	
	def createEnumSwitchSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createEnumSwitchSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an EnumSwitchSIB with the given id. Post create hook won't be triggered.
	 */
	def createEnumSwitchSIB(InternalModelElement ime) {
		createEnumSwitchSIB(generateUUID,ime,null,false)
	}
	
	override createEnumSwitchSIB() {
		createEnumSwitchSIB(generateUUID)
	}
	def createEventConnector(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createEventConnector => [
			setID(ID)
			internal = ime ?: createInternalEventConnector => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.EventConnectorEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an EventConnector with the given id. Post create hook will be triggered.
	 */
	def createEventConnector(String ID, InternalNode source, InternalNode target){
		createEventConnector(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an EventConnector with generated id. Post create hook will be triggered.
	 */
	def createEventConnector(InternalNode source, InternalNode target){
		createEventConnector(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an EventConnector with the given id. Post create hook won't be triggered.
	 */
	def createEventConnector(String ID){
		createEventConnector(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an EventConnector with a generated id. Post create hook won't be triggered.
	 */
	override createEventConnector() {
		createEventConnector(generateUUID)
	}
	/**
	 * This method creates an EntryPointProcessSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createEntryPointProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createEntryPointProcessSIB => [
			setID(ID)
			internal = ime ?: createInternalEntryPointProcessSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.EntryPointProcessSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an EntryPointProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createEntryPointProcessSIB(String ID){
		createEntryPointProcessSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an EntryPointProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createEntryPointProcessSIB(InternalModelElementContainer parent){
		createEntryPointProcessSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an EntryPointProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createEntryPointProcessSIB(String ID, InternalModelElementContainer parent){
		createEntryPointProcessSIB(ID,null,parent,true)
	}
	
	def createEntryPointProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createEntryPointProcessSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an EntryPointProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createEntryPointProcessSIB(InternalModelElement ime) {
		createEntryPointProcessSIB(generateUUID,ime,null,false)
	}
	
	override createEntryPointProcessSIB() {
		createEntryPointProcessSIB(generateUUID)
	}
	def createJavaNativeUpdate(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createJavaNativeUpdate => [
			setID(ID)
			internal = ime ?: createInternalJavaNativeUpdate => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.process.adapter.JavaNativeUpdateEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an JavaNativeUpdate with the given id. Post create hook will be triggered.
	 */
	def createJavaNativeUpdate(String ID, InternalNode source, InternalNode target){
		createJavaNativeUpdate(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an JavaNativeUpdate with generated id. Post create hook will be triggered.
	 */
	def createJavaNativeUpdate(InternalNode source, InternalNode target){
		createJavaNativeUpdate(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an JavaNativeUpdate with the given id. Post create hook won't be triggered.
	 */
	def createJavaNativeUpdate(String ID){
		createJavaNativeUpdate(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an JavaNativeUpdate with a generated id. Post create hook won't be triggered.
	 */
	override createJavaNativeUpdate() {
		createJavaNativeUpdate(generateUUID)
	}
	/**
	 * This method creates an RetrieveOfTypeSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createRetrieveOfTypeSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createRetrieveOfTypeSIB => [
			setID(ID)
			internal = ime ?: createInternalRetrieveOfTypeSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.RetrieveOfTypeSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an RetrieveOfTypeSIB with the given id. Post create hook won't be triggered.
	 */
	def createRetrieveOfTypeSIB(String ID){
		createRetrieveOfTypeSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an RetrieveOfTypeSIB with the given id. Post create hook will be triggered.
	 */
	def createRetrieveOfTypeSIB(InternalModelElementContainer parent){
		createRetrieveOfTypeSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an RetrieveOfTypeSIB with the given id. Post create hook will be triggered.
	 */
	def createRetrieveOfTypeSIB(String ID, InternalModelElementContainer parent){
		createRetrieveOfTypeSIB(ID,null,parent,true)
	}
	
	def createRetrieveOfTypeSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createRetrieveOfTypeSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an RetrieveOfTypeSIB with the given id. Post create hook won't be triggered.
	 */
	def createRetrieveOfTypeSIB(InternalModelElement ime) {
		createRetrieveOfTypeSIB(generateUUID,ime,null,false)
	}
	
	override createRetrieveOfTypeSIB() {
		createRetrieveOfTypeSIB(generateUUID)
	}
	/**
	 * This method creates an AtomicSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createAtomicSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createAtomicSIB => [
			setID(ID)
			internal = ime ?: createInternalAtomicSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.AtomicSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an AtomicSIB with the given id. Post create hook won't be triggered.
	 */
	def createAtomicSIB(String ID){
		createAtomicSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an AtomicSIB with the given id. Post create hook will be triggered.
	 */
	def createAtomicSIB(InternalModelElementContainer parent){
		createAtomicSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an AtomicSIB with the given id. Post create hook will be triggered.
	 */
	def createAtomicSIB(String ID, InternalModelElementContainer parent){
		createAtomicSIB(ID,null,parent,true)
	}
	
	def createAtomicSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createAtomicSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an AtomicSIB with the given id. Post create hook won't be triggered.
	 */
	def createAtomicSIB(InternalModelElement ime) {
		createAtomicSIB(generateUUID,ime,null,false)
	}
	
	override createAtomicSIB() {
		createAtomicSIB(generateUUID)
	}
	/**
	 * This method creates an BooleanInputStatic with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBooleanInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBooleanInputStatic => [
			setID(ID)
			internal = ime ?: createInternalBooleanInputStatic => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.BooleanInputStaticEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an BooleanInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createBooleanInputStatic(String ID){
		createBooleanInputStatic(ID,null,null,false)
	}
	
	/**
	 * This method creates an BooleanInputStatic with the given id. Post create hook will be triggered.
	 */
	def createBooleanInputStatic(InternalModelElementContainer parent){
		createBooleanInputStatic(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an BooleanInputStatic with the given id. Post create hook will be triggered.
	 */
	def createBooleanInputStatic(String ID, InternalModelElementContainer parent){
		createBooleanInputStatic(ID,null,parent,true)
	}
	
	def createBooleanInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBooleanInputStatic(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an BooleanInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createBooleanInputStatic(InternalModelElement ime) {
		createBooleanInputStatic(generateUUID,ime,null,false)
	}
	
	override createBooleanInputStatic() {
		createBooleanInputStatic(generateUUID)
	}
	/**
	 * This method creates an ExtensionAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createExtensionAttribute => [
			setID(ID)
			internal = ime ?: createInternalExtensionAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.ExtensionAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createExtensionAttribute(String ID){
		createExtensionAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createExtensionAttribute(InternalModelElementContainer parent){
		createExtensionAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createExtensionAttribute(String ID, InternalModelElementContainer parent){
		createExtensionAttribute(ID,null,parent,true)
	}
	
	def createExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createExtensionAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createExtensionAttribute(InternalModelElement ime) {
		createExtensionAttribute(generateUUID,ime,null,false)
	}
	
	override createExtensionAttribute() {
		createExtensionAttribute(generateUUID)
	}
	/**
	 * This method creates an GuardContainer with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGuardContainer(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGuardContainer => [
			setID(ID)
			internal = ime ?: createInternalGuardContainer => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.GuardContainerEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an GuardContainer with the given id. Post create hook won't be triggered.
	 */
	def createGuardContainer(String ID){
		createGuardContainer(ID,null,null,false)
	}
	
	/**
	 * This method creates an GuardContainer with the given id. Post create hook will be triggered.
	 */
	def createGuardContainer(InternalModelElementContainer parent){
		createGuardContainer(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GuardContainer with the given id. Post create hook will be triggered.
	 */
	def createGuardContainer(String ID, InternalModelElementContainer parent){
		createGuardContainer(ID,null,parent,true)
	}
	
	def createGuardContainer(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGuardContainer(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GuardContainer with the given id. Post create hook won't be triggered.
	 */
	def createGuardContainer(InternalModelElement ime) {
		createGuardContainer(generateUUID,ime,null,false)
	}
	
	override createGuardContainer() {
		createGuardContainer(generateUUID)
	}
	/**
	 * This method creates an CreateUserSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createCreateUserSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createCreateUserSIB => [
			setID(ID)
			internal = ime ?: createInternalCreateUserSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.process.adapter.CreateUserSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an CreateUserSIB with the given id. Post create hook won't be triggered.
	 */
	def createCreateUserSIB(String ID){
		createCreateUserSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an CreateUserSIB with the given id. Post create hook will be triggered.
	 */
	def createCreateUserSIB(InternalModelElementContainer parent){
		createCreateUserSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an CreateUserSIB with the given id. Post create hook will be triggered.
	 */
	def createCreateUserSIB(String ID, InternalModelElementContainer parent){
		createCreateUserSIB(ID,null,parent,true)
	}
	
	def createCreateUserSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createCreateUserSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an CreateUserSIB with the given id. Post create hook won't be triggered.
	 */
	def createCreateUserSIB(InternalModelElement ime) {
		createCreateUserSIB(generateUUID,ime,null,false)
	}
	
	override createCreateUserSIB() {
		createCreateUserSIB(generateUUID)
	}
	
	private def <T extends IdentifiableElement> setInternal(T elm, InternalIdentifiableElement internal) {
		elm => [
			if (id.isNullOrEmpty)
				ID = generateUUID
			switch elm {
				GraphModel: elm.setInternalElement_(internal as InternalGraphModel)
				ModelElement: elm.setInternalElement_(internal as InternalModelElement)
				Type: elm.setInternalElement_(internal as InternalType)
			}
		]
	}
	
	/**
	* This method creates a new Process object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can 
	* simply call the Process's save method to save your changes.
	*/
	def info.scce.dime.process.process.Process createProcess(java.lang.String path, java.lang.String fileName) {
		var filePath = new org.eclipse.core.runtime.Path(path).append(fileName).addFileExtension("process");
		var uri = org.eclipse.emf.common.util.URI.createPlatformResourceURI(filePath.toOSString(), true);
		var res = new org.eclipse.emf.ecore.resource.impl.ResourceSetImpl().createResource(uri);
		var graph = info.scce.dime.process.factory.ProcessFactory.eINSTANCE.createProcess();
		
		org.eclipse.emf.ecore.util.EcoreUtil.setID(graph, org.eclipse.emf.ecore.util.EcoreUtil.generateUUID());

		res.getContents().add(graph.getInternalElement_());
		
		postCreates(graph);
		try {
			res.save(null);
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}

		return graph;
	}
	
	def postCreates(info.scce.dime.process.process.StartSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ProcessNodePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.EndSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ProcessNodePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.Branch me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ProcessNodePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.SearchSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.SearchSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.CreateSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.CreateSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.TransientCreateSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.TransientCreateSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.CreateUserSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.CreateUserSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ContainsSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ContainsSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ContainsJavaNativeSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ContainsJavaNativeSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ContainsPrimitiveSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ContainsPrimitiveSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.IsOfTypeSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.IsOfTypeSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.IterateSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.IterateSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.IterateJavaNativeSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.IterateJavaNativeSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.IteratePrimitiveSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.IteratePrimitiveSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.PutComplexToContextSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.PutComplexToContextSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.PutToContextSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.PutToContextSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.TriggerEventSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.TriggerEventSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.RetrieveOfTypeSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.RetrieveOfTypeSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.RetrieveCurrentUserSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.RetrieveCurrentUserSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.SwitchToUserSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.SwitchToUserSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.GetOriginalUserSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.GetOriginalUserSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.SwitchToOriginalUserSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.SwitchToOriginalUserSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.DeleteSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.DeleteSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.RemoveFromListSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.RemoveFromListSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.PutPrimitiveToContextSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.PutPrimitiveToContextSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.LinkProcessSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.LinkProcessSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.EnumSwitchSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.EnumSwitchSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.RetrieveEnumLiteralSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.RetrieveEnumLiteralSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.SetAttributeValueSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.SetAttributeValueSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.UnsetAttributeValueSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.UnsetAttributeValueSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.AtomicSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.AtomicSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ProcessSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ProcessSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.GenericSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.GenericSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ProcessPlaceholderSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ProcessSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.GUISIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.GUISIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.GuardedProcessSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.GuardedProcessSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.EntryPointProcessSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ProcessSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.GuardProcessSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.GuardProcessSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ProcessBlueprintSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ProcessNodePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.BranchBlueprint me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ProcessNodePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ComplexInputPort me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.InputHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ComplexAttributePort me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ComplexAttributePortHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.PrimitiveAttributePort me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.PrimitiveAttributePortHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.PrimitiveInputPort me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.InputHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.JavaNativeInputPort me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.InputHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ProcessInputStatic me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.InputHook().postCreate(me)
		]
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ProcessInputStaticHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.PrimitiveOutputPort me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.OutputPortHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ComplexOutputPort me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.OutputPortHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.JavaNativeOutputPort me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.OutputPortHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.PrimitiveVariable me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.Variable_PostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.JavaNativeVariable me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.Variable_PostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ComplexVariable me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ComplexVariablePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.NativeFrontendSIBReference me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.CreateNativeFrontendSIBReference().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.ComplexDirectDataFlow me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.DirectDataFlowPostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.PrimitiveDirectDataFlow me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.DirectDataFlowPostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.JavaNativeDirectDataFlow me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.DirectDataFlowPostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.process.process.Process me) {
		me.transact [ // Post create hook
			new info.scce.dime.process.hooks.ProcessInit().postCreate(me)
		]
	}
	
}
