package info.scce.dime.gui.factory

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

import info.scce.dime.gui.gui.GuiPackage
import info.scce.dime.gui.gui.impl.GuiFactoryImpl
import info.scce.dime.gui.gui.internal.InternalFactory
import info.scce.dime.gui.gui.internal.InternalPackage

import info.scce.dime.gui.gui.adapter.*

import graphmodel.internal.InternalModelElement
import graphmodel.internal.InternalModelElementContainer
import graphmodel.internal.InternalGraphModel
import graphmodel.internal.InternalContainer
import graphmodel.internal.InternalNode
import graphmodel.internal.InternalEdge
import graphmodel.internal.InternalType
import graphmodel.internal.InternalIdentifiableElement
import graphmodel.ModelElement
import graphmodel.IdentifiableElement
import graphmodel.GraphModel
import graphmodel.Type

import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EPackage
import org.eclipse.emf.ecore.plugin.EcorePlugin

class GUIFactory extends GuiFactoryImpl {
	
	final extension InternalFactory = InternalFactory.eINSTANCE
	public static GUIFactory eINSTANCE = GUIFactory.init
	
	extension de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension = new de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension
	
	static def GUIFactory init() {
		try {
			val fct = EPackage::Registry.INSTANCE.getEFactory(GuiPackage.eNS_URI) as GUIFactory
			if (fct !== null)
				return fct as GUIFactory
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		new GUIFactory
	}
	
	def createAddPrimitiveToSubmission(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createAddPrimitiveToSubmission => [
			setID(ID)
			internal = ime ?: createInternalAddPrimitiveToSubmission => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.AddPrimitiveToSubmissionEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an AddPrimitiveToSubmission with the given id. Post create hook will be triggered.
	 */
	def createAddPrimitiveToSubmission(String ID, InternalNode source, InternalNode target){
		createAddPrimitiveToSubmission(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an AddPrimitiveToSubmission with generated id. Post create hook will be triggered.
	 */
	def createAddPrimitiveToSubmission(InternalNode source, InternalNode target){
		createAddPrimitiveToSubmission(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an AddPrimitiveToSubmission with the given id. Post create hook won't be triggered.
	 */
	def createAddPrimitiveToSubmission(String ID){
		createAddPrimitiveToSubmission(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an AddPrimitiveToSubmission with a generated id. Post create hook won't be triggered.
	 */
	override createAddPrimitiveToSubmission() {
		createAddPrimitiveToSubmission(generateUUID)
	}
	def createSetGenericType(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createSetGenericType => [
			setID(ID)
			internal = ime ?: createInternalSetGenericType => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.SetGenericTypeEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an SetGenericType with the given id. Post create hook will be triggered.
	 */
	def createSetGenericType(String ID, InternalNode source, InternalNode target){
		createSetGenericType(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an SetGenericType with generated id. Post create hook will be triggered.
	 */
	def createSetGenericType(InternalNode source, InternalNode target){
		createSetGenericType(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an SetGenericType with the given id. Post create hook won't be triggered.
	 */
	def createSetGenericType(String ID){
		createSetGenericType(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an SetGenericType with a generated id. Post create hook won't be triggered.
	 */
	override createSetGenericType() {
		createSetGenericType(generateUUID)
	}
	/**
	 * This method creates an FormFieldValidation with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createFormFieldValidation(String ID, InternalModelElement ime, boolean hook){
		super.createFormFieldValidation => [ 
			setID(ID)
			internal = ime ?: createInternalFormFieldValidation => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.FormFieldValidationEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an FormFieldValidation with the given id. Post create hook won't be triggered.
	 */
	def createFormFieldValidation(String ID){
		createFormFieldValidation(ID,null,false)
	}
	
	/**
	 * This method creates an FormFieldValidation with the given id. Post create hook won't be triggered.
	 */
	def createFormFieldValidation(InternalModelElement ime) {
		createFormFieldValidation(generateUUID,ime,false)
	}
	
	override createFormFieldValidation() {
		createFormFieldValidation(generateUUID)
	}
	/**
	 * This method creates an Thumbnail with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createThumbnail(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createThumbnail => [
			setID(ID)
			internal = ime ?: createInternalThumbnail => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ThumbnailEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Thumbnail with the given id. Post create hook won't be triggered.
	 */
	def createThumbnail(String ID){
		createThumbnail(ID,null,null,false)
	}
	
	/**
	 * This method creates an Thumbnail with the given id. Post create hook will be triggered.
	 */
	def createThumbnail(InternalModelElementContainer parent){
		createThumbnail(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Thumbnail with the given id. Post create hook will be triggered.
	 */
	def createThumbnail(String ID, InternalModelElementContainer parent){
		createThumbnail(ID,null,parent,true)
	}
	
	def createThumbnail(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createThumbnail(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Thumbnail with the given id. Post create hook won't be triggered.
	 */
	def createThumbnail(InternalModelElement ime) {
		createThumbnail(generateUUID,ime,null,false)
	}
	
	override createThumbnail() {
		createThumbnail(generateUUID)
	}
	/**
	 * This method creates an GeneralStyling with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGeneralStyling(String ID, InternalModelElement ime, boolean hook){
		super.createGeneralStyling => [ 
			setID(ID)
			internal = ime ?: createInternalGeneralStyling => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.GeneralStylingEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an GeneralStyling with the given id. Post create hook won't be triggered.
	 */
	def createGeneralStyling(String ID){
		createGeneralStyling(ID,null,false)
	}
	
	/**
	 * This method creates an GeneralStyling with the given id. Post create hook won't be triggered.
	 */
	def createGeneralStyling(InternalModelElement ime) {
		createGeneralStyling(generateUUID,ime,false)
	}
	
	override createGeneralStyling() {
		createGeneralStyling(generateUUID)
	}
	/**
	 * This method creates an Listentry with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createListentry(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createListentry => [
			setID(ID)
			internal = ime ?: createInternalListentry => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ListentryEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Listentry with the given id. Post create hook won't be triggered.
	 */
	def createListentry(String ID){
		createListentry(ID,null,null,false)
	}
	
	/**
	 * This method creates an Listentry with the given id. Post create hook will be triggered.
	 */
	def createListentry(InternalModelElementContainer parent){
		createListentry(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Listentry with the given id. Post create hook will be triggered.
	 */
	def createListentry(String ID, InternalModelElementContainer parent){
		createListentry(ID,null,parent,true)
	}
	
	def createListentry(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createListentry(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Listentry with the given id. Post create hook won't be triggered.
	 */
	def createListentry(InternalModelElement ime) {
		createListentry(generateUUID,ime,null,false)
	}
	
	override createListentry() {
		createListentry(generateUUID)
	}
	def createFormLoadSubmit(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createFormLoadSubmit => [
			setID(ID)
			internal = ime ?: createInternalFormLoadSubmit => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.FormLoadSubmitEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an FormLoadSubmit with the given id. Post create hook will be triggered.
	 */
	def createFormLoadSubmit(String ID, InternalNode source, InternalNode target){
		createFormLoadSubmit(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an FormLoadSubmit with generated id. Post create hook will be triggered.
	 */
	def createFormLoadSubmit(InternalNode source, InternalNode target){
		createFormLoadSubmit(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an FormLoadSubmit with the given id. Post create hook won't be triggered.
	 */
	def createFormLoadSubmit(String ID){
		createFormLoadSubmit(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an FormLoadSubmit with a generated id. Post create hook won't be triggered.
	 */
	override createFormLoadSubmit() {
		createFormLoadSubmit(generateUUID)
	}
	/**
	 * This method creates an ButtonGroup with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createButtonGroup(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createButtonGroup => [
			setID(ID)
			internal = ime ?: createInternalButtonGroup => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ButtonGroupEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ButtonGroup with the given id. Post create hook won't be triggered.
	 */
	def createButtonGroup(String ID){
		createButtonGroup(ID,null,null,false)
	}
	
	/**
	 * This method creates an ButtonGroup with the given id. Post create hook will be triggered.
	 */
	def createButtonGroup(InternalModelElementContainer parent){
		createButtonGroup(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ButtonGroup with the given id. Post create hook will be triggered.
	 */
	def createButtonGroup(String ID, InternalModelElementContainer parent){
		createButtonGroup(ID,null,parent,true)
	}
	
	def createButtonGroup(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createButtonGroup(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ButtonGroup with the given id. Post create hook won't be triggered.
	 */
	def createButtonGroup(InternalModelElement ime) {
		createButtonGroup(generateUUID,ime,null,false)
	}
	
	override createButtonGroup() {
		createButtonGroup(generateUUID)
	}
	/**
	 * This method creates an TopNavBar with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTopNavBar(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTopNavBar => [
			setID(ID)
			internal = ime ?: createInternalTopNavBar => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.TopNavBarEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an TopNavBar with the given id. Post create hook won't be triggered.
	 */
	def createTopNavBar(String ID){
		createTopNavBar(ID,null,null,false)
	}
	
	/**
	 * This method creates an TopNavBar with the given id. Post create hook will be triggered.
	 */
	def createTopNavBar(InternalModelElementContainer parent){
		createTopNavBar(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an TopNavBar with the given id. Post create hook will be triggered.
	 */
	def createTopNavBar(String ID, InternalModelElementContainer parent){
		createTopNavBar(ID,null,parent,true)
	}
	
	def createTopNavBar(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTopNavBar(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an TopNavBar with the given id. Post create hook won't be triggered.
	 */
	def createTopNavBar(InternalModelElement ime) {
		createTopNavBar(generateUUID,ime,null,false)
	}
	
	override createTopNavBar() {
		createTopNavBar(generateUUID)
	}
	/**
	 * This method creates an ModalCloseButton with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createModalCloseButton(String ID, InternalModelElement ime, boolean hook){
		super.createModalCloseButton => [ 
			setID(ID)
			internal = ime ?: createInternalModalCloseButton => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ModalCloseButtonEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ModalCloseButton with the given id. Post create hook won't be triggered.
	 */
	def createModalCloseButton(String ID){
		createModalCloseButton(ID,null,false)
	}
	
	/**
	 * This method creates an ModalCloseButton with the given id. Post create hook won't be triggered.
	 */
	def createModalCloseButton(InternalModelElement ime) {
		createModalCloseButton(generateUUID,ime,false)
	}
	
	override createModalCloseButton() {
		createModalCloseButton(generateUUID)
	}
	def createIF(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createIF => [
			setID(ID)
			internal = ime ?: createInternalIF => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.IFEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an IF with the given id. Post create hook will be triggered.
	 */
	def createIF(String ID, InternalNode source, InternalNode target){
		createIF(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an IF with generated id. Post create hook will be triggered.
	 */
	def createIF(InternalNode source, InternalNode target){
		createIF(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an IF with the given id. Post create hook won't be triggered.
	 */
	def createIF(String ID){
		createIF(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an IF with a generated id. Post create hook won't be triggered.
	 */
	override createIF() {
		createIF(generateUUID)
	}
	/**
	 * This method creates an GuardSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGuardSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGuardSIB => [
			setID(ID)
			internal = ime ?: createInternalGuardSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.GuardSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GuardSIB with the given id. Post create hook won't be triggered.
	 */
	def createGuardSIB(String ID){
		createGuardSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an GuardSIB with the given id. Post create hook will be triggered.
	 */
	def createGuardSIB(InternalModelElementContainer parent){
		createGuardSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GuardSIB with the given id. Post create hook will be triggered.
	 */
	def createGuardSIB(String ID, InternalModelElementContainer parent){
		createGuardSIB(ID,null,parent,true)
	}
	
	def createGuardSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGuardSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GuardSIB with the given id. Post create hook won't be triggered.
	 */
	def createGuardSIB(InternalModelElement ime) {
		createGuardSIB(generateUUID,ime,null,false)
	}
	
	override createGuardSIB() {
		createGuardSIB(generateUUID)
	}
	def createIS(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createIS => [
			setID(ID)
			internal = ime ?: createInternalIS => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ISEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an IS with the given id. Post create hook will be triggered.
	 */
	def createIS(String ID, InternalNode source, InternalNode target){
		createIS(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an IS with generated id. Post create hook will be triggered.
	 */
	def createIS(InternalNode source, InternalNode target){
		createIS(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an IS with the given id. Post create hook won't be triggered.
	 */
	def createIS(String ID){
		createIS(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an IS with a generated id. Post create hook won't be triggered.
	 */
	override createIS() {
		createIS(generateUUID)
	}
	/**
	 * This method creates an FORSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createFORSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createFORSIB => [
			setID(ID)
			internal = ime ?: createInternalFORSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.FORSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an FORSIB with the given id. Post create hook won't be triggered.
	 */
	def createFORSIB(String ID){
		createFORSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an FORSIB with the given id. Post create hook will be triggered.
	 */
	def createFORSIB(InternalModelElementContainer parent){
		createFORSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an FORSIB with the given id. Post create hook will be triggered.
	 */
	def createFORSIB(String ID, InternalModelElementContainer parent){
		createFORSIB(ID,null,parent,true)
	}
	
	def createFORSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createFORSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an FORSIB with the given id. Post create hook won't be triggered.
	 */
	def createFORSIB(InternalModelElement ime) {
		createFORSIB(generateUUID,ime,null,false)
	}
	
	override createFORSIB() {
		createFORSIB(generateUUID)
	}
	/**
	 * This method creates an Button with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createButton(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createButton => [
			setID(ID)
			internal = ime ?: createInternalButton => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ButtonEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Button with the given id. Post create hook won't be triggered.
	 */
	def createButton(String ID){
		createButton(ID,null,null,false)
	}
	
	/**
	 * This method creates an Button with the given id. Post create hook will be triggered.
	 */
	def createButton(InternalModelElementContainer parent){
		createButton(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Button with the given id. Post create hook will be triggered.
	 */
	def createButton(String ID, InternalModelElementContainer parent){
		createButton(ID,null,parent,true)
	}
	
	def createButton(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createButton(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Button with the given id. Post create hook won't be triggered.
	 */
	def createButton(InternalModelElement ime) {
		createButton(generateUUID,ime,null,false)
	}
	
	override createButton() {
		createButton(generateUUID)
	}
	/**
	 * This method creates an ComplexExtensionAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexExtensionAttribute => [
			setID(ID)
			internal = ime ?: createInternalComplexExtensionAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexExtensionAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexExtensionAttribute(String ID){
		createComplexExtensionAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexExtensionAttribute(InternalModelElementContainer parent){
		createComplexExtensionAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexExtensionAttribute(String ID, InternalModelElementContainer parent){
		createComplexExtensionAttribute(ID,null,parent,true)
	}
	
	def createComplexExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexExtensionAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexExtensionAttribute(InternalModelElement ime) {
		createComplexExtensionAttribute(generateUUID,ime,null,false)
	}
	
	override createComplexExtensionAttribute() {
		createComplexExtensionAttribute(generateUUID)
	}
	/**
	 * This method creates an TimestampInputStatic with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTimestampInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTimestampInputStatic => [
			setID(ID)
			internal = ime ?: createInternalTimestampInputStatic => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.TimestampInputStaticEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an TimestampInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createTimestampInputStatic(String ID){
		createTimestampInputStatic(ID,null,null,false)
	}
	
	/**
	 * This method creates an TimestampInputStatic with the given id. Post create hook will be triggered.
	 */
	def createTimestampInputStatic(InternalModelElementContainer parent){
		createTimestampInputStatic(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an TimestampInputStatic with the given id. Post create hook will be triggered.
	 */
	def createTimestampInputStatic(String ID, InternalModelElementContainer parent){
		createTimestampInputStatic(ID,null,parent,true)
	}
	
	def createTimestampInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTimestampInputStatic(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an TimestampInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createTimestampInputStatic(InternalModelElement ime) {
		createTimestampInputStatic(generateUUID,ime,null,false)
	}
	
	override createTimestampInputStatic() {
		createTimestampInputStatic(generateUUID)
	}
	/**
	 * This method creates an ProgressBarStyling with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProgressBarStyling(String ID, InternalModelElement ime, boolean hook){
		super.createProgressBarStyling => [ 
			setID(ID)
			internal = ime ?: createInternalProgressBarStyling => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ProgressBarStylingEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ProgressBarStyling with the given id. Post create hook won't be triggered.
	 */
	def createProgressBarStyling(String ID){
		createProgressBarStyling(ID,null,false)
	}
	
	/**
	 * This method creates an ProgressBarStyling with the given id. Post create hook won't be triggered.
	 */
	def createProgressBarStyling(InternalModelElement ime) {
		createProgressBarStyling(generateUUID,ime,false)
	}
	
	override createProgressBarStyling() {
		createProgressBarStyling(generateUUID)
	}
	/**
	 * This method creates an Event with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createEvent(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createEvent => [
			setID(ID)
			internal = ime ?: createInternalEvent => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.EventEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Event with the given id. Post create hook won't be triggered.
	 */
	def createEvent(String ID){
		createEvent(ID,null,null,false)
	}
	
	/**
	 * This method creates an Event with the given id. Post create hook will be triggered.
	 */
	def createEvent(InternalModelElementContainer parent){
		createEvent(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Event with the given id. Post create hook will be triggered.
	 */
	def createEvent(String ID, InternalModelElementContainer parent){
		createEvent(ID,null,parent,true)
	}
	
	def createEvent(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createEvent(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Event with the given id. Post create hook won't be triggered.
	 */
	def createEvent(InternalModelElement ime) {
		createEvent(generateUUID,ime,null,false)
	}
	
	override createEvent() {
		createEvent(generateUUID)
	}
	/**
	 * This method creates an Field with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createField(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createField => [
			setID(ID)
			internal = ime ?: createInternalField => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.FieldEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Field with the given id. Post create hook won't be triggered.
	 */
	def createField(String ID){
		createField(ID,null,null,false)
	}
	
	/**
	 * This method creates an Field with the given id. Post create hook will be triggered.
	 */
	def createField(InternalModelElementContainer parent){
		createField(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Field with the given id. Post create hook will be triggered.
	 */
	def createField(String ID, InternalModelElementContainer parent){
		createField(ID,null,parent,true)
	}
	
	def createField(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createField(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Field with the given id. Post create hook won't be triggered.
	 */
	def createField(InternalModelElement ime) {
		createField(generateUUID,ime,null,false)
	}
	
	override createField() {
		createField(generateUUID)
	}
	/**
	 * This method creates an PrimitiveAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveAttribute => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.PrimitiveAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAttribute(String ID){
		createPrimitiveAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAttribute(InternalModelElementContainer parent){
		createPrimitiveAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAttribute(String ID, InternalModelElementContainer parent){
		createPrimitiveAttribute(ID,null,parent,true)
	}
	
	def createPrimitiveAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAttribute(InternalModelElement ime) {
		createPrimitiveAttribute(generateUUID,ime,null,false)
	}
	
	override createPrimitiveAttribute() {
		createPrimitiveAttribute(generateUUID)
	}
	/**
	 * This method creates an SelectFormFieldStyling with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createSelectFormFieldStyling(String ID, InternalModelElement ime, boolean hook){
		super.createSelectFormFieldStyling => [ 
			setID(ID)
			internal = ime ?: createInternalSelectFormFieldStyling => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.SelectFormFieldStylingEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an SelectFormFieldStyling with the given id. Post create hook won't be triggered.
	 */
	def createSelectFormFieldStyling(String ID){
		createSelectFormFieldStyling(ID,null,false)
	}
	
	/**
	 * This method creates an SelectFormFieldStyling with the given id. Post create hook won't be triggered.
	 */
	def createSelectFormFieldStyling(InternalModelElement ime) {
		createSelectFormFieldStyling(generateUUID,ime,false)
	}
	
	override createSelectFormFieldStyling() {
		createSelectFormFieldStyling(generateUUID)
	}
	/**
	 * This method creates an Description with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDescription(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDescription => [
			setID(ID)
			internal = ime ?: createInternalDescription => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.DescriptionEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Description with the given id. Post create hook won't be triggered.
	 */
	def createDescription(String ID){
		createDescription(ID,null,null,false)
	}
	
	/**
	 * This method creates an Description with the given id. Post create hook will be triggered.
	 */
	def createDescription(InternalModelElementContainer parent){
		createDescription(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Description with the given id. Post create hook will be triggered.
	 */
	def createDescription(String ID, InternalModelElementContainer parent){
		createDescription(ID,null,parent,true)
	}
	
	def createDescription(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDescription(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Description with the given id. Post create hook won't be triggered.
	 */
	def createDescription(InternalModelElement ime) {
		createDescription(generateUUID,ime,null,false)
	}
	
	override createDescription() {
		createDescription(generateUUID)
	}
	/**
	 * This method creates an EventListener with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createEventListener(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createEventListener => [
			setID(ID)
			internal = ime ?: createInternalEventListener => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.EventListenerEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an EventListener with the given id. Post create hook won't be triggered.
	 */
	def createEventListener(String ID){
		createEventListener(ID,null,null,false)
	}
	
	/**
	 * This method creates an EventListener with the given id. Post create hook will be triggered.
	 */
	def createEventListener(InternalModelElementContainer parent){
		createEventListener(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an EventListener with the given id. Post create hook will be triggered.
	 */
	def createEventListener(String ID, InternalModelElementContainer parent){
		createEventListener(ID,null,parent,true)
	}
	
	def createEventListener(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createEventListener(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an EventListener with the given id. Post create hook won't be triggered.
	 */
	def createEventListener(InternalModelElement ime) {
		createEventListener(generateUUID,ime,null,false)
	}
	
	override createEventListener() {
		createEventListener(generateUUID)
	}
	/**
	 * This method creates an SecuritySIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createSecuritySIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createSecuritySIB => [
			setID(ID)
			internal = ime ?: createInternalSecuritySIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.SecuritySIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an SecuritySIB with the given id. Post create hook won't be triggered.
	 */
	def createSecuritySIB(String ID){
		createSecuritySIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an SecuritySIB with the given id. Post create hook will be triggered.
	 */
	def createSecuritySIB(InternalModelElementContainer parent){
		createSecuritySIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an SecuritySIB with the given id. Post create hook will be triggered.
	 */
	def createSecuritySIB(String ID, InternalModelElementContainer parent){
		createSecuritySIB(ID,null,parent,true)
	}
	
	def createSecuritySIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createSecuritySIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an SecuritySIB with the given id. Post create hook won't be triggered.
	 */
	def createSecuritySIB(InternalModelElement ime) {
		createSecuritySIB(generateUUID,ime,null,false)
	}
	
	override createSecuritySIB() {
		createSecuritySIB(generateUUID)
	}
	/**
	 * This method creates an Argument with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createArgument(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createArgument => [
			setID(ID)
			internal = ime ?: createInternalArgument => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ArgumentEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Argument with the given id. Post create hook won't be triggered.
	 */
	def createArgument(String ID){
		createArgument(ID,null,null,false)
	}
	
	/**
	 * This method creates an Argument with the given id. Post create hook will be triggered.
	 */
	def createArgument(InternalModelElementContainer parent){
		createArgument(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Argument with the given id. Post create hook will be triggered.
	 */
	def createArgument(String ID, InternalModelElementContainer parent){
		createArgument(ID,null,parent,true)
	}
	
	def createArgument(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createArgument(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Argument with the given id. Post create hook won't be triggered.
	 */
	def createArgument(InternalModelElement ime) {
		createArgument(generateUUID,ime,null,false)
	}
	
	override createArgument() {
		createArgument(generateUUID)
	}
	/**
	 * This method creates an TODOList with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTODOList(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTODOList => [
			setID(ID)
			internal = ime ?: createInternalTODOList => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.TODOListEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an TODOList with the given id. Post create hook won't be triggered.
	 */
	def createTODOList(String ID){
		createTODOList(ID,null,null,false)
	}
	
	/**
	 * This method creates an TODOList with the given id. Post create hook will be triggered.
	 */
	def createTODOList(InternalModelElementContainer parent){
		createTODOList(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an TODOList with the given id. Post create hook will be triggered.
	 */
	def createTODOList(String ID, InternalModelElementContainer parent){
		createTODOList(ID,null,parent,true)
	}
	
	def createTODOList(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTODOList(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an TODOList with the given id. Post create hook won't be triggered.
	 */
	def createTODOList(InternalModelElement ime) {
		createTODOList(generateUUID,ime,null,false)
	}
	
	override createTODOList() {
		createTODOList(generateUUID)
	}
	/**
	 * This method creates an ComponentColoring with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComponentColoring(String ID, InternalModelElement ime, boolean hook){
		super.createComponentColoring => [ 
			setID(ID)
			internal = ime ?: createInternalComponentColoring => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ComponentColoringEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComponentColoring with the given id. Post create hook won't be triggered.
	 */
	def createComponentColoring(String ID){
		createComponentColoring(ID,null,false)
	}
	
	/**
	 * This method creates an ComponentColoring with the given id. Post create hook won't be triggered.
	 */
	def createComponentColoring(InternalModelElement ime) {
		createComponentColoring(generateUUID,ime,false)
	}
	
	override createComponentColoring() {
		createComponentColoring(generateUUID)
	}
	def createRegistration(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createRegistration => [
			setID(ID)
			internal = ime ?: createInternalRegistration => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.RegistrationEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an Registration with the given id. Post create hook will be triggered.
	 */
	def createRegistration(String ID, InternalNode source, InternalNode target){
		createRegistration(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an Registration with generated id. Post create hook will be triggered.
	 */
	def createRegistration(InternalNode source, InternalNode target){
		createRegistration(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an Registration with the given id. Post create hook won't be triggered.
	 */
	def createRegistration(String ID){
		createRegistration(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an Registration with a generated id. Post create hook won't be triggered.
	 */
	override createRegistration() {
		createRegistration(generateUUID)
	}
	def createComplexChoiceData(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexChoiceData => [
			setID(ID)
			internal = ime ?: createInternalComplexChoiceData => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexChoiceDataEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ComplexChoiceData with the given id. Post create hook will be triggered.
	 */
	def createComplexChoiceData(String ID, InternalNode source, InternalNode target){
		createComplexChoiceData(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexChoiceData with generated id. Post create hook will be triggered.
	 */
	def createComplexChoiceData(InternalNode source, InternalNode target){
		createComplexChoiceData(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexChoiceData with the given id. Post create hook won't be triggered.
	 */
	def createComplexChoiceData(String ID){
		createComplexChoiceData(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexChoiceData with a generated id. Post create hook won't be triggered.
	 */
	override createComplexChoiceData() {
		createComplexChoiceData(generateUUID)
	}
	/**
	 * This method creates an Form with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createForm(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createForm => [
			setID(ID)
			internal = ime ?: createInternalForm => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.FormEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Form with the given id. Post create hook won't be triggered.
	 */
	def createForm(String ID){
		createForm(ID,null,null,false)
	}
	
	/**
	 * This method creates an Form with the given id. Post create hook will be triggered.
	 */
	def createForm(InternalModelElementContainer parent){
		createForm(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Form with the given id. Post create hook will be triggered.
	 */
	def createForm(String ID, InternalModelElementContainer parent){
		createForm(ID,null,parent,true)
	}
	
	def createForm(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createForm(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Form with the given id. Post create hook won't be triggered.
	 */
	def createForm(InternalModelElement ime) {
		createForm(generateUUID,ime,null,false)
	}
	
	override createForm() {
		createForm(generateUUID)
	}
	def createPrimitivDataTarget(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createPrimitivDataTarget => [
			setID(ID)
			internal = ime ?: createInternalPrimitivDataTarget => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.PrimitivDataTargetEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an PrimitivDataTarget with the given id. Post create hook will be triggered.
	 */
	def createPrimitivDataTarget(String ID, InternalNode source, InternalNode target){
		createPrimitivDataTarget(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitivDataTarget with generated id. Post create hook will be triggered.
	 */
	def createPrimitivDataTarget(InternalNode source, InternalNode target){
		createPrimitivDataTarget(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitivDataTarget with the given id. Post create hook won't be triggered.
	 */
	def createPrimitivDataTarget(String ID){
		createPrimitivDataTarget(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an PrimitivDataTarget with a generated id. Post create hook won't be triggered.
	 */
	override createPrimitivDataTarget() {
		createPrimitivDataTarget(generateUUID)
	}
	/**
	 * This method creates an FormFieldStyling with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createFormFieldStyling(String ID, InternalModelElement ime, boolean hook){
		super.createFormFieldStyling => [ 
			setID(ID)
			internal = ime ?: createInternalFormFieldStyling => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.FormFieldStylingEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an FormFieldStyling with the given id. Post create hook won't be triggered.
	 */
	def createFormFieldStyling(String ID){
		createFormFieldStyling(ID,null,false)
	}
	
	/**
	 * This method creates an FormFieldStyling with the given id. Post create hook won't be triggered.
	 */
	def createFormFieldStyling(InternalModelElement ime) {
		createFormFieldStyling(generateUUID,ime,false)
	}
	
	override createFormFieldStyling() {
		createFormFieldStyling(generateUUID)
	}
	/**
	 * This method creates an BooleanInputStatic with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBooleanInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBooleanInputStatic => [
			setID(ID)
			internal = ime ?: createInternalBooleanInputStatic => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.BooleanInputStaticEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an BooleanInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createBooleanInputStatic(String ID){
		createBooleanInputStatic(ID,null,null,false)
	}
	
	/**
	 * This method creates an BooleanInputStatic with the given id. Post create hook will be triggered.
	 */
	def createBooleanInputStatic(InternalModelElementContainer parent){
		createBooleanInputStatic(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an BooleanInputStatic with the given id. Post create hook will be triggered.
	 */
	def createBooleanInputStatic(String ID, InternalModelElementContainer parent){
		createBooleanInputStatic(ID,null,parent,true)
	}
	
	def createBooleanInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBooleanInputStatic(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an BooleanInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createBooleanInputStatic(InternalModelElement ime) {
		createBooleanInputStatic(generateUUID,ime,null,false)
	}
	
	override createBooleanInputStatic() {
		createBooleanInputStatic(generateUUID)
	}
	/**
	 * This method creates an Descriptionentry with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDescriptionentry(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDescriptionentry => [
			setID(ID)
			internal = ime ?: createInternalDescriptionentry => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.DescriptionentryEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Descriptionentry with the given id. Post create hook won't be triggered.
	 */
	def createDescriptionentry(String ID){
		createDescriptionentry(ID,null,null,false)
	}
	
	/**
	 * This method creates an Descriptionentry with the given id. Post create hook will be triggered.
	 */
	def createDescriptionentry(InternalModelElementContainer parent){
		createDescriptionentry(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Descriptionentry with the given id. Post create hook will be triggered.
	 */
	def createDescriptionentry(String ID, InternalModelElementContainer parent){
		createDescriptionentry(ID,null,parent,true)
	}
	
	def createDescriptionentry(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDescriptionentry(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Descriptionentry with the given id. Post create hook won't be triggered.
	 */
	def createDescriptionentry(InternalModelElement ime) {
		createDescriptionentry(generateUUID,ime,null,false)
	}
	
	override createDescriptionentry() {
		createDescriptionentry(generateUUID)
	}
	def createTableColumnLoad(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createTableColumnLoad => [
			setID(ID)
			internal = ime ?: createInternalTableColumnLoad => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.TableColumnLoadEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an TableColumnLoad with the given id. Post create hook will be triggered.
	 */
	def createTableColumnLoad(String ID, InternalNode source, InternalNode target){
		createTableColumnLoad(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an TableColumnLoad with generated id. Post create hook will be triggered.
	 */
	def createTableColumnLoad(InternalNode source, InternalNode target){
		createTableColumnLoad(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an TableColumnLoad with the given id. Post create hook won't be triggered.
	 */
	def createTableColumnLoad(String ID){
		createTableColumnLoad(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an TableColumnLoad with a generated id. Post create hook won't be triggered.
	 */
	override createTableColumnLoad() {
		createTableColumnLoad(generateUUID)
	}
	def createDisplay(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createDisplay => [
			setID(ID)
			internal = ime ?: createInternalDisplay => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.DisplayEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an Display with the given id. Post create hook will be triggered.
	 */
	def createDisplay(String ID, InternalNode source, InternalNode target){
		createDisplay(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an Display with generated id. Post create hook will be triggered.
	 */
	def createDisplay(InternalNode source, InternalNode target){
		createDisplay(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an Display with the given id. Post create hook won't be triggered.
	 */
	def createDisplay(String ID){
		createDisplay(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an Display with a generated id. Post create hook won't be triggered.
	 */
	override createDisplay() {
		createDisplay(generateUUID)
	}
	/**
	 * This method creates an GUISIBModal with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUISIBModal(String ID, InternalModelElement ime, boolean hook){
		super.createGUISIBModal => [ 
			setID(ID)
			internal = ime ?: createInternalGUISIBModal => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.GUISIBModalEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an GUISIBModal with the given id. Post create hook won't be triggered.
	 */
	def createGUISIBModal(String ID){
		createGUISIBModal(ID,null,false)
	}
	
	/**
	 * This method creates an GUISIBModal with the given id. Post create hook won't be triggered.
	 */
	def createGUISIBModal(InternalModelElement ime) {
		createGUISIBModal(generateUUID,ime,false)
	}
	
	override createGUISIBModal() {
		createGUISIBModal(generateUUID)
	}
	/**
	 * This method creates an StaticContent with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createStaticContent(String ID, InternalModelElement ime, boolean hook){
		super.createStaticContent => [ 
			setID(ID)
			internal = ime ?: createInternalStaticContent => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.StaticContentEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an StaticContent with the given id. Post create hook won't be triggered.
	 */
	def createStaticContent(String ID){
		createStaticContent(ID,null,false)
	}
	
	/**
	 * This method creates an StaticContent with the given id. Post create hook won't be triggered.
	 */
	def createStaticContent(InternalModelElement ime) {
		createStaticContent(generateUUID,ime,false)
	}
	
	override createStaticContent() {
		createStaticContent(generateUUID)
	}
	/**
	 * This method creates an MoveLeft with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createMoveLeft(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createMoveLeft => [
			setID(ID)
			internal = ime ?: createInternalMoveLeft => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.MoveLeftEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an MoveLeft with the given id. Post create hook won't be triggered.
	 */
	def createMoveLeft(String ID){
		createMoveLeft(ID,null,null,false)
	}
	
	/**
	 * This method creates an MoveLeft with the given id. Post create hook will be triggered.
	 */
	def createMoveLeft(InternalModelElementContainer parent){
		createMoveLeft(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an MoveLeft with the given id. Post create hook will be triggered.
	 */
	def createMoveLeft(String ID, InternalModelElementContainer parent){
		createMoveLeft(ID,null,parent,true)
	}
	
	def createMoveLeft(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createMoveLeft(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an MoveLeft with the given id. Post create hook won't be triggered.
	 */
	def createMoveLeft(InternalModelElement ime) {
		createMoveLeft(generateUUID,ime,null,false)
	}
	
	override createMoveLeft() {
		createMoveLeft(generateUUID)
	}
	/**
	 * This method creates an GUI with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUI(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGUI => [ 
			setID(ID)
			internal = ime ?: createInternalGUI => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.GUIEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GUI with the given id. Post create hook won't be triggered.
	 */
	def createGUI(String ID){
		createGUI(ID,null,null,false)
	}
	
	/**
	 * This method creates an GUI with the given id. Post create hook will be triggered.
	 */
	def createGUI(InternalModelElementContainer parent){
		createGUI(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GUI with the given id. Post create hook will be triggered.
	 */
	def createGUI(String ID, InternalModelElementContainer parent){
		createGUI(ID,null,parent,true)
	}
	
	def createGUI(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGUI(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GUI with the given id. Post create hook won't be triggered.
	 */
	def createGUI(InternalModelElement ime) {
		createGUI(generateUUID,ime,null,false)
	}
	
	override createGUI() {
		createGUI(generateUUID)
	}
	/**
	 * This method creates an ProgressBar with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProgressBar(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProgressBar => [
			setID(ID)
			internal = ime ?: createInternalProgressBar => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ProgressBarEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ProgressBar with the given id. Post create hook won't be triggered.
	 */
	def createProgressBar(String ID){
		createProgressBar(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProgressBar with the given id. Post create hook will be triggered.
	 */
	def createProgressBar(InternalModelElementContainer parent){
		createProgressBar(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProgressBar with the given id. Post create hook will be triggered.
	 */
	def createProgressBar(String ID, InternalModelElementContainer parent){
		createProgressBar(ID,null,parent,true)
	}
	
	def createProgressBar(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProgressBar(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProgressBar with the given id. Post create hook won't be triggered.
	 */
	def createProgressBar(InternalModelElement ime) {
		createProgressBar(generateUUID,ime,null,false)
	}
	
	override createProgressBar() {
		createProgressBar(generateUUID)
	}
	/**
	 * This method creates an Jumbotron with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createJumbotron(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createJumbotron => [
			setID(ID)
			internal = ime ?: createInternalJumbotron => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.JumbotronEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Jumbotron with the given id. Post create hook won't be triggered.
	 */
	def createJumbotron(String ID){
		createJumbotron(ID,null,null,false)
	}
	
	/**
	 * This method creates an Jumbotron with the given id. Post create hook will be triggered.
	 */
	def createJumbotron(InternalModelElementContainer parent){
		createJumbotron(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Jumbotron with the given id. Post create hook will be triggered.
	 */
	def createJumbotron(String ID, InternalModelElementContainer parent){
		createJumbotron(ID,null,parent,true)
	}
	
	def createJumbotron(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createJumbotron(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Jumbotron with the given id. Post create hook won't be triggered.
	 */
	def createJumbotron(InternalModelElement ime) {
		createJumbotron(generateUUID,ime,null,false)
	}
	
	override createJumbotron() {
		createJumbotron(generateUUID)
	}
	/**
	 * This method creates an TableEntry with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTableEntry(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTableEntry => [
			setID(ID)
			internal = ime ?: createInternalTableEntry => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.TableEntryEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an TableEntry with the given id. Post create hook won't be triggered.
	 */
	def createTableEntry(String ID){
		createTableEntry(ID,null,null,false)
	}
	
	/**
	 * This method creates an TableEntry with the given id. Post create hook will be triggered.
	 */
	def createTableEntry(InternalModelElementContainer parent){
		createTableEntry(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an TableEntry with the given id. Post create hook will be triggered.
	 */
	def createTableEntry(String ID, InternalModelElementContainer parent){
		createTableEntry(ID,null,parent,true)
	}
	
	def createTableEntry(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTableEntry(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an TableEntry with the given id. Post create hook won't be triggered.
	 */
	def createTableEntry(InternalModelElement ime) {
		createTableEntry(generateUUID,ime,null,false)
	}
	
	override createTableEntry() {
		createTableEntry(generateUUID)
	}
	/**
	 * This method creates an Image with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createImage(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createImage => [
			setID(ID)
			internal = ime ?: createInternalImage => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ImageEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Image with the given id. Post create hook won't be triggered.
	 */
	def createImage(String ID){
		createImage(ID,null,null,false)
	}
	
	/**
	 * This method creates an Image with the given id. Post create hook will be triggered.
	 */
	def createImage(InternalModelElementContainer parent){
		createImage(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Image with the given id. Post create hook will be triggered.
	 */
	def createImage(String ID, InternalModelElementContainer parent){
		createImage(ID,null,parent,true)
	}
	
	def createImage(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createImage(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Image with the given id. Post create hook won't be triggered.
	 */
	def createImage(InternalModelElement ime) {
		createImage(generateUUID,ime,null,false)
	}
	
	override createImage() {
		createImage(generateUUID)
	}
	def createAddComplexToSubmission(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createAddComplexToSubmission => [
			setID(ID)
			internal = ime ?: createInternalAddComplexToSubmission => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.AddComplexToSubmissionEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an AddComplexToSubmission with the given id. Post create hook will be triggered.
	 */
	def createAddComplexToSubmission(String ID, InternalNode source, InternalNode target){
		createAddComplexToSubmission(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an AddComplexToSubmission with generated id. Post create hook will be triggered.
	 */
	def createAddComplexToSubmission(InternalNode source, InternalNode target){
		createAddComplexToSubmission(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an AddComplexToSubmission with the given id. Post create hook won't be triggered.
	 */
	def createAddComplexToSubmission(String ID){
		createAddComplexToSubmission(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an AddComplexToSubmission with a generated id. Post create hook won't be triggered.
	 */
	override createAddComplexToSubmission() {
		createAddComplexToSubmission(generateUUID)
	}
	/**
	 * This method creates an ComplexVariable with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexVariable => [
			setID(ID)
			internal = ime ?: createInternalComplexVariable => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexVariableEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexVariable with the given id. Post create hook won't be triggered.
	 */
	def createComplexVariable(String ID){
		createComplexVariable(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexVariable with the given id. Post create hook will be triggered.
	 */
	def createComplexVariable(InternalModelElementContainer parent){
		createComplexVariable(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexVariable with the given id. Post create hook will be triggered.
	 */
	def createComplexVariable(String ID, InternalModelElementContainer parent){
		createComplexVariable(ID,null,parent,true)
	}
	
	def createComplexVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexVariable(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexVariable with the given id. Post create hook won't be triggered.
	 */
	def createComplexVariable(InternalModelElement ime) {
		createComplexVariable(generateUUID,ime,null,false)
	}
	
	override createComplexVariable() {
		createComplexVariable(generateUUID)
	}
	/**
	 * This method creates an DropTarget with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDropTarget(String ID, InternalModelElement ime, boolean hook){
		super.createDropTarget => [ 
			setID(ID)
			internal = ime ?: createInternalDropTarget => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.DropTargetEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an DropTarget with the given id. Post create hook won't be triggered.
	 */
	def createDropTarget(String ID){
		createDropTarget(ID,null,false)
	}
	
	/**
	 * This method creates an DropTarget with the given id. Post create hook won't be triggered.
	 */
	def createDropTarget(InternalModelElement ime) {
		createDropTarget(generateUUID,ime,false)
	}
	
	override createDropTarget() {
		createDropTarget(generateUUID)
	}
	/**
	 * This method creates an ISSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createISSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createISSIB => [
			setID(ID)
			internal = ime ?: createInternalISSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ISSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ISSIB with the given id. Post create hook won't be triggered.
	 */
	def createISSIB(String ID){
		createISSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ISSIB with the given id. Post create hook will be triggered.
	 */
	def createISSIB(InternalModelElementContainer parent){
		createISSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ISSIB with the given id. Post create hook will be triggered.
	 */
	def createISSIB(String ID, InternalModelElementContainer parent){
		createISSIB(ID,null,parent,true)
	}
	
	def createISSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createISSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ISSIB with the given id. Post create hook won't be triggered.
	 */
	def createISSIB(InternalModelElement ime) {
		createISSIB(generateUUID,ime,null,false)
	}
	
	override createISSIB() {
		createISSIB(generateUUID)
	}
	/**
	 * This method creates an PrimitiveOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveOutputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.PrimitiveOutputPortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveOutputPort(String ID){
		createPrimitiveOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveOutputPort(InternalModelElementContainer parent){
		createPrimitiveOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveOutputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveOutputPort(ID,null,parent,true)
	}
	
	def createPrimitiveOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveOutputPort(InternalModelElement ime) {
		createPrimitiveOutputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveOutputPort() {
		createPrimitiveOutputPort(generateUUID)
	}
	def createComplexWrite(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexWrite => [
			setID(ID)
			internal = ime ?: createInternalComplexWrite => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexWriteEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ComplexWrite with the given id. Post create hook will be triggered.
	 */
	def createComplexWrite(String ID, InternalNode source, InternalNode target){
		createComplexWrite(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexWrite with generated id. Post create hook will be triggered.
	 */
	def createComplexWrite(InternalNode source, InternalNode target){
		createComplexWrite(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexWrite with the given id. Post create hook won't be triggered.
	 */
	def createComplexWrite(String ID){
		createComplexWrite(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexWrite with a generated id. Post create hook won't be triggered.
	 */
	override createComplexWrite() {
		createComplexWrite(generateUUID)
	}
	/**
	 * This method creates an PageUp with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPageUp(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPageUp => [
			setID(ID)
			internal = ime ?: createInternalPageUp => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.PageUpEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PageUp with the given id. Post create hook won't be triggered.
	 */
	def createPageUp(String ID){
		createPageUp(ID,null,null,false)
	}
	
	/**
	 * This method creates an PageUp with the given id. Post create hook will be triggered.
	 */
	def createPageUp(InternalModelElementContainer parent){
		createPageUp(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PageUp with the given id. Post create hook will be triggered.
	 */
	def createPageUp(String ID, InternalModelElementContainer parent){
		createPageUp(ID,null,parent,true)
	}
	
	def createPageUp(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPageUp(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PageUp with the given id. Post create hook won't be triggered.
	 */
	def createPageUp(InternalModelElement ime) {
		createPageUp(generateUUID,ime,null,false)
	}
	
	override createPageUp() {
		createPageUp(generateUUID)
	}
	def createPrimitiveWrite(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createPrimitiveWrite => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveWrite => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.PrimitiveWriteEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an PrimitiveWrite with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveWrite(String ID, InternalNode source, InternalNode target){
		createPrimitiveWrite(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveWrite with generated id. Post create hook will be triggered.
	 */
	def createPrimitiveWrite(InternalNode source, InternalNode target){
		createPrimitiveWrite(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveWrite with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveWrite(String ID){
		createPrimitiveWrite(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveWrite with a generated id. Post create hook won't be triggered.
	 */
	override createPrimitiveWrite() {
		createPrimitiveWrite(generateUUID)
	}
	/**
	 * This method creates an PrimitiveVariable with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveVariable => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveVariable => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.PrimitiveVariableEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveVariable(String ID){
		createPrimitiveVariable(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveVariable(InternalModelElementContainer parent){
		createPrimitiveVariable(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveVariable(String ID, InternalModelElementContainer parent){
		createPrimitiveVariable(ID,null,parent,true)
	}
	
	def createPrimitiveVariable(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveVariable(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveVariable with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveVariable(InternalModelElement ime) {
		createPrimitiveVariable(generateUUID,ime,null,false)
	}
	
	override createPrimitiveVariable() {
		createPrimitiveVariable(generateUUID)
	}
	/**
	 * This method creates an ImageStyling with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createImageStyling(String ID, InternalModelElement ime, boolean hook){
		super.createImageStyling => [ 
			setID(ID)
			internal = ime ?: createInternalImageStyling => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ImageStylingEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ImageStyling with the given id. Post create hook won't be triggered.
	 */
	def createImageStyling(String ID){
		createImageStyling(ID,null,false)
	}
	
	/**
	 * This method creates an ImageStyling with the given id. Post create hook won't be triggered.
	 */
	def createImageStyling(InternalModelElement ime) {
		createImageStyling(generateUUID,ime,false)
	}
	
	override createImageStyling() {
		createImageStyling(generateUUID)
	}
	/**
	 * This method creates an ComplexOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexOutputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexOutputPortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputPort(String ID){
		createComplexOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputPort(InternalModelElementContainer parent){
		createComplexOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputPort(String ID, InternalModelElementContainer parent){
		createComplexOutputPort(ID,null,parent,true)
	}
	
	def createComplexOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputPort(InternalModelElement ime) {
		createComplexOutputPort(generateUUID,ime,null,false)
	}
	
	override createComplexOutputPort() {
		createComplexOutputPort(generateUUID)
	}
	/**
	 * This method creates an Col with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createCol(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createCol => [
			setID(ID)
			internal = ime ?: createInternalCol => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ColEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Col with the given id. Post create hook won't be triggered.
	 */
	def createCol(String ID){
		createCol(ID,null,null,false)
	}
	
	/**
	 * This method creates an Col with the given id. Post create hook will be triggered.
	 */
	def createCol(InternalModelElementContainer parent){
		createCol(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Col with the given id. Post create hook will be triggered.
	 */
	def createCol(String ID, InternalModelElementContainer parent){
		createCol(ID,null,parent,true)
	}
	
	def createCol(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createCol(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Col with the given id. Post create hook won't be triggered.
	 */
	def createCol(InternalModelElement ime) {
		createCol(generateUUID,ime,null,false)
	}
	
	override createCol() {
		createCol(generateUUID)
	}
	/**
	 * This method creates an IFSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createIFSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createIFSIB => [
			setID(ID)
			internal = ime ?: createInternalIFSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.IFSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an IFSIB with the given id. Post create hook won't be triggered.
	 */
	def createIFSIB(String ID){
		createIFSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an IFSIB with the given id. Post create hook will be triggered.
	 */
	def createIFSIB(InternalModelElementContainer parent){
		createIFSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an IFSIB with the given id. Post create hook will be triggered.
	 */
	def createIFSIB(String ID, InternalModelElementContainer parent){
		createIFSIB(ID,null,parent,true)
	}
	
	def createIFSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createIFSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an IFSIB with the given id. Post create hook won't be triggered.
	 */
	def createIFSIB(InternalModelElement ime) {
		createIFSIB(generateUUID,ime,null,false)
	}
	
	override createIFSIB() {
		createIFSIB(generateUUID)
	}
	/**
	 * This method creates an Tab with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTab(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTab => [
			setID(ID)
			internal = ime ?: createInternalTab => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.TabEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Tab with the given id. Post create hook won't be triggered.
	 */
	def createTab(String ID){
		createTab(ID,null,null,false)
	}
	
	/**
	 * This method creates an Tab with the given id. Post create hook will be triggered.
	 */
	def createTab(InternalModelElementContainer parent){
		createTab(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Tab with the given id. Post create hook will be triggered.
	 */
	def createTab(String ID, InternalModelElementContainer parent){
		createTab(ID,null,parent,true)
	}
	
	def createTab(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTab(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Tab with the given id. Post create hook won't be triggered.
	 */
	def createTab(InternalModelElement ime) {
		createTab(generateUUID,ime,null,false)
	}
	
	override createTab() {
		createTab(generateUUID)
	}
	/**
	 * This method creates an Listing with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createListing(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createListing => [
			setID(ID)
			internal = ime ?: createInternalListing => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ListingEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Listing with the given id. Post create hook won't be triggered.
	 */
	def createListing(String ID){
		createListing(ID,null,null,false)
	}
	
	/**
	 * This method creates an Listing with the given id. Post create hook will be triggered.
	 */
	def createListing(InternalModelElementContainer parent){
		createListing(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Listing with the given id. Post create hook will be triggered.
	 */
	def createListing(String ID, InternalModelElementContainer parent){
		createListing(ID,null,parent,true)
	}
	
	def createListing(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createListing(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Listing with the given id. Post create hook won't be triggered.
	 */
	def createListing(InternalModelElement ime) {
		createListing(generateUUID,ime,null,false)
	}
	
	override createListing() {
		createListing(generateUUID)
	}
	/**
	 * This method creates an Template with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTemplate(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTemplate => [
			setID(ID)
			internal = ime ?: createInternalTemplate => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.TemplateEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Template with the given id. Post create hook won't be triggered.
	 */
	def createTemplate(String ID){
		createTemplate(ID,null,null,false)
	}
	
	/**
	 * This method creates an Template with the given id. Post create hook will be triggered.
	 */
	def createTemplate(InternalModelElementContainer parent){
		createTemplate(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Template with the given id. Post create hook will be triggered.
	 */
	def createTemplate(String ID, InternalModelElementContainer parent){
		createTemplate(ID,null,parent,true)
	}
	
	def createTemplate(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTemplate(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Template with the given id. Post create hook won't be triggered.
	 */
	def createTemplate(InternalModelElement ime) {
		createTemplate(generateUUID,ime,null,false)
	}
	
	override createTemplate() {
		createTemplate(generateUUID)
	}
	/**
	 * This method creates an Tabbing with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTabbing(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTabbing => [
			setID(ID)
			internal = ime ?: createInternalTabbing => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.TabbingEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Tabbing with the given id. Post create hook won't be triggered.
	 */
	def createTabbing(String ID){
		createTabbing(ID,null,null,false)
	}
	
	/**
	 * This method creates an Tabbing with the given id. Post create hook will be triggered.
	 */
	def createTabbing(InternalModelElementContainer parent){
		createTabbing(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Tabbing with the given id. Post create hook will be triggered.
	 */
	def createTabbing(String ID, InternalModelElementContainer parent){
		createTabbing(ID,null,parent,true)
	}
	
	def createTabbing(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTabbing(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Tabbing with the given id. Post create hook won't be triggered.
	 */
	def createTabbing(InternalModelElement ime) {
		createTabbing(generateUUID,ime,null,false)
	}
	
	override createTabbing() {
		createTabbing(generateUUID)
	}
	/**
	 * This method creates an MoveUp with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createMoveUp(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createMoveUp => [
			setID(ID)
			internal = ime ?: createInternalMoveUp => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.MoveUpEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an MoveUp with the given id. Post create hook won't be triggered.
	 */
	def createMoveUp(String ID){
		createMoveUp(ID,null,null,false)
	}
	
	/**
	 * This method creates an MoveUp with the given id. Post create hook will be triggered.
	 */
	def createMoveUp(InternalModelElementContainer parent){
		createMoveUp(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an MoveUp with the given id. Post create hook will be triggered.
	 */
	def createMoveUp(String ID, InternalModelElementContainer parent){
		createMoveUp(ID,null,parent,true)
	}
	
	def createMoveUp(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createMoveUp(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an MoveUp with the given id. Post create hook won't be triggered.
	 */
	def createMoveUp(InternalModelElement ime) {
		createMoveUp(generateUUID,ime,null,false)
	}
	
	override createMoveUp() {
		createMoveUp(generateUUID)
	}
	/**
	 * This method creates an Embedded with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createEmbedded(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createEmbedded => [
			setID(ID)
			internal = ime ?: createInternalEmbedded => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.EmbeddedEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Embedded with the given id. Post create hook won't be triggered.
	 */
	def createEmbedded(String ID){
		createEmbedded(ID,null,null,false)
	}
	
	/**
	 * This method creates an Embedded with the given id. Post create hook will be triggered.
	 */
	def createEmbedded(InternalModelElementContainer parent){
		createEmbedded(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Embedded with the given id. Post create hook will be triggered.
	 */
	def createEmbedded(String ID, InternalModelElementContainer parent){
		createEmbedded(ID,null,parent,true)
	}
	
	def createEmbedded(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createEmbedded(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Embedded with the given id. Post create hook won't be triggered.
	 */
	def createEmbedded(InternalModelElement ime) {
		createEmbedded(generateUUID,ime,null,false)
	}
	
	override createEmbedded() {
		createEmbedded(generateUUID)
	}
	/**
	 * This method creates an Icon with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createIcon(String ID, InternalModelElement ime, boolean hook){
		super.createIcon => [ 
			setID(ID)
			internal = ime ?: createInternalIcon => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.IconEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Icon with the given id. Post create hook won't be triggered.
	 */
	def createIcon(String ID){
		createIcon(ID,null,false)
	}
	
	/**
	 * This method creates an Icon with the given id. Post create hook won't be triggered.
	 */
	def createIcon(InternalModelElement ime) {
		createIcon(generateUUID,ime,false)
	}
	
	override createIcon() {
		createIcon(generateUUID)
	}
	def createFormSubmit(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createFormSubmit => [
			setID(ID)
			internal = ime ?: createInternalFormSubmit => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.FormSubmitEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an FormSubmit with the given id. Post create hook will be triggered.
	 */
	def createFormSubmit(String ID, InternalNode source, InternalNode target){
		createFormSubmit(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an FormSubmit with generated id. Post create hook will be triggered.
	 */
	def createFormSubmit(InternalNode source, InternalNode target){
		createFormSubmit(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an FormSubmit with the given id. Post create hook won't be triggered.
	 */
	def createFormSubmit(String ID){
		createFormSubmit(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an FormSubmit with a generated id. Post create hook won't be triggered.
	 */
	override createFormSubmit() {
		createFormSubmit(generateUUID)
	}
	/**
	 * This method creates an ExtensionAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createExtensionAttribute => [
			setID(ID)
			internal = ime ?: createInternalExtensionAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ExtensionAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createExtensionAttribute(String ID){
		createExtensionAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createExtensionAttribute(InternalModelElementContainer parent){
		createExtensionAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createExtensionAttribute(String ID, InternalModelElementContainer parent){
		createExtensionAttribute(ID,null,parent,true)
	}
	
	def createExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createExtensionAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createExtensionAttribute(InternalModelElement ime) {
		createExtensionAttribute(generateUUID,ime,null,false)
	}
	
	override createExtensionAttribute() {
		createExtensionAttribute(generateUUID)
	}
	/**
	 * This method creates an ComplexListAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexListAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexListAttribute => [
			setID(ID)
			internal = ime ?: createInternalComplexListAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexListAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexListAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexListAttribute(String ID){
		createComplexListAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexListAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexListAttribute(InternalModelElementContainer parent){
		createComplexListAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexListAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexListAttribute(String ID, InternalModelElementContainer parent){
		createComplexListAttribute(ID,null,parent,true)
	}
	
	def createComplexListAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexListAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexListAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexListAttribute(InternalModelElement ime) {
		createComplexListAttribute(generateUUID,ime,null,false)
	}
	
	override createComplexListAttribute() {
		createComplexListAttribute(generateUUID)
	}
	/**
	 * This method creates an ComplexInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexInputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexInputPortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexInputPort(String ID){
		createComplexInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexInputPort(InternalModelElementContainer parent){
		createComplexInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexInputPort(String ID, InternalModelElementContainer parent){
		createComplexInputPort(ID,null,parent,true)
	}
	
	def createComplexInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexInputPort(InternalModelElement ime) {
		createComplexInputPort(generateUUID,ime,null,false)
	}
	
	override createComplexInputPort() {
		createComplexInputPort(generateUUID)
	}
	/**
	 * This method creates an PrimitiveInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveInputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.PrimitiveInputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputPort(String ID){
		createPrimitiveInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputPort(InternalModelElementContainer parent){
		createPrimitiveInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveInputPort(ID,null,parent,true)
	}
	
	def createPrimitiveInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputPort(InternalModelElement ime) {
		createPrimitiveInputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveInputPort() {
		createPrimitiveInputPort(generateUUID)
	}
	/**
	 * This method creates an Headline with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createHeadline(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createHeadline => [
			setID(ID)
			internal = ime ?: createInternalHeadline => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.HeadlineEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Headline with the given id. Post create hook won't be triggered.
	 */
	def createHeadline(String ID){
		createHeadline(ID,null,null,false)
	}
	
	/**
	 * This method creates an Headline with the given id. Post create hook will be triggered.
	 */
	def createHeadline(InternalModelElementContainer parent){
		createHeadline(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Headline with the given id. Post create hook will be triggered.
	 */
	def createHeadline(String ID, InternalModelElementContainer parent){
		createHeadline(ID,null,parent,true)
	}
	
	def createHeadline(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createHeadline(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Headline with the given id. Post create hook won't be triggered.
	 */
	def createHeadline(InternalModelElement ime) {
		createHeadline(generateUUID,ime,null,false)
	}
	
	override createHeadline() {
		createHeadline(generateUUID)
	}
	/**
	 * This method creates an FormFieldAdditionalOptions with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createFormFieldAdditionalOptions(String ID, InternalModelElement ime, boolean hook){
		super.createFormFieldAdditionalOptions => [ 
			setID(ID)
			internal = ime ?: createInternalFormFieldAdditionalOptions => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.FormFieldAdditionalOptionsEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an FormFieldAdditionalOptions with the given id. Post create hook won't be triggered.
	 */
	def createFormFieldAdditionalOptions(String ID){
		createFormFieldAdditionalOptions(ID,null,false)
	}
	
	/**
	 * This method creates an FormFieldAdditionalOptions with the given id. Post create hook won't be triggered.
	 */
	def createFormFieldAdditionalOptions(InternalModelElement ime) {
		createFormFieldAdditionalOptions(generateUUID,ime,false)
	}
	
	override createFormFieldAdditionalOptions() {
		createFormFieldAdditionalOptions(generateUUID)
	}
	/**
	 * This method creates an Alert with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createAlert(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createAlert => [
			setID(ID)
			internal = ime ?: createInternalAlert => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.AlertEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Alert with the given id. Post create hook won't be triggered.
	 */
	def createAlert(String ID){
		createAlert(ID,null,null,false)
	}
	
	/**
	 * This method creates an Alert with the given id. Post create hook will be triggered.
	 */
	def createAlert(InternalModelElementContainer parent){
		createAlert(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Alert with the given id. Post create hook will be triggered.
	 */
	def createAlert(String ID, InternalModelElementContainer parent){
		createAlert(ID,null,parent,true)
	}
	
	def createAlert(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createAlert(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Alert with the given id. Post create hook won't be triggered.
	 */
	def createAlert(InternalModelElement ime) {
		createAlert(generateUUID,ime,null,false)
	}
	
	override createAlert() {
		createAlert(generateUUID)
	}
	def createComplexDataTarget(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexDataTarget => [
			setID(ID)
			internal = ime ?: createInternalComplexDataTarget => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexDataTargetEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ComplexDataTarget with the given id. Post create hook will be triggered.
	 */
	def createComplexDataTarget(String ID, InternalNode source, InternalNode target){
		createComplexDataTarget(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexDataTarget with generated id. Post create hook will be triggered.
	 */
	def createComplexDataTarget(InternalNode source, InternalNode target){
		createComplexDataTarget(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexDataTarget with the given id. Post create hook won't be triggered.
	 */
	def createComplexDataTarget(String ID){
		createComplexDataTarget(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexDataTarget with a generated id. Post create hook won't be triggered.
	 */
	override createComplexDataTarget() {
		createComplexDataTarget(generateUUID)
	}
	/**
	 * This method creates an File with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createFile(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createFile => [
			setID(ID)
			internal = ime ?: createInternalFile => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.FileEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an File with the given id. Post create hook won't be triggered.
	 */
	def createFile(String ID){
		createFile(ID,null,null,false)
	}
	
	/**
	 * This method creates an File with the given id. Post create hook will be triggered.
	 */
	def createFile(InternalModelElementContainer parent){
		createFile(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an File with the given id. Post create hook will be triggered.
	 */
	def createFile(String ID, InternalModelElementContainer parent){
		createFile(ID,null,parent,true)
	}
	
	def createFile(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createFile(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an File with the given id. Post create hook won't be triggered.
	 */
	def createFile(InternalModelElement ime) {
		createFile(generateUUID,ime,null,false)
	}
	
	override createFile() {
		createFile(generateUUID)
	}
	/**
	 * This method creates an IntegerInputStatic with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createIntegerInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createIntegerInputStatic => [
			setID(ID)
			internal = ime ?: createInternalIntegerInputStatic => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.IntegerInputStaticEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an IntegerInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createIntegerInputStatic(String ID){
		createIntegerInputStatic(ID,null,null,false)
	}
	
	/**
	 * This method creates an IntegerInputStatic with the given id. Post create hook will be triggered.
	 */
	def createIntegerInputStatic(InternalModelElementContainer parent){
		createIntegerInputStatic(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an IntegerInputStatic with the given id. Post create hook will be triggered.
	 */
	def createIntegerInputStatic(String ID, InternalModelElementContainer parent){
		createIntegerInputStatic(ID,null,parent,true)
	}
	
	def createIntegerInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createIntegerInputStatic(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an IntegerInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createIntegerInputStatic(InternalModelElement ime) {
		createIntegerInputStatic(generateUUID,ime,null,false)
	}
	
	override createIntegerInputStatic() {
		createIntegerInputStatic(generateUUID)
	}
	/**
	 * This method creates an ProcessSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProcessSIB => [
			setID(ID)
			internal = ime ?: createInternalProcessSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ProcessSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessSIB(String ID){
		createProcessSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessSIB(InternalModelElementContainer parent){
		createProcessSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessSIB(String ID, InternalModelElementContainer parent){
		createProcessSIB(ID,null,parent,true)
	}
	
	def createProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProcessSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessSIB(InternalModelElement ime) {
		createProcessSIB(generateUUID,ime,null,false)
	}
	
	override createProcessSIB() {
		createProcessSIB(generateUUID)
	}
	/**
	 * This method creates an Box with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBox(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBox => [
			setID(ID)
			internal = ime ?: createInternalBox => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.BoxEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Box with the given id. Post create hook won't be triggered.
	 */
	def createBox(String ID){
		createBox(ID,null,null,false)
	}
	
	/**
	 * This method creates an Box with the given id. Post create hook will be triggered.
	 */
	def createBox(InternalModelElementContainer parent){
		createBox(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Box with the given id. Post create hook will be triggered.
	 */
	def createBox(String ID, InternalModelElementContainer parent){
		createBox(ID,null,parent,true)
	}
	
	def createBox(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBox(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Box with the given id. Post create hook won't be triggered.
	 */
	def createBox(InternalModelElement ime) {
		createBox(generateUUID,ime,null,false)
	}
	
	override createBox() {
		createBox(generateUUID)
	}
	def createPrimitiveRead(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createPrimitiveRead => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveRead => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.PrimitiveReadEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an PrimitiveRead with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveRead(String ID, InternalNode source, InternalNode target){
		createPrimitiveRead(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveRead with generated id. Post create hook will be triggered.
	 */
	def createPrimitiveRead(InternalNode source, InternalNode target){
		createPrimitiveRead(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveRead with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveRead(String ID){
		createPrimitiveRead(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveRead with a generated id. Post create hook won't be triggered.
	 */
	override createPrimitiveRead() {
		createPrimitiveRead(generateUUID)
	}
	/**
	 * This method creates an Panel with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPanel(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPanel => [
			setID(ID)
			internal = ime ?: createInternalPanel => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.PanelEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Panel with the given id. Post create hook won't be triggered.
	 */
	def createPanel(String ID){
		createPanel(ID,null,null,false)
	}
	
	/**
	 * This method creates an Panel with the given id. Post create hook will be triggered.
	 */
	def createPanel(InternalModelElementContainer parent){
		createPanel(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Panel with the given id. Post create hook will be triggered.
	 */
	def createPanel(String ID, InternalModelElementContainer parent){
		createPanel(ID,null,parent,true)
	}
	
	def createPanel(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPanel(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Panel with the given id. Post create hook won't be triggered.
	 */
	def createPanel(InternalModelElement ime) {
		createPanel(generateUUID,ime,null,false)
	}
	
	override createPanel() {
		createPanel(generateUUID)
	}
	/**
	 * This method creates an LinkProcessSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createLinkProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createLinkProcessSIB => [
			setID(ID)
			internal = ime ?: createInternalLinkProcessSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.LinkProcessSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an LinkProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createLinkProcessSIB(String ID){
		createLinkProcessSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an LinkProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createLinkProcessSIB(InternalModelElementContainer parent){
		createLinkProcessSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an LinkProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createLinkProcessSIB(String ID, InternalModelElementContainer parent){
		createLinkProcessSIB(ID,null,parent,true)
	}
	
	def createLinkProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createLinkProcessSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an LinkProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createLinkProcessSIB(InternalModelElement ime) {
		createLinkProcessSIB(generateUUID,ime,null,false)
	}
	
	override createLinkProcessSIB() {
		createLinkProcessSIB(generateUUID)
	}
	/**
	 * This method creates an Badge with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBadge(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBadge => [
			setID(ID)
			internal = ime ?: createInternalBadge => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.BadgeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Badge with the given id. Post create hook won't be triggered.
	 */
	def createBadge(String ID){
		createBadge(ID,null,null,false)
	}
	
	/**
	 * This method creates an Badge with the given id. Post create hook will be triggered.
	 */
	def createBadge(InternalModelElementContainer parent){
		createBadge(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Badge with the given id. Post create hook will be triggered.
	 */
	def createBadge(String ID, InternalModelElementContainer parent){
		createBadge(ID,null,parent,true)
	}
	
	def createBadge(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBadge(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Badge with the given id. Post create hook won't be triggered.
	 */
	def createBadge(InternalModelElement ime) {
		createBadge(generateUUID,ime,null,false)
	}
	
	override createBadge() {
		createBadge(generateUUID)
	}
	/**
	 * This method creates an OutputGeneric with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createOutputGeneric(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createOutputGeneric => [
			setID(ID)
			internal = ime ?: createInternalOutputGeneric => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.OutputGenericEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an OutputGeneric with the given id. Post create hook won't be triggered.
	 */
	def createOutputGeneric(String ID){
		createOutputGeneric(ID,null,null,false)
	}
	
	/**
	 * This method creates an OutputGeneric with the given id. Post create hook will be triggered.
	 */
	def createOutputGeneric(InternalModelElementContainer parent){
		createOutputGeneric(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an OutputGeneric with the given id. Post create hook will be triggered.
	 */
	def createOutputGeneric(String ID, InternalModelElementContainer parent){
		createOutputGeneric(ID,null,parent,true)
	}
	
	def createOutputGeneric(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createOutputGeneric(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an OutputGeneric with the given id. Post create hook won't be triggered.
	 */
	def createOutputGeneric(InternalModelElement ime) {
		createOutputGeneric(generateUUID,ime,null,false)
	}
	
	override createOutputGeneric() {
		createOutputGeneric(generateUUID)
	}
	def createPrimitiveFOR(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createPrimitiveFOR => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveFOR => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.PrimitiveFOREContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an PrimitiveFOR with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveFOR(String ID, InternalNode source, InternalNode target){
		createPrimitiveFOR(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveFOR with generated id. Post create hook will be triggered.
	 */
	def createPrimitiveFOR(InternalNode source, InternalNode target){
		createPrimitiveFOR(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveFOR with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveFOR(String ID){
		createPrimitiveFOR(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveFOR with a generated id. Post create hook won't be triggered.
	 */
	override createPrimitiveFOR() {
		createPrimitiveFOR(generateUUID)
	}
	/**
	 * This method creates an DataContext with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDataContext(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDataContext => [
			setID(ID)
			internal = ime ?: createInternalDataContext => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.DataContextEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook won't be triggered.
	 */
	def createDataContext(String ID){
		createDataContext(ID,null,null,false)
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook will be triggered.
	 */
	def createDataContext(InternalModelElementContainer parent){
		createDataContext(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook will be triggered.
	 */
	def createDataContext(String ID, InternalModelElementContainer parent){
		createDataContext(ID,null,parent,true)
	}
	
	def createDataContext(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDataContext(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an DataContext with the given id. Post create hook won't be triggered.
	 */
	def createDataContext(InternalModelElement ime) {
		createDataContext(generateUUID,ime,null,false)
	}
	
	override createDataContext() {
		createDataContext(generateUUID)
	}
	def createComplexRead(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexRead => [
			setID(ID)
			internal = ime ?: createInternalComplexRead => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexReadEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ComplexRead with the given id. Post create hook will be triggered.
	 */
	def createComplexRead(String ID, InternalNode source, InternalNode target){
		createComplexRead(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexRead with generated id. Post create hook will be triggered.
	 */
	def createComplexRead(InternalNode source, InternalNode target){
		createComplexRead(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexRead with the given id. Post create hook won't be triggered.
	 */
	def createComplexRead(String ID){
		createComplexRead(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexRead with a generated id. Post create hook won't be triggered.
	 */
	override createComplexRead() {
		createComplexRead(generateUUID)
	}
	/**
	 * This method creates an Text with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createText(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createText => [
			setID(ID)
			internal = ime ?: createInternalText => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.TextEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Text with the given id. Post create hook won't be triggered.
	 */
	def createText(String ID){
		createText(ID,null,null,false)
	}
	
	/**
	 * This method creates an Text with the given id. Post create hook will be triggered.
	 */
	def createText(InternalModelElementContainer parent){
		createText(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Text with the given id. Post create hook will be triggered.
	 */
	def createText(String ID, InternalModelElementContainer parent){
		createText(ID,null,parent,true)
	}
	
	def createText(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createText(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Text with the given id. Post create hook won't be triggered.
	 */
	def createText(InternalModelElement ime) {
		createText(generateUUID,ime,null,false)
	}
	
	override createText() {
		createText(generateUUID)
	}
	/**
	 * This method creates an Checkbox with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createCheckbox(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createCheckbox => [
			setID(ID)
			internal = ime ?: createInternalCheckbox => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.CheckboxEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Checkbox with the given id. Post create hook won't be triggered.
	 */
	def createCheckbox(String ID){
		createCheckbox(ID,null,null,false)
	}
	
	/**
	 * This method creates an Checkbox with the given id. Post create hook will be triggered.
	 */
	def createCheckbox(InternalModelElementContainer parent){
		createCheckbox(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Checkbox with the given id. Post create hook will be triggered.
	 */
	def createCheckbox(String ID, InternalModelElementContainer parent){
		createCheckbox(ID,null,parent,true)
	}
	
	def createCheckbox(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createCheckbox(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Checkbox with the given id. Post create hook won't be triggered.
	 */
	def createCheckbox(InternalModelElement ime) {
		createCheckbox(generateUUID,ime,null,false)
	}
	
	override createCheckbox() {
		createCheckbox(generateUUID)
	}
	/**
	 * This method creates an Tooltip with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTooltip(String ID, InternalModelElement ime, boolean hook){
		super.createTooltip => [ 
			setID(ID)
			internal = ime ?: createInternalTooltip => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.TooltipEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Tooltip with the given id. Post create hook won't be triggered.
	 */
	def createTooltip(String ID){
		createTooltip(ID,null,false)
	}
	
	/**
	 * This method creates an Tooltip with the given id. Post create hook won't be triggered.
	 */
	def createTooltip(InternalModelElement ime) {
		createTooltip(generateUUID,ime,false)
	}
	
	override createTooltip() {
		createTooltip(generateUUID)
	}
	/**
	 * This method creates an Layout with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createLayout(String ID, InternalModelElement ime, boolean hook){
		super.createLayout => [ 
			setID(ID)
			internal = ime ?: createInternalLayout => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.LayoutEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Layout with the given id. Post create hook won't be triggered.
	 */
	def createLayout(String ID){
		createLayout(ID,null,false)
	}
	
	/**
	 * This method creates an Layout with the given id. Post create hook won't be triggered.
	 */
	def createLayout(InternalModelElement ime) {
		createLayout(generateUUID,ime,false)
	}
	
	override createLayout() {
		createLayout(generateUUID)
	}
	/**
	 * This method creates an DispatchedGUISIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDispatchedGUISIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDispatchedGUISIB => [
			setID(ID)
			internal = ime ?: createInternalDispatchedGUISIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.DispatchedGUISIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an DispatchedGUISIB with the given id. Post create hook won't be triggered.
	 */
	def createDispatchedGUISIB(String ID){
		createDispatchedGUISIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an DispatchedGUISIB with the given id. Post create hook will be triggered.
	 */
	def createDispatchedGUISIB(InternalModelElementContainer parent){
		createDispatchedGUISIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an DispatchedGUISIB with the given id. Post create hook will be triggered.
	 */
	def createDispatchedGUISIB(String ID, InternalModelElementContainer parent){
		createDispatchedGUISIB(ID,null,parent,true)
	}
	
	def createDispatchedGUISIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDispatchedGUISIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an DispatchedGUISIB with the given id. Post create hook won't be triggered.
	 */
	def createDispatchedGUISIB(InternalModelElement ime) {
		createDispatchedGUISIB(generateUUID,ime,null,false)
	}
	
	override createDispatchedGUISIB() {
		createDispatchedGUISIB(generateUUID)
	}
	/**
	 * This method creates an RealInputStatic with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createRealInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createRealInputStatic => [
			setID(ID)
			internal = ime ?: createInternalRealInputStatic => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.RealInputStaticEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an RealInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createRealInputStatic(String ID){
		createRealInputStatic(ID,null,null,false)
	}
	
	/**
	 * This method creates an RealInputStatic with the given id. Post create hook will be triggered.
	 */
	def createRealInputStatic(InternalModelElementContainer parent){
		createRealInputStatic(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an RealInputStatic with the given id. Post create hook will be triggered.
	 */
	def createRealInputStatic(String ID, InternalModelElementContainer parent){
		createRealInputStatic(ID,null,parent,true)
	}
	
	def createRealInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createRealInputStatic(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an RealInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createRealInputStatic(InternalModelElement ime) {
		createRealInputStatic(generateUUID,ime,null,false)
	}
	
	override createRealInputStatic() {
		createRealInputStatic(generateUUID)
	}
	/**
	 * This method creates an Combobox with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createCombobox(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createCombobox => [
			setID(ID)
			internal = ime ?: createInternalCombobox => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ComboboxEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Combobox with the given id. Post create hook won't be triggered.
	 */
	def createCombobox(String ID){
		createCombobox(ID,null,null,false)
	}
	
	/**
	 * This method creates an Combobox with the given id. Post create hook will be triggered.
	 */
	def createCombobox(InternalModelElementContainer parent){
		createCombobox(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Combobox with the given id. Post create hook will be triggered.
	 */
	def createCombobox(String ID, InternalModelElementContainer parent){
		createCombobox(ID,null,parent,true)
	}
	
	def createCombobox(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createCombobox(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Combobox with the given id. Post create hook won't be triggered.
	 */
	def createCombobox(InternalModelElement ime) {
		createCombobox(generateUUID,ime,null,false)
	}
	
	override createCombobox() {
		createCombobox(generateUUID)
	}
	/**
	 * This method creates an GUIPlugin with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUIPlugin(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGUIPlugin => [
			setID(ID)
			internal = ime ?: createInternalGUIPlugin => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.GUIPluginEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GUIPlugin with the given id. Post create hook won't be triggered.
	 */
	def createGUIPlugin(String ID){
		createGUIPlugin(ID,null,null,false)
	}
	
	/**
	 * This method creates an GUIPlugin with the given id. Post create hook will be triggered.
	 */
	def createGUIPlugin(InternalModelElementContainer parent){
		createGUIPlugin(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GUIPlugin with the given id. Post create hook will be triggered.
	 */
	def createGUIPlugin(String ID, InternalModelElementContainer parent){
		createGUIPlugin(ID,null,parent,true)
	}
	
	def createGUIPlugin(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGUIPlugin(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GUIPlugin with the given id. Post create hook won't be triggered.
	 */
	def createGUIPlugin(InternalModelElement ime) {
		createGUIPlugin(generateUUID,ime,null,false)
	}
	
	override createGUIPlugin() {
		createGUIPlugin(generateUUID)
	}
	/**
	 * This method creates an ButtonToolbar with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createButtonToolbar(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createButtonToolbar => [
			setID(ID)
			internal = ime ?: createInternalButtonToolbar => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ButtonToolbarEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ButtonToolbar with the given id. Post create hook won't be triggered.
	 */
	def createButtonToolbar(String ID){
		createButtonToolbar(ID,null,null,false)
	}
	
	/**
	 * This method creates an ButtonToolbar with the given id. Post create hook will be triggered.
	 */
	def createButtonToolbar(InternalModelElementContainer parent){
		createButtonToolbar(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ButtonToolbar with the given id. Post create hook will be triggered.
	 */
	def createButtonToolbar(String ID, InternalModelElementContainer parent){
		createButtonToolbar(ID,null,parent,true)
	}
	
	def createButtonToolbar(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createButtonToolbar(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ButtonToolbar with the given id. Post create hook won't be triggered.
	 */
	def createButtonToolbar(InternalModelElement ime) {
		createButtonToolbar(generateUUID,ime,null,false)
	}
	
	override createButtonToolbar() {
		createButtonToolbar(generateUUID)
	}
	/**
	 * This method creates an TextStyling with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTextStyling(String ID, InternalModelElement ime, boolean hook){
		super.createTextStyling => [ 
			setID(ID)
			internal = ime ?: createInternalTextStyling => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.TextStylingEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an TextStyling with the given id. Post create hook won't be triggered.
	 */
	def createTextStyling(String ID){
		createTextStyling(ID,null,false)
	}
	
	/**
	 * This method creates an TextStyling with the given id. Post create hook won't be triggered.
	 */
	def createTextStyling(InternalModelElement ime) {
		createTextStyling(generateUUID,ime,false)
	}
	
	override createTextStyling() {
		createTextStyling(generateUUID)
	}
	/**
	 * This method creates an ButtonOptions with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createButtonOptions(String ID, InternalModelElement ime, boolean hook){
		super.createButtonOptions => [ 
			setID(ID)
			internal = ime ?: createInternalButtonOptions => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ButtonOptionsEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ButtonOptions with the given id. Post create hook won't be triggered.
	 */
	def createButtonOptions(String ID){
		createButtonOptions(ID,null,false)
	}
	
	/**
	 * This method creates an ButtonOptions with the given id. Post create hook won't be triggered.
	 */
	def createButtonOptions(InternalModelElement ime) {
		createButtonOptions(generateUUID,ime,false)
	}
	
	override createButtonOptions() {
		createButtonOptions(generateUUID)
	}
	/**
	 * This method creates an TextInputStatic with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTextInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTextInputStatic => [
			setID(ID)
			internal = ime ?: createInternalTextInputStatic => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.TextInputStaticEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an TextInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createTextInputStatic(String ID){
		createTextInputStatic(ID,null,null,false)
	}
	
	/**
	 * This method creates an TextInputStatic with the given id. Post create hook will be triggered.
	 */
	def createTextInputStatic(InternalModelElementContainer parent){
		createTextInputStatic(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an TextInputStatic with the given id. Post create hook will be triggered.
	 */
	def createTextInputStatic(String ID, InternalModelElementContainer parent){
		createTextInputStatic(ID,null,parent,true)
	}
	
	def createTextInputStatic(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTextInputStatic(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an TextInputStatic with the given id. Post create hook won't be triggered.
	 */
	def createTextInputStatic(InternalModelElement ime) {
		createTextInputStatic(generateUUID,ime,null,false)
	}
	
	override createTextInputStatic() {
		createTextInputStatic(generateUUID)
	}
	def createFOR(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createFOR => [
			setID(ID)
			internal = ime ?: createInternalFOR => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.FOREContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an FOR with the given id. Post create hook will be triggered.
	 */
	def createFOR(String ID, InternalNode source, InternalNode target){
		createFOR(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an FOR with generated id. Post create hook will be triggered.
	 */
	def createFOR(InternalNode source, InternalNode target){
		createFOR(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an FOR with the given id. Post create hook won't be triggered.
	 */
	def createFOR(String ID){
		createFOR(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an FOR with a generated id. Post create hook won't be triggered.
	 */
	override createFOR() {
		createFOR(generateUUID)
	}
	/**
	 * This method creates an ButtonStyling with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createButtonStyling(String ID, InternalModelElement ime, boolean hook){
		super.createButtonStyling => [ 
			setID(ID)
			internal = ime ?: createInternalButtonStyling => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ButtonStylingEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ButtonStyling with the given id. Post create hook won't be triggered.
	 */
	def createButtonStyling(String ID){
		createButtonStyling(ID,null,false)
	}
	
	/**
	 * This method creates an ButtonStyling with the given id. Post create hook won't be triggered.
	 */
	def createButtonStyling(InternalModelElement ime) {
		createButtonStyling(generateUUID,ime,false)
	}
	
	override createButtonStyling() {
		createButtonStyling(generateUUID)
	}
	/**
	 * This method creates an BottomNavBar with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBottomNavBar(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBottomNavBar => [
			setID(ID)
			internal = ime ?: createInternalBottomNavBar => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.BottomNavBarEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an BottomNavBar with the given id. Post create hook won't be triggered.
	 */
	def createBottomNavBar(String ID){
		createBottomNavBar(ID,null,null,false)
	}
	
	/**
	 * This method creates an BottomNavBar with the given id. Post create hook will be triggered.
	 */
	def createBottomNavBar(InternalModelElementContainer parent){
		createBottomNavBar(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an BottomNavBar with the given id. Post create hook will be triggered.
	 */
	def createBottomNavBar(String ID, InternalModelElementContainer parent){
		createBottomNavBar(ID,null,parent,true)
	}
	
	def createBottomNavBar(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBottomNavBar(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an BottomNavBar with the given id. Post create hook won't be triggered.
	 */
	def createBottomNavBar(InternalModelElement ime) {
		createBottomNavBar(generateUUID,ime,null,false)
	}
	
	override createBottomNavBar() {
		createBottomNavBar(generateUUID)
	}
	/**
	 * This method creates an PrimitiveExtensionAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveExtensionAttribute => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveExtensionAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.PrimitiveExtensionAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveExtensionAttribute(String ID){
		createPrimitiveExtensionAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveExtensionAttribute(InternalModelElementContainer parent){
		createPrimitiveExtensionAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveExtensionAttribute(String ID, InternalModelElementContainer parent){
		createPrimitiveExtensionAttribute(ID,null,parent,true)
	}
	
	def createPrimitiveExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveExtensionAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveExtensionAttribute(InternalModelElement ime) {
		createPrimitiveExtensionAttribute(generateUUID,ime,null,false)
	}
	
	override createPrimitiveExtensionAttribute() {
		createPrimitiveExtensionAttribute(generateUUID)
	}
	/**
	 * This method creates an Dropdown with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDropdown(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDropdown => [
			setID(ID)
			internal = ime ?: createInternalDropdown => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.DropdownEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Dropdown with the given id. Post create hook won't be triggered.
	 */
	def createDropdown(String ID){
		createDropdown(ID,null,null,false)
	}
	
	/**
	 * This method creates an Dropdown with the given id. Post create hook will be triggered.
	 */
	def createDropdown(InternalModelElementContainer parent){
		createDropdown(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Dropdown with the given id. Post create hook will be triggered.
	 */
	def createDropdown(String ID, InternalModelElementContainer parent){
		createDropdown(ID,null,parent,true)
	}
	
	def createDropdown(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDropdown(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Dropdown with the given id. Post create hook won't be triggered.
	 */
	def createDropdown(InternalModelElement ime) {
		createDropdown(generateUUID,ime,null,false)
	}
	
	override createDropdown() {
		createDropdown(generateUUID)
	}
	def createTableLoad(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createTableLoad => [
			setID(ID)
			internal = ime ?: createInternalTableLoad => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.TableLoadEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an TableLoad with the given id. Post create hook will be triggered.
	 */
	def createTableLoad(String ID, InternalNode source, InternalNode target){
		createTableLoad(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an TableLoad with generated id. Post create hook will be triggered.
	 */
	def createTableLoad(InternalNode source, InternalNode target){
		createTableLoad(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an TableLoad with the given id. Post create hook won't be triggered.
	 */
	def createTableLoad(String ID){
		createTableLoad(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an TableLoad with a generated id. Post create hook won't be triggered.
	 */
	override createTableLoad() {
		createTableLoad(generateUUID)
	}
	/**
	 * This method creates an Radio with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createRadio(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createRadio => [
			setID(ID)
			internal = ime ?: createInternalRadio => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.RadioEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Radio with the given id. Post create hook won't be triggered.
	 */
	def createRadio(String ID){
		createRadio(ID,null,null,false)
	}
	
	/**
	 * This method creates an Radio with the given id. Post create hook will be triggered.
	 */
	def createRadio(InternalModelElementContainer parent){
		createRadio(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Radio with the given id. Post create hook will be triggered.
	 */
	def createRadio(String ID, InternalModelElementContainer parent){
		createRadio(ID,null,parent,true)
	}
	
	def createRadio(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createRadio(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Radio with the given id. Post create hook won't be triggered.
	 */
	def createRadio(InternalModelElement ime) {
		createRadio(generateUUID,ime,null,false)
	}
	
	override createRadio() {
		createRadio(generateUUID)
	}
	/**
	 * This method creates an Row with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createRow(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createRow => [
			setID(ID)
			internal = ime ?: createInternalRow => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.RowEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Row with the given id. Post create hook won't be triggered.
	 */
	def createRow(String ID){
		createRow(ID,null,null,false)
	}
	
	/**
	 * This method creates an Row with the given id. Post create hook will be triggered.
	 */
	def createRow(InternalModelElementContainer parent){
		createRow(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Row with the given id. Post create hook will be triggered.
	 */
	def createRow(String ID, InternalModelElementContainer parent){
		createRow(ID,null,parent,true)
	}
	
	def createRow(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createRow(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Row with the given id. Post create hook won't be triggered.
	 */
	def createRow(InternalModelElement ime) {
		createRow(generateUUID,ime,null,false)
	}
	
	override createRow() {
		createRow(generateUUID)
	}
	/**
	 * This method creates an ComplexAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexAttribute => [
			setID(ID)
			internal = ime ?: createInternalComplexAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttribute(String ID){
		createComplexAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexAttribute(InternalModelElementContainer parent){
		createComplexAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexAttribute(String ID, InternalModelElementContainer parent){
		createComplexAttribute(ID,null,parent,true)
	}
	
	def createComplexAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttribute(InternalModelElement ime) {
		createComplexAttribute(generateUUID,ime,null,false)
	}
	
	override createComplexAttribute() {
		createComplexAttribute(generateUUID)
	}
	def createPrimitiveChoiceData(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createPrimitiveChoiceData => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveChoiceData => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.PrimitiveChoiceDataEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an PrimitiveChoiceData with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveChoiceData(String ID, InternalNode source, InternalNode target){
		createPrimitiveChoiceData(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveChoiceData with generated id. Post create hook will be triggered.
	 */
	def createPrimitiveChoiceData(InternalNode source, InternalNode target){
		createPrimitiveChoiceData(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveChoiceData with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveChoiceData(String ID){
		createPrimitiveChoiceData(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveChoiceData with a generated id. Post create hook won't be triggered.
	 */
	override createPrimitiveChoiceData() {
		createPrimitiveChoiceData(generateUUID)
	}
	/**
	 * This method creates an MoveDown with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createMoveDown(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createMoveDown => [
			setID(ID)
			internal = ime ?: createInternalMoveDown => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.MoveDownEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an MoveDown with the given id. Post create hook won't be triggered.
	 */
	def createMoveDown(String ID){
		createMoveDown(ID,null,null,false)
	}
	
	/**
	 * This method creates an MoveDown with the given id. Post create hook will be triggered.
	 */
	def createMoveDown(InternalModelElementContainer parent){
		createMoveDown(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an MoveDown with the given id. Post create hook will be triggered.
	 */
	def createMoveDown(String ID, InternalModelElementContainer parent){
		createMoveDown(ID,null,parent,true)
	}
	
	def createMoveDown(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createMoveDown(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an MoveDown with the given id. Post create hook won't be triggered.
	 */
	def createMoveDown(InternalModelElement ime) {
		createMoveDown(generateUUID,ime,null,false)
	}
	
	override createMoveDown() {
		createMoveDown(generateUUID)
	}
	/**
	 * This method creates an PrimitiveListAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveListAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveListAttribute => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveListAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.PrimitiveListAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveListAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveListAttribute(String ID){
		createPrimitiveListAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveListAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveListAttribute(InternalModelElementContainer parent){
		createPrimitiveListAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveListAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveListAttribute(String ID, InternalModelElementContainer parent){
		createPrimitiveListAttribute(ID,null,parent,true)
	}
	
	def createPrimitiveListAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveListAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveListAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveListAttribute(InternalModelElement ime) {
		createPrimitiveListAttribute(generateUUID,ime,null,false)
	}
	
	override createPrimitiveListAttribute() {
		createPrimitiveListAttribute(generateUUID)
	}
	/**
	 * This method creates an Branch with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBranch => [
			setID(ID)
			internal = ime ?: createInternalBranch => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.BranchEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook won't be triggered.
	 */
	def createBranch(String ID){
		createBranch(ID,null,null,false)
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook will be triggered.
	 */
	def createBranch(InternalModelElementContainer parent){
		createBranch(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook will be triggered.
	 */
	def createBranch(String ID, InternalModelElementContainer parent){
		createBranch(ID,null,parent,true)
	}
	
	def createBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBranch(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook won't be triggered.
	 */
	def createBranch(InternalModelElement ime) {
		createBranch(generateUUID,ime,null,false)
	}
	
	override createBranch() {
		createBranch(generateUUID)
	}
	/**
	 * This method creates an InputGeneric with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createInputGeneric(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createInputGeneric => [
			setID(ID)
			internal = ime ?: createInternalInputGeneric => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.InputGenericEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an InputGeneric with the given id. Post create hook won't be triggered.
	 */
	def createInputGeneric(String ID){
		createInputGeneric(ID,null,null,false)
	}
	
	/**
	 * This method creates an InputGeneric with the given id. Post create hook will be triggered.
	 */
	def createInputGeneric(InternalModelElementContainer parent){
		createInputGeneric(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an InputGeneric with the given id. Post create hook will be triggered.
	 */
	def createInputGeneric(String ID, InternalModelElementContainer parent){
		createInputGeneric(ID,null,parent,true)
	}
	
	def createInputGeneric(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createInputGeneric(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an InputGeneric with the given id. Post create hook won't be triggered.
	 */
	def createInputGeneric(InternalModelElement ime) {
		createInputGeneric(generateUUID,ime,null,false)
	}
	
	override createInputGeneric() {
		createInputGeneric(generateUUID)
	}
	/**
	 * This method creates an ListenerContext with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createListenerContext(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createListenerContext => [
			setID(ID)
			internal = ime ?: createInternalListenerContext => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ListenerContextEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ListenerContext with the given id. Post create hook won't be triggered.
	 */
	def createListenerContext(String ID){
		createListenerContext(ID,null,null,false)
	}
	
	/**
	 * This method creates an ListenerContext with the given id. Post create hook will be triggered.
	 */
	def createListenerContext(InternalModelElementContainer parent){
		createListenerContext(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ListenerContext with the given id. Post create hook will be triggered.
	 */
	def createListenerContext(String ID, InternalModelElementContainer parent){
		createListenerContext(ID,null,parent,true)
	}
	
	def createListenerContext(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createListenerContext(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ListenerContext with the given id. Post create hook won't be triggered.
	 */
	def createListenerContext(InternalModelElement ime) {
		createListenerContext(generateUUID,ime,null,false)
	}
	
	override createListenerContext() {
		createListenerContext(generateUUID)
	}
	def createComplexAttributeConnector(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexAttributeConnector => [
			setID(ID)
			internal = ime ?: createInternalComplexAttributeConnector => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexAttributeConnectorEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ComplexAttributeConnector with the given id. Post create hook will be triggered.
	 */
	def createComplexAttributeConnector(String ID, InternalNode source, InternalNode target){
		createComplexAttributeConnector(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexAttributeConnector with generated id. Post create hook will be triggered.
	 */
	def createComplexAttributeConnector(InternalNode source, InternalNode target){
		createComplexAttributeConnector(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexAttributeConnector with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttributeConnector(String ID){
		createComplexAttributeConnector(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexAttributeConnector with a generated id. Post create hook won't be triggered.
	 */
	override createComplexAttributeConnector() {
		createComplexAttributeConnector(generateUUID)
	}
	/**
	 * This method creates an GUISIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGUISIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGUISIB => [
			setID(ID)
			internal = ime ?: createInternalGUISIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.GUISIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook won't be triggered.
	 */
	def createGUISIB(String ID){
		createGUISIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook will be triggered.
	 */
	def createGUISIB(InternalModelElementContainer parent){
		createGUISIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook will be triggered.
	 */
	def createGUISIB(String ID, InternalModelElementContainer parent){
		createGUISIB(ID,null,parent,true)
	}
	
	def createGUISIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGUISIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GUISIB with the given id. Post create hook won't be triggered.
	 */
	def createGUISIB(InternalModelElement ime) {
		createGUISIB(generateUUID,ime,null,false)
	}
	
	override createGUISIB() {
		createGUISIB(generateUUID)
	}
	/**
	 * This method creates an Table with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createTable(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createTable => [
			setID(ID)
			internal = ime ?: createInternalTable => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.TableEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Table with the given id. Post create hook won't be triggered.
	 */
	def createTable(String ID){
		createTable(ID,null,null,false)
	}
	
	/**
	 * This method creates an Table with the given id. Post create hook will be triggered.
	 */
	def createTable(InternalModelElementContainer parent){
		createTable(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Table with the given id. Post create hook will be triggered.
	 */
	def createTable(String ID, InternalModelElementContainer parent){
		createTable(ID,null,parent,true)
	}
	
	def createTable(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createTable(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Table with the given id. Post create hook won't be triggered.
	 */
	def createTable(InternalModelElement ime) {
		createTable(generateUUID,ime,null,false)
	}
	
	override createTable() {
		createTable(generateUUID)
	}
	/**
	 * This method creates an LeftNavBarPart with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createLeftNavBarPart(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createLeftNavBarPart => [
			setID(ID)
			internal = ime ?: createInternalLeftNavBarPart => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.LeftNavBarPartEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an LeftNavBarPart with the given id. Post create hook won't be triggered.
	 */
	def createLeftNavBarPart(String ID){
		createLeftNavBarPart(ID,null,null,false)
	}
	
	/**
	 * This method creates an LeftNavBarPart with the given id. Post create hook will be triggered.
	 */
	def createLeftNavBarPart(InternalModelElementContainer parent){
		createLeftNavBarPart(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an LeftNavBarPart with the given id. Post create hook will be triggered.
	 */
	def createLeftNavBarPart(String ID, InternalModelElementContainer parent){
		createLeftNavBarPart(ID,null,parent,true)
	}
	
	def createLeftNavBarPart(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createLeftNavBarPart(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an LeftNavBarPart with the given id. Post create hook won't be triggered.
	 */
	def createLeftNavBarPart(InternalModelElement ime) {
		createLeftNavBarPart(generateUUID,ime,null,false)
	}
	
	override createLeftNavBarPart() {
		createLeftNavBarPart(generateUUID)
	}
	def createComplexListAttributeConnector(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexListAttributeConnector => [
			setID(ID)
			internal = ime ?: createInternalComplexListAttributeConnector => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.gui.adapter.ComplexListAttributeConnectorEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ComplexListAttributeConnector with the given id. Post create hook will be triggered.
	 */
	def createComplexListAttributeConnector(String ID, InternalNode source, InternalNode target){
		createComplexListAttributeConnector(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexListAttributeConnector with generated id. Post create hook will be triggered.
	 */
	def createComplexListAttributeConnector(InternalNode source, InternalNode target){
		createComplexListAttributeConnector(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexListAttributeConnector with the given id. Post create hook won't be triggered.
	 */
	def createComplexListAttributeConnector(String ID){
		createComplexListAttributeConnector(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexListAttributeConnector with a generated id. Post create hook won't be triggered.
	 */
	override createComplexListAttributeConnector() {
		createComplexListAttributeConnector(generateUUID)
	}
	/**
	 * This method creates an Placeholder with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPlaceholder(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPlaceholder => [
			setID(ID)
			internal = ime ?: createInternalPlaceholder => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.PlaceholderEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Placeholder with the given id. Post create hook won't be triggered.
	 */
	def createPlaceholder(String ID){
		createPlaceholder(ID,null,null,false)
	}
	
	/**
	 * This method creates an Placeholder with the given id. Post create hook will be triggered.
	 */
	def createPlaceholder(InternalModelElementContainer parent){
		createPlaceholder(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Placeholder with the given id. Post create hook will be triggered.
	 */
	def createPlaceholder(String ID, InternalModelElementContainer parent){
		createPlaceholder(ID,null,parent,true)
	}
	
	def createPlaceholder(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPlaceholder(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Placeholder with the given id. Post create hook won't be triggered.
	 */
	def createPlaceholder(InternalModelElement ime) {
		createPlaceholder(generateUUID,ime,null,false)
	}
	
	override createPlaceholder() {
		createPlaceholder(generateUUID)
	}
	/**
	 * This method creates an RightNavBarPart with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createRightNavBarPart(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createRightNavBarPart => [
			setID(ID)
			internal = ime ?: createInternalRightNavBarPart => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.RightNavBarPartEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an RightNavBarPart with the given id. Post create hook won't be triggered.
	 */
	def createRightNavBarPart(String ID){
		createRightNavBarPart(ID,null,null,false)
	}
	
	/**
	 * This method creates an RightNavBarPart with the given id. Post create hook will be triggered.
	 */
	def createRightNavBarPart(InternalModelElementContainer parent){
		createRightNavBarPart(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an RightNavBarPart with the given id. Post create hook will be triggered.
	 */
	def createRightNavBarPart(String ID, InternalModelElementContainer parent){
		createRightNavBarPart(ID,null,parent,true)
	}
	
	def createRightNavBarPart(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createRightNavBarPart(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an RightNavBarPart with the given id. Post create hook won't be triggered.
	 */
	def createRightNavBarPart(InternalModelElement ime) {
		createRightNavBarPart(generateUUID,ime,null,false)
	}
	
	override createRightNavBarPart() {
		createRightNavBarPart(generateUUID)
	}
	/**
	 * This method creates an MoveRight with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createMoveRight(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createMoveRight => [
			setID(ID)
			internal = ime ?: createInternalMoveRight => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.MoveRightEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an MoveRight with the given id. Post create hook won't be triggered.
	 */
	def createMoveRight(String ID){
		createMoveRight(ID,null,null,false)
	}
	
	/**
	 * This method creates an MoveRight with the given id. Post create hook will be triggered.
	 */
	def createMoveRight(InternalModelElementContainer parent){
		createMoveRight(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an MoveRight with the given id. Post create hook will be triggered.
	 */
	def createMoveRight(String ID, InternalModelElementContainer parent){
		createMoveRight(ID,null,parent,true)
	}
	
	def createMoveRight(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createMoveRight(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an MoveRight with the given id. Post create hook won't be triggered.
	 */
	def createMoveRight(InternalModelElement ime) {
		createMoveRight(generateUUID,ime,null,false)
	}
	
	override createMoveRight() {
		createMoveRight(generateUUID)
	}
	/**
	 * This method creates an ExtensionContext with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createExtensionContext(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createExtensionContext => [
			setID(ID)
			internal = ime ?: createInternalExtensionContext => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.gui.adapter.ExtensionContextEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ExtensionContext with the given id. Post create hook won't be triggered.
	 */
	def createExtensionContext(String ID){
		createExtensionContext(ID,null,null,false)
	}
	
	/**
	 * This method creates an ExtensionContext with the given id. Post create hook will be triggered.
	 */
	def createExtensionContext(InternalModelElementContainer parent){
		createExtensionContext(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ExtensionContext with the given id. Post create hook will be triggered.
	 */
	def createExtensionContext(String ID, InternalModelElementContainer parent){
		createExtensionContext(ID,null,parent,true)
	}
	
	def createExtensionContext(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createExtensionContext(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ExtensionContext with the given id. Post create hook won't be triggered.
	 */
	def createExtensionContext(InternalModelElement ime) {
		createExtensionContext(generateUUID,ime,null,false)
	}
	
	override createExtensionContext() {
		createExtensionContext(generateUUID)
	}
	
	private def <T extends IdentifiableElement> setInternal(T elm, InternalIdentifiableElement internal) {
		elm => [
			if (id.isNullOrEmpty)
				ID = generateUUID
			switch elm {
				GraphModel: elm.setInternalElement_(internal as InternalGraphModel)
				ModelElement: elm.setInternalElement_(internal as InternalModelElement)
				Type: elm.setInternalElement_(internal as InternalType)
			}
		]
	}
	
	/**
	* This method creates a new GUI object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can 
	* simply call the GUI's save method to save your changes.
	*/
	def info.scce.dime.gui.gui.GUI createGUI(java.lang.String path, java.lang.String fileName) {
		var filePath = new org.eclipse.core.runtime.Path(path).append(fileName).addFileExtension("gui");
		var uri = org.eclipse.emf.common.util.URI.createPlatformResourceURI(filePath.toOSString(), true);
		var res = new org.eclipse.emf.ecore.resource.impl.ResourceSetImpl().createResource(uri);
		var graph = info.scce.dime.gui.factory.GUIFactory.eINSTANCE.createGUI();
		
		org.eclipse.emf.ecore.util.EcoreUtil.setID(graph, org.eclipse.emf.ecore.util.EcoreUtil.generateUUID());

		res.getContents().add(graph.getInternalElement_());
		
		postCreates(graph);
		try {
			res.save(null);
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}

		return graph;
	}
	
	def postCreates(info.scce.dime.gui.gui.ProcessSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.ProcessSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.IFSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.ControlSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.ISSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.ControlSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.FORSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.ControlSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.SecuritySIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.ControlSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.GUISIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.GUISIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.DispatchedGUISIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.DispatchedGUISIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.GuardSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.GuardSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Event me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.Event_PostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.PrimitiveOutputPort me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.OutputPortHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.ComplexOutputPort me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.OutputPortHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.GUIPlugin me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.GUIPluginHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Argument me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.ComplexInputPort me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.ComplexInputPostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Placeholder me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Row me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.TODOList me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Template me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Col me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Headline me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Text me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Listing me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Description me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Listentry me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Descriptionentry me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Table me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.TableEntry me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Form me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.File me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Field me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Radio me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Combobox me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Checkbox me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Button me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.LinkProcessSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.LinkProcessSIBHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.ButtonToolbar me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.ButtonGroup me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Dropdown me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Image me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Thumbnail me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Alert me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.PageUp me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.ProgressBar me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Jumbotron me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Embedded me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Panel me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Box me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Badge me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Tabbing me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.Tab me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.TopNavBar me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.BottomNavBar me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.RightNavBarPart me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.LeftNavBarPart me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateComponentHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.ExtensionContext me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.ListenerContextPostCreateHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.PrimitiveVariable me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.Variable_PostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.ComplexVariable me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.ComplexVariablePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.^FOR me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateForEdgeHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.PrimitiveFOR me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateForEdgeHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.TableLoad me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateTableBindingEdgeHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.TableColumnLoad me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateTableBindingEdgeHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.FormLoadSubmit me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateDataBindingEdgeHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.FormSubmit me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateDataBindingEdgeHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.SetGenericType me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.SetGenericTypeCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.gui.gui.GUI me) {
		me.transact [ // Post create hook
			new info.scce.dime.gui.hooks.CreateGraphModelHook().postCreate(me)
		]
	}
	
}
