package info.scce.dime.graphql.schema.factory

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

import info.scce.dime.graphql.schema.graphql.GraphqlPackage
import info.scce.dime.graphql.schema.graphql.impl.GraphqlFactoryImpl
import info.scce.dime.graphql.schema.graphql.internal.InternalFactory
import info.scce.dime.graphql.schema.graphql.internal.InternalPackage

import info.scce.dime.graphql.schema.graphql.adapter.*

import graphmodel.internal.InternalModelElement
import graphmodel.internal.InternalModelElementContainer
import graphmodel.internal.InternalGraphModel
import graphmodel.internal.InternalContainer
import graphmodel.internal.InternalNode
import graphmodel.internal.InternalEdge
import graphmodel.internal.InternalType
import graphmodel.internal.InternalIdentifiableElement
import graphmodel.ModelElement
import graphmodel.IdentifiableElement
import graphmodel.GraphModel
import graphmodel.Type

import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EPackage
import org.eclipse.emf.ecore.plugin.EcorePlugin

class GraphQLFactory extends GraphqlFactoryImpl {
	
	final extension InternalFactory = InternalFactory.eINSTANCE
	public static GraphQLFactory eINSTANCE = GraphQLFactory.init
	
	extension de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension = new de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension
	
	static def GraphQLFactory init() {
		try {
			val fct = EPackage::Registry.INSTANCE.getEFactory(GraphqlPackage.eNS_URI) as GraphQLFactory
			if (fct !== null)
				return fct as GraphQLFactory
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		new GraphQLFactory
	}
	
	/**
	 * This method creates an GraphQL with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGraphQL(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGraphQL => [ 
			setID(ID)
			internal = ime ?: createInternalGraphQL => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.GraphQLEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an GraphQL with the given id. Post create hook won't be triggered.
	 */
	def createGraphQL(String ID){
		createGraphQL(ID,null,null,false)
	}
	
	/**
	 * This method creates an GraphQL with the given id. Post create hook will be triggered.
	 */
	def createGraphQL(InternalModelElementContainer parent){
		createGraphQL(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GraphQL with the given id. Post create hook will be triggered.
	 */
	def createGraphQL(String ID, InternalModelElementContainer parent){
		createGraphQL(ID,null,parent,true)
	}
	
	def createGraphQL(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGraphQL(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GraphQL with the given id. Post create hook won't be triggered.
	 */
	def createGraphQL(InternalModelElement ime) {
		createGraphQL(generateUUID,ime,null,false)
	}
	
	override createGraphQL() {
		createGraphQL(generateUUID)
	}
	/**
	 * This method creates an ApiInput with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createApiInput(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createApiInput => [
			setID(ID)
			internal = ime ?: createInternalApiInput => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ApiInputEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ApiInput with the given id. Post create hook won't be triggered.
	 */
	def createApiInput(String ID){
		createApiInput(ID,null,null,false)
	}
	
	/**
	 * This method creates an ApiInput with the given id. Post create hook will be triggered.
	 */
	def createApiInput(InternalModelElementContainer parent){
		createApiInput(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ApiInput with the given id. Post create hook will be triggered.
	 */
	def createApiInput(String ID, InternalModelElementContainer parent){
		createApiInput(ID,null,parent,true)
	}
	
	def createApiInput(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createApiInput(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ApiInput with the given id. Post create hook won't be triggered.
	 */
	def createApiInput(InternalModelElement ime) {
		createApiInput(generateUUID,ime,null,false)
	}
	
	override createApiInput() {
		createApiInput(generateUUID)
	}
	/**
	 * This method creates an Queries with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createQueries(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createQueries => [
			setID(ID)
			internal = ime ?: createInternalQueries => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.QueriesEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Queries with the given id. Post create hook won't be triggered.
	 */
	def createQueries(String ID){
		createQueries(ID,null,null,false)
	}
	
	/**
	 * This method creates an Queries with the given id. Post create hook will be triggered.
	 */
	def createQueries(InternalModelElementContainer parent){
		createQueries(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Queries with the given id. Post create hook will be triggered.
	 */
	def createQueries(String ID, InternalModelElementContainer parent){
		createQueries(ID,null,parent,true)
	}
	
	def createQueries(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createQueries(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Queries with the given id. Post create hook won't be triggered.
	 */
	def createQueries(InternalModelElement ime) {
		createQueries(generateUUID,ime,null,false)
	}
	
	override createQueries() {
		createQueries(generateUUID)
	}
	/**
	 * This method creates an ForbiddenPrimitiveAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createForbiddenPrimitiveAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createForbiddenPrimitiveAttribute => [
			setID(ID)
			internal = ime ?: createInternalForbiddenPrimitiveAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ForbiddenPrimitiveAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ForbiddenPrimitiveAttribute with the given id. Post create hook won't be triggered.
	 */
	def createForbiddenPrimitiveAttribute(String ID){
		createForbiddenPrimitiveAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ForbiddenPrimitiveAttribute with the given id. Post create hook will be triggered.
	 */
	def createForbiddenPrimitiveAttribute(InternalModelElementContainer parent){
		createForbiddenPrimitiveAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ForbiddenPrimitiveAttribute with the given id. Post create hook will be triggered.
	 */
	def createForbiddenPrimitiveAttribute(String ID, InternalModelElementContainer parent){
		createForbiddenPrimitiveAttribute(ID,null,parent,true)
	}
	
	def createForbiddenPrimitiveAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createForbiddenPrimitiveAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ForbiddenPrimitiveAttribute with the given id. Post create hook won't be triggered.
	 */
	def createForbiddenPrimitiveAttribute(InternalModelElement ime) {
		createForbiddenPrimitiveAttribute(generateUUID,ime,null,false)
	}
	
	override createForbiddenPrimitiveAttribute() {
		createForbiddenPrimitiveAttribute(generateUUID)
	}
	/**
	 * This method creates an ForbiddenTypes with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createForbiddenTypes(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createForbiddenTypes => [
			setID(ID)
			internal = ime ?: createInternalForbiddenTypes => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ForbiddenTypesEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ForbiddenTypes with the given id. Post create hook won't be triggered.
	 */
	def createForbiddenTypes(String ID){
		createForbiddenTypes(ID,null,null,false)
	}
	
	/**
	 * This method creates an ForbiddenTypes with the given id. Post create hook will be triggered.
	 */
	def createForbiddenTypes(InternalModelElementContainer parent){
		createForbiddenTypes(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ForbiddenTypes with the given id. Post create hook will be triggered.
	 */
	def createForbiddenTypes(String ID, InternalModelElementContainer parent){
		createForbiddenTypes(ID,null,parent,true)
	}
	
	def createForbiddenTypes(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createForbiddenTypes(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ForbiddenTypes with the given id. Post create hook won't be triggered.
	 */
	def createForbiddenTypes(InternalModelElement ime) {
		createForbiddenTypes(generateUUID,ime,null,false)
	}
	
	override createForbiddenTypes() {
		createForbiddenTypes(generateUUID)
	}
	/**
	 * This method creates an ForbiddenType with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createForbiddenType(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createForbiddenType => [
			setID(ID)
			internal = ime ?: createInternalForbiddenType => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ForbiddenTypeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ForbiddenType with the given id. Post create hook won't be triggered.
	 */
	def createForbiddenType(String ID){
		createForbiddenType(ID,null,null,false)
	}
	
	/**
	 * This method creates an ForbiddenType with the given id. Post create hook will be triggered.
	 */
	def createForbiddenType(InternalModelElementContainer parent){
		createForbiddenType(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ForbiddenType with the given id. Post create hook will be triggered.
	 */
	def createForbiddenType(String ID, InternalModelElementContainer parent){
		createForbiddenType(ID,null,parent,true)
	}
	
	def createForbiddenType(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createForbiddenType(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ForbiddenType with the given id. Post create hook won't be triggered.
	 */
	def createForbiddenType(InternalModelElement ime) {
		createForbiddenType(generateUUID,ime,null,false)
	}
	
	override createForbiddenType() {
		createForbiddenType(generateUUID)
	}
	/**
	 * This method creates an Mutations with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createMutations(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createMutations => [
			setID(ID)
			internal = ime ?: createInternalMutations => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.MutationsEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Mutations with the given id. Post create hook won't be triggered.
	 */
	def createMutations(String ID){
		createMutations(ID,null,null,false)
	}
	
	/**
	 * This method creates an Mutations with the given id. Post create hook will be triggered.
	 */
	def createMutations(InternalModelElementContainer parent){
		createMutations(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Mutations with the given id. Post create hook will be triggered.
	 */
	def createMutations(String ID, InternalModelElementContainer parent){
		createMutations(ID,null,parent,true)
	}
	
	def createMutations(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createMutations(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Mutations with the given id. Post create hook won't be triggered.
	 */
	def createMutations(InternalModelElement ime) {
		createMutations(generateUUID,ime,null,false)
	}
	
	override createMutations() {
		createMutations(generateUUID)
	}
	/**
	 * This method creates an ForbiddenUserType with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createForbiddenUserType(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createForbiddenUserType => [
			setID(ID)
			internal = ime ?: createInternalForbiddenUserType => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ForbiddenUserTypeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ForbiddenUserType with the given id. Post create hook won't be triggered.
	 */
	def createForbiddenUserType(String ID){
		createForbiddenUserType(ID,null,null,false)
	}
	
	/**
	 * This method creates an ForbiddenUserType with the given id. Post create hook will be triggered.
	 */
	def createForbiddenUserType(InternalModelElementContainer parent){
		createForbiddenUserType(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ForbiddenUserType with the given id. Post create hook will be triggered.
	 */
	def createForbiddenUserType(String ID, InternalModelElementContainer parent){
		createForbiddenUserType(ID,null,parent,true)
	}
	
	def createForbiddenUserType(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createForbiddenUserType(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ForbiddenUserType with the given id. Post create hook won't be triggered.
	 */
	def createForbiddenUserType(InternalModelElement ime) {
		createForbiddenUserType(generateUUID,ime,null,false)
	}
	
	override createForbiddenUserType() {
		createForbiddenUserType(generateUUID)
	}
	/**
	 * This method creates an ResolverProcess with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createResolverProcess(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createResolverProcess => [
			setID(ID)
			internal = ime ?: createInternalResolverProcess => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ResolverProcessEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ResolverProcess with the given id. Post create hook won't be triggered.
	 */
	def createResolverProcess(String ID){
		createResolverProcess(ID,null,null,false)
	}
	
	/**
	 * This method creates an ResolverProcess with the given id. Post create hook will be triggered.
	 */
	def createResolverProcess(InternalModelElementContainer parent){
		createResolverProcess(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ResolverProcess with the given id. Post create hook will be triggered.
	 */
	def createResolverProcess(String ID, InternalModelElementContainer parent){
		createResolverProcess(ID,null,parent,true)
	}
	
	def createResolverProcess(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createResolverProcess(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ResolverProcess with the given id. Post create hook won't be triggered.
	 */
	def createResolverProcess(InternalModelElement ime) {
		createResolverProcess(generateUUID,ime,null,false)
	}
	
	override createResolverProcess() {
		createResolverProcess(generateUUID)
	}
	/**
	 * This method creates an Resolver with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createResolver(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createResolver => [
			setID(ID)
			internal = ime ?: createInternalResolver => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ResolverEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Resolver with the given id. Post create hook won't be triggered.
	 */
	def createResolver(String ID){
		createResolver(ID,null,null,false)
	}
	
	/**
	 * This method creates an Resolver with the given id. Post create hook will be triggered.
	 */
	def createResolver(InternalModelElementContainer parent){
		createResolver(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Resolver with the given id. Post create hook will be triggered.
	 */
	def createResolver(String ID, InternalModelElementContainer parent){
		createResolver(ID,null,parent,true)
	}
	
	def createResolver(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createResolver(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Resolver with the given id. Post create hook won't be triggered.
	 */
	def createResolver(InternalModelElement ime) {
		createResolver(generateUUID,ime,null,false)
	}
	
	override createResolver() {
		createResolver(generateUUID)
	}
	/**
	 * This method creates an APISIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createAPISIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createAPISIB => [
			setID(ID)
			internal = ime ?: createInternalAPISIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.APISIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an APISIB with the given id. Post create hook won't be triggered.
	 */
	def createAPISIB(String ID){
		createAPISIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an APISIB with the given id. Post create hook will be triggered.
	 */
	def createAPISIB(InternalModelElementContainer parent){
		createAPISIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an APISIB with the given id. Post create hook will be triggered.
	 */
	def createAPISIB(String ID, InternalModelElementContainer parent){
		createAPISIB(ID,null,parent,true)
	}
	
	def createAPISIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createAPISIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an APISIB with the given id. Post create hook won't be triggered.
	 */
	def createAPISIB(InternalModelElement ime) {
		createAPISIB(generateUUID,ime,null,false)
	}
	
	override createAPISIB() {
		createAPISIB(generateUUID)
	}
	/**
	 * This method creates an ResolverAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createResolverAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createResolverAttribute => [
			setID(ID)
			internal = ime ?: createInternalResolverAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ResolverAttributeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ResolverAttribute with the given id. Post create hook won't be triggered.
	 */
	def createResolverAttribute(String ID){
		createResolverAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ResolverAttribute with the given id. Post create hook will be triggered.
	 */
	def createResolverAttribute(InternalModelElementContainer parent){
		createResolverAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ResolverAttribute with the given id. Post create hook will be triggered.
	 */
	def createResolverAttribute(String ID, InternalModelElementContainer parent){
		createResolverAttribute(ID,null,parent,true)
	}
	
	def createResolverAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createResolverAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ResolverAttribute with the given id. Post create hook won't be triggered.
	 */
	def createResolverAttribute(InternalModelElement ime) {
		createResolverAttribute(generateUUID,ime,null,false)
	}
	
	override createResolverAttribute() {
		createResolverAttribute(generateUUID)
	}
	/**
	 * This method creates an ForbiddenComplexAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createForbiddenComplexAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createForbiddenComplexAttribute => [
			setID(ID)
			internal = ime ?: createInternalForbiddenComplexAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ForbiddenComplexAttributeEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ForbiddenComplexAttribute with the given id. Post create hook won't be triggered.
	 */
	def createForbiddenComplexAttribute(String ID){
		createForbiddenComplexAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ForbiddenComplexAttribute with the given id. Post create hook will be triggered.
	 */
	def createForbiddenComplexAttribute(InternalModelElementContainer parent){
		createForbiddenComplexAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ForbiddenComplexAttribute with the given id. Post create hook will be triggered.
	 */
	def createForbiddenComplexAttribute(String ID, InternalModelElementContainer parent){
		createForbiddenComplexAttribute(ID,null,parent,true)
	}
	
	def createForbiddenComplexAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createForbiddenComplexAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ForbiddenComplexAttribute with the given id. Post create hook won't be triggered.
	 */
	def createForbiddenComplexAttribute(InternalModelElement ime) {
		createForbiddenComplexAttribute(generateUUID,ime,null,false)
	}
	
	override createForbiddenComplexAttribute() {
		createForbiddenComplexAttribute(generateUUID)
	}
	/**
	 * This method creates an ApiError with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createApiError(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createApiError => [
			setID(ID)
			internal = ime ?: createInternalApiError => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ApiErrorEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ApiError with the given id. Post create hook won't be triggered.
	 */
	def createApiError(String ID){
		createApiError(ID,null,null,false)
	}
	
	/**
	 * This method creates an ApiError with the given id. Post create hook will be triggered.
	 */
	def createApiError(InternalModelElementContainer parent){
		createApiError(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ApiError with the given id. Post create hook will be triggered.
	 */
	def createApiError(String ID, InternalModelElementContainer parent){
		createApiError(ID,null,parent,true)
	}
	
	def createApiError(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createApiError(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ApiError with the given id. Post create hook won't be triggered.
	 */
	def createApiError(InternalModelElement ime) {
		createApiError(generateUUID,ime,null,false)
	}
	
	override createApiError() {
		createApiError(generateUUID)
	}
	/**
	 * This method creates an ApiOutput with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createApiOutput(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createApiOutput => [
			setID(ID)
			internal = ime ?: createInternalApiOutput => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ApiOutputEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ApiOutput with the given id. Post create hook won't be triggered.
	 */
	def createApiOutput(String ID){
		createApiOutput(ID,null,null,false)
	}
	
	/**
	 * This method creates an ApiOutput with the given id. Post create hook will be triggered.
	 */
	def createApiOutput(InternalModelElementContainer parent){
		createApiOutput(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ApiOutput with the given id. Post create hook will be triggered.
	 */
	def createApiOutput(String ID, InternalModelElementContainer parent){
		createApiOutput(ID,null,parent,true)
	}
	
	def createApiOutput(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createApiOutput(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ApiOutput with the given id. Post create hook won't be triggered.
	 */
	def createApiOutput(InternalModelElement ime) {
		createApiOutput(generateUUID,ime,null,false)
	}
	
	override createApiOutput() {
		createApiOutput(generateUUID)
	}
	/**
	 * This method creates an Resolvers with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createResolvers(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createResolvers => [
			setID(ID)
			internal = ime ?: createInternalResolvers => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.schema.adapter.ResolversEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Resolvers with the given id. Post create hook won't be triggered.
	 */
	def createResolvers(String ID){
		createResolvers(ID,null,null,false)
	}
	
	/**
	 * This method creates an Resolvers with the given id. Post create hook will be triggered.
	 */
	def createResolvers(InternalModelElementContainer parent){
		createResolvers(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Resolvers with the given id. Post create hook will be triggered.
	 */
	def createResolvers(String ID, InternalModelElementContainer parent){
		createResolvers(ID,null,parent,true)
	}
	
	def createResolvers(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createResolvers(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Resolvers with the given id. Post create hook won't be triggered.
	 */
	def createResolvers(InternalModelElement ime) {
		createResolvers(generateUUID,ime,null,false)
	}
	
	override createResolvers() {
		createResolvers(generateUUID)
	}
	
	private def <T extends IdentifiableElement> setInternal(T elm, InternalIdentifiableElement internal) {
		elm => [
			if (id.isNullOrEmpty)
				ID = generateUUID
			switch elm {
				GraphModel: elm.setInternalElement_(internal as InternalGraphModel)
				ModelElement: elm.setInternalElement_(internal as InternalModelElement)
				Type: elm.setInternalElement_(internal as InternalType)
			}
		]
	}
	
	/**
	* This method creates a new GraphQL object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can 
	* simply call the GraphQL's save method to save your changes.
	*/
	def info.scce.dime.graphql.schema.graphql.GraphQL createGraphQL(java.lang.String path, java.lang.String fileName) {
		var filePath = new org.eclipse.core.runtime.Path(path).append(fileName).addFileExtension("graphql");
		var uri = org.eclipse.emf.common.util.URI.createPlatformResourceURI(filePath.toOSString(), true);
		var res = new org.eclipse.emf.ecore.resource.impl.ResourceSetImpl().createResource(uri);
		var graph = info.scce.dime.graphql.schema.factory.GraphQLFactory.eINSTANCE.createGraphQL();
		
		org.eclipse.emf.ecore.util.EcoreUtil.setID(graph, org.eclipse.emf.ecore.util.EcoreUtil.generateUUID());

		res.getContents().add(graph.getInternalElement_());
		
		postCreates(graph);
		try {
			res.save(null);
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}

		return graph;
	}
	
	def postCreates(info.scce.dime.graphql.schema.graphql.Resolver me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.ResolverPostCreateHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.schema.graphql.ResolverAttribute me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.ResolverAttributePostCreateHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.schema.graphql.ResolverProcess me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.ResolverProcessPostCreateHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.schema.graphql.APISIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.APISIBPostCreateHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.schema.graphql.ForbiddenType me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.ReferencedTypePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.schema.graphql.ForbiddenUserType me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.ReferencedTypePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.schema.graphql.GraphQL me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.GraphQLInit().postCreate(me)
		]
	}
	
}
