/*-
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.hooks

import info.scce.dime.api.DIMEPostCreateHook
import info.scce.dime.graphql.api.api.ComplexInputPort
import info.scce.dime.graphql.api.api.DataFlowTarget
import info.scce.dime.process.helper.NodeLayout
import info.scce.dime.graphql.api.api.Input
import static info.scce.dime.process.helper.LayoutConstants.ATTR_SPACE
import static info.scce.dime.process.helper.LayoutConstants.ATTR_X
import static info.scce.dime.process.helper.LayoutConstants.TYPE_FIRST_ATTR_Y
import info.scce.dime.graphql.api.api.ProcessSIB

class InputPortHook extends DIMEPostCreateHook<ComplexInputPort> {
	
	def layout(DataFlowTarget node) {
		var x = ATTR_X
		var y = TYPE_FIRST_ATTR_Y+35


		if (node instanceof ProcessSIB) {
			var attributeAmountEndSib = node.inputs.size() + 2;
			node.resize(node.getWidth(), NodeLayout.getTypeHeight(attributeAmountEndSib));
			for (Input input : node.inputs) {
				input.moveTo(node, x, y);
				input.resize(node.getWidth() - 2 * ATTR_X, input.getHeight());
				y += ATTR_SPACE;
			}
		}
	}
	
	
	override postCreate(ComplexInputPort inPort) {
		layout(inPort.container)
	}
		
}
