package info.scce.dime.graphql.api.factory

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

import info.scce.dime.graphql.api.api.ApiPackage
import info.scce.dime.graphql.api.api.impl.ApiFactoryImpl
import info.scce.dime.graphql.api.api.internal.InternalFactory
import info.scce.dime.graphql.api.api.internal.InternalPackage

import info.scce.dime.graphql.api.api.adapter.*

import graphmodel.internal.InternalModelElement
import graphmodel.internal.InternalModelElementContainer
import graphmodel.internal.InternalGraphModel
import graphmodel.internal.InternalContainer
import graphmodel.internal.InternalNode
import graphmodel.internal.InternalEdge
import graphmodel.internal.InternalType
import graphmodel.internal.InternalIdentifiableElement
import graphmodel.ModelElement
import graphmodel.IdentifiableElement
import graphmodel.GraphModel
import graphmodel.Type

import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EPackage
import org.eclipse.emf.ecore.plugin.EcorePlugin

class APIFactory extends ApiFactoryImpl {
	
	final extension InternalFactory = InternalFactory.eINSTANCE
	public static APIFactory eINSTANCE = APIFactory.init
	
	extension de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension = new de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension
	
	static def APIFactory init() {
		try {
			val fct = EPackage::Registry.INSTANCE.getEFactory(ApiPackage.eNS_URI) as APIFactory
			if (fct !== null)
				return fct as APIFactory
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		new APIFactory
	}
	
	/**
	 * This method creates an StartSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createStartSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createStartSIB => [
			setID(ID)
			internal = ime ?: createInternalStartSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.StartSIBEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an StartSIB with the given id. Post create hook won't be triggered.
	 */
	def createStartSIB(String ID){
		createStartSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an StartSIB with the given id. Post create hook will be triggered.
	 */
	def createStartSIB(InternalModelElementContainer parent){
		createStartSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an StartSIB with the given id. Post create hook will be triggered.
	 */
	def createStartSIB(String ID, InternalModelElementContainer parent){
		createStartSIB(ID,null,parent,true)
	}
	
	def createStartSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createStartSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an StartSIB with the given id. Post create hook won't be triggered.
	 */
	def createStartSIB(InternalModelElement ime) {
		createStartSIB(generateUUID,ime,null,false)
	}
	
	override createStartSIB() {
		createStartSIB(generateUUID)
	}
	def createComplexDirectDataFlow(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createComplexDirectDataFlow => [
			setID(ID)
			internal = ime ?: createInternalComplexDirectDataFlow => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.graphql.api.adapter.ComplexDirectDataFlowEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an ComplexDirectDataFlow with the given id. Post create hook will be triggered.
	 */
	def createComplexDirectDataFlow(String ID, InternalNode source, InternalNode target){
		createComplexDirectDataFlow(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexDirectDataFlow with generated id. Post create hook will be triggered.
	 */
	def createComplexDirectDataFlow(InternalNode source, InternalNode target){
		createComplexDirectDataFlow(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ComplexDirectDataFlow with the given id. Post create hook won't be triggered.
	 */
	def createComplexDirectDataFlow(String ID){
		createComplexDirectDataFlow(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ComplexDirectDataFlow with a generated id. Post create hook won't be triggered.
	 */
	override createComplexDirectDataFlow() {
		createComplexDirectDataFlow(generateUUID)
	}
	/**
	 * This method creates an Branch with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBranch => [
			setID(ID)
			internal = ime ?: createInternalBranch => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.BranchEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook won't be triggered.
	 */
	def createBranch(String ID){
		createBranch(ID,null,null,false)
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook will be triggered.
	 */
	def createBranch(InternalModelElementContainer parent){
		createBranch(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook will be triggered.
	 */
	def createBranch(String ID, InternalModelElementContainer parent){
		createBranch(ID,null,parent,true)
	}
	
	def createBranch(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBranch(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Branch with the given id. Post create hook won't be triggered.
	 */
	def createBranch(InternalModelElement ime) {
		createBranch(generateUUID,ime,null,false)
	}
	
	override createBranch() {
		createBranch(generateUUID)
	}
	def createBranchConnector(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createBranchConnector => [
			setID(ID)
			internal = ime ?: createInternalBranchConnector => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.graphql.api.adapter.BranchConnectorEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an BranchConnector with the given id. Post create hook will be triggered.
	 */
	def createBranchConnector(String ID, InternalNode source, InternalNode target){
		createBranchConnector(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an BranchConnector with generated id. Post create hook will be triggered.
	 */
	def createBranchConnector(InternalNode source, InternalNode target){
		createBranchConnector(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an BranchConnector with the given id. Post create hook won't be triggered.
	 */
	def createBranchConnector(String ID){
		createBranchConnector(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an BranchConnector with a generated id. Post create hook won't be triggered.
	 */
	override createBranchConnector() {
		createBranchConnector(generateUUID)
	}
	/**
	 * This method creates an API with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createAPI(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createAPI => [ 
			setID(ID)
			internal = ime ?: createInternalAPI => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.graphql.api.adapter.APIEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an API with the given id. Post create hook won't be triggered.
	 */
	def createAPI(String ID){
		createAPI(ID,null,null,false)
	}
	
	/**
	 * This method creates an API with the given id. Post create hook will be triggered.
	 */
	def createAPI(InternalModelElementContainer parent){
		createAPI(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an API with the given id. Post create hook will be triggered.
	 */
	def createAPI(String ID, InternalModelElementContainer parent){
		createAPI(ID,null,parent,true)
	}
	
	def createAPI(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createAPI(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an API with the given id. Post create hook won't be triggered.
	 */
	def createAPI(InternalModelElement ime) {
		createAPI(generateUUID,ime,null,false)
	}
	
	override createAPI() {
		createAPI(generateUUID)
	}
	/**
	 * This method creates an ComplexInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexInputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.ComplexInputPortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexInputPort(String ID){
		createComplexInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexInputPort(InternalModelElementContainer parent){
		createComplexInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexInputPort(String ID, InternalModelElementContainer parent){
		createComplexInputPort(ID,null,parent,true)
	}
	
	def createComplexInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexInputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexInputPort(InternalModelElement ime) {
		createComplexInputPort(generateUUID,ime,null,false)
	}
	
	override createComplexInputPort() {
		createComplexInputPort(generateUUID)
	}
	/**
	 * This method creates an ComplexOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexOutputPort => [
			setID(ID)
			internal = ime ?: createInternalComplexOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.ComplexOutputPortEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputPort(String ID){
		createComplexOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputPort(InternalModelElementContainer parent){
		createComplexOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook will be triggered.
	 */
	def createComplexOutputPort(String ID, InternalModelElementContainer parent){
		createComplexOutputPort(ID,null,parent,true)
	}
	
	def createComplexOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createComplexOutputPort(InternalModelElement ime) {
		createComplexOutputPort(generateUUID,ime,null,false)
	}
	
	override createComplexOutputPort() {
		createComplexOutputPort(generateUUID)
	}
	/**
	 * This method creates an ComplexAPIinput with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexAPIinput(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexAPIinput => [
			setID(ID)
			internal = ime ?: createInternalComplexAPIinput => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.ComplexAPIinputEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexAPIinput with the given id. Post create hook won't be triggered.
	 */
	def createComplexAPIinput(String ID){
		createComplexAPIinput(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexAPIinput with the given id. Post create hook will be triggered.
	 */
	def createComplexAPIinput(InternalModelElementContainer parent){
		createComplexAPIinput(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexAPIinput with the given id. Post create hook will be triggered.
	 */
	def createComplexAPIinput(String ID, InternalModelElementContainer parent){
		createComplexAPIinput(ID,null,parent,true)
	}
	
	def createComplexAPIinput(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexAPIinput(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexAPIinput with the given id. Post create hook won't be triggered.
	 */
	def createComplexAPIinput(InternalModelElement ime) {
		createComplexAPIinput(generateUUID,ime,null,false)
	}
	
	override createComplexAPIinput() {
		createComplexAPIinput(generateUUID)
	}
	/**
	 * This method creates an ErrorSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createErrorSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createErrorSIB => [
			setID(ID)
			internal = ime ?: createInternalErrorSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.ErrorSIBEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ErrorSIB with the given id. Post create hook won't be triggered.
	 */
	def createErrorSIB(String ID){
		createErrorSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ErrorSIB with the given id. Post create hook will be triggered.
	 */
	def createErrorSIB(InternalModelElementContainer parent){
		createErrorSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ErrorSIB with the given id. Post create hook will be triggered.
	 */
	def createErrorSIB(String ID, InternalModelElementContainer parent){
		createErrorSIB(ID,null,parent,true)
	}
	
	def createErrorSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createErrorSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ErrorSIB with the given id. Post create hook won't be triggered.
	 */
	def createErrorSIB(InternalModelElement ime) {
		createErrorSIB(generateUUID,ime,null,false)
	}
	
	override createErrorSIB() {
		createErrorSIB(generateUUID)
	}
	/**
	 * This method creates an EndSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createEndSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createEndSIB => [
			setID(ID)
			internal = ime ?: createInternalEndSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.EndSIBEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an EndSIB with the given id. Post create hook won't be triggered.
	 */
	def createEndSIB(String ID){
		createEndSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an EndSIB with the given id. Post create hook will be triggered.
	 */
	def createEndSIB(InternalModelElementContainer parent){
		createEndSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an EndSIB with the given id. Post create hook will be triggered.
	 */
	def createEndSIB(String ID, InternalModelElementContainer parent){
		createEndSIB(ID,null,parent,true)
	}
	
	def createEndSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createEndSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an EndSIB with the given id. Post create hook won't be triggered.
	 */
	def createEndSIB(InternalModelElement ime) {
		createEndSIB(generateUUID,ime,null,false)
	}
	
	override createEndSIB() {
		createEndSIB(generateUUID)
	}
	/**
	 * This method creates an PrimitiveOutputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveOutputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveOutputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.PrimitiveOutputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveOutputPort(String ID){
		createPrimitiveOutputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveOutputPort(InternalModelElementContainer parent){
		createPrimitiveOutputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveOutputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveOutputPort(ID,null,parent,true)
	}
	
	def createPrimitiveOutputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveOutputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveOutputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveOutputPort(InternalModelElement ime) {
		createPrimitiveOutputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveOutputPort() {
		createPrimitiveOutputPort(generateUUID)
	}
	/**
	 * This method creates an ProcessSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProcessSIB => [
			setID(ID)
			internal = ime ?: createInternalProcessSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.ProcessSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessSIB(String ID){
		createProcessSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessSIB(InternalModelElementContainer parent){
		createProcessSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
	 */
	def createProcessSIB(String ID, InternalModelElementContainer parent){
		createProcessSIB(ID,null,parent,true)
	}
	
	def createProcessSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProcessSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
	 */
	def createProcessSIB(InternalModelElement ime) {
		createProcessSIB(generateUUID,ime,null,false)
	}
	
	override createProcessSIB() {
		createProcessSIB(generateUUID)
	}
	/**
	 * This method creates an ComplexAPIoutput with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexAPIoutput(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexAPIoutput => [
			setID(ID)
			internal = ime ?: createInternalComplexAPIoutput => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.ComplexAPIoutputEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexAPIoutput with the given id. Post create hook won't be triggered.
	 */
	def createComplexAPIoutput(String ID){
		createComplexAPIoutput(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexAPIoutput with the given id. Post create hook will be triggered.
	 */
	def createComplexAPIoutput(InternalModelElementContainer parent){
		createComplexAPIoutput(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexAPIoutput with the given id. Post create hook will be triggered.
	 */
	def createComplexAPIoutput(String ID, InternalModelElementContainer parent){
		createComplexAPIoutput(ID,null,parent,true)
	}
	
	def createComplexAPIoutput(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexAPIoutput(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexAPIoutput with the given id. Post create hook won't be triggered.
	 */
	def createComplexAPIoutput(InternalModelElement ime) {
		createComplexAPIoutput(generateUUID,ime,null,false)
	}
	
	override createComplexAPIoutput() {
		createComplexAPIoutput(generateUUID)
	}
	/**
	 * This method creates an PrimitiveAPIoutput with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveAPIoutput(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveAPIoutput => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveAPIoutput => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.PrimitiveAPIoutputEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveAPIoutput with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAPIoutput(String ID){
		createPrimitiveAPIoutput(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveAPIoutput with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAPIoutput(InternalModelElementContainer parent){
		createPrimitiveAPIoutput(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAPIoutput with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAPIoutput(String ID, InternalModelElementContainer parent){
		createPrimitiveAPIoutput(ID,null,parent,true)
	}
	
	def createPrimitiveAPIoutput(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveAPIoutput(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAPIoutput with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAPIoutput(InternalModelElement ime) {
		createPrimitiveAPIoutput(generateUUID,ime,null,false)
	}
	
	override createPrimitiveAPIoutput() {
		createPrimitiveAPIoutput(generateUUID)
	}
	/**
	 * This method creates an PrimitiveAPIinput with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveAPIinput(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveAPIinput => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveAPIinput => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.PrimitiveAPIinputEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveAPIinput with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAPIinput(String ID){
		createPrimitiveAPIinput(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveAPIinput with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAPIinput(InternalModelElementContainer parent){
		createPrimitiveAPIinput(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAPIinput with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAPIinput(String ID, InternalModelElementContainer parent){
		createPrimitiveAPIinput(ID,null,parent,true)
	}
	
	def createPrimitiveAPIinput(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveAPIinput(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAPIinput with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAPIinput(InternalModelElement ime) {
		createPrimitiveAPIinput(generateUUID,ime,null,false)
	}
	
	override createPrimitiveAPIinput() {
		createPrimitiveAPIinput(generateUUID)
	}
	def createControlFlow(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createControlFlow => [
			setID(ID)
			internal = ime ?: createInternalControlFlow => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.graphql.api.adapter.ControlFlowEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an ControlFlow with the given id. Post create hook will be triggered.
	 */
	def createControlFlow(String ID, InternalNode source, InternalNode target){
		createControlFlow(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an ControlFlow with generated id. Post create hook will be triggered.
	 */
	def createControlFlow(InternalNode source, InternalNode target){
		createControlFlow(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an ControlFlow with the given id. Post create hook won't be triggered.
	 */
	def createControlFlow(String ID){
		createControlFlow(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an ControlFlow with a generated id. Post create hook won't be triggered.
	 */
	override createControlFlow() {
		createControlFlow(generateUUID)
	}
	def createPrimitiveDirectDataFlow(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createPrimitiveDirectDataFlow => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveDirectDataFlow => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.graphql.api.adapter.PrimitiveDirectDataFlowEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an PrimitiveDirectDataFlow with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveDirectDataFlow(String ID, InternalNode source, InternalNode target){
		createPrimitiveDirectDataFlow(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveDirectDataFlow with generated id. Post create hook will be triggered.
	 */
	def createPrimitiveDirectDataFlow(InternalNode source, InternalNode target){
		createPrimitiveDirectDataFlow(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an PrimitiveDirectDataFlow with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveDirectDataFlow(String ID){
		createPrimitiveDirectDataFlow(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveDirectDataFlow with a generated id. Post create hook won't be triggered.
	 */
	override createPrimitiveDirectDataFlow() {
		createPrimitiveDirectDataFlow(generateUUID)
	}
	/**
	 * This method creates an PrimitiveInputPort with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveInputPort => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveInputPort => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.graphql.api.adapter.PrimitiveInputPortEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputPort(String ID){
		createPrimitiveInputPort(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputPort(InternalModelElementContainer parent){
		createPrimitiveInputPort(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveInputPort(String ID, InternalModelElementContainer parent){
		createPrimitiveInputPort(ID,null,parent,true)
	}
	
	def createPrimitiveInputPort(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveInputPort(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveInputPort with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveInputPort(InternalModelElement ime) {
		createPrimitiveInputPort(generateUUID,ime,null,false)
	}
	
	override createPrimitiveInputPort() {
		createPrimitiveInputPort(generateUUID)
	}
	
	private def <T extends IdentifiableElement> setInternal(T elm, InternalIdentifiableElement internal) {
		elm => [
			if (id.isNullOrEmpty)
				ID = generateUUID
			switch elm {
				GraphModel: elm.setInternalElement_(internal as InternalGraphModel)
				ModelElement: elm.setInternalElement_(internal as InternalModelElement)
				Type: elm.setInternalElement_(internal as InternalType)
			}
		]
	}
	
	/**
	* This method creates a new API object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can 
	* simply call the API's save method to save your changes.
	*/
	def info.scce.dime.graphql.api.api.API createAPI(java.lang.String path, java.lang.String fileName) {
		var filePath = new org.eclipse.core.runtime.Path(path).append(fileName).addFileExtension("api");
		var uri = org.eclipse.emf.common.util.URI.createPlatformResourceURI(filePath.toOSString(), true);
		var res = new org.eclipse.emf.ecore.resource.impl.ResourceSetImpl().createResource(uri);
		var graph = info.scce.dime.graphql.api.factory.APIFactory.eINSTANCE.createAPI();
		
		org.eclipse.emf.ecore.util.EcoreUtil.setID(graph, org.eclipse.emf.ecore.util.EcoreUtil.generateUUID());

		res.getContents().add(graph.getInternalElement_());
		
		postCreates(graph);
		try {
			res.save(null);
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}

		return graph;
	}
	
	def postCreates(info.scce.dime.graphql.api.api.ProcessSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.ProcessSIBPostCreateHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.api.api.ComplexAPIinput me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.PortPostCreateHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.api.api.ComplexOutputPort me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.OutputPortHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.api.api.ComplexInputPort me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.InputPortHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.api.api.ComplexAPIoutput me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.APIoutputPortHook().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.api.api.PrimitiveDirectDataFlow me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.DirectDataFlowPostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.api.api.ComplexDirectDataFlow me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.DirectDataFlowPostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.graphql.api.api.API me) {
		me.transact [ // Post create hook
			new info.scce.dime.graphql.hooks.APIInit().postCreate(me)
		]
	}
	
}
