/*-
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.actions

import info.scce.dime.api.DIMECustomAction
import info.scce.dime.graphql.api.api.StartSIB
import info.scce.dime.process.helper.NodeLayout

import static info.scce.dime.process.helper.LayoutConstants.ATTR_SPACE
import static info.scce.dime.process.helper.LayoutConstants.ATTR_X
import static info.scce.dime.process.helper.LayoutConstants.TYPE_FIRST_ATTR_Y

class StartSIBDoubleclickAction extends DIMECustomAction<StartSIB> {
	
	override getName() {
		"New primitive input"
	}

	override execute(StartSIB sib) {
		// create unique name
		val existingNames = sib.APIinputPorts.map[it.name]
		var newPortName = "input"
		var i = 1
		while(existingNames.contains(newPortName + i)) i++
			
		// create port
		val port = sib.newPrimitiveAPIinput(1, 1)
		port.name = newPortName + i;
			
		// layout
		var x = ATTR_X
		var y = TYPE_FIRST_ATTR_Y + 35
		var attributeAmount = sib.APIinputPorts.size() + 2;
		sib.resize(sib.width, NodeLayout.getTypeHeight(attributeAmount));
		for (input: sib.APIinputPorts) {				
			input.moveTo(sib, x, y);
			input.resize(sib.getWidth() - 2 * ATTR_X, input.getHeight());
			y += ATTR_SPACE;
		}
	}
}
