package info.scce.dime.data.factory

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

import info.scce.dime.data.data.DataPackage
import info.scce.dime.data.data.impl.DataFactoryImpl
import info.scce.dime.data.data.internal.InternalFactory
import info.scce.dime.data.data.internal.InternalPackage

import info.scce.dime.data.data.adapter.*

import graphmodel.internal.InternalModelElement
import graphmodel.internal.InternalModelElementContainer
import graphmodel.internal.InternalGraphModel
import graphmodel.internal.InternalContainer
import graphmodel.internal.InternalNode
import graphmodel.internal.InternalEdge
import graphmodel.internal.InternalType
import graphmodel.internal.InternalIdentifiableElement
import graphmodel.ModelElement
import graphmodel.IdentifiableElement
import graphmodel.GraphModel
import graphmodel.Type

import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EPackage
import org.eclipse.emf.ecore.plugin.EcorePlugin

class DataFactory extends DataFactoryImpl {
	
	final extension InternalFactory = InternalFactory.eINSTANCE
	public static DataFactory eINSTANCE = DataFactory.init
	
	extension de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension = new de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension
	
	static def DataFactory init() {
		try {
			val fct = EPackage::Registry.INSTANCE.getEFactory(DataPackage.eNS_URI) as DataFactory
			if (fct !== null)
				return fct as DataFactory
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		new DataFactory
	}
	
	/**
	 * This method creates an ReferencedBidirectionalAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createReferencedBidirectionalAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createReferencedBidirectionalAttribute => [
			setID(ID)
			internal = ime ?: createInternalReferencedBidirectionalAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.ReferencedBidirectionalAttributeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ReferencedBidirectionalAttribute with the given id. Post create hook won't be triggered.
	 */
	def createReferencedBidirectionalAttribute(String ID){
		createReferencedBidirectionalAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ReferencedBidirectionalAttribute with the given id. Post create hook will be triggered.
	 */
	def createReferencedBidirectionalAttribute(InternalModelElementContainer parent){
		createReferencedBidirectionalAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ReferencedBidirectionalAttribute with the given id. Post create hook will be triggered.
	 */
	def createReferencedBidirectionalAttribute(String ID, InternalModelElementContainer parent){
		createReferencedBidirectionalAttribute(ID,null,parent,true)
	}
	
	def createReferencedBidirectionalAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createReferencedBidirectionalAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ReferencedBidirectionalAttribute with the given id. Post create hook won't be triggered.
	 */
	def createReferencedBidirectionalAttribute(InternalModelElement ime) {
		createReferencedBidirectionalAttribute(generateUUID,ime,null,false)
	}
	
	override createReferencedBidirectionalAttribute() {
		createReferencedBidirectionalAttribute(generateUUID)
	}
	/**
	 * This method creates an ReferencedUserAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createReferencedUserAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createReferencedUserAttribute => [
			setID(ID)
			internal = ime ?: createInternalReferencedUserAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.ReferencedUserAttributeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ReferencedUserAttribute with the given id. Post create hook won't be triggered.
	 */
	def createReferencedUserAttribute(String ID){
		createReferencedUserAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ReferencedUserAttribute with the given id. Post create hook will be triggered.
	 */
	def createReferencedUserAttribute(InternalModelElementContainer parent){
		createReferencedUserAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ReferencedUserAttribute with the given id. Post create hook will be triggered.
	 */
	def createReferencedUserAttribute(String ID, InternalModelElementContainer parent){
		createReferencedUserAttribute(ID,null,parent,true)
	}
	
	def createReferencedUserAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createReferencedUserAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ReferencedUserAttribute with the given id. Post create hook won't be triggered.
	 */
	def createReferencedUserAttribute(InternalModelElement ime) {
		createReferencedUserAttribute(generateUUID,ime,null,false)
	}
	
	override createReferencedUserAttribute() {
		createReferencedUserAttribute(generateUUID)
	}
	/**
	 * This method creates an UserType with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createUserType(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createUserType => [
			setID(ID)
			internal = ime ?: createInternalUserType => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.UserTypeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an UserType with the given id. Post create hook won't be triggered.
	 */
	def createUserType(String ID){
		createUserType(ID,null,null,false)
	}
	
	/**
	 * This method creates an UserType with the given id. Post create hook will be triggered.
	 */
	def createUserType(InternalModelElementContainer parent){
		createUserType(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an UserType with the given id. Post create hook will be triggered.
	 */
	def createUserType(String ID, InternalModelElementContainer parent){
		createUserType(ID,null,parent,true)
	}
	
	def createUserType(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createUserType(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an UserType with the given id. Post create hook won't be triggered.
	 */
	def createUserType(InternalModelElement ime) {
		createUserType(generateUUID,ime,null,false)
	}
	
	override createUserType() {
		createUserType(generateUUID)
	}
	/**
	 * This method creates an ReferencedUserType with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createReferencedUserType(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createReferencedUserType => [
			setID(ID)
			internal = ime ?: createInternalReferencedUserType => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.ReferencedUserTypeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ReferencedUserType with the given id. Post create hook won't be triggered.
	 */
	def createReferencedUserType(String ID){
		createReferencedUserType(ID,null,null,false)
	}
	
	/**
	 * This method creates an ReferencedUserType with the given id. Post create hook will be triggered.
	 */
	def createReferencedUserType(InternalModelElementContainer parent){
		createReferencedUserType(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ReferencedUserType with the given id. Post create hook will be triggered.
	 */
	def createReferencedUserType(String ID, InternalModelElementContainer parent){
		createReferencedUserType(ID,null,parent,true)
	}
	
	def createReferencedUserType(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createReferencedUserType(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ReferencedUserType with the given id. Post create hook won't be triggered.
	 */
	def createReferencedUserType(InternalModelElement ime) {
		createReferencedUserType(generateUUID,ime,null,false)
	}
	
	override createReferencedUserType() {
		createReferencedUserType(generateUUID)
	}
	/**
	 * This method creates an EnumType with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createEnumType(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createEnumType => [
			setID(ID)
			internal = ime ?: createInternalEnumType => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.EnumTypeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an EnumType with the given id. Post create hook won't be triggered.
	 */
	def createEnumType(String ID){
		createEnumType(ID,null,null,false)
	}
	
	/**
	 * This method creates an EnumType with the given id. Post create hook will be triggered.
	 */
	def createEnumType(InternalModelElementContainer parent){
		createEnumType(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an EnumType with the given id. Post create hook will be triggered.
	 */
	def createEnumType(String ID, InternalModelElementContainer parent){
		createEnumType(ID,null,parent,true)
	}
	
	def createEnumType(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createEnumType(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an EnumType with the given id. Post create hook won't be triggered.
	 */
	def createEnumType(InternalModelElement ime) {
		createEnumType(generateUUID,ime,null,false)
	}
	
	override createEnumType() {
		createEnumType(generateUUID)
	}
	def createBidirectionalAssociation(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createBidirectionalAssociation => [
			setID(ID)
			internal = ime ?: createInternalBidirectionalAssociation => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.data.adapter.BidirectionalAssociationEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an BidirectionalAssociation with the given id. Post create hook will be triggered.
	 */
	def createBidirectionalAssociation(String ID, InternalNode source, InternalNode target){
		createBidirectionalAssociation(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an BidirectionalAssociation with generated id. Post create hook will be triggered.
	 */
	def createBidirectionalAssociation(InternalNode source, InternalNode target){
		createBidirectionalAssociation(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an BidirectionalAssociation with the given id. Post create hook won't be triggered.
	 */
	def createBidirectionalAssociation(String ID){
		createBidirectionalAssociation(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an BidirectionalAssociation with a generated id. Post create hook won't be triggered.
	 */
	override createBidirectionalAssociation() {
		createBidirectionalAssociation(generateUUID)
	}
	/**
	 * This method creates an ReferencedPrimitiveAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createReferencedPrimitiveAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createReferencedPrimitiveAttribute => [
			setID(ID)
			internal = ime ?: createInternalReferencedPrimitiveAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.ReferencedPrimitiveAttributeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ReferencedPrimitiveAttribute with the given id. Post create hook won't be triggered.
	 */
	def createReferencedPrimitiveAttribute(String ID){
		createReferencedPrimitiveAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ReferencedPrimitiveAttribute with the given id. Post create hook will be triggered.
	 */
	def createReferencedPrimitiveAttribute(InternalModelElementContainer parent){
		createReferencedPrimitiveAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ReferencedPrimitiveAttribute with the given id. Post create hook will be triggered.
	 */
	def createReferencedPrimitiveAttribute(String ID, InternalModelElementContainer parent){
		createReferencedPrimitiveAttribute(ID,null,parent,true)
	}
	
	def createReferencedPrimitiveAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createReferencedPrimitiveAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ReferencedPrimitiveAttribute with the given id. Post create hook won't be triggered.
	 */
	def createReferencedPrimitiveAttribute(InternalModelElement ime) {
		createReferencedPrimitiveAttribute(generateUUID,ime,null,false)
	}
	
	override createReferencedPrimitiveAttribute() {
		createReferencedPrimitiveAttribute(generateUUID)
	}
	/**
	 * This method creates an PrimitiveAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createPrimitiveAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createPrimitiveAttribute => [
			setID(ID)
			internal = ime ?: createInternalPrimitiveAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.PrimitiveAttributeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAttribute(String ID){
		createPrimitiveAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAttribute(InternalModelElementContainer parent){
		createPrimitiveAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook will be triggered.
	 */
	def createPrimitiveAttribute(String ID, InternalModelElementContainer parent){
		createPrimitiveAttribute(ID,null,parent,true)
	}
	
	def createPrimitiveAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createPrimitiveAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an PrimitiveAttribute with the given id. Post create hook won't be triggered.
	 */
	def createPrimitiveAttribute(InternalModelElement ime) {
		createPrimitiveAttribute(generateUUID,ime,null,false)
	}
	
	override createPrimitiveAttribute() {
		createPrimitiveAttribute(generateUUID)
	}
	def createUserAssociation(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createUserAssociation => [
			setID(ID)
			internal = ime ?: createInternalUserAssociation => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.data.adapter.UserAssociationEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an UserAssociation with the given id. Post create hook will be triggered.
	 */
	def createUserAssociation(String ID, InternalNode source, InternalNode target){
		createUserAssociation(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an UserAssociation with generated id. Post create hook will be triggered.
	 */
	def createUserAssociation(InternalNode source, InternalNode target){
		createUserAssociation(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an UserAssociation with the given id. Post create hook won't be triggered.
	 */
	def createUserAssociation(String ID){
		createUserAssociation(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an UserAssociation with a generated id. Post create hook won't be triggered.
	 */
	override createUserAssociation() {
		createUserAssociation(generateUUID)
	}
	def createInheritance(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createInheritance => [
			setID(ID)
			internal = ime ?: createInternalInheritance => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.data.adapter.InheritanceEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an Inheritance with the given id. Post create hook will be triggered.
	 */
	def createInheritance(String ID, InternalNode source, InternalNode target){
		createInheritance(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an Inheritance with generated id. Post create hook will be triggered.
	 */
	def createInheritance(InternalNode source, InternalNode target){
		createInheritance(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an Inheritance with the given id. Post create hook won't be triggered.
	 */
	def createInheritance(String ID){
		createInheritance(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an Inheritance with a generated id. Post create hook won't be triggered.
	 */
	override createInheritance() {
		createInheritance(generateUUID)
	}
	/**
	 * This method creates an ExtensionAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createExtensionAttribute => [
			setID(ID)
			internal = ime ?: createInternalExtensionAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.ExtensionAttributeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createExtensionAttribute(String ID){
		createExtensionAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createExtensionAttribute(InternalModelElementContainer parent){
		createExtensionAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createExtensionAttribute(String ID, InternalModelElementContainer parent){
		createExtensionAttribute(ID,null,parent,true)
	}
	
	def createExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createExtensionAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createExtensionAttribute(InternalModelElement ime) {
		createExtensionAttribute(generateUUID,ime,null,false)
	}
	
	override createExtensionAttribute() {
		createExtensionAttribute(generateUUID)
	}
	/**
	 * This method creates an EnumLiteral with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createEnumLiteral(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createEnumLiteral => [
			setID(ID)
			internal = ime ?: createInternalEnumLiteral => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.EnumLiteralEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an EnumLiteral with the given id. Post create hook won't be triggered.
	 */
	def createEnumLiteral(String ID){
		createEnumLiteral(ID,null,null,false)
	}
	
	/**
	 * This method creates an EnumLiteral with the given id. Post create hook will be triggered.
	 */
	def createEnumLiteral(InternalModelElementContainer parent){
		createEnumLiteral(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an EnumLiteral with the given id. Post create hook will be triggered.
	 */
	def createEnumLiteral(String ID, InternalModelElementContainer parent){
		createEnumLiteral(ID,null,parent,true)
	}
	
	def createEnumLiteral(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createEnumLiteral(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an EnumLiteral with the given id. Post create hook won't be triggered.
	 */
	def createEnumLiteral(InternalModelElement ime) {
		createEnumLiteral(generateUUID,ime,null,false)
	}
	
	override createEnumLiteral() {
		createEnumLiteral(generateUUID)
	}
	/**
	 * This method creates an BidirectionalAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBidirectionalAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createBidirectionalAttribute => [
			setID(ID)
			internal = ime ?: createInternalBidirectionalAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.BidirectionalAttributeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an BidirectionalAttribute with the given id. Post create hook won't be triggered.
	 */
	def createBidirectionalAttribute(String ID){
		createBidirectionalAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an BidirectionalAttribute with the given id. Post create hook will be triggered.
	 */
	def createBidirectionalAttribute(InternalModelElementContainer parent){
		createBidirectionalAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an BidirectionalAttribute with the given id. Post create hook will be triggered.
	 */
	def createBidirectionalAttribute(String ID, InternalModelElementContainer parent){
		createBidirectionalAttribute(ID,null,parent,true)
	}
	
	def createBidirectionalAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createBidirectionalAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an BidirectionalAttribute with the given id. Post create hook won't be triggered.
	 */
	def createBidirectionalAttribute(InternalModelElement ime) {
		createBidirectionalAttribute(generateUUID,ime,null,false)
	}
	
	override createBidirectionalAttribute() {
		createBidirectionalAttribute(generateUUID)
	}
	/**
	 * This method creates an ComplexAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createComplexAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createComplexAttribute => [
			setID(ID)
			internal = ime ?: createInternalComplexAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.ComplexAttributeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttribute(String ID){
		createComplexAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexAttribute(InternalModelElementContainer parent){
		createComplexAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook will be triggered.
	 */
	def createComplexAttribute(String ID, InternalModelElementContainer parent){
		createComplexAttribute(ID,null,parent,true)
	}
	
	def createComplexAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createComplexAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ComplexAttribute with the given id. Post create hook won't be triggered.
	 */
	def createComplexAttribute(InternalModelElement ime) {
		createComplexAttribute(generateUUID,ime,null,false)
	}
	
	override createComplexAttribute() {
		createComplexAttribute(generateUUID)
	}
	/**
	 * This method creates an ReferencedComplexAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createReferencedComplexAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createReferencedComplexAttribute => [
			setID(ID)
			internal = ime ?: createInternalReferencedComplexAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.ReferencedComplexAttributeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ReferencedComplexAttribute with the given id. Post create hook won't be triggered.
	 */
	def createReferencedComplexAttribute(String ID){
		createReferencedComplexAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ReferencedComplexAttribute with the given id. Post create hook will be triggered.
	 */
	def createReferencedComplexAttribute(InternalModelElementContainer parent){
		createReferencedComplexAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ReferencedComplexAttribute with the given id. Post create hook will be triggered.
	 */
	def createReferencedComplexAttribute(String ID, InternalModelElementContainer parent){
		createReferencedComplexAttribute(ID,null,parent,true)
	}
	
	def createReferencedComplexAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createReferencedComplexAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ReferencedComplexAttribute with the given id. Post create hook won't be triggered.
	 */
	def createReferencedComplexAttribute(InternalModelElement ime) {
		createReferencedComplexAttribute(generateUUID,ime,null,false)
	}
	
	override createReferencedComplexAttribute() {
		createReferencedComplexAttribute(generateUUID)
	}
	def createAssociation(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createAssociation => [
			setID(ID)
			internal = ime ?: createInternalAssociation => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.data.adapter.AssociationEContentAdapter)
			]
			if (hook) postCreates
		]
	}
	
	/**
	 * This method creates an Association with the given id. Post create hook will be triggered.
	 */
	def createAssociation(String ID, InternalNode source, InternalNode target){
		createAssociation(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an Association with generated id. Post create hook will be triggered.
	 */
	def createAssociation(InternalNode source, InternalNode target){
		createAssociation(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an Association with the given id. Post create hook won't be triggered.
	 */
	def createAssociation(String ID){
		createAssociation(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an Association with a generated id. Post create hook won't be triggered.
	 */
	override createAssociation() {
		createAssociation(generateUUID)
	}
	/**
	 * This method creates an ReferencedExtensionAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createReferencedExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createReferencedExtensionAttribute => [
			setID(ID)
			internal = ime ?: createInternalReferencedExtensionAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.ReferencedExtensionAttributeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ReferencedExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createReferencedExtensionAttribute(String ID){
		createReferencedExtensionAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an ReferencedExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createReferencedExtensionAttribute(InternalModelElementContainer parent){
		createReferencedExtensionAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ReferencedExtensionAttribute with the given id. Post create hook will be triggered.
	 */
	def createReferencedExtensionAttribute(String ID, InternalModelElementContainer parent){
		createReferencedExtensionAttribute(ID,null,parent,true)
	}
	
	def createReferencedExtensionAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createReferencedExtensionAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ReferencedExtensionAttribute with the given id. Post create hook won't be triggered.
	 */
	def createReferencedExtensionAttribute(InternalModelElement ime) {
		createReferencedExtensionAttribute(generateUUID,ime,null,false)
	}
	
	override createReferencedExtensionAttribute() {
		createReferencedExtensionAttribute(generateUUID)
	}
	/**
	 * This method creates an ConcreteType with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createConcreteType(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createConcreteType => [
			setID(ID)
			internal = ime ?: createInternalConcreteType => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.ConcreteTypeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ConcreteType with the given id. Post create hook won't be triggered.
	 */
	def createConcreteType(String ID){
		createConcreteType(ID,null,null,false)
	}
	
	/**
	 * This method creates an ConcreteType with the given id. Post create hook will be triggered.
	 */
	def createConcreteType(InternalModelElementContainer parent){
		createConcreteType(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ConcreteType with the given id. Post create hook will be triggered.
	 */
	def createConcreteType(String ID, InternalModelElementContainer parent){
		createConcreteType(ID,null,parent,true)
	}
	
	def createConcreteType(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createConcreteType(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ConcreteType with the given id. Post create hook won't be triggered.
	 */
	def createConcreteType(InternalModelElement ime) {
		createConcreteType(generateUUID,ime,null,false)
	}
	
	override createConcreteType() {
		createConcreteType(generateUUID)
	}
	/**
	 * This method creates an ReferencedEnumType with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createReferencedEnumType(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createReferencedEnumType => [
			setID(ID)
			internal = ime ?: createInternalReferencedEnumType => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.ReferencedEnumTypeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ReferencedEnumType with the given id. Post create hook won't be triggered.
	 */
	def createReferencedEnumType(String ID){
		createReferencedEnumType(ID,null,null,false)
	}
	
	/**
	 * This method creates an ReferencedEnumType with the given id. Post create hook will be triggered.
	 */
	def createReferencedEnumType(InternalModelElementContainer parent){
		createReferencedEnumType(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ReferencedEnumType with the given id. Post create hook will be triggered.
	 */
	def createReferencedEnumType(String ID, InternalModelElementContainer parent){
		createReferencedEnumType(ID,null,parent,true)
	}
	
	def createReferencedEnumType(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createReferencedEnumType(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ReferencedEnumType with the given id. Post create hook won't be triggered.
	 */
	def createReferencedEnumType(InternalModelElement ime) {
		createReferencedEnumType(generateUUID,ime,null,false)
	}
	
	override createReferencedEnumType() {
		createReferencedEnumType(generateUUID)
	}
	/**
	 * This method creates an UserAttribute with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createUserAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createUserAttribute => [
			setID(ID)
			internal = ime ?: createInternalUserAttribute => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.UserAttributeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an UserAttribute with the given id. Post create hook won't be triggered.
	 */
	def createUserAttribute(String ID){
		createUserAttribute(ID,null,null,false)
	}
	
	/**
	 * This method creates an UserAttribute with the given id. Post create hook will be triggered.
	 */
	def createUserAttribute(InternalModelElementContainer parent){
		createUserAttribute(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an UserAttribute with the given id. Post create hook will be triggered.
	 */
	def createUserAttribute(String ID, InternalModelElementContainer parent){
		createUserAttribute(ID,null,parent,true)
	}
	
	def createUserAttribute(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createUserAttribute(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an UserAttribute with the given id. Post create hook won't be triggered.
	 */
	def createUserAttribute(InternalModelElement ime) {
		createUserAttribute(generateUUID,ime,null,false)
	}
	
	override createUserAttribute() {
		createUserAttribute(generateUUID)
	}
	/**
	 * This method creates an Data with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createData(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createData => [ 
			setID(ID)
			internal = ime ?: createInternalData => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.data.adapter.DataEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an Data with the given id. Post create hook won't be triggered.
	 */
	def createData(String ID){
		createData(ID,null,null,false)
	}
	
	/**
	 * This method creates an Data with the given id. Post create hook will be triggered.
	 */
	def createData(InternalModelElementContainer parent){
		createData(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Data with the given id. Post create hook will be triggered.
	 */
	def createData(String ID, InternalModelElementContainer parent){
		createData(ID,null,parent,true)
	}
	
	def createData(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createData(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Data with the given id. Post create hook won't be triggered.
	 */
	def createData(InternalModelElement ime) {
		createData(generateUUID,ime,null,false)
	}
	
	override createData() {
		createData(generateUUID)
	}
	/**
	 * This method creates an ReferencedType with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createReferencedType(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createReferencedType => [
			setID(ID)
			internal = ime ?: createInternalReferencedType => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.ReferencedTypeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ReferencedType with the given id. Post create hook won't be triggered.
	 */
	def createReferencedType(String ID){
		createReferencedType(ID,null,null,false)
	}
	
	/**
	 * This method creates an ReferencedType with the given id. Post create hook will be triggered.
	 */
	def createReferencedType(InternalModelElementContainer parent){
		createReferencedType(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ReferencedType with the given id. Post create hook will be triggered.
	 */
	def createReferencedType(String ID, InternalModelElementContainer parent){
		createReferencedType(ID,null,parent,true)
	}
	
	def createReferencedType(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createReferencedType(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ReferencedType with the given id. Post create hook won't be triggered.
	 */
	def createReferencedType(InternalModelElement ime) {
		createReferencedType(generateUUID,ime,null,false)
	}
	
	override createReferencedType() {
		createReferencedType(generateUUID)
	}
	/**
	 * This method creates an AbstractType with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createAbstractType(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createAbstractType => [
			setID(ID)
			internal = ime ?: createInternalAbstractType => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.data.adapter.AbstractTypeEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an AbstractType with the given id. Post create hook won't be triggered.
	 */
	def createAbstractType(String ID){
		createAbstractType(ID,null,null,false)
	}
	
	/**
	 * This method creates an AbstractType with the given id. Post create hook will be triggered.
	 */
	def createAbstractType(InternalModelElementContainer parent){
		createAbstractType(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an AbstractType with the given id. Post create hook will be triggered.
	 */
	def createAbstractType(String ID, InternalModelElementContainer parent){
		createAbstractType(ID,null,parent,true)
	}
	
	def createAbstractType(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createAbstractType(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an AbstractType with the given id. Post create hook won't be triggered.
	 */
	def createAbstractType(InternalModelElement ime) {
		createAbstractType(generateUUID,ime,null,false)
	}
	
	override createAbstractType() {
		createAbstractType(generateUUID)
	}
	
	private def <T extends IdentifiableElement> setInternal(T elm, InternalIdentifiableElement internal) {
		elm => [
			if (id.isNullOrEmpty)
				ID = generateUUID
			switch elm {
				GraphModel: elm.setInternalElement_(internal as InternalGraphModel)
				ModelElement: elm.setInternalElement_(internal as InternalModelElement)
				Type: elm.setInternalElement_(internal as InternalType)
			}
		]
	}
	
	/**
	* This method creates a new Data object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can 
	* simply call the Data's save method to save your changes.
	*/
	def info.scce.dime.data.data.Data createData(java.lang.String path, java.lang.String fileName) {
		var filePath = new org.eclipse.core.runtime.Path(path).append(fileName).addFileExtension("data");
		var uri = org.eclipse.emf.common.util.URI.createPlatformResourceURI(filePath.toOSString(), true);
		var res = new org.eclipse.emf.ecore.resource.impl.ResourceSetImpl().createResource(uri);
		var graph = info.scce.dime.data.factory.DataFactory.eINSTANCE.createData();
		
		org.eclipse.emf.ecore.util.EcoreUtil.setID(graph, org.eclipse.emf.ecore.util.EcoreUtil.generateUUID());

		res.getContents().add(graph.getInternalElement_());
		
		postCreates(graph);
		try {
			res.save(null);
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}

		return graph;
	}
	
	def postCreates(info.scce.dime.data.data.AbstractType me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.TypePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.ConcreteType me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.TypePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.ReferencedType me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.ReferencedTypePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.ReferencedEnumType me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.ReferencedEnumTypePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.ReferencedUserType me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.ReferencedTypePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.UserType me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.UserTypePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.ReferencedPrimitiveAttribute me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AttributePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.ReferencedComplexAttribute me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AttributePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.ReferencedExtensionAttribute me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AttributePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.ReferencedBidirectionalAttribute me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AttributePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.ReferencedUserAttribute me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AttributePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.EnumType me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.TypePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.PrimitiveAttribute me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AttributePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.ComplexAttribute me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AttributePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.ExtensionAttribute me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AttributePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.BidirectionalAttribute me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AttributePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.UserAttribute me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AttributePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.EnumLiteral me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AttributePostCreate().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.BidirectionalAssociation me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.BidirectionalAssociationInitialize().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.Association me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.AssociationInitialize().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.UserAssociation me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.UserAssociationInitialize().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.data.data.Data me) {
		me.transact [ // Post create hook
			new info.scce.dime.data.hooks.DataPostCreate().postCreate(me)
		]
	}
	
}
