package info.scce.dime.dad.factory

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

import info.scce.dime.dad.dad.DadPackage
import info.scce.dime.dad.dad.impl.DadFactoryImpl
import info.scce.dime.dad.dad.internal.InternalFactory
import info.scce.dime.dad.dad.internal.InternalPackage

import info.scce.dime.dad.dad.adapter.*

import graphmodel.internal.InternalModelElement
import graphmodel.internal.InternalModelElementContainer
import graphmodel.internal.InternalGraphModel
import graphmodel.internal.InternalContainer
import graphmodel.internal.InternalNode
import graphmodel.internal.InternalEdge
import graphmodel.internal.InternalType
import graphmodel.internal.InternalIdentifiableElement
import graphmodel.ModelElement
import graphmodel.IdentifiableElement
import graphmodel.GraphModel
import graphmodel.Type

import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EPackage
import org.eclipse.emf.ecore.plugin.EcorePlugin

class DADFactory extends DadFactoryImpl {
	
	final extension InternalFactory = InternalFactory.eINSTANCE
	public static DADFactory eINSTANCE = DADFactory.init
	
	extension de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension = new de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension
	
	static def DADFactory init() {
		try {
			val fct = EPackage::Registry.INSTANCE.getEFactory(DadPackage.eNS_URI) as DADFactory
			if (fct !== null)
				return fct as DADFactory
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		new DADFactory
	}
	
	/**
	 * This method creates an Property with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProperty(String ID, InternalModelElement ime, boolean hook){
		super.createProperty => [ 
			setID(ID)
			internal = ime ?: createInternalProperty => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.dad.adapter.PropertyEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Property with the given id. Post create hook won't be triggered.
	 */
	def createProperty(String ID){
		createProperty(ID,null,false)
	}
	
	/**
	 * This method creates an Property with the given id. Post create hook won't be triggered.
	 */
	def createProperty(InternalModelElement ime) {
		createProperty(generateUUID,ime,false)
	}
	
	override createProperty() {
		createProperty(generateUUID)
	}
	/**
	 * This method creates an Servers with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createServers(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createServers => [
			setID(ID)
			internal = ime ?: createInternalServers => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.ServersEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Servers with the given id. Post create hook won't be triggered.
	 */
	def createServers(String ID){
		createServers(ID,null,null,false)
	}
	
	/**
	 * This method creates an Servers with the given id. Post create hook will be triggered.
	 */
	def createServers(InternalModelElementContainer parent){
		createServers(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Servers with the given id. Post create hook will be triggered.
	 */
	def createServers(String ID, InternalModelElementContainer parent){
		createServers(ID,null,parent,true)
	}
	
	def createServers(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createServers(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Servers with the given id. Post create hook won't be triggered.
	 */
	def createServers(InternalModelElement ime) {
		createServers(generateUUID,ime,null,false)
	}
	
	override createServers() {
		createServers(generateUUID)
	}
	/**
	 * This method creates an GraphQLComponent with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createGraphQLComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createGraphQLComponent => [
			setID(ID)
			internal = ime ?: createInternalGraphQLComponent => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.GraphQLComponentEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an GraphQLComponent with the given id. Post create hook won't be triggered.
	 */
	def createGraphQLComponent(String ID){
		createGraphQLComponent(ID,null,null,false)
	}
	
	/**
	 * This method creates an GraphQLComponent with the given id. Post create hook will be triggered.
	 */
	def createGraphQLComponent(InternalModelElementContainer parent){
		createGraphQLComponent(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an GraphQLComponent with the given id. Post create hook will be triggered.
	 */
	def createGraphQLComponent(String ID, InternalModelElementContainer parent){
		createGraphQLComponent(ID,null,parent,true)
	}
	
	def createGraphQLComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createGraphQLComponent(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an GraphQLComponent with the given id. Post create hook won't be triggered.
	 */
	def createGraphQLComponent(InternalModelElement ime) {
		createGraphQLComponent(generateUUID,ime,null,false)
	}
	
	override createGraphQLComponent() {
		createGraphQLComponent(generateUUID)
	}
	/**
	 * This method creates an LoginComponent with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createLoginComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createLoginComponent => [
			setID(ID)
			internal = ime ?: createInternalLoginComponent => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.LoginComponentEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an LoginComponent with the given id. Post create hook won't be triggered.
	 */
	def createLoginComponent(String ID){
		createLoginComponent(ID,null,null,false)
	}
	
	/**
	 * This method creates an LoginComponent with the given id. Post create hook will be triggered.
	 */
	def createLoginComponent(InternalModelElementContainer parent){
		createLoginComponent(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an LoginComponent with the given id. Post create hook will be triggered.
	 */
	def createLoginComponent(String ID, InternalModelElementContainer parent){
		createLoginComponent(ID,null,parent,true)
	}
	
	def createLoginComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createLoginComponent(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an LoginComponent with the given id. Post create hook won't be triggered.
	 */
	def createLoginComponent(InternalModelElement ime) {
		createLoginComponent(generateUUID,ime,null,false)
	}
	
	override createLoginComponent() {
		createLoginComponent(generateUUID)
	}
	/**
	 * This method creates an ProfileSIB with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProfileSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProfileSIB => [
			setID(ID)
			internal = ime ?: createInternalProfileSIB => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.ProfileSIBEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ProfileSIB with the given id. Post create hook won't be triggered.
	 */
	def createProfileSIB(String ID){
		createProfileSIB(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProfileSIB with the given id. Post create hook will be triggered.
	 */
	def createProfileSIB(InternalModelElementContainer parent){
		createProfileSIB(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProfileSIB with the given id. Post create hook will be triggered.
	 */
	def createProfileSIB(String ID, InternalModelElementContainer parent){
		createProfileSIB(ID,null,parent,true)
	}
	
	def createProfileSIB(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProfileSIB(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProfileSIB with the given id. Post create hook won't be triggered.
	 */
	def createProfileSIB(InternalModelElement ime) {
		createProfileSIB(generateUUID,ime,null,false)
	}
	
	override createProfileSIB() {
		createProfileSIB(generateUUID)
	}
	/**
	 * This method creates an ExternalResource with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createExternalResource(String ID, InternalModelElement ime, boolean hook){
		super.createExternalResource => [ 
			setID(ID)
			internal = ime ?: createInternalExternalResource => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.dad.adapter.ExternalResourceEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ExternalResource with the given id. Post create hook won't be triggered.
	 */
	def createExternalResource(String ID){
		createExternalResource(ID,null,false)
	}
	
	/**
	 * This method creates an ExternalResource with the given id. Post create hook won't be triggered.
	 */
	def createExternalResource(InternalModelElement ime) {
		createExternalResource(generateUUID,ime,false)
	}
	
	override createExternalResource() {
		createExternalResource(generateUUID)
	}
	/**
	 * This method creates an DataComponent with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDataComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDataComponent => [
			setID(ID)
			internal = ime ?: createInternalDataComponent => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.DataComponentEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an DataComponent with the given id. Post create hook won't be triggered.
	 */
	def createDataComponent(String ID){
		createDataComponent(ID,null,null,false)
	}
	
	/**
	 * This method creates an DataComponent with the given id. Post create hook will be triggered.
	 */
	def createDataComponent(InternalModelElementContainer parent){
		createDataComponent(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an DataComponent with the given id. Post create hook will be triggered.
	 */
	def createDataComponent(String ID, InternalModelElementContainer parent){
		createDataComponent(ID,null,parent,true)
	}
	
	def createDataComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDataComponent(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an DataComponent with the given id. Post create hook won't be triggered.
	 */
	def createDataComponent(InternalModelElement ime) {
		createDataComponent(generateUUID,ime,null,false)
	}
	
	override createDataComponent() {
		createDataComponent(generateUUID)
	}
	/**
	 * This method creates an AdvancedSettings with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createAdvancedSettings(String ID, InternalModelElement ime, boolean hook){
		super.createAdvancedSettings => [ 
			setID(ID)
			internal = ime ?: createInternalAdvancedSettings => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.dad.adapter.AdvancedSettingsEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an AdvancedSettings with the given id. Post create hook won't be triggered.
	 */
	def createAdvancedSettings(String ID){
		createAdvancedSettings(ID,null,false)
	}
	
	/**
	 * This method creates an AdvancedSettings with the given id. Post create hook won't be triggered.
	 */
	def createAdvancedSettings(InternalModelElement ime) {
		createAdvancedSettings(generateUUID,ime,false)
	}
	
	override createAdvancedSettings() {
		createAdvancedSettings(generateUUID)
	}
	/**
	 * This method creates an Start with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createStart(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createStart => [
			setID(ID)
			internal = ime ?: createInternalStart => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.StartEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an Start with the given id. Post create hook won't be triggered.
	 */
	def createStart(String ID){
		createStart(ID,null,null,false)
	}
	
	/**
	 * This method creates an Start with the given id. Post create hook will be triggered.
	 */
	def createStart(InternalModelElementContainer parent){
		createStart(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an Start with the given id. Post create hook will be triggered.
	 */
	def createStart(String ID, InternalModelElementContainer parent){
		createStart(ID,null,parent,true)
	}
	
	def createStart(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createStart(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an Start with the given id. Post create hook won't be triggered.
	 */
	def createStart(InternalModelElement ime) {
		createStart(generateUUID,ime,null,false)
	}
	
	override createStart() {
		createStart(generateUUID)
	}
	/**
	 * This method creates an SystemUser with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createSystemUser(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createSystemUser => [
			setID(ID)
			internal = ime ?: createInternalSystemUser => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.SystemUserEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an SystemUser with the given id. Post create hook won't be triggered.
	 */
	def createSystemUser(String ID){
		createSystemUser(ID,null,null,false)
	}
	
	/**
	 * This method creates an SystemUser with the given id. Post create hook will be triggered.
	 */
	def createSystemUser(InternalModelElementContainer parent){
		createSystemUser(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an SystemUser with the given id. Post create hook will be triggered.
	 */
	def createSystemUser(String ID, InternalModelElementContainer parent){
		createSystemUser(ID,null,parent,true)
	}
	
	def createSystemUser(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createSystemUser(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an SystemUser with the given id. Post create hook won't be triggered.
	 */
	def createSystemUser(InternalModelElement ime) {
		createSystemUser(generateUUID,ime,null,false)
	}
	
	override createSystemUser() {
		createSystemUser(generateUUID)
	}
	/**
	 * This method creates an ProfileIconButton with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProfileIconButton(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProfileIconButton => [
			setID(ID)
			internal = ime ?: createInternalProfileIconButton => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.ProfileIconButtonEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ProfileIconButton with the given id. Post create hook won't be triggered.
	 */
	def createProfileIconButton(String ID){
		createProfileIconButton(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProfileIconButton with the given id. Post create hook will be triggered.
	 */
	def createProfileIconButton(InternalModelElementContainer parent){
		createProfileIconButton(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProfileIconButton with the given id. Post create hook will be triggered.
	 */
	def createProfileIconButton(String ID, InternalModelElementContainer parent){
		createProfileIconButton(ID,null,parent,true)
	}
	
	def createProfileIconButton(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProfileIconButton(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProfileIconButton with the given id. Post create hook won't be triggered.
	 */
	def createProfileIconButton(InternalModelElement ime) {
		createProfileIconButton(generateUUID,ime,null,false)
	}
	
	override createProfileIconButton() {
		createProfileIconButton(generateUUID)
	}
	/**
	 * This method creates an ProfileContainer with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProfileContainer(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProfileContainer => [
			setID(ID)
			internal = ime ?: createInternalProfileContainer => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.ProfileContainerEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ProfileContainer with the given id. Post create hook won't be triggered.
	 */
	def createProfileContainer(String ID){
		createProfileContainer(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProfileContainer with the given id. Post create hook will be triggered.
	 */
	def createProfileContainer(InternalModelElementContainer parent){
		createProfileContainer(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProfileContainer with the given id. Post create hook will be triggered.
	 */
	def createProfileContainer(String ID, InternalModelElementContainer parent){
		createProfileContainer(ID,null,parent,true)
	}
	
	def createProfileContainer(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProfileContainer(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProfileContainer with the given id. Post create hook won't be triggered.
	 */
	def createProfileContainer(InternalModelElement ime) {
		createProfileContainer(generateUUID,ime,null,false)
	}
	
	override createProfileContainer() {
		createProfileContainer(generateUUID)
	}
	/**
	 * This method creates an ProductionServer with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProductionServer(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProductionServer => [
			setID(ID)
			internal = ime ?: createInternalProductionServer => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.ProductionServerEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an ProductionServer with the given id. Post create hook won't be triggered.
	 */
	def createProductionServer(String ID){
		createProductionServer(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProductionServer with the given id. Post create hook will be triggered.
	 */
	def createProductionServer(InternalModelElementContainer parent){
		createProductionServer(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProductionServer with the given id. Post create hook will be triggered.
	 */
	def createProductionServer(String ID, InternalModelElementContainer parent){
		createProductionServer(ID,null,parent,true)
	}
	
	def createProductionServer(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProductionServer(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProductionServer with the given id. Post create hook won't be triggered.
	 */
	def createProductionServer(InternalModelElement ime) {
		createProductionServer(generateUUID,ime,null,false)
	}
	
	override createProductionServer() {
		createProductionServer(generateUUID)
	}
	/**
	 * This method creates an ProcessEntryPointComponent with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProcessEntryPointComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProcessEntryPointComponent => [
			setID(ID)
			internal = ime ?: createInternalProcessEntryPointComponent => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.ProcessEntryPointComponentEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ProcessEntryPointComponent with the given id. Post create hook won't be triggered.
	 */
	def createProcessEntryPointComponent(String ID){
		createProcessEntryPointComponent(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProcessEntryPointComponent with the given id. Post create hook will be triggered.
	 */
	def createProcessEntryPointComponent(InternalModelElementContainer parent){
		createProcessEntryPointComponent(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProcessEntryPointComponent with the given id. Post create hook will be triggered.
	 */
	def createProcessEntryPointComponent(String ID, InternalModelElementContainer parent){
		createProcessEntryPointComponent(ID,null,parent,true)
	}
	
	def createProcessEntryPointComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProcessEntryPointComponent(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProcessEntryPointComponent with the given id. Post create hook won't be triggered.
	 */
	def createProcessEntryPointComponent(InternalModelElement ime) {
		createProcessEntryPointComponent(generateUUID,ime,null,false)
	}
	
	override createProcessEntryPointComponent() {
		createProcessEntryPointComponent(generateUUID)
	}
	/**
	 * This method creates an FindLoginUserComponent with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createFindLoginUserComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createFindLoginUserComponent => [
			setID(ID)
			internal = ime ?: createInternalFindLoginUserComponent => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.FindLoginUserComponentEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an FindLoginUserComponent with the given id. Post create hook won't be triggered.
	 */
	def createFindLoginUserComponent(String ID){
		createFindLoginUserComponent(ID,null,null,false)
	}
	
	/**
	 * This method creates an FindLoginUserComponent with the given id. Post create hook will be triggered.
	 */
	def createFindLoginUserComponent(InternalModelElementContainer parent){
		createFindLoginUserComponent(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an FindLoginUserComponent with the given id. Post create hook will be triggered.
	 */
	def createFindLoginUserComponent(String ID, InternalModelElementContainer parent){
		createFindLoginUserComponent(ID,null,parent,true)
	}
	
	def createFindLoginUserComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createFindLoginUserComponent(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an FindLoginUserComponent with the given id. Post create hook won't be triggered.
	 */
	def createFindLoginUserComponent(InternalModelElement ime) {
		createFindLoginUserComponent(generateUUID,ime,null,false)
	}
	
	override createFindLoginUserComponent() {
		createFindLoginUserComponent(generateUUID)
	}
	/**
	 * This method creates an NonProductionServer with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createNonProductionServer(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createNonProductionServer => [
			setID(ID)
			internal = ime ?: createInternalNonProductionServer => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.NonProductionServerEContentAdapter)
			]
			if (hook) postCreates
		]
		
	}
	
	/**
	 * This method creates an NonProductionServer with the given id. Post create hook won't be triggered.
	 */
	def createNonProductionServer(String ID){
		createNonProductionServer(ID,null,null,false)
	}
	
	/**
	 * This method creates an NonProductionServer with the given id. Post create hook will be triggered.
	 */
	def createNonProductionServer(InternalModelElementContainer parent){
		createNonProductionServer(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an NonProductionServer with the given id. Post create hook will be triggered.
	 */
	def createNonProductionServer(String ID, InternalModelElementContainer parent){
		createNonProductionServer(ID,null,parent,true)
	}
	
	def createNonProductionServer(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createNonProductionServer(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an NonProductionServer with the given id. Post create hook won't be triggered.
	 */
	def createNonProductionServer(InternalModelElement ime) {
		createNonProductionServer(generateUUID,ime,null,false)
	}
	
	override createNonProductionServer() {
		createNonProductionServer(generateUUID)
	}
	/**
	 * This method creates an BlueprintingConfig with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createBlueprintingConfig(String ID, InternalModelElement ime, boolean hook){
		super.createBlueprintingConfig => [ 
			setID(ID)
			internal = ime ?: createInternalBlueprintingConfig => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.dad.adapter.BlueprintingConfigEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an BlueprintingConfig with the given id. Post create hook won't be triggered.
	 */
	def createBlueprintingConfig(String ID){
		createBlueprintingConfig(ID,null,false)
	}
	
	/**
	 * This method creates an BlueprintingConfig with the given id. Post create hook won't be triggered.
	 */
	def createBlueprintingConfig(InternalModelElement ime) {
		createBlueprintingConfig(generateUUID,ime,false)
	}
	
	override createBlueprintingConfig() {
		createBlueprintingConfig(generateUUID)
	}
	/**
	 * This method creates an DAD with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createDAD(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createDAD => [ 
			setID(ID)
			internal = ime ?: createInternalDAD => [
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.dad.adapter.DADEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an DAD with the given id. Post create hook won't be triggered.
	 */
	def createDAD(String ID){
		createDAD(ID,null,null,false)
	}
	
	/**
	 * This method creates an DAD with the given id. Post create hook will be triggered.
	 */
	def createDAD(InternalModelElementContainer parent){
		createDAD(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an DAD with the given id. Post create hook will be triggered.
	 */
	def createDAD(String ID, InternalModelElementContainer parent){
		createDAD(ID,null,parent,true)
	}
	
	def createDAD(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createDAD(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an DAD with the given id. Post create hook won't be triggered.
	 */
	def createDAD(InternalModelElement ime) {
		createDAD(generateUUID,ime,null,false)
	}
	
	override createDAD() {
		createDAD(generateUUID)
	}
	def createRootInteractionPointer(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createRootInteractionPointer => [
			setID(ID)
			internal = ime ?: createInternalRootInteractionPointer => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.dad.adapter.RootInteractionPointerEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an RootInteractionPointer with the given id. Post create hook will be triggered.
	 */
	def createRootInteractionPointer(String ID, InternalNode source, InternalNode target){
		createRootInteractionPointer(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an RootInteractionPointer with generated id. Post create hook will be triggered.
	 */
	def createRootInteractionPointer(InternalNode source, InternalNode target){
		createRootInteractionPointer(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an RootInteractionPointer with the given id. Post create hook won't be triggered.
	 */
	def createRootInteractionPointer(String ID){
		createRootInteractionPointer(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an RootInteractionPointer with a generated id. Post create hook won't be triggered.
	 */
	override createRootInteractionPointer() {
		createRootInteractionPointer(generateUUID)
	}
	/**
	 * This method creates an ProcessComponent with the given id.
	 *
	 * @param ID: The id for the new element
	 * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
	 * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
	 * element of the created element
	 * @param hook: Indicates, if the post create hook should be executed
	 */
	def createProcessComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){
		super.createProcessComponent => [
			setID(ID)
			internal = ime ?: createInternalProcessComponent => [
				setID(ID + "_INTERNAL")
				container = parent
				eAdapters.add(new info.scce.dime.dad.adapter.ProcessComponentEContentAdapter)
			]
		]
		
	}
	
	/**
	 * This method creates an ProcessComponent with the given id. Post create hook won't be triggered.
	 */
	def createProcessComponent(String ID){
		createProcessComponent(ID,null,null,false)
	}
	
	/**
	 * This method creates an ProcessComponent with the given id. Post create hook will be triggered.
	 */
	def createProcessComponent(InternalModelElementContainer parent){
		createProcessComponent(generateUUID,null,parent,true)
	}
	
	/**
	 * This method creates an ProcessComponent with the given id. Post create hook will be triggered.
	 */
	def createProcessComponent(String ID, InternalModelElementContainer parent){
		createProcessComponent(ID,null,parent,true)
	}
	
	def createProcessComponent(String ID, InternalModelElement ime, InternalModelElementContainer parent){
		createProcessComponent(ID,ime,parent,true)
	}
	
	/**
	 * This method creates an ProcessComponent with the given id. Post create hook won't be triggered.
	 */
	def createProcessComponent(InternalModelElement ime) {
		createProcessComponent(generateUUID,ime,null,false)
	}
	
	override createProcessComponent() {
		createProcessComponent(generateUUID)
	}
	def createGraphQLDataPointer(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createGraphQLDataPointer => [
			setID(ID)
			internal = ime ?: createInternalGraphQLDataPointer => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.dad.adapter.GraphQLDataPointerEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an GraphQLDataPointer with the given id. Post create hook will be triggered.
	 */
	def createGraphQLDataPointer(String ID, InternalNode source, InternalNode target){
		createGraphQLDataPointer(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an GraphQLDataPointer with generated id. Post create hook will be triggered.
	 */
	def createGraphQLDataPointer(InternalNode source, InternalNode target){
		createGraphQLDataPointer(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an GraphQLDataPointer with the given id. Post create hook won't be triggered.
	 */
	def createGraphQLDataPointer(String ID){
		createGraphQLDataPointer(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an GraphQLDataPointer with a generated id. Post create hook won't be triggered.
	 */
	override createGraphQLDataPointer() {
		createGraphQLDataPointer(generateUUID)
	}
	def createStartupProcessPointer(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {
		super.createStartupProcessPointer => [
			setID(ID)
			internal = ime ?: createInternalStartupProcessPointer => [
				(it as InternalEdge).set_sourceElement(source)
				(it as InternalEdge).set_targetElement(target)
				container = source?.rootElement ?: target?.rootElement
				setID(ID + "_INTERNAL")
				eAdapters.add(new info.scce.dime.dad.adapter.StartupProcessPointerEContentAdapter)
			]
		]
	}
	
	/**
	 * This method creates an StartupProcessPointer with the given id. Post create hook will be triggered.
	 */
	def createStartupProcessPointer(String ID, InternalNode source, InternalNode target){
		createStartupProcessPointer(ID,null,source,target,true)
	}
	
	/**
	 * This method creates an StartupProcessPointer with generated id. Post create hook will be triggered.
	 */
	def createStartupProcessPointer(InternalNode source, InternalNode target){
		createStartupProcessPointer(generateUUID,null,source,target,true)
	}
	
	/**
	 * This method creates an StartupProcessPointer with the given id. Post create hook won't be triggered.
	 */
	def createStartupProcessPointer(String ID){
		createStartupProcessPointer(ID,null,null,null,false)
	}
	
	/**
	 * This method creates an StartupProcessPointer with a generated id. Post create hook won't be triggered.
	 */
	override createStartupProcessPointer() {
		createStartupProcessPointer(generateUUID)
	}
	
	private def <T extends IdentifiableElement> setInternal(T elm, InternalIdentifiableElement internal) {
		elm => [
			if (id.isNullOrEmpty)
				ID = generateUUID
			switch elm {
				GraphModel: elm.setInternalElement_(internal as InternalGraphModel)
				ModelElement: elm.setInternalElement_(internal as InternalModelElement)
				Type: elm.setInternalElement_(internal as InternalType)
			}
		]
	}
	
	/**
	* This method creates a new DAD object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can 
	* simply call the DAD's save method to save your changes.
	*/
	def info.scce.dime.dad.dad.DAD createDAD(java.lang.String path, java.lang.String fileName) {
		var filePath = new org.eclipse.core.runtime.Path(path).append(fileName).addFileExtension("dad");
		var uri = org.eclipse.emf.common.util.URI.createPlatformResourceURI(filePath.toOSString(), true);
		var res = new org.eclipse.emf.ecore.resource.impl.ResourceSetImpl().createResource(uri);
		var graph = info.scce.dime.dad.factory.DADFactory.eINSTANCE.createDAD();
		
		org.eclipse.emf.ecore.util.EcoreUtil.setID(graph, org.eclipse.emf.ecore.util.EcoreUtil.generateUUID());

		res.getContents().add(graph.getInternalElement_());
		
		try {
			res.save(null);
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}

		return graph;
	}
	
	def postCreates(info.scce.dime.dad.dad.ProfileSIB me) {
		me.transact [ // Post create hook
			new info.scce.dime.dad.hooks.PostCreateProfileSIB().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.dad.dad.ProductionServer me) {
		me.transact [ // Post create hook
			new info.scce.dime.dad.hooks.PostCreateServer().postCreate(me)
		]
	}
	def postCreates(info.scce.dime.dad.dad.NonProductionServer me) {
		me.transact [ // Post create hook
			new info.scce.dime.dad.hooks.PostCreateServer().postCreate(me)
		]
	}
	
}
