package de.jabc.cinco.meta.plugin.gratext.tmpl.file

import de.jabc.cinco.meta.core.utils.MGLUtil
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils
import de.jabc.cinco.meta.plugin.template.FileTemplate
import java.util.Map
import java.util.Set
import mgl.ModelElement
import mgl.ReferencedModelElement
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage
import org.eclipse.emf.ecore.EClassifier

class MweWorkflowTmpl extends FileTemplate {
	protected extension MGLUtil = new MGLUtil
	val generatorUtils = GeneratorUtils.instance
	Map<String,String> genPackages = newHashMap
	Set<String> referencedNsURIs = newHashSet
	
	String projectName
	String projectBasePackage
	
	new(String projectName, String projectBasePackage) {
		println("New MweWorkflowTmpl: " + projectName)
		this.projectName = projectName
		this.projectBasePackage = projectBasePackage
	}
	
	def targetName() '''«generatorUtils.getFileName(model)»Gratext'''
	
	override getTargetFileName() '''«generatorUtils.getFileName(model)»Gratext.mwe2'''
	
	override init() {
		// Imported external MGLs are handled separately below
		val importedMGLModels = MGLUtil.getAllImportedMGLs(model, false, true)
		importedMGLModels.forEach[
			val pkg = if (!package.nullOrEmpty) '''«package».''' else ""
			val lcModelName = generatorUtils.getFileName(it).toLowerCase
			genPackages.put(MGLUtil.nsURI(it),
				'''«pkg»«lcModelName».«lcModelName.toFirstUpper»Package''')
		]
		
		// Handle imported external MGLs as well
		model.importedGenModels
			.flatMap[it.genPackages]
			.forEach[collectGenPackagesDeeply]
		
		referencedNsURIs += model.primeReferences.map[ pr |
			switch pr.type {
				ModelElement:
					if (!(pr as ReferencedModelElement).isLocal)
						MGLUtil.nsURI(MGLUtil.mglModel(pr.imprt))
					else
						MGLUtil.nsURI(model)
				EClassifier: (pr.type as EClassifier).EPackage.nsURI
			}
		].filter[it != MGLUtil.nsURI(model)].filterNull
	}
	
	def void collectGenPackagesDeeply(GenPackage genpgk) {
		val pkg = if (!genpgk.basePackage.nullOrEmpty) '''«genpgk.basePackage».''' else ""
		genPackages.put(genpgk.NSURI,
			'''«pkg»«genpgk.getEcorePackage.name».«genpgk.prefix»Package''')
		for (nested : genpgk.nestedGenPackages) {
			collectGenPackagesDeeply(nested)
		}
	}
	
	def genPackageRule(String pkg) '''
		registerGeneratedEPackage = "«pkg»"
	'''

	def toPath(String pkg) {
		pkg?.replace('.', '/')
	}
	
	override template() '''
		module «package»
		
		import org.eclipse.emf.mwe.utils.*
		import org.eclipse.xtext.xtext.generator.*
		import org.eclipse.xtext.xtext.generator.model.project.*
		
		var languageName = "«projectBasePackage».«generatorUtils.getFileName(model)»Gratext"
		var projectName = "«projectName»"
		
		Workflow {
		
			bean = StandaloneSetup {
				scanClassPath  = true
				registerGeneratedEPackage = "«projectBasePackage».«targetName»Package"
				registerGenModelFile = "platform:/resource/«projectName»/model/«projectBasePackage.toPath»/«GenmodelTmpl.getTargetFileName»"
				«referencedNsURIs.map[genPackages.get(it)].filterNull.map[genPackageRule].join('\n')»
				registerGenModelFile = "platform:/resource/«model.projectName»/src-gen/model/«cpd.name».genmodel"
			}
		
			component = org.eclipse.xtext.xtext.generator.XtextGenerator {
				configuration = {
					project = StandardProjectConfig {
						baseName = projectName
						rootPath = ".."
						
						runtimeTest = {
							enabled = false
						}
						eclipsePlugin = {
							enabled = true
						}
						eclipsePluginTest = {
							enabled = false
						}
						genericIde = {
							enabled = true
							name = projectName // generate to the base project
						}
						createEclipseMetaData = true
						codeConfig = {
							preferXtendStubs = false
						}
					}
					code = {
						preferXtendStubs = false
						encoding = "UTF-8"
						lineDelimiter = "\n"
						fileHeader = "/*\n * generated by Xtext \${version}\n */"
					}
				}
				language = StandardLanguage {
					name = languageName
		
					serializer = {
						generateStub = false
					}
					validator = {
						generateStub = false
					}
					scopeProvider = {
						generateStub = true
						generateXtendStub = true
					}
					contentAssist = {
						generateStub = true
						generateXtendStub = true
					}
				}
			}
		}
	'''
	
}