package info.scce.dime.profile.profile.gratext.scoping

import graphmodel.internal.InternalIdentifiableElement
import info.scce.dime.profile.profile.gratext.*

import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.naming.QualifiedName
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider

import static extension org.eclipse.xtext.EcoreUtil2.getRootContainer
import static extension org.eclipse.xtext.scoping.Scopes.scopeFor

/**
 * This class contains custom scoping description.
 */
class ProfileGratextScopeProvider extends AbstractDeclarativeScopeProvider {
	
	override getScope(EObject context, EReference reference) {
		getScope(context, reference.name) ?: super.getScope(context, reference)
	}
	
	dispatch def IScope getScope(EObject element, String refName) {
		null
	}
	
	dispatch def IScope getScope(^GratextInternalOutputPortMapping element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.profile.profile.internal.InternalPrimitiveAttributeReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalAddToSubmissionReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalGUIPrimitiveInputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalOutputPort,
				info.scce.dime.profile.profile.internal.InternalOutputGenericReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalGUIComplexInputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalGUIPrimitiveOutputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalGUIComplexOutputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalComplexVariableReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalAttributeReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalPrimitiveVariableReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalAbstractParameterReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalOutputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalComplexInputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalComplexAttributeReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalComplexOutputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalPrimitiveOutputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalPrimitiveInputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalGUIInputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalGUIOutputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalInputPortReferencingOutputPort,
				info.scce.dime.profile.profile.internal.InternalVariableReferencingOutputPort
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalInputPortMapping element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.profile.profile.internal.InternalOutputPortReferencingInputPort,
				info.scce.dime.profile.profile.internal.InternalInputPort,
				info.scce.dime.profile.profile.internal.InternalComplexOutputPortReferencingInputPort,
				info.scce.dime.profile.profile.internal.InternalInputPortReferencingInputPort,
				info.scce.dime.profile.profile.internal.InternalComplexVariableReferencingInputPort,
				info.scce.dime.profile.profile.internal.InternalPrimitiveOutputPortReferencingInputPort,
				info.scce.dime.profile.profile.internal.InternalVariableReferencingInputPort,
				info.scce.dime.profile.profile.internal.InternalPrimitiveVariableReferencingInputPort,
				info.scce.dime.profile.profile.internal.InternalComplexInputPortReferencingInputPort,
				info.scce.dime.profile.profile.internal.InternalPrimitiveInputPortReferencingInputPort
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalSIBReplacement element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.profile.profile.internal.InternalGUIBlueprintSIB,
				info.scce.dime.profile.profile.internal.InternalBlueprintSIB,
				info.scce.dime.profile.profile.internal.InternalSIB,
				info.scce.dime.profile.profile.internal.InternalProcessBlueprintSIB,
				info.scce.dime.profile.profile.internal.InternalProcessSIB,
				info.scce.dime.profile.profile.internal.InternalDoNotReplace,
				info.scce.dime.profile.profile.internal.InternalReplacementSIB,
				info.scce.dime.profile.profile.internal.InternalGUISIB
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalBranchReplacement element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.profile.profile.internal.InternalBranch,
				info.scce.dime.profile.profile.internal.InternalButtonReferencingBranch,
				info.scce.dime.profile.profile.internal.InternalEndSIBReferencingBranch,
				info.scce.dime.profile.profile.internal.InternalBranchReferencingBranch,
				info.scce.dime.profile.profile.internal.InternalBlueprintBranch,
				info.scce.dime.profile.profile.internal.InternalOutputReferencingBranch,
				info.scce.dime.profile.profile.internal.InternalReplacementBranch
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalReplacementCondition element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.profile.profile.internal.InternalGUIBlueprintSIB,
				info.scce.dime.profile.profile.internal.InternalBlueprintSIB,
				info.scce.dime.profile.profile.internal.InternalSIB,
				info.scce.dime.profile.profile.internal.InternalProcessBlueprintSIB,
				info.scce.dime.profile.profile.internal.InternalProcessSIB,
				info.scce.dime.profile.profile.internal.InternalReplacementSIB,
				info.scce.dime.profile.profile.internal.InternalGUISIB
				 )
		}
	}
	def scopeForContents(EObject obj, Class<?>... types) {
		obj.rootContainer.contents
			.filter(anyTypeOf(types))
			.filter(InternalIdentifiableElement)
			.toScope
	}
	
	def getContents(EObject obj) {
		val Iterable<EObject> iterable = [obj.eAllContents]
		return iterable
	}
	
	def anyTypeOf(Class<?>... types) {
		[Object obj | types.stream.anyMatch[isInstance(obj)]]
	}
	
	def IScope toScope(Iterable<InternalIdentifiableElement> elements) {
		scopeFor(elements, [QualifiedName::create(id)], IScope.NULLSCOPE)
	}
}
