package info.scce.dime.profile.profile.gratext

import graphmodel.internal.InternalGraphModel

import de.jabc.cinco.meta.core.utils.registry.NonEmptyIdentityRegistry
import de.jabc.cinco.meta.plugin.gratext.runtime.resource.GratextResource

import info.scce.dime.profile.profile.gratext.generator.ProfileGratextTransformer

class ProfileGratextResource extends GratextResource {
	
	public static val transformers = new NonEmptyIdentityRegistry<InternalGraphModel,ProfileGratextTransformer> [
		new ProfileGratextTransformer
	]
	
	val lastTransformers = new NonEmptyIdentityRegistry<InternalGraphModel,ProfileGratextTransformer> [
		new ProfileGratextTransformer
	]

	override getTransformer(InternalGraphModel model) {
		transformers.get(model)
	}

	override getLastTransformer(InternalGraphModel model) {
		lastTransformers.get(model)
	}

	override removeTransformer(InternalGraphModel model) {
		lastTransformers.put(model, transformers.remove(model))
	}

	override isSortGratext() {
		false
	}
}
